# 
# This file is part of Config-Model-TkUI
# 
# This software is Copyright (c) 2010 by Dominique Dumont.
# 
# This is free software, licensed under:
# 
#   The GNU Lesser General Public License, Version 2.1, February 1999
# 
package Config::Model::Tk::NoteEditor ;
BEGIN {
  $Config::Model::Tk::NoteEditor::VERSION = '1.307';
}

use strict;
use warnings ;
use Carp ;
use Log::Log4perl ;

use base qw/Tk::Frame/;
use vars qw/$icon_path/ ;
use subs qw/menu_struct/ ;
use Tk::Dialog ;
use Tk::Photo ;
use Tk::Balloon ;


Construct Tk::Widget 'ConfigModelNoteEditor';

my @fbe1 = qw/-fill both -expand 1/ ;
my @fxe1 = qw/-fill x    -expand 1/ ;
my @fx   = qw/-fill x    / ;
my $logger = Log::Log4perl::get_logger(__PACKAGE__);

sub ClassInit {
    my ($cw, $args) = @_;
    # ClassInit is often used to define bindings and/or other
    # resources shared by all instances, e.g., images.

    # cw->Advertise(name=>$widget);
}

# This widget is to be integrated directly in a ConfigModel editor widget

sub Populate { 
    my ($cw, $args) = @_;
    my $obj = delete $args->{-object} 
      || croak "NoteEditor: no -object option, got ",
	join(',', keys %$args);

    $cw->Label( -text => 'Edit note')->pack() ;
    my $note_w = $cw->Scrolled ( 'Text',
				    -height => 5 ,
				    -scrollbars => 'ow',
				  )
      ->pack(@fbe1);

    # read annotation and set up a callback to save user's entry at
    # every return
    $note_w ->  Contents($obj->annotation);
    $note_w -> bind('<Return>',
		       sub { $obj->annotation($note_w-> Contents ) ;}
		      );
    #$cw->Button(label=>'ok');
}
1;

