# $Author: ddumont $
# $Date: 2008-04-08 12:26:28 +0200 (Tue, 08 Apr 2008) $
# $Revision: 592 $

#    Copyright (c) 2005-2008 Dominique Dumont.
#
#    This file is part of Config-Model.
#
#    Config-Model is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser Public License as
#    published by the Free Software Foundation; either version 2.1 of
#    the License, or (at your option) any later version.
#
#    Config-Model is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser Public License for more details.
#
#    You should have received a copy of the GNU Lesser Public License
#    along with Config-Model; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
#    02110-1301 USA

use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

require 5.008;

print "If you want to use the TermUI interface, you should install\n",
  "Term::ReadLine::Perl or Term::ReadLine::Gnu\n";

WriteMakefile 
  (
   NAME         => 'Config-Model',
   VERSION_FROM => 'lib/Config/Model.pm',
   dist         => {COMPRESS=>'gzip -9f', SUFFIX => 'gz'},
   'EXE_FILES'  => [ 'config-edit' ],
   ABSTRACT     => 'Describe and edit configuration data',
   AUTHOR       => 'Dominique Dumont (ddumont at cpan dot org)',
   PREREQ_PM    => {
		    'Test::More'        => 0, # for test
		    'Term::ReadLine'    => 0,
		    'Log::Log4perl'     => '1.11', # for TRACE log level
		    'Parse::RecDescent' => '1.90',
		    'Scalar::Util'      => 0, # provided by perl 5.8.0
		    'Exception::Class'  => 0,
		    'Carp::Assert::More' => 0,
		    'Error'             => 0,

		    # recommended modules to get more reader/writer
		    'Config::Tiny' => 0,
		   },
   # cleanup required by t/auto_read.t
   # PreGrammar.pm is created by t/value_computer.t
   clean => {FILES => "PreGrammar.pm wr_test zero_test"}
  );

