# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230112200227;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]|
              636[457-9]
            )|
            9(?:
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                7[015-9]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17|
                3[015-9]
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3[045]|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9(?:
                  [019]|
                  4[1-3]|
                  6(?:
                    [0-47-9]|
                    5[01346-9]
                  )
                )
              )|
              3(?:
                [29]|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[23]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                72|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              6[1-3]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              829(?:
                2|
                66
              )|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{ja} = {"819673", "熊本一の宮",
"819804", "名護",
"818660", "岡山瀬戸",
"814229", "武蔵野三鷹",
"811544", "釧路",
"815959", "亀山",
"812995", "石岡",
"817904", "福崎",
"812239", "仙台",
"818398", "小郡",
"812644", "木曾福島",
"811944", "岩泉",
"817466", "十津川",
"81877", "丸亀",
"812838", "佐野",
"812878", "烏山",
"81467", "藤沢",
"8199345", "鹿児島",
"819822", "延岡",
"81463", "平塚",
"818594", "米子",
"817457", "大和高田",
"817456", "大和高田",
"81192", "大船渡",
"812615", "大町",
"81262", "長野",
"812580", "十日町",
"819722", "佐伯",
"812617", "大町",
"812616", "大町",
"811858", "能代",
"817994", "洲本",
"819963", "川内",
"817455", "大和高田",
"81495", "本庄",
"81424", "武蔵野三鷹",
"811393", "松前",
"815748", "美濃白川",
"819208", "対馬佐賀",
"815564", "鰍沢青柳",
"811868", "鷹巣",
"81944", "瀬高",
"811549", "釧路",
"814224", "武蔵野三鷹",
"81288", "今市",
"819953", "大口",
"819809", "八重山",
"817465", "吉野",
"812852", "小山",
"811732", "五所川原",
"81581", "高富",
"815954", "上野",
"812997", "潮来",
"812649", "長野",
"812234", "仙台",
"817614", "小松",
"812996", "潮来",
"819682", "山鹿",
"819553", "伊万里",
"81965", "八代",
"815368", "設楽",
"818466", "木江",
"818467", "木江",
"812655", "飯田",
"8182942", "広島",
"81460", "小田原",
"818206", "柳井",
"812576", "十日町",
"818207", "久賀",
"812577", "六日町",
"811955", "二戸",
"819786", "杵築",
"819787", "国東",
"818664", "高梁",
"8166", "大阪",
"8188095", "土佐清水",
"818587", "郡家",
"814754", "茂原",
"818586", "倉吉",
"814283", "青梅",
"8186997", "岡山瀬戸",
"811637", "北見枝幸",
"811636", "北見枝幸",
"81779", "大野",
"811555", "帯広",
"812977", "竜ケ崎",
"8125481", "村上",
"812976", "竜ケ崎",
"8186552", "倉敷",
"812936", "水戸",
"812640", "長野",
"818362", "宇部",
"812937", "水戸",
"818654", "鴨方",
"812798", "長野原",
"819542", "武雄",
"814291", "飯能",
"81233", "新庄",
"81950", "平戸",
"812589", "長岡",
"81184", "本荘",
"817713", "亀岡",
"81534", "浜松",
"819942", "大根占",
"81928", "福岡",
"81432", "千葉",
"812414", "柳津",
"818295", "廿日市",
"811333", "当別",
"811567", "十勝清水",
"818296", "広島",
"811566", "十勝清水",
"818297", "廿日市",
"819734", "日田",
"8112397", "栗山",
"81174", "蟹田",
"818974", "新居浜",
"815733", "恵那",
"812584", "長岡",
"819432", "八女",
"812898", "鹿沼",
"819913", "硫黄島",
"812743", "藤岡",
"817352", "新宮",
"818842", "阿南",
"81585", "揖斐川",
"8153974", "天竜",
"812419", "田島",
"81738", "御坊",
"812935", "水戸",
"812975", "水海道",
"818669", "総社",
"811556", "帯広",
"811635", "浜頓別",
"814220", "国分寺",
"811557", "十勝池田",
"812388", "長井",
"818585", "倉吉",
"815392", "浜松",
"811957", "岩手",
"81586", "一宮",
"8198291", "延岡",
"819785", "豊後高田",
"81742", "奈良",
"811956", "岩手",
"817362", "和歌山橋本",
"818205", "柳井",
"812575", "十日町",
"818378", "下関",
"812230", "仙台",
"812656", "伊那",
"812657", "伊那",
"815754", "関",
"811932", "釜石",
"8186553", "倉敷",
"81548", "榛原",
"811972", "水沢",
"818243", "東広島",
"818953", "宇和島",
"817673", "羽咋",
"812895", "宇都宮",
"818384", "萩",
"812672", "小諸",
"81476", "成田",
"81793", "姫路",
"81797", "西宮",
"818553", "浜田",
"81983", "高鍋",
"812796", "渋川",
"818682", "津山",
"8182943", "広島",
"812797", "渋川",
"812374", "村山",
"81987", "日南",
"811532", "根室",
"81434", "千葉",
"812938", "水戸",
"812978", "竜ケ崎",
"815764", "下呂",
"811638", "利尻礼文",
"81229", "古川",
"817492", "彦根",
"81532", "豊橋",
"818588", "郡家",
"818894", "須崎",
"812385", "米沢",
"81182", "横手",
"812780", "前橋",
"819788", "国東",
"818375", "美祢",
"812578", "六日町",
"818208", "久賀",
"819599", "大瀬戸",
"818563", "益田",
"812962", "下館",
"812658", "伊那",
"818794", "三本松",
"818377", "下関",
"817963", "豊岡",
"818376", "美祢",
"815769", "荘川",
"817722", "宮津",
"811958", "岩手",
"815993", "鳥羽",
"81485", "熊谷",
"8145", "横浜",
"812386", "長井",
"812387", "長井",
"81569", "半田",
"811558", "広尾",
"81172", "弘前",
"81766", "高岡",
"811364", "倶知安",
"812562", "三条",
"819594", "有川",
"811652", "士別",
"817704", "敦賀",
"81486", "浦和",
"81298", "土浦",
"812795", "渋川",
"81853", "出雲",
"81744", "大和高田",
"812242", "白石",
"818804", "土佐中村",
"81591", "津",
"811583", "紋別",
"817953", "西脇",
"818673", "福渡",
"81857", "鳥取",
"81220", "迫",
"812897", "鹿沼",
"81765", "魚津",
"811983", "花巻",
"812896", "鹿沼",
"81551", "韮崎",
"81977", "別府",
"812552", "上越",
"811354", "余市",
"814240", "国分寺",
"81893", "大洲",
"812911", "鉾田",
"818298", "廿日市",
"817682", "輪島",
"811463", "浦河",
"81126", "岩見沢",
"818693", "邑久",
"811855", "能代",
"817458", "大和榛原",
"815745", "美濃加茂",
"81471", "柏",
"819205", "厳原",
"81246", "いわき",
"812877", "黒磯",
"81899", "松山",
"812876", "黒磯",
"811524", "網走",
"812836", "佐野",
"811756", "野辺地",
"81979", "中津",
"811757", "野辺地",
"812837", "佐野",
"8112394", "夕張",
"811865", "大館",
"817468", "上北山",
"815973", "尾鷲",
"818879", "室戸",
"812543", "新発田",
"818472", "甲山",
"811453", "早来",
"819974", "屋久島",
"818397", "小郡",
"81125", "滝川",
"819934", "指宿",
"81728", "寝屋川",
"811643", "石狩深川",
"812482", "白河",
"814793", "銚子",
"819574", "諫早",
"817483", "八日市",
"8153977", "天竜",
"812784", "沼田",
"81567", "津島",
"8125488", "津川",
"817942", "加古川",
"81245", "福島",
"81563", "西尾",
"815366", "設楽",
"818834", "鴨島",
"817472", "五条",
"815367", "設楽",
"81227", "仙台",
"81555", "吉田",
"812473", "石川",
"818542", "安来",
"818874", "安芸",
"819979", "徳之島",
"812998", "潮来",
"815582", "下田",
"817734", "福知山",
"815982", "松阪",
"811233", "千歳",
"812551", "上越",
"81938", "北九州",
"81828", "広島",
"8198298", "日向",
"81143", "室蘭",
"818942", "八幡浜",
"812789", "前橋",
"819742", "三重",
"811866", "鷹巣",
"811867", "鷹巣",
"812835", "佐野",
"819664", "人吉",
"812692", "中野",
"812875", "大田原",
"813", "東京",
"815747", "美濃白川",
"815746", "美濃加茂",
"814703", "館山",
"818262", "加計",
"811857", "能代",
"812618", "大町",
"81596", "伊勢",
"817238", "寝屋川",
"8186994", "岡山瀬戸",
"811856", "能代",
"81989", "那覇",
"81942", "久留米",
"819672", "熊本一の宮",
"8124196", "柳津",
"81482", "川口",
"81888", "高知",
"811873", "角館",
"817995", "洲本",
"81778", "武生",
"818597", "根雨",
"817454", "大和高田",
"81584", "大垣",
"818596", "米子",
"81134", "小樽",
"8152", "名古屋",
"817239", "寝屋川",
"812619", "大町",
"811528", "美幌",
"815565", "鰍沢青柳",
"811947", "久慈",
"814225", "武蔵野三鷹",
"811946", "久慈",
"817464", "吉野",
"81839", "山口",
"81929", "福岡",
"815955", "上野",
"819823", "延岡",
"819978", "徳之島",
"812646", "長野",
"812930", "水戸",
"819938", "加世田",
"812647", "長野",
"812999", "潮来",
"8112398", "栗山",
"817906", "播磨山崎",
"817615", "小松",
"812235", "仙台",
"817907", "播磨山崎",
"8125484", "村上",
"819578", "島原",
"812570", "小出",
"814281", "相模原",
"812788", "前橋",
"819807", "沖縄宮古",
"811546", "釧路",
"819806", "沖縄宮古",
"811547", "白糠",
"81176", "十和田",
"81762", "金沢",
"819723", "佐伯",
"818838", "阿波池田",
"818464", "竹原",
"8164", "大阪",
"81739", "田辺",
"818878", "嶺北",
"819805", "名護",
"811545", "釧路",
"8199343", "鹿児島",
"812236", "仙台",
"817616", "小松",
"812994", "石岡",
"819962", "川内",
"817738", "舞鶴",
"812237", "仙台",
"817905", "福崎",
"817617", "加賀",
"811392", "木古内",
"812645", "木曾福島",
"815956", "上野",
"815957", "上野",
"814227", "武蔵野三鷹",
"811945", "久慈",
"814226", "武蔵野三鷹",
"8198294", "延岡",
"81862", "岡山",
"81468", "横須賀",
"815566", "身延",
"81535", "浜松",
"819668", "水俣",
"819952", "大口",
"811733", "五所川原",
"812853", "小山",
"81998", "鹿児島",
"817459", "大和榛原",
"81878", "高松",
"818290", "広島",
"818595", "米子",
"8153961", "天竜",
"819683", "山鹿",
"81958", "長崎",
"812614", "大町",
"817996", "津名",
"817997", "津名",
"81277", "桐生",
"819552", "伊万里",
"8186998", "岡山瀬戸",
"81273", "高崎",
"812417", "会津山口",
"815758", "郡上八幡",
"8147957", "八日市場",
"812416", "田島",
"819735", "日田",
"818975", "新居浜",
"81552", "甲府",
"818388", "田万川",
"812585", "長岡",
"81592", "津",
"814282", "青梅",
"812378", "寒河江",
"81946", "甘木",
"818299", "広島",
"818363", "宇部",
"818657", "笠岡",
"81425", "立川",
"81494", "秩父",
"818656", "笠岡",
"812659", "伊那",
"812934", "高萩",
"812974", "水海道",
"815768", "下呂",
"811634", "浜頓別",
"81964", "松橋",
"819543", "武雄",
"81737", "湯浅",
"814756", "東金",
"818584", "倉吉",
"814757", "東金",
"817712", "亀岡",
"81426", "八王子",
"811559", "帯広",
"818666", "井原",
"819943", "鹿屋",
"819784", "豊後高田",
"818667", "井原",
"811372", "鹿部",
"812574", "柏崎",
"818204", "柳井",
"81280", "古河",
"811332", "当別",
"812939", "水戸",
"812654", "飯田",
"818798", "土庄",
"812979", "竜ケ崎",
"81923", "福岡",
"815732", "恵那",
"81833", "下松",
"811954", "二戸",
"818665", "高梁",
"8161", "大阪",
"811639", "利尻礼文",
"81927", "福岡",
"819433", "八女",
"819912", "中之島",
"812742", "藤岡",
"817353", "新宮",
"814755", "東金",
"81531", "田原",
"819789", "杵築",
"81270", "伊勢崎",
"811554", "帯広",
"818843", "阿南",
"812579", "小出",
"819598", "福江",
"814992", "伊豆大島",
"818655", "鴨方",
"818808", "土佐清水",
"8188093", "窪川",
"812586", "長岡",
"81242", "会津若松",
"812587", "長岡",
"815393", "浜松",
"819737", "玖珠",
"818976", "新居浜",
"817363", "和歌山橋本",
"818977", "伯方",
"817230", "寝屋川",
"811564", "上士幌",
"812415", "柳津",
"818294", "廿日市",
"811933", "釜石",
"81492", "川越",
"81898", "今治",
"818795", "三本松",
"811973", "水沢",
"818952", "宇和島",
"818668", "井原",
"818242", "東広島",
"81253", "新潟",
"817672", "羽咋",
"812673", "小諸",
"81930", "行橋",
"81594", "桑名",
"8112391", "夕張",
"812389", "米沢",
"814758", "東金",
"8199331", "鹿児島",
"818896", "須崎",
"81554", "大月",
"815766", "下呂",
"815767", "下呂",
"818552", "浜田",
"81167", "富良野",
"818683", "津山",
"811365", "倶知安",
"819595", "有川",
"811533", "根室",
"812376", "寒河江",
"817705", "小浜",
"812794", "渋川",
"812377", "寒河江",
"817493", "彦根",
"818805", "土佐中村",
"812830", "宇都宮",
"81729", "八尾",
"812899", "鹿沼",
"818387", "田万川",
"81962", "熊本",
"8188090", "窪川",
"815757", "郡上八幡",
"818562", "益田",
"815756", "郡上八幡",
"812418", "会津山口",
"8198297", "日向",
"815755", "関",
"812963", "下館",
"818978", "伯方",
"812799", "長野原",
"819738", "玖珠",
"817962", "豊岡",
"811356", "岩内",
"81939", "北九州",
"811357", "岩内",
"817723", "宮津",
"812588", "長岡",
"815992", "鳥羽",
"818385", "萩",
"812894", "宇都宮",
"818493", "尾道",
"8125487", "津川",
"81196", "盛岡",
"818806", "宿毛",
"814701", "鴨川",
"818807", "宿毛",
"817707", "小浜",
"817706", "小浜",
"812375", "村山",
"814772", "市川",
"81266", "諏訪",
"812563", "三条",
"81798", "西宮",
"811367", "寿都",
"811653", "士別",
"819596", "福江",
"811366", "寿都",
"819597", "福江",
"8188099", "土佐清水",
"812243", "白石",
"81988", "那覇",
"815765", "下呂",
"817952", "西脇",
"81244", "原町",
"811582", "紋別",
"812384", "米沢",
"818895", "須崎",
"818672", "福渡",
"81547", "島田",
"811982", "花巻",
"812553", "上越",
"81543", "静岡",
"8188092", "窪川",
"818797", "土庄",
"818374", "長門",
"818796", "土庄",
"817683", "輪島",
"81124", "芦別",
"811869", "大館",
"818835", "脇町",
"811462", "浦河",
"812786", "沼田",
"811548", "弟子屈",
"812787", "沼田",
"819808", "八重山",
"818692", "邑久",
"818875", "土佐山田",
"819576", "島原",
"819577", "島原",
"817908", "播磨山崎",
"817735", "福知山",
"812648", "長野",
"81582", "岐阜",
"819936", "加世田",
"819937", "加世田",
"819977", "瀬戸内",
"819976", "名瀬",
"8183766", "下関",
"81549", "静岡",
"81484", "川口",
"818512", "西郷",
"81937", "北九州",
"81250", "新津",
"81827", "岩国",
"811754", "むつ",
"812834", "宇都宮",
"81764", "富山",
"812874", "大田原",
"812542", "新発田",
"811526", "網走",
"815972", "尾鷲",
"819665", "人吉",
"81933", "北九州",
"811527", "美幌",
"81823", "呉",
"818473", "甲山",
"811452", "早来",
"812483", "白河",
"811642", "石狩深川",
"818598", "根雨",
"814792", "銚子",
"81228", "築館",
"817482", "八日市",
"817943", "加古川",
"812839", "佐野",
"817473", "五条",
"81723", "堺",
"812890", "宇都宮",
"812472", "石川",
"81727", "池田",
"818543", "安来",
"81864", "倉敷",
"812879", "烏山",
"811854", "男鹿",
"817998", "津名",
"81191", "一関",
"81568", "春日井",
"815583", "下田",
"815744", "美濃加茂",
"815983", "松阪",
"811232", "千歳",
"819204", "郷ノ浦",
"8188096", "土佐清水",
"819667", "水俣",
"818943", "八幡浜",
"819666", "水俣",
"811525", "網走",
"81436", "市原",
"817912", "相生",
"819743", "三重",
"812913", "鉾田",
"81845", "因島",
"811864", "大館",
"81259", "佐渡",
"812693", "中野",
"814228", "武蔵野三鷹",
"819975", "名瀬",
"815958", "亀山",
"819935", "加世田",
"812238", "仙台",
"817618", "加賀",
"814702", "館山",
"817736", "舞鶴",
"818263", "加計",
"817737", "舞鶴",
"81474", "船橋",
"819575", "諫早",
"818876", "土佐山田",
"814771", "市川",
"81572", "多治見",
"818877", "嶺北",
"812785", "沼田",
"818837", "阿波池田",
"818836", "脇町",
"8125485", "津川",
"811753", "むつ",
"812833", "宇都宮",
"818549", "石見大田",
"812873", "大田原",
"818474", "府中",
"819972", "種子島",
"81533", "豊橋",
"815589", "修善寺大仁",
"81537", "掛川",
"819932", "指宿",
"814705", "館山",
"812484", "白河",
"81234", "酒田",
"819572", "諫早",
"81183", "湯沢",
"8188091", "窪川",
"818696", "備前",
"81429", "所沢",
"812782", "沼田",
"818697", "備前",
"818949", "宇和",
"817944", "加古川",
"811466", "えりも",
"8112390", "夕張",
"819678", "矢部",
"812475", "石川",
"8186999", "岡山瀬戸",
"817486", "水口",
"814797", "八日市場",
"814796", "八日市場",
"817487", "水口",
"811647", "羽幌",
"811646", "羽幌",
"811235", "夕張",
"818680", "岡山",
"811457", "門別富川",
"81792", "姫路",
"81949", "直方",
"811456", "門別富川",
"812547", "村上",
"8186992", "備前",
"815977", "熊野",
"812546", "村上",
"817915", "相生",
"811522", "斜里",
"81276", "太田",
"811863", "鹿角",
"819662", "人吉",
"812694", "中野",
"817916", "竜野",
"812545", "村上",
"817917", "竜野",
"811455", "鵡川",
"81852", "松江",
"811237", "栗山",
"811236", "千歳",
"811645", "留萌",
"8162", "大阪",
"818264", "安芸吉田",
"81892", "久万",
"814795", "銚子",
"817485", "八日市",
"81286", "宇都宮",
"812477", "三春",
"812476", "三春",
"819558", "唐津",
"812550", "安塚",
"81420", "所沢",
"815363", "新城",
"818832", "鴨島",
"818490", "尾道",
"817474", "五条",
"811465", "静内",
"818479", "東城",
"818544", "木次",
"818872", "室戸",
"818695", "岡山瀬戸",
"811853", "男鹿",
"8198295", "日向",
"814707", "大原",
"8112392", "夕張",
"819968", "出水",
"814706", "大原",
"817732", "福知山",
"815584", "下田",
"815984", "松阪",
"815743", "美濃加茂",
"8112399", "栗山",
"812560", "糸魚川",
"812489", "須賀川",
"81940", "宗像",
"811398", "熊石",
"818944", "八幡浜",
"81177", "青森",
"812914", "鉾田",
"819744", "三重",
"817949", "加古川",
"812793", "渋川",
"8153963", "天竜",
"818556", "江津",
"815762", "下呂",
"81926", "福岡",
"818557", "川本",
"817494", "彦根",
"811585", "遠軽",
"817955", "三田",
"818675", "久世",
"818892", "佐川",
"817718", "園部",
"81179", "三戸",
"817940", "加古川",
"818957", "御荘",
"817676", "七尾",
"818247", "庄原",
"81464", "厚木",
"818956", "宇和島",
"817677", "七尾",
"818246", "三次",
"81562", "尾張横須賀",
"8186996", "岡山瀬戸",
"811378", "今金",
"812569", "巻",
"815752", "関",
"81835", "防府",
"81925", "福岡",
"811934", "釜石",
"818567", "津和野",
"811974", "水沢",
"817965", "豊岡",
"81578", "神岡",
"818382", "萩",
"815995", "阿児",
"812674", "小諸",
"814288", "青梅",
"812559", "安塚",
"818684", "津山",
"812372", "村山",
"814775", "船橋",
"811534", "中標津",
"811654", "名寄",
"814777", "船橋",
"81774", "宇治",
"811939", "宮古",
"814776", "船橋",
"817702", "敦賀",
"81281", "宇都宮",
"818802", "窪川",
"812244", "白石",
"8112396", "栗山",
"812679", "佐久",
"812383", "米沢",
"815997", "阿児",
"815996", "阿児",
"812554", "上越",
"8186698", "倉敷",
"811352", "余市",
"818373", "長門",
"817966", "八鹿",
"818689", "岡山",
"817967", "八鹿",
"81138", "函館",
"818565", "益田",
"811539", "根室標津",
"817684", "輪島",
"819233", "前原",
"81947", "田川",
"812964", "下館",
"81222", "仙台",
"818792", "三本松",
"818245", "三次",
"818955", "宇和島",
"817724", "宮津",
"817675", "七尾",
"815738", "中津川",
"812893", "宇都宮",
"811986", "遠野",
"811987", "遠野",
"817957", "丹波柏原",
"81427", "相模原",
"818676", "久世",
"811587", "中湧別",
"812748", "富岡",
"817956", "三田",
"818677", "新見",
"81142", "伊達",
"811586", "中湧別",
"81423", "国分寺",
"818555", "江津",
"811362", "倶知安",
"814998", "小笠原",
"812564", "三条",
"819592", "大瀬戸",
"818652", "倉敷",
"812933", "高萩",
"811541", "弟子屈",
"81564", "岡崎",
"812973", "水海道",
"819544", "武雄",
"81462", "厚木",
"814286", "相模原",
"818583", "倉吉",
"814287", "青梅",
"81157", "北見",
"8153962", "天竜",
"819783", "豊後高田",
"819944", "鹿屋",
"812573", "柏崎",
"818203", "柳井",
"81721", "富田林",
"81263", "松本",
"81545", "富士",
"812412", "喜多方",
"818568", "津和野",
"811336", "石狩",
"81952", "佐賀",
"811337", "石狩",
"811377", "八雲",
"811376", "八雲",
"817678", "七尾",
"815735", "恵那",
"818958", "御荘",
"818248", "庄原",
"818662", "高梁",
"817717", "園部",
"817716", "園部",
"815399", "天竜",
"812745", "藤岡",
"814752", "茂原",
"818558", "川本",
"8188098", "土佐清水",
"81546", "静岡",
"818364", "宇部",
"8163", "大阪",
"81992", "鹿児島",
"81478", "佐原",
"814996", "八丈島",
"812747", "富岡",
"818678", "新見",
"812746", "富岡",
"817958", "丹波柏原",
"811588", "興部",
"817715", "亀岡",
"815394", "浜松",
"815737", "中津川",
"81488", "浦和",
"815736", "中津川",
"81849", "福山",
"811375", "八雲",
"817364", "和歌山橋本",
"811563", "本別",
"81166", "旭川",
"8153960", "天竜",
"818293", "廿日市",
"818369", "宇部",
"812653", "飯田",
"819732", "日田",
"817968", "浜坂",
"818972", "新居浜",
"811953", "二戸",
"8182920", "廿日市",
"812582", "長岡",
"815998", "阿児",
"81144", "苫小牧",
"819434", "八女",
"814285", "相模原",
"817354", "新宮",
"819949", "大根占",
"81439", "木更津",
"811553", "帯広",
"81740", "今津",
"818844", "阿南",
"8183768", "下関",
"81726", "茨木",
"819955", "加治木",
"817463", "吉野",
"815978", "熊野",
"819824", "延岡",
"818592", "米子",
"8144", "川崎",
"811648", "焼尻",
"817488", "水口",
"814798", "八日市場",
"819940", "志布志",
"819555", "唐津",
"81433", "千葉",
"819677", "矢部",
"819676", "高森",
"8186993", "備前",
"81984", "小林",
"818698", "備前",
"819802", "南大東",
"811874", "角館",
"811542", "釧路",
"812859", "小山",
"81725", "和泉",
"819965", "川内",
"817453", "大和高田",
"817902", "福崎",
"811395", "江差",
"812642", "木曾福島",
"818360", "小郡",
"81260", "阿南町",
"811942", "岩泉",
"814222", "武蔵野三鷹",
"812854", "小山",
"811734", "五所川原",
"815952", "上野",
"811397", "奥尻",
"81825", "広島",
"811396", "江差",
"81935", "北九州",
"819967", "出水",
"8147955", "八日市場",
"812232", "岩沼",
"817612", "小松",
"814708", "大原",
"819966", "出水",
"81743", "奈良",
"812613", "大町",
"819684", "山鹿",
"819675", "熊本一の宮",
"819724", "佐伯",
"818463", "竹原",
"819557", "唐津",
"81936", "北九州",
"819556", "唐津",
"812478", "三春",
"817992", "洲本",
"812993", "石岡",
"811238", "栗山",
"8186691", "倉敷",
"8112393", "夕張",
"819956", "加治木",
"81199", "盛岡",
"819957", "加治木",
"815562", "鰍沢青柳",
"818514", "海士",
"811752", "むつ",
"812832", "佐野",
"812544", "新発田",
"812872", "大田原",
"815974", "尾鷲",
"812695", "中野",
"819973", "種子島",
"8124197", "柳津",
"819828", "高千穂",
"811454", "鵡川",
"8198293", "延岡",
"819933", "指宿",
"81178", "八戸",
"81775", "大津",
"811644", "留萌",
"81963", "熊本",
"818265", "安芸吉田",
"814794", "銚子",
"81734", "和歌山",
"817484", "八日市",
"819573", "諫早",
"812783", "沼田",
"81885", "小松島",
"817947", "三木",
"817946", "三木",
"811464", "静内",
"817475", "下市",
"811878", "大曲",
"81493", "東松山",
"818694", "岡山",
"818545", "木次",
"818240", "東広島",
"8111", "札幌",
"814298", "飯能",
"812487", "須賀川",
"815585", "下田",
"81252", "新潟",
"812486", "須賀川",
"81292", "水戸",
"815985", "松阪",
"814709", "鴨川",
"81886", "徳島",
"818476", "府中",
"818945", "八幡浜",
"818477", "東城",
"81776", "福井",
"811523", "斜里",
"81162", "稚内",
"8186697", "倉敷",
"812917", "水戸",
"819747", "竹田",
"817950", "三田",
"811862", "鹿角",
"819746", "竹田",
"818947", "宇和",
"81956", "佐世保",
"819663", "人吉",
"818946", "宇和",
"818475", "府中",
"81465", "小田原",
"812858", "真岡",
"811738", "鰺ケ沢",
"815987", "三瀬谷",
"815986", "松阪",
"812485", "白河",
"814704", "館山",
"815586", "下田",
"81542", "静岡",
"815587", "修善寺大仁",
"819688", "玉名",
"818546", "掛合",
"818547", "掛合",
"817476", "下市",
"817945", "加古川",
"815362", "新城",
"818833", "鴨島",
"8125483", "村上",
"819728", "臼杵",
"812474", "石川",
"81188", "秋田",
"815979", "熊野",
"818873", "安芸",
"812549", "津川",
"8147950", "八日市場",
"817960", "八鹿",
"811852", "男鹿",
"818266", "千代田",
"81466", "藤沢",
"818267", "千代田",
"817733", "福知山",
"81924", "福岡",
"811234", "千歳",
"815742", "美濃加茂",
"81834", "徳山",
"814770", "市川",
"81875", "観音寺",
"812697", "飯山",
"81538", "磐田",
"812696", "飯山",
"8175", "京都",
"817914", "相生",
"811536", "厚岸",
"811655", "名寄",
"81822", "広島",
"81932", "北九州",
"811537", "中標津",
"8169", "大阪",
"818686", "津山",
"817969", "浜坂",
"818687", "美作",
"812792", "渋川",
"812245", "大河原",
"815763", "下呂",
"812955", "常陸大宮",
"818893", "佐川",
"815999", "津",
"812677", "佐久",
"812676", "佐久",
"812555", "糸魚川",
"818391", "小郡",
"819948", "志布志",
"811976", "北上",
"811977", "北上",
"8165", "大阪",
"811937", "宮古",
"818564", "益田",
"8126177", "長野",
"811936", "宮古",
"817685", "輪島",
"815753", "関",
"812965", "下館",
"818690", "岡山",
"818954", "宇和島",
"818244", "三次",
"817674", "羽咋",
"817725", "宮津",
"81948", "飯塚",
"81284", "足利",
"818679", "新見",
"818383", "萩",
"811589", "興部",
"817959", "三田",
"81587", "一宮",
"81583", "岐阜",
"817496", "長浜",
"818554", "浜田",
"817497", "長浜",
"8188094", "窪川",
"812373", "村山",
"812565", "三条",
"818368", "宇部",
"812566", "三条",
"81235", "鶴岡",
"812567", "巻",
"817703", "敦賀",
"817495", "長浜",
"818249", "東広島",
"818803", "土佐中村",
"817954", "西脇",
"811584", "遠軽",
"812382", "米沢",
"818674", "久世",
"815398", "浜松",
"811984", "花巻",
"817726", "峰山",
"818559", "川本",
"817727", "峰山",
"811353", "余市",
"818372", "長門",
"81577", "高山",
"817368", "岩出",
"812967", "笠間",
"814700", "鴨川",
"819232", "前原",
"817686", "能都",
"811935", "釜石",
"817687", "能都",
"818793", "三本松",
"81722", "堺",
"817964", "豊岡",
"811975", "水沢",
"81236", "山形",
"812557", "新井",
"812556", "糸魚川",
"812675", "佐久",
"815994", "阿児",
"812892", "宇都宮",
"819438", "田主丸",
"812956", "常陸大宮",
"812246", "大河原",
"812957", "大子",
"812247", "大河原",
"818848", "牟岐",
"818685", "津山",
"811363", "倶知安",
"819593", "大瀬戸",
"81969", "天草",
"811656", "美深",
"811535", "厚岸",
"81550", "御殿場",
"818367", "宇部",
"812932", "高萩",
"818366", "宇部",
"812972", "水海道",
"811632", "天塩",
"817498", "長浜",
"818582", "倉吉",
"817714", "亀岡",
"815395", "浜松",
"819782", "豊後高田",
"811374", "森",
"817365", "和歌山橋本",
"81763", "福野",
"818202", "柳井",
"812572", "柏崎",
"81975", "大分",
"812413", "喜多方",
"81934", "北九州",
"81487", "浦和",
"811938", "宮古",
"811978", "北上",
"819946", "鹿屋",
"818663", "総社",
"819947", "志布志",
"819435", "八女",
"812678", "佐久",
"81282", "栃木",
"817355", "新宮",
"814284", "立川",
"814753", "茂原",
"819547", "鹿島",
"8198296", "日向",
"81896", "伊予三島",
"819546", "鹿島",
"818688", "美作",
"818845", "丹生谷",
"81249", "郡山",
"811538", "根室標津",
"811658", "上川",
"81559", "沼津",
"818847", "牟岐",
"818846", "丹生谷",
"812248", "大河原",
"817356", "串本",
"81473", "市川",
"817357", "串本",
"814289", "青梅",
"819437", "田主丸",
"819945", "鹿屋",
"812558", "新井",
"8125486", "津川",
"81986", "都城",
"81272", "前橋",
"817688", "能都",
"811562", "本別",
"818292", "広島",
"812968", "笠間",
"81561", "瀬戸",
"812652", "飯田",
"8178", "神戸",
"817367", "岩出",
"819733", "日田",
"817366", "岩出",
"818973", "新居浜",
"817728", "峰山",
"815734", "恵那",
"811952", "二戸",
"815396", "浜松",
"815397", "浜松",
"812583", "長岡",
"81268", "上田",
"812744", "藤岡",
"81985", "宮崎",
"811552", "帯広",
"8199347", "鹿児島",
"81724", "岸和田貝塚",
"818365", "宇部",
"812568", "巻",
"81863", "玉野",
"81240", "磐城富岡",
"814994", "三宅",
"8168", "大阪",
"818478", "東城",
"81226", "気仙沼",
"812855", "小山",
"811735", "五所川原",
"8198299", "日向",
"81480", "久喜",
"819969", "中甑",
"8183767", "下関",
"818593", "米子",
"814297", "飯能",
"812488", "須賀川",
"819685", "玉名",
"8198292", "延岡",
"8112395", "栗山",
"811876", "大曲",
"811877", "大曲",
"817948", "三木",
"819725", "佐伯",
"819674", "熊本一の宮",
"819803", "名護",
"811543", "釧路",
"81553", "山梨",
"817452", "大和高田",
"81294", "常陸太田",
"81225", "石巻",
"81557", "伊東",
"817903", "福崎",
"812643", "木曾福島",
"81593", "四日市",
"819826", "日向",
"8125480", "村上",
"819827", "高千穂",
"811943", "岩泉",
"814280", "立川",
"812571", "六日町",
"8186995", "岡山瀬戸",
"819679", "高森",
"81848", "尾道",
"814223", "武蔵野三鷹",
"812698", "飯山",
"819954", "加治木",
"81489", "草加",
"815953", "上野",
"819825", "日向",
"81544", "富士宮",
"818268", "千代田",
"811551", "十勝池田",
"817613", "小松",
"812233", "岩沼",
"812612", "大町",
"81565", "豊田",
"81243", "二本松",
"819554", "伊万里",
"8198290", "延岡",
"819727", "臼杵",
"8188097", "土佐清水",
"819726", "臼杵",
"8182941", "広島",
"818462", "竹原",
"8125489", "津川",
"818548", "石見大田",
"811875", "角館",
"8167", "大阪",
"819687", "玉名",
"817993", "洲本",
"81438", "木更津",
"819686", "玉名",
"819964", "川内",
"812992", "石岡",
"81832", "下関",
"815588", "修善寺大仁",
"81922", "福岡",
"811394", "松前",
"815988", "三瀬谷",
"811736", "五所川原",
"812856", "真岡",
"811737", "鰺ケ沢",
"812857", "真岡",
"8128798", "大田原",
"8125482", "村上",
"818948", "宇和",
"815563", "鰍沢青柳",
"81566", "刈谷",};
$areanames{en} = {"81578", "Kamioka\,\ Akita",
"81950", "Hirado\,\ Nagasaki",
"818382", "Hagi\,\ Yamaguchi",
"815995", "Ago\,\ Mie",
"812674", "Komoro\,\ Nagano",
"812589", "Nagaoka\,\ Niigata",
"81184", "Yurihonjo\,\ Akita",
"819542", "Takeo\,\ Saga",
"81233", "Shinjo\,\ Yamagata",
"814291", "Hanno\,\ Saitama",
"812798", "Naganohara\,\ Gunma",
"817965", "Toyooka\,\ Hyogo",
"811974", "Mizusawa\,\ Iwate",
"81835", "Hofu\,\ Yamaguchi",
"815752", "Sekigahara\,\ Gifu",
"81925", "Fukuoka\,\ Fukuoka",
"811934", "Kamaishi\,\ Iwate",
"818567", "Tsuwano\,\ Shimane",
"818654", "Kamogata\,\ Okayama",
"81432", "Chiba\,\ Chiba",
"812414", "Yanaizu\,\ Fukushima",
"814775", "Funabashi\,\ Chiba",
"811534", "Nakashibetsu\,\ Hokkaido",
"818295", "Hatsukaichi\,\ Hiroshima",
"811333", "Tobetsu\,\ Hokkaido",
"818684", "Tsuyama\,\ Okayama",
"812372", "Murayama\,\ Yamagata",
"81928", "Fukuoka\,\ Fukuoka",
"812559", "Yasuzuka\,\ Niigata",
"814288", "Ome\,\ Tokyo",
"817713", "Kameoka\,\ Kyoto",
"81534", "Hamamatsu\,\ Shizuoka",
"811585", "Engaru\,\ Hokkaido",
"817955", "Sanda\,\ Hyogo",
"8188095", "Tosashimizu\,\ Kochi",
"818675", "Kuse\,\ Okayama",
"818892", "Sakawa\,\ Kochi",
"811955", "Ninohe\,\ Iwate",
"819786", "Kitsuki\,\ Oita",
"818556", "Gotsu\,\ Shimane",
"815762", "Gero\,\ Gifu",
"81926", "Fukuoka\,\ Fukuoka",
"8153973", "Hamamatsu\,\ Shizuoka",
"818557", "Kawamoto\,\ Shimane",
"819787", "Kunisaki\,\ Oita",
"818664", "Takahashi\,\ Okayama",
"817494", "Hikone\,\ Shiga",
"8166", "Osaka\,\ Osaka",
"81460", "Odawara\,\ Kanagawa",
"812576", "Tokamachi\,\ Niigata",
"818206", "Yanai\,\ Yamaguchi",
"812793", "Shibukawa\,\ Gunma",
"812577", "Muika\,\ Niigata",
"812655", "Iida\,\ Nagano",
"8182942", "Hiroshima\,\ Hiroshima",
"8186552", "Kurashiki\,\ Okayama",
"812640", "Nagano\,\ Nagano",
"812936", "Mito\,\ Ibaraki",
"818362", "Ube\,\ Yamaguchi",
"812937", "Mito\,\ Ibaraki",
"8186996", "Seto\,\ Okayama",
"8125481", "Murakami\,\ Niigata",
"811378", "Imakane\,\ Hokkaido",
"818957", "Misho\,\ Ehime",
"817676", "Nanao\,\ Ishikawa",
"818247", "Shobara\,\ Hiroshima",
"81464", "Atsugi\,\ Kanagawa",
"818956", "Uwajima\,\ Ehime",
"817677", "Nanao\,\ Ishikawa",
"81779", "Ono\,\ Gifu",
"818246", "Miyoshi\,\ Hiroshima",
"811555", "Obihiro\,\ Hokkaido",
"818587", "Koge\,\ Tottori",
"817718", "Sonobe\,\ Kyoto",
"81179", "Sannohe\,\ Aomori",
"814754", "Mobara\,\ Chiba",
"818586", "Kurayoshi\,\ Tottori",
"817940", "Kakogawa\,\ Hyogo",
"814283", "Ome\,\ Tokyo",
"8186997", "Seto\,\ Okayama",
"811986", "Tono\,\ Iwate",
"812893", "Utsunomiya\,\ Tochigi",
"812388", "Nagai\,\ Yamagata",
"818585", "Kurayoshi\,\ Tottori",
"811987", "Tono\,\ Iwate",
"818669", "Soja\,\ Okayama",
"811556", "Obihiro\,\ Hokkaido",
"818245", "Miyoshi\,\ Hiroshima",
"818955", "Uwajima\,\ Ehime",
"811635", "Hamatonbetsu\,\ Hokkaido",
"817724", "Miyazu\,\ Kyoto",
"814220", "Kokubunji\,\ Tokyo",
"817675", "Nanao\,\ Ishikawa",
"815738", "Nakatsugawa\,\ Gifu",
"812964", "Shimodate\,\ Ibaraki",
"81222", "Sendai\,\ Miyagi",
"812935", "Mito\,\ Ibaraki",
"811362", "Kutchan\,\ Hokkaido",
"812230", "Sendai\,\ Miyagi",
"814998", "Ogasawara\,\ Tokyo",
"812656", "Ina\,\ Nagano",
"812657", "Ina\,\ Nagano",
"812564", "Sanjo\,\ Niigata",
"819592", "Oseto\,\ Nagasaki",
"812575", "Tokamachi\,\ Niigata",
"818205", "Yanai\,\ Yamaguchi",
"818378", "Shimonoseki\,\ Yamaguchi",
"811957", "Iwate\,\ Iwate",
"8198291", "Nobeoka\,\ Miyazaki",
"81586", "Ichinomiya\,\ Aichi",
"819785", "Bungotakada\,\ Oita",
"81423", "Kokubunji\,\ Tokyo",
"818555", "Gotsu\,\ Shimane",
"81742", "Nara\,\ Nara",
"811956", "Iwate\,\ Iwate",
"81427", "Sagamihara\,\ Kanagawa",
"818676", "Kuse\,\ Okayama",
"811587", "Nakayubetsu\,\ Hokkaido",
"812748", "Tomioka\,\ Gunma",
"817956", "Sanda\,\ Hyogo",
"818677", "Niimi\,\ Okayama",
"815392", "Hamamatsu\,\ Shizuoka",
"81142", "Date\,\ Hokkaido",
"811586", "Nakayubetsu\,\ Hokkaido",
"812584", "Nagaoka\,\ Niigata",
"812679", "Saku\,\ Nagano",
"8112396", "Kuriyama\,\ Hokkaido",
"819432", "Yame\,\ Fukuoka",
"812898", "Kanuma\,\ Tochigi",
"812383", "Yonezawa\,\ Yamagata",
"815733", "Ena\,\ Gifu",
"81281", "Utsunomiya\,\ Tochigi",
"812244", "Shiroishi\,\ Miyagi",
"819734", "Hita\,\ Oita",
"817702", "Tsuruga\,\ Fukui",
"8112397", "Kuriyama\,\ Hokkaido",
"81174", "Kanita\,\ Aomori",
"818974", "Niihama\,\ Ehime",
"814777", "Funabashi\,\ Chiba",
"811654", "Nayoro\,\ Hokkaido",
"818296", "Hiroshima\,\ Hiroshima",
"81774", "Uji\,\ Kyoto",
"811939", "Miyako\,\ Iwate",
"814776", "Funabashi\,\ Chiba",
"818297", "Hatsukaichi\,\ Hiroshima",
"81585", "Ibigawa\,\ Gifu",
"818565", "Masuda\,\ Shimane",
"817684", "Wajima\,\ Ishikawa",
"81947", "Tagawa\,\ Fukuoka",
"819233", "Maebaru\,\ Fukuoka",
"812419", "Tajima\,\ Fukushima",
"8153964", "Hamamatsu\,\ Shizuoka",
"81738", "Gobo\,\ Wakayama",
"818373", "Nagato\,\ Yamaguchi",
"818689", "Okayama\,\ Okayama",
"818842", "Anan\,\ Tokushima",
"81138", "Hakodate\,\ Hokkaido",
"8186698", "Kurashiki\,\ Okayama",
"812554", "Joetsu\,\ Niigata",
"811352", "Yoichi\,\ Hokkaido",
"815997", "Ago\,\ Mie",
"812743", "Fujioka\,\ Gunma",
"815996", "Ago\,\ Mie",
"817352", "Shingu\,\ Fukuoka",
"811647", "Haboro\,\ Hokkaido",
"81463", "Hiratsuka\,\ Kanagawa",
"811646", "Haboro\,\ Hokkaido",
"814797", "Yokaichiba\,\ Chiba",
"817486", "Minakuchi\,\ Shiga",
"81467", "Fujisawa\,\ Kanagawa",
"819822", "Nobeoka\,\ Miyazaki",
"8199345", "Kagoshima\,\ Kagoshima",
"814796", "Yokaichiba\,\ Chiba",
"817487", "Minakuchi\,\ Shiga",
"812475", "Ishikawa\,\ Fukushima",
"812878", "Nasukarasuyama\,\ Tochigi",
"8186999", "Seto\,\ Okayama",
"812838", "Sano\,\ Tochigi",
"8112390", "Yubari\,\ Hokkaido",
"81276", "Ota\,\ Gunma",
"812547", "Murakami\,\ Niigata",
"815977", "Kumano\,\ Mie",
"8186992", "Bizen\,\ Okayama",
"81262", "Nagano\,\ Nagano",
"817915", "Aioi\,\ Hyogo",
"812546", "Murakami\,\ Niigata",
"811522", "Shari\,\ Hokkaido",
"818680", "Okayama\,\ Okayama",
"812615", "Omachi\,\ Nagano",
"81792", "Himeji\,\ Hyogo",
"81949", "Nogata\,\ Fukuoka",
"818594", "Yonago\,\ Tottori",
"811235", "Yubari\,\ Hokkaido",
"817457", "Yamatotakada\,\ Nara",
"817456", "Yamatotakada\,\ Nara",
"81192", "Ofunato\,\ Iwate",
"812995", "Ishioka\,\ Ibaraki",
"81537", "Kakegawa\,\ Shizuoka",
"819932", "Ibusuki\,\ Kagoshima",
"817904", "Fukusaki\,\ Hyogo",
"815959", "Kameyama\,\ Mie",
"81533", "Toyohashi\,\ Aichi",
"819804", "Nago\,\ Okinawa",
"812873", "Otawara\,\ Tochigi",
"818660", "Seto\,\ Okayama",
"818474", "Fuchu\,\ Hiroshima",
"811544", "Kushiro\,\ Hokkaido",
"8125485", "Tsugawa\,\ Niigata",
"812833", "Utsunomiya\,\ Tochigi",
"811753", "Mutsu\,\ Aomori",
"817944", "Kakogawa\,\ Hyogo",
"811466", "Erimo\,\ Hokkaido",
"811944", "Iwaizumi\,\ Iwate",
"818696", "Bizen\,\ Okayama",
"817466", "Totsukawa\,\ Nara",
"81429", "Tokorozawa\,\ Saitama",
"812782", "Numata\,\ Gunma",
"818949", "Uwajima\,\ Ehime",
"818697", "Bizen\,\ Okayama",
"81877", "Marugame\,\ Kagawa",
"819572", "Isahaya\,\ Nagasaki",
"81183", "Yuzawa\,\ Akita",
"814705", "Tateyama\,\ Chiba",
"812484", "Shirakawa\,\ Fukushima",
"812239", "Sendai\,\ Miyagi",
"818398", "Ogori\,\ Yamaguchi",
"81234", "Sakata\,\ Yamagata",
"8198295", "Hyuga\,\ Miyazaki",
"8112392", "Yubari\,\ Hokkaido",
"819968", "Izumi\,\ Kagoshima",
"817732", "Fukuchiyama\,\ Kyoto",
"815584", "Shimoda\,\ Shizuoka",
"811853", "Oga\,\ Akita",
"812852", "Oyama\,\ Tochigi",
"811732", "Goshogawara\,\ Aomori",
"811549", "Kushiro\,\ Hokkaido",
"818479", "Tojo\,\ Hiroshima",
"81288", "Imabari\,\ Ehime",
"819953", "Okuchi\,\ Kagoshima",
"818544", "Kisuki\,\ Shimane",
"818872", "Muroto\,\ Kochi",
"819809", "Yaeyama\ District\,\ Okinawa",
"817465", "Yoshino\,\ Nara",
"818695", "Seto\,\ Okayama",
"818832", "Kamojima\,\ Tokushima",
"811868", "Takanosu\,\ Akita",
"818490", "Onomichi\,\ Hiroshima",
"81944", "Setaka\,\ Fukuoka",
"811465", "Shizunai\,\ Hokkaido",
"815368", "Shitara\,\ Aichi",
"818466", "Mima\,\ Tokushima",
"812914", "Hokota\,\ Ibaraki",
"819744", "Mie\,\ Oita",
"818467", "Mima\,\ Tokushima",
"817949", "Kakogawa\,\ Hyogo",
"819553", "Imari\,\ Saga",
"81965", "Yatsushiro\,\ Kumamoto",
"818944", "Yawatahama\,\ Ehime",
"81177", "Aomori\,\ Aomori",
"8126178", "Omachi\,\ Nagano",
"819682", "Yamaga\,\ Kumamoto",
"815743", "Minokamo\,\ Gifu",
"815984", "Matsusaka\,\ Mie",
"8112399", "Kuriyama\,\ Hokkaido",
"812649", "Nagano\,\ Nagano",
"812997", "Itako\,\ Ibaraki",
"812560", "Itoigawa\,\ Niigata",
"812234", "Sendai\,\ Miyagi",
"812489", "Sukagawa\,\ Fukushima",
"817614", "Komatsu\,\ Ishikawa",
"811398", "Kumaishi\,\ Hokkaido",
"81940", "Munakata\,\ Fukuoka",
"812996", "Itako\,\ Ibaraki",
"819963", "Satsumasendai\,\ Kagoshima",
"817455", "Yamatotakada\,\ Nara",
"81852", "Matsue\,\ Shimane",
"811237", "Kuriyama\,\ Hokkaido",
"81495", "Honjo\,\ Saitama",
"811236", "Chitose\,\ Hokkaido",
"811455", "Mukawa\,\ Hokkaido",
"812616", "Omachi\,\ Nagano",
"811858", "Noshiro\,\ Akita",
"817994", "Sumoto\,\ Hyogo",
"819662", "Hitoyoshi\,\ Kumamoto",
"812694", "Nakano\,\ Nagano",
"812545", "Murakami\,\ Niigata",
"812580", "Tokamachi\,\ Niigata",
"819722", "Saiki\,\ Oita",
"811863", "Kazuno\,\ Akita",
"81420", "Tokorozawa\,\ Saitama",
"815363", "Shinshiro\,\ Aichi",
"812477", "Miharu\,\ Fukushima",
"812476", "Miharu\,\ Fukushima",
"819558", "Karatsu\,\ Saga",
"812550", "Yasuzuka\,\ Niigata",
"814795", "Choshi\,\ Chiba",
"817485", "Yokaichi\,\ Shiga",
"81286", "Utsunomiya\,\ Tochigi",
"811645", "Rumoi\,\ Hokkaido",
"811393", "Matsumae\,\ Hokkaido",
"8162", "Osaka\,\ Osaka",
"81892", "Kumakogen\,\ Ehime",
"818397", "Ogori\,\ Yamaguchi",
"819965", "Satsumasendai\,\ Kagoshima",
"817453", "Yamatotakada\,\ Nara",
"81125", "Takikawa\,\ Hokkaido",
"817902", "Fukusaki\,\ Hyogo",
"819934", "Ibusuki\,\ Kagoshima",
"811453", "Hayakita\,\ Hokkaido",
"812859", "Oyama\,\ Tochigi",
"819974", "Yakushima\,\ Kagoshima",
"81725", "Izumi\,\ Osaka",
"819802", "Minamidaito\,\ Okinawa",
"818698", "Bizen\,\ Okayama",
"817468", "Kamikitayama\,\ Nara",
"815973", "Owase\,\ Mie",
"818879", "Muroto\,\ Kochi",
"812543", "Shibata\,\ Niigata",
"811542", "Kushiro\,\ Hokkaido",
"811874", "Kakunodate\,\ Akita",
"8112394", "Yubari\,\ Hokkaido",
"8186993", "Bizen\,\ Okayama",
"81984", "Kobayashi\,\ Miyazaki",
"811865", "Odate\,\ Akita",
"817942", "Kakogawa\,\ Hyogo",
"81245", "Fukushima\,\ Fukushima",
"81563", "Nishio\,\ Aichi",
"811942", "Iwaizumi\,\ Iwate",
"812784", "Numata\,\ Gunma",
"81567", "Tsushima\,\ Aichi",
"8153967", "Hamamatsu\,\ Shizuoka",
"8125488", "Tsugawa\,\ Niigata",
"814793", "Choshi\,\ Chiba",
"819574", "Isahaya\,\ Nagasaki",
"817483", "Yokaichi\,\ Shiga",
"81260", "Anan\,\ Nagano",
"811395", "Esashi\,\ Hokkaido",
"81728", "Neyagawa\,\ Osaka",
"8153966", "Hamamatsu\,\ Shizuoka",
"812482", "Shirakawa\,\ Fukushima",
"8153976", "Hamamatsu\,\ Shizuoka",
"818360", "Ogori\,\ Yamaguchi",
"811855", "Noshiro\,\ Akita",
"819824", "Nobeoka\,\ Miyazaki",
"81126", "Iwamizawa\,\ Hokkaido",
"819955", "Kajiki\,\ Kagoshima",
"818693", "Oku\,\ Okayama",
"817463", "Yoshino\,\ Nara",
"815978", "Kumano\,\ Mie",
"81726", "Ibaraki\,\ Osaka",
"811463", "Urakawa\,\ Hokkaido",
"811756", "Noheji\,\ Aomori",
"812836", "Sano\,\ Tochigi",
"81979", "Nakatsu\,\ Oita",
"811757", "Noheji\,\ Aomori",
"812837", "Sano\,\ Tochigi",
"819676", "Takamori\,\ Kumamoto",
"812877", "Kuroiso\,\ Tochigi",
"819940", "Shibushi\,\ Kagoshima",
"81899", "Matsuyama\,\ Ehime",
"819555", "Karatsu\,\ Saga",
"81433", "Chiba\,\ Chiba",
"812876", "Kuroiso\,\ Tochigi",
"811524", "Abashiri\,\ Hokkaido",
"817488", "Minakuchi\,\ Shiga",
"814798", "Yokaichiba\,\ Chiba",
"81246", "Iwaki\,\ Fukushima",
"815745", "Minokamo\,\ Gifu",
"818592", "Yonago\,\ Tottori",
"8144", "Kawasaki\,\ Kanagawa",
"81471", "Kashiwa\,\ Chiba",
"812993", "Ishioka\,\ Ibaraki",
"815746", "Minokamo\,\ Gifu",
"817992", "Sumoto\,\ Hyogo",
"812692", "Nakano\,\ Nagano",
"819664", "Hitoyoshi\,\ Kumamoto",
"819557", "Karatsu\,\ Saga",
"81936", "Kitakyushu\,\ Fukuoka",
"812875", "Otawara\,\ Tochigi",
"819556", "Karatsu\,\ Saga",
"812478", "Miharu\,\ Fukushima",
"813", "Tokyo",
"819724", "Saiki\,\ Oita",
"818463", "Takehara\,\ Hiroshima",
"812835", "Sano\,\ Tochigi",
"81942", "Kurume\,\ Fukuoka",
"819956", "Kajiki\,\ Kagoshima",
"81199", "Morioka\,\ Iwate",
"819957", "Kajiki\,\ Kagoshima",
"811857", "Noshiro\,\ Akita",
"812618", "Omachi\,\ Nagano",
"81596", "Ise\,\ Mie",
"817238", "Neyagawa\,\ Osaka",
"8186994", "Seto\,\ Okayama",
"811856", "Noshiro\,\ Akita",
"8186691", "Kurashiki\,\ Okayama",
"81989", "Naha\,\ Okinawa",
"8112393", "Yubari\,\ Hokkaido",
"814703", "Tateyama\,\ Chiba",
"818262", "Kake\,\ Hiroshima",
"811238", "Kuriyama\,\ Hokkaido",
"811397", "Okushiri\,\ Hokkaido",
"8126175", "Omachi\,\ Nagano",
"812998", "Itako\,\ Ibaraki",
"81825", "Hiroshima\,\ Hiroshima",
"811396", "Esashi\,\ Hokkaido",
"81935", "Kitakyushu\,\ Fukuoka",
"817734", "Fukuchiyama\,\ Kyoto",
"815582", "Shimoda\,\ Shizuoka",
"819979", "Tokunoshima\,\ Kagoshima",
"811734", "Goshogawara\,\ Aomori",
"812854", "Oyama\,\ Tochigi",
"812473", "Ishikawa\,\ Fukushima",
"818874", "Aki\,\ Kochi",
"818542", "Yasugi\,\ Shimane",
"815366", "Shitara\,\ Aichi",
"818834", "Kamojima\,\ Tokushima",
"815367", "Shitara\,\ Aichi",
"81555", "Fujiyoshida\,\ Yamanashi",
"81227", "Sendai\,\ Miyagi",
"811866", "Takanosu\,\ Akita",
"819742", "Mie\,\ Oita",
"811867", "Takanosu\,\ Akita",
"818942", "Yawatahama\,\ Ehime",
"812789", "Maebashi\,\ Gunma",
"81938", "Kitakyushu\,\ Fukuoka",
"8198298", "Hyuga\,\ Miyazaki",
"81828", "Hiroshima\,\ Hiroshima",
"812613", "Omachi\,\ Nagano",
"819684", "Yamaga\,\ Kumamoto",
"81143", "Muroran\,\ Hokkaido",
"811233", "Chitose\,\ Hokkaido",
"815982", "Matsusaka\,\ Mie",
"819967", "Izumi\,\ Kagoshima",
"8147955", "Yokaichiba\,\ Chiba",
"812551", "Joetsu\,\ Niigata",
"812232", "Iwanuma\,\ Miyagi",
"817612", "Komatsu\,\ Ishikawa",
"81743", "Nara\,\ Nara",
"819966", "Izumi\,\ Kagoshima",
"817717", "Sonobe\,\ Kyoto",
"817716", "Sonobe\,\ Kyoto",
"81532", "Toyohashi\,\ Aichi",
"818588", "Koge\,\ Tottori",
"818894", "Susaki\,\ Kochi",
"812385", "Yonezawa\,\ Yamagata",
"817678", "Nanao\,\ Ishikawa",
"815735", "Ena\,\ Gifu",
"815764", "Gero\,\ Gifu",
"818958", "Misho\,\ Ehime",
"817492", "Hikone\,\ Shiga",
"818662", "Takahashi\,\ Okayama",
"818248", "Shobara\,\ Hiroshima",
"811377", "Yakumo\,\ Hokkaido",
"811376", "Yakumo\,\ Hokkaido",
"811336", "Ishikari\,\ Hokkaido",
"812938", "Mito\,\ Ibaraki",
"81434", "Chiba\,\ Chiba",
"81952", "Saga\,\ Saga",
"811337", "Ishikari\,\ Hokkaido",
"819599", "Oseto\,\ Nagasaki",
"818563", "Masuda\,\ Shimane",
"818364", "Ube\,\ Yamaguchi",
"81992", "Kagoshima\,\ Kagoshima",
"8163", "Osaka\,\ Osaka",
"81478", "Sawara\,\ Chiba",
"818375", "Mine\,\ Yamaguchi",
"812578", "Muika\,\ Niigata",
"812780", "Maebashi\,\ Gunma",
"818558", "Kawamoto\,\ Shimane",
"819788", "Kunisaki\,\ Oita",
"8188098", "Tosashimizu\,\ Kochi",
"81546", "Shizuoka\,\ Shizuoka",
"812745", "Fujioka\,\ Gunma",
"814752", "Mobara\,\ Chiba",
"81182", "Yokote\,\ Akita",
"812895", "Utsunomiya\,\ Tochigi",
"814286", "Sagamihara\,\ Kanagawa",
"818384", "Hagi\,\ Yamaguchi",
"818583", "Kurayoshi\,\ Tottori",
"8153979", "Hamamatsu\,\ Shizuoka",
"812672", "Komoro\,\ Nagano",
"814287", "Ome\,\ Tokyo",
"81476", "Narita\,\ Chiba",
"81157", "Kitami\,\ Hokkaido",
"8153969", "Hamamatsu\,\ Shizuoka",
"818243", "Higashi\-ku\,\ Hiroshima",
"819544", "Takeo\,\ Saga",
"818953", "Uwajima\,\ Ehime",
"817673", "Hakui\,\ Ishikawa",
"81462", "Atsugi\,\ Kanagawa",
"81564", "Okazaki\,\ Aichi",
"8186553", "Kurashiki\,\ Okayama",
"811972", "Mizusawa\,\ Iwate",
"81548", "Haibara\,\ Shizuoka",
"815754", "Sekigahara\,\ Gifu",
"811932", "Kamaishi\,\ Iwate",
"818652", "Kurashiki\,\ Okayama",
"812933", "Takahagi\,\ Ibaraki",
"811541", "Teshikaga\,\ Hokkaido",
"81721", "Tondabayashi\,\ Osaka",
"81545", "Fuji\,\ Shizuoka",
"81263", "Matsumoto\,\ Nagano",
"812412", "Kitakata\,\ Fukushima",
"81987", "Nichinan\,\ Miyazaki",
"811532", "Nemuro\,\ Hokkaido",
"818568", "Tsuwano\,\ Shimane",
"81983", "Takanabe\,\ Miyazaki",
"812796", "Shibukawa\,\ Gunma",
"818682", "Tsuyama\,\ Okayama",
"818203", "Yanai\,\ Yamaguchi",
"8182943", "Hiroshima\,\ Hiroshima",
"812797", "Shibukawa\,\ Gunma",
"812573", "Kashiwazaki\,\ Niigata",
"812374", "Murayama\,\ Yamagata",
"81797", "Nishinomiya\,\ Hyogo",
"819944", "Kanoya\,\ Kagoshima",
"818553", "Hamada\,\ Shimane",
"819783", "Bungotakada\,\ Oita",
"81793", "Himeji\,\ Hyogo",
"8153972", "Hamamatsu\,\ Shizuoka",
"8182920", "Hatsukaichi\,\ Hiroshima",
"811583", "Monbetsu\,\ Hokkaido",
"817953", "Nishiwaki\,\ Hyogo",
"812582", "Nagaoka\,\ Niigata",
"81857", "Tottori\,\ Tottori",
"815998", "Ago\,\ Mie",
"81144", "Tomakomai\,\ Hokkaido",
"819434", "Yame\,\ Fukuoka",
"811953", "Ninohe\,\ Iwate",
"81853", "Izumo\,\ Shimane",
"81744", "Yamatotakada\,\ Nara",
"812242", "Shiroishi\,\ Miyagi",
"81591", "Tsu\,\ Mie",
"819732", "Hita\,\ Oita",
"81486", "Urawa\,\ Saitama",
"817704", "Tsuruga\,\ Fukui",
"817968", "Hamasaka\,\ Hyogo",
"818972", "Niihama\,\ Ehime",
"81298", "Tsuchiura\,\ Ibaraki",
"812795", "Shibukawa\,\ Gunma",
"811652", "Shibetsu\,\ Hokkaido",
"812653", "Iida\,\ Nagano",
"818298", "Hatsukaichi\,\ Hiroshima",
"817682", "Wajima\,\ Ishikawa",
"81740", "Imazu\,\ Shiga",
"812911", "Hokota\,\ Ibaraki",
"818844", "Anan\,\ Tokushima",
"8183768", "Shimonoseki\,\ Yamaguchi",
"81551", "Nirasaki\,\ Yamanashi",
"81977", "Beppu\,\ Oita",
"812552", "Joetsu\,\ Niigata",
"81439", "Kisarazu\,\ Chiba",
"811354", "Yoichi\,\ Hokkaido",
"814240", "Kokubunji\,\ Tokyo",
"81893", "Ozu\,\ Ehime",
"811553", "Obihiro\,\ Hokkaido",
"812897", "Kanuma\,\ Tochigi",
"81765", "Uozu\,\ Toyama",
"817354", "Shingu\,\ Fukuoka",
"814285", "Sagamihara\,\ Kanagawa",
"812896", "Kanuma\,\ Tochigi",
"811983", "Hanamaki\,\ Iwate",
"812747", "Tomioka\,\ Gunma",
"815993", "Toba\,\ Mie",
"818678", "Niimi\,\ Okayama",
"812746", "Tomioka\,\ Gunma",
"81485", "Kumagaya\,\ Saitama",
"8145", "Yokohama\,\ Kanagawa",
"811588", "Okoppe\,\ Hokkaido",
"815769", "Shokawa\,\ Gifu",
"817722", "Miyazu\,\ Kyoto",
"811958", "Iwate\,\ Iwate",
"818377", "Shimonoseki\,\ Yamaguchi",
"817963", "Toyooka\,\ Hyogo",
"818376", "Mine\,\ Yamaguchi",
"812962", "Shimodate\,\ Ibaraki",
"812658", "Ina\,\ Nagano",
"8153970", "Hamamatsu\,\ Shizuoka",
"811364", "Kutchan\,\ Hokkaido",
"811563", "Honbetsu\,\ Hokkaido",
"81166", "Asahikawa\,\ Hokkaido",
"818293", "Hatsukaichi\,\ Hiroshima",
"818369", "Ube\,\ Yamaguchi",
"812562", "Sanjo\,\ Niigata",
"81172", "Hirosaki\,\ Aomori",
"81849", "Fukuyama\,\ Hiroshima",
"81766", "Takaoka\,\ Toyama",
"811375", "Yakumo\,\ Hokkaido",
"811558", "Hiroo\,\ Hokkaido",
"815737", "Nakatsugawa\,\ Gifu",
"81488", "Urawa\,\ Saitama",
"815736", "Nakatsugawa\,\ Gifu",
"8126171", "Omachi\,\ Nagano",
"812386", "Nagai\,\ Yamagata",
"817715", "Kameoka\,\ Kyoto",
"812387", "Nagai\,\ Yamagata",
"81569", "Handa\,\ Aichi",
"815394", "Hamamatsu\,\ Shizuoka",
"81284", "Ashikaga\,\ Tochigi",
"814756", "Togane\,\ Chiba",
"818679", "Niimi\,\ Okayama",
"818584", "Kurayoshi\,\ Tottori",
"818383", "Hagi\,\ Yamaguchi",
"811589", "Okoppe\,\ Hokkaido",
"814757", "Togane\,\ Chiba",
"817959", "Sanda\,\ Hyogo",
"811634", "Hamatonbetsu\,\ Hokkaido",
"815768", "Gero\,\ Gifu",
"818954", "Uwajima\,\ Ehime",
"819543", "Takeo\,\ Saga",
"818690", "Okayama\,\ Okayama",
"818244", "Miyoshi\,\ Hiroshima",
"81737", "Yuasa\,\ Wakayama",
"817674", "Hakui\,\ Ishikawa",
"817725", "Miyazu\,\ Kyoto",
"81948", "Iizuka\,\ Fukuoka",
"812659", "Ina\,\ Nagano",
"812965", "Shimodate\,\ Ibaraki",
"815753", "Sekigahara\,\ Gifu",
"812934", "Takahagi\,\ Ibaraki",
"812565", "Sanjo\,\ Niigata",
"81280", "Koga\,\ Ibaraki",
"811332", "Tobetsu\,\ Hokkaido",
"818368", "Ube\,\ Yamaguchi",
"811372", "Shikabe\,\ Hokkaido",
"812373", "Murayama\,\ Yamagata",
"812574", "Kashiwazaki\,\ Niigata",
"818204", "Yanai\,\ Yamaguchi",
"81426", "Hachioji\,\ Tokyo",
"81583", "Gifu\,\ Gifu",
"811559", "Obihiro\,\ Hokkaido",
"818666", "Ibara\,\ Okayama",
"817496", "Nagahama\,\ Shiga",
"819784", "Bungotakada\,\ Oita",
"819943", "Kanoya\,\ Kagoshima",
"818554", "Hamada\,\ Shimane",
"818667", "Ibara\,\ Okayama",
"817497", "Nagahama\,\ Shiga",
"817712", "Kameoka\,\ Kyoto",
"81587", "Ichinomiya\,\ Aichi",
"81552", "Kofu\,\ Yamanashi",
"818388", "Tamagawa\,\ Yamaguchi",
"818893", "Sakawa\,\ Kochi",
"815999", "Tsu\,\ Mie",
"812585", "Nagaoka\,\ Niigata",
"812245", "Ogawara\,\ Miyagi",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"815763", "Gero\,\ Gifu",
"818686", "Tsuyama\,\ Okayama",
"817969", "Hamasaka\,\ Hyogo",
"819735", "Hita\,\ Oita",
"818687", "Mimasaka\,\ Okayama",
"812792", "Shibukawa\,\ Gunma",
"818975", "Niihama\,\ Ehime",
"811536", "Akkeshi\,\ Hokkaido",
"811655", "Nayoro\,\ Hokkaido",
"8147957", "Yokaichiba\,\ Chiba",
"81822", "Hiroshima\,\ Hiroshima",
"81932", "Kitakyushu\,\ Fukuoka",
"811537", "Nakashibetsu\,\ Hokkaido",
"8169", "Osaka\,\ Osaka",
"812416", "Tajima\,\ Fukushima",
"818299", "Hiroshima\,\ Hiroshima",
"818363", "Ube\,\ Yamaguchi",
"818564", "Masuda\,\ Shimane",
"8165", "Osaka\,\ Osaka",
"811937", "Miyako\,\ Iwate",
"818657", "Kasaoka\,\ Okayama",
"81425", "Tachikawa\,\ Tokyo",
"811936", "Miyako\,\ Iwate",
"81494", "Chichibu\,\ Saitama",
"818656", "Kasaoka\,\ Okayama",
"817685", "Wajima\,\ Ishikawa",
"811976", "Kitakami\,\ Iwate",
"812378", "Sagae\,\ Yamagata",
"81946", "Amagi\,\ Fukuoka",
"811977", "Kitakami\,\ Iwate",
"812555", "Itoigawa\,\ Niigata",
"818391", "Ogori\,\ Yamaguchi",
"8126176", "Omachi\,\ Nagano",
"819948", "Shibushi\,\ Kagoshima",
"81592", "Tsu\,\ Mie",
"812677", "Saku\,\ Nagano",
"814282", "Ome\,\ Tokyo",
"812676", "Saku\,\ Nagano",
"812675", "Saku\,\ Nagano",
"815994", "Ago\,\ Mie",
"819438", "Tanushimaru\,\ Fukuoka",
"812892", "Utsunomiya\,\ Tochigi",
"8153965", "Hamamatsu\,\ Shizuoka",
"81236", "Yamagata\,\ Yamagata",
"818808", "Tosashimizu\,\ Kochi",
"8153975", "Hamamatsu\,\ Shizuoka",
"812556", "Itoigawa\,\ Niigata",
"81722", "Sakai\,\ Osaka",
"817964", "Toyooka\,\ Hyogo",
"811975", "Mizusawa\,\ Iwate",
"817686", "Noto\,\ Ishikawa",
"818655", "Kamogata\,\ Okayama",
"811935", "Kamaishi\,\ Iwate",
"817687", "Noto\,\ Ishikawa",
"811564", "Kamishihoro\,\ Hokkaido",
"812415", "Yanaizu\,\ Fukushima",
"811363", "Kutchan\,\ Hokkaido",
"81969", "Amakusa\,\ Kumamoto",
"819593", "Oseto\,\ Nagasaki",
"811656", "Bifuka\,\ Hokkaido",
"811535", "Akkeshi\,\ Hokkaido",
"818294", "Hatsukaichi\,\ Hiroshima",
"818976", "Niihama\,\ Ehime",
"819737", "Kusu\,\ Oita",
"818977", "Hakata\,\ Ehime",
"817230", "Neyagawa\,\ Osaka",
"818685", "Tsuyama\,\ Okayama",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"812246", "Ogawara\,\ Miyagi",
"812957", "Daigo\,\ Ibaraki",
"812247", "Ogawara\,\ Miyagi",
"81242", "Aizuwakamatsu\,\ Fukushima",
"812586", "Nagaoka\,\ Niigata",
"812587", "Nagaoka\,\ Niigata",
"815393", "Hamamatsu\,\ Shizuoka",
"817954", "Nishiwaki\,\ Hyogo",
"811584", "Engaru\,\ Hokkaido",
"819433", "Yame\,\ Fukuoka",
"81927", "Fukuoka\,\ Fukuoka",
"812382", "Yonezawa\,\ Yamagata",
"818674", "Kuse\,\ Okayama",
"81923", "Fukuoka\,\ Fukuoka",
"81833", "Kudamatsu\,\ Yamaguchi",
"815732", "Ena\,\ Gifu",
"811954", "Ninohe\,\ Iwate",
"818665", "Takahashi\,\ Okayama",
"818249", "Higashi\-ku\,\ Hiroshima",
"817495", "Nagahama\,\ Shiga",
"8161", "Osaka\,\ Osaka",
"817703", "Tsuruga\,\ Fukui",
"818798", "Tonosho\,\ Kagawa",
"812939", "Mito\,\ Ibaraki",
"812566", "Sanjo\,\ Niigata",
"81235", "Tsuruoka\,\ Yamagata",
"812654", "Iida\,\ Nagano",
"812967", "Kasama\,\ Ibaraki",
"819598", "Fukue\,\ Nagasaki",
"819232", "Maebaru\,\ Fukuoka",
"814700", "Kamogawa\,\ Chiba",
"818843", "Anan\,\ Tokushima",
"81577", "Takayama\,\ Gifu",
"818372", "Nagato\,\ Yamaguchi",
"817368", "Iwade\,\ Wakayama",
"81531", "Tahara\,\ Aichi",
"819789", "Kitsuki\,\ Oita",
"818559", "Kawamoto\,\ Shimane",
"81270", "Isesaki\,\ Gunma",
"811554", "Obihiro\,\ Hokkaido",
"811353", "Yoichi\,\ Hokkaido",
"812742", "Fujioka\,\ Gunma",
"815398", "Hamamatsu\,\ Shizuoka",
"811984", "Hanamaki\,\ Iwate",
"817353", "Shingu\,\ Fukuoka",
"814755", "Togane\,\ Chiba",
"814298", "Hanno\,\ Saitama",
"812646", "Nagano\,\ Nagano",
"812930", "Mito\,\ Ibaraki",
"812487", "Sukagawa\,\ Fukushima",
"819938", "Kaseda\,\ Kagoshima",
"815585", "Shimoda\,\ Shizuoka",
"812647", "Nagano\,\ Nagano",
"812999", "Itako\,\ Ibaraki",
"81252", "Niigata\,\ Niigata",
"8112398", "Kuriyama\,\ Hokkaido",
"812486", "Sukagawa\,\ Fukushima",
"8111", "Sapporo\,\ Hokkaido",
"8126179", "Omachi\,\ Nagano",
"819823", "Nobeoka\,\ Miyazaki",
"819978", "Tokunoshima\,\ Kagoshima",
"811947", "Kuji\,\ Iwate",
"811878", "Omagari\,\ Akita",
"81493", "Higashimatsuyama\,\ Saitama",
"811946", "Kuji\,\ Iwate",
"817464", "Yoshino\,\ Nara",
"818694", "Okayama\,\ Okayama",
"81839", "Yamaguchi\,\ Yamaguchi",
"818545", "Kisuki\,\ Shimane",
"818240", "Higashi\-ku\,\ Hiroshima",
"81929", "Fukuoka\,\ Fukuoka",
"817947", "Miki\,\ Hyogo",
"817946", "Miki\,\ Hyogo",
"817475", "Shimonoseki\,\ Yamaguchi",
"811464", "Shizunai\,\ Hokkaido",
"8186697", "Kurashiki\,\ Okayama",
"81176", "Towada\,\ Aomori",
"81762", "Kanazawa\,\ Ishikawa",
"818476", "Fuchu\,\ Hiroshima",
"812788", "Maebashi\,\ Gunma",
"818945", "Yawatahama\,\ Ehime",
"811546", "Kushiro\,\ Hokkaido",
"818477", "Tojo\,\ Hiroshima",
"81776", "Fukui\,\ Fukui",
"81162", "Wakkanai\,\ Hokkaido",
"811523", "Shari\,\ Hokkaido",
"811547", "Shiranuka\,\ Hokkaido",
"8125484", "Murakami\,\ Niigata",
"819578", "Shimabara\,\ Nagasaki",
"8126172", "Omachi\,\ Nagano",
"81886", "Tokushima\,\ Tokushima",
"814281", "Sagamihara\,\ Kanagawa",
"81292", "Mito\,\ Ibaraki",
"815985", "Matsusaka\,\ Mie",
"814709", "Kamogawa\,\ Chiba",
"817615", "Komatsu\,\ Ishikawa",
"812235", "Sendai\,\ Miyagi",
"8198293", "Nobeoka\,\ Miyazaki",
"817454", "Yamatotakada\,\ Nara",
"81584", "Ogaki\,\ Gifu",
"819933", "Ibusuki\,\ Kagoshima",
"818596", "Yonago\,\ Tottori",
"81178", "Hachinohe\,\ Aomori",
"8124197", "Yanaizu\,\ Fukushima",
"819828", "Takachiho\,\ Miyazaki",
"811454", "Mukawa\,\ Hokkaido",
"817995", "Sumoto\,\ Hyogo",
"81778", "Takefu\,\ Fukui",
"812872", "Otawara\,\ Tochigi",
"812544", "Shibata\,\ Niigata",
"81888", "Kochi\,\ Kochi",
"815974", "Owase\,\ Mie",
"812695", "Nakano\,\ Nagano",
"811873", "Kakunodate\,\ Akita",
"818514", "Ama\,\ Shimane",
"811752", "Mutsu\,\ Aomori",
"812832", "Sano\,\ Tochigi",
"8124196", "Yanaizu\,\ Fukushima",
"81482", "Kawaguchi\,\ Saitama",
"81885", "Komatsushima\,\ Tokushima",
"811528", "Bihoro\,\ Hokkaido",
"812783", "Numata\,\ Gunma",
"814794", "Choshi\,\ Chiba",
"81734", "Wakayama\,\ Wakayama",
"817239", "Neyagawa\,\ Osaka",
"817484", "Yokaichi\,\ Shiga",
"819573", "Isahaya\,\ Nagasaki",
"812619", "Omachi\,\ Nagano",
"81775", "Otsu\,\ Shiga",
"81134", "Otaru\,\ Hokkaido",
"811644", "Rumoi\,\ Hokkaido",
"81963", "Kumamoto\,\ Kumamoto",
"8152", "Nagoya\,\ Aichi",
"81466", "Fujisawa\,\ Kanagawa",
"817733", "Fukuchiyama\,\ Kyoto",
"81878", "Takamatsu\,\ Kagawa",
"811852", "Oga\,\ Akita",
"812853", "Oyama\,\ Tochigi",
"811733", "Goshogawara\,\ Aomori",
"81998", "Kagoshima\,\ Kagoshima",
"812474", "Ishikawa\,\ Fukushima",
"81188", "Akita\,\ Akita",
"819668", "Minamata\,\ Kumamoto",
"815979", "Kumano\,\ Mie",
"819952", "Okuchi\,\ Kagoshima",
"818873", "Aki\,\ Kochi",
"8147950", "Yokaichiba\,\ Chiba",
"812549", "Tsugawa\,\ Niigata",
"815566", "Minobu\,\ Yamanashi",
"818833", "Kamojima\,\ Tokushima",
"81535", "Hamamatsu\,\ Shizuoka",
"8125483", "Murakami\,\ Niigata",
"819728", "Usuki\,\ Oita",
"81273", "Takasaki\,\ Gunma",
"812697", "Iiyama\,\ Nagano",
"81277", "Kiryu\,\ Gunma",
"81538", "Iwata\,\ Shizuoka",
"819552", "Imari\,\ Saga",
"8186998", "Seto\,\ Okayama",
"812696", "Iiyama\,\ Nagano",
"8126170", "Omachi\,\ Nagano",
"8175", "Kyoto\,\ Kyoto",
"817914", "Aioi\,\ Hyogo",
"812614", "Omachi\,\ Nagano",
"819683", "Yamaga\,\ Kumamoto",
"81958", "Nagasaki\,\ Nagasaki",
"81875", "Kan\'onji\,\ Kagawa",
"817996", "Tsuna\,\ Hyogo",
"817997", "Tsuna\,\ Hyogo",
"8153971", "Hamamatsu\,\ Shizuoka",
"818290", "Hiroshima\,\ Hiroshima",
"81924", "Fukuoka\,\ Fukuoka",
"81834", "Tokuyama\,\ Yamaguchi",
"818595", "Yonago\,\ Tottori",
"811234", "Chitose\,\ Hokkaido",
"815742", "Minokamo\,\ Gifu",
"814770", "Ichikawa\,\ Chiba",
"812236", "Sendai\,\ Miyagi",
"817616", "Komatsu\,\ Ishikawa",
"819962", "Satsumasendai\,\ Kagoshima",
"812994", "Ishioka\,\ Ibaraki",
"817738", "Maizuru\,\ Kyoto",
"817905", "Fukusaki\,\ Hyogo",
"815986", "Matsusaka\,\ Mie",
"812237", "Sendai\,\ Miyagi",
"817617", "Kaga\,\ Ishikawa",
"812858", "Mooka\,\ Tochigi",
"8199343", "Kagoshima\,\ Kagoshima",
"818947", "Uwajima\,\ Ehime",
"819805", "Nago\,\ Okinawa",
"819663", "Hitoyoshi\,\ Kumamoto",
"81956", "Sasebo\,\ Nagasaki",
"811545", "Kushiro\,\ Hokkaido",
"818946", "Uwajima\,\ Ehime",
"818475", "Fuchu\,\ Hiroshima",
"81465", "Odawara\,\ Kanagawa",
"819723", "Saiki\,\ Oita",
"812917", "Mito\,\ Ibaraki",
"819747", "Taketa\,\ Oita",
"8164", "Osaka\,\ Osaka",
"818464", "Takehara\,\ Hiroshima",
"817950", "Sanda\,\ Hyogo",
"81739", "Tanabe\,\ Wakayama",
"819746", "Taketa\,\ Oita",
"811862", "Kazuno\,\ Akita",
"817476", "Shimonoseki\,\ Yamaguchi",
"81468", "Yokosuka\,\ Kanagawa",
"817945", "Kakogawa\,\ Hyogo",
"815362", "Shinshiro\,\ Aichi",
"818546", "Kakeya\,\ Shimane",
"811945", "Kuji\,\ Iwate",
"818547", "Kakeya\,\ Shimane",
"8198294", "Nobeoka\,\ Miyazaki",
"81862", "Okayama\,\ Okayama",
"819688", "Tamana\,\ Kumamoto",
"812485", "Shirakawa\,\ Fukushima",
"811392", "Kikonai\,\ Hokkaido",
"814704", "Tateyama\,\ Chiba",
"815586", "Shimoda\,\ Shizuoka",
"81542", "Shizuoka\,\ Shizuoka",
"81294", "Hitachiota\,\ Ibaraki",
"817452", "Yamatotakada\,\ Nara",
"81557", "Ito\,\ Shizuoka",
"8126173", "Omachi\,\ Nagano",
"81225", "Ishinomaki\,\ Miyagi",
"817903", "Fukusaki\,\ Hyogo",
"811452", "Hayakita\,\ Hokkaido",
"81553", "Yamanashi\,\ Yamanashi",
"812874", "Otawara\,\ Tochigi",
"812542", "Shibata\,\ Niigata",
"819803", "Nago\,\ Okinawa",
"815972", "Owase\,\ Mie",
"811526", "Abashiri\,\ Hokkaido",
"819665", "Hitoyoshi\,\ Kumamoto",
"811543", "Kushiro\,\ Hokkaido",
"811527", "Bihoro\,\ Hokkaido",
"81933", "Kitakyushu\,\ Fukuoka",
"81823", "Kure\,\ Hiroshima",
"819725", "Saiki\,\ Oita",
"818512", "Nishigo\,\ Fukushima",
"81937", "Kitakyushu\,\ Fukuoka",
"81250", "Niitsu\,\ Niigata",
"81827", "Iwakuni\,\ Yamaguchi",
"811754", "Mutsu\,\ Aomori",
"812834", "Utsunomiya\,\ Tochigi",
"81764", "Toyama\,\ Toyama",
"814280", "Tachikawa\,\ Tokyo",
"817943", "Kakogawa\,\ Hyogo",
"812571", "Muika\,\ Niigata",
"811943", "Iwaizumi\,\ Iwate",
"81593", "Yokkaichi\,\ Mie",
"819826", "Hyuga\,\ Miyazaki",
"814792", "Choshi\,\ Chiba",
"8125480", "Murakami\,\ Niigata",
"819827", "Takachiho\,\ Miyazaki",
"817482", "Yokaichi\,\ Shiga",
"812483", "Shirakawa\,\ Fukushima",
"81480", "Kuki\,\ Saitama",
"817735", "Fukuchiyama\,\ Kyoto",
"819576", "Shimabara\,\ Nagasaki",
"819577", "Shimabara\,\ Nagasaki",
"812855", "Oyama\,\ Tochigi",
"811735", "Goshogawara\,\ Aomori",
"8198299", "Hyuga\,\ Miyazaki",
"818478", "Tojo\,\ Hiroshima",
"812786", "Numata\,\ Gunma",
"811548", "Teshikaga\,\ Hokkaido",
"812787", "Numata\,\ Gunma",
"819808", "Yaeyama\ District\,\ Okinawa",
"818692", "Oku\,\ Okayama",
"81226", "Kesennuma\,\ Miyagi",
"811869", "Odate\,\ Akita",
"818835", "Mima\,\ Tokushima",
"8168", "Osaka\,\ Osaka",
"811462", "Urakawa\,\ Hokkaido",
"817948", "Miki\,\ Hyogo",
"81484", "Kawaguchi\,\ Saitama",
"811876", "Omagari\,\ Akita",
"81549", "Shizuoka\,\ Shizuoka",
"8183766", "Shimonoseki\,\ Yamaguchi",
"811877", "Omagari\,\ Akita",
"819685", "Tamana\,\ Kumamoto",
"8198292", "Nobeoka\,\ Miyazaki",
"819977", "Setouchi\,\ Kagoshima",
"8112395", "Kuriyama\,\ Hokkaido",
"819976", "Naze\,\ Kagoshima",
"812648", "Nagano\,\ Nagano",
"81582", "Gifu\,\ Gifu",
"8183767", "Shimonoseki\,\ Yamaguchi",
"819936", "Kaseda\,\ Kagoshima",
"818593", "Yonago\,\ Tottori",
"814297", "Hanno\,\ Saitama",
"812488", "Sukagawa\,\ Fukushima",
"819937", "Kaseda\,\ Kagoshima",
"812992", "Ishioka\,\ Ibaraki",
"819964", "Satsumasendai\,\ Kagoshima",
"81832", "Shimonoseki\,\ Yamaguchi",
"81922", "Fukuoka\,\ Fukuoka",
"819935", "Kaseda\,\ Kagoshima",
"819975", "Naze\,\ Kagoshima",
"8167", "Osaka\,\ Osaka",
"819687", "Tamana\,\ Kumamoto",
"815958", "Kameyama\,\ Mie",
"817993", "Sumoto\,\ Hyogo",
"81438", "Kisarazu\,\ Chiba",
"819686", "Tamana\,\ Kumamoto",
"8125489", "Tsugawa\,\ Niigata",
"812693", "Nakano\,\ Nagano",
"81259", "Sado\,\ Niigata",
"811875", "Kakunodate\,\ Akita",
"8182941", "Hiroshima\,\ Hiroshima",
"818462", "Takehara\,\ Hiroshima",
"811864", "Odate\,\ Akita",
"818836", "Mima\,\ Tokushima",
"81566", "Kariya\,\ Aichi",
"814771", "Ichikawa\,\ Chiba",
"8128798", "Otawara\,\ Tochigi",
"81572", "Tajimi\,\ Gifu",
"8126174", "Omachi\,\ Nagano",
"8125482", "Murakami\,\ Niigata",
"818948", "Uwajima\,\ Ehime",
"812785", "Numata\,\ Gunma",
"81474", "Funabashi\,\ Chiba",
"812856", "Mooka\,\ Tochigi",
"811736", "Goshogawara\,\ Aomori",
"812857", "Mooka\,\ Tochigi",
"819575", "Isahaya\,\ Nagasaki",
"812238", "Sendai\,\ Miyagi",
"817618", "Kaga\,\ Ishikawa",
"811394", "Matsumae\,\ Hokkaido",
"814702", "Tateyama\,\ Chiba",
"817736", "Maizuru\,\ Kyoto",
"817737", "Maizuru\,\ Kyoto",
"818263", "Kake\,\ Hiroshima",
"81544", "Fujinomiya\,\ Shizuoka",
"81568", "Kasugai\,\ Aichi",
"815583", "Shimoda\,\ Shizuoka",
"81489", "Soka\,\ Saitama",
"811854", "Oga\,\ Akita",
"81191", "Ichinoseki\,\ Iwate",
"817998", "Tsuna\,\ Hyogo",
"819825", "Hyuga\,\ Miyazaki",
"81848", "Onomichi\,\ Hiroshima",
"812472", "Ishikawa\,\ Fukushima",
"81727", "Ikeda\,\ Osaka",
"812698", "Iiyama\,\ Nagano",
"81864", "Kurashiki\,\ Okayama",
"819954", "Kajiki\,\ Kagoshima",
"818543", "Yasugi\,\ Shimane",
"812879", "Nasukarasuyama\,\ Tochigi",
"8186995", "Seto\,\ Okayama",
"812839", "Sano\,\ Tochigi",
"819679", "Takamori\,\ Kumamoto",
"812890", "Utsunomiya\,\ Tochigi",
"81723", "Sakai\,\ Osaka",
"812913", "Hokota\,\ Ibaraki",
"819743", "Mie\,\ Oita",
"819727", "Usuki\,\ Oita",
"8188097", "Tosashimizu\,\ Kochi",
"819726", "Usuki\,\ Oita",
"81845", "Innoshima\,\ Hiroshima",
"819667", "Minamata\,\ Kumamoto",
"819554", "Imari\,\ Saga",
"818943", "Yawatahama\,\ Ehime",
"8198290", "Nobeoka\,\ Miyazaki",
"819666", "Minamata\,\ Kumamoto",
"811525", "Abashiri\,\ Hokkaido",
"81436", "Ichihara\,\ Chiba",
"817912", "Aioi\,\ Hyogo",
"812612", "Omachi\,\ Nagano",
"8188096", "Tosashimizu\,\ Kochi",
"81565", "Toyota\,\ Aichi",
"81243", "Nihonmatsu\,\ Fukushima",
"815983", "Matsusaka\,\ Mie",
"815744", "Minokamo\,\ Gifu",
"811232", "Chitose\,\ Hokkaido",
"817613", "Komatsu\,\ Ishikawa",
"812233", "Iwanuma\,\ Miyagi",
"81729", "Yao\,\ Osaka",
"812830", "Utsunomiya\,\ Tochigi",
"812899", "Kanuma\,\ Tochigi",
"819435", "Yame\,\ Fukuoka",
"812678", "Saku\,\ Nagano",
"819946", "Kanoya\,\ Kagoshima",
"817493", "Hikone\,\ Shiga",
"818663", "Soja\,\ Okayama",
"819947", "Shibushi\,\ Kagoshima",
"812376", "Sagae\,\ Yamagata",
"811978", "Kitakami\,\ Iwate",
"817705", "Obama\,\ Fukui",
"812794", "Shibukawa\,\ Gunma",
"812377", "Sagae\,\ Yamagata",
"81487", "Urawa\,\ Saitama",
"811938", "Miyako\,\ Iwate",
"818562", "Masuda\,\ Shimane",
"8198297", "Hyuga\,\ Miyazaki",
"818688", "Mimasaka\,\ Okayama",
"81249", "Koriyama\,\ Fukushima",
"81962", "Kumamoto\,\ Kumamoto",
"819547", "Kashima\,\ Saga",
"8198296", "Hyuga\,\ Miyazaki",
"81896", "Iyomishima\,\ Ehime",
"819546", "Kashima\,\ Saga",
"81282", "Tochigi\,\ Tochigi",
"818387", "Tamagawa\,\ Yamaguchi",
"814284", "Tachikawa\,\ Tokyo",
"817355", "Shingu\,\ Fukuoka",
"814753", "Mobara\,\ Chiba",
"812673", "Komoro\,\ Nagano",
"818582", "Kurayoshi\,\ Tottori",
"81930", "Yukuhashi\,\ Fukuoka",
"81594", "Kuwana\,\ Mie",
"8112391", "Yubari\,\ Hokkaido",
"812389", "Yonezawa\,\ Yamagata",
"811632", "Teshio\,\ Hokkaido",
"818952", "Uwajima\,\ Ehime",
"817498", "Nagahama\,\ Shiga",
"818668", "Ibara\,\ Okayama",
"818242", "Higashi\-ku\,\ Hiroshima",
"81253", "Niigata\,\ Niigata",
"817672", "Hakui\,\ Ishikawa",
"81898", "Imabari\,\ Ehime",
"811973", "Mizusawa\,\ Iwate",
"81550", "Gotenba\,\ Shizuoka",
"811933", "Kamaishi\,\ Iwate",
"818367", "Ube\,\ Yamaguchi",
"812932", "Takahagi\,\ Ibaraki",
"818366", "Ube\,\ Yamaguchi",
"81492", "Kawagoe\,\ Saitama",
"812413", "Kitakata\,\ Fukushima",
"811365", "Kutchan\,\ Hokkaido",
"81934", "Kitakyushu\,\ Fukuoka",
"811533", "Nemuro\,\ Hokkaido",
"811374", "Mori\,\ Hokkaido",
"81167", "Furano\,\ Hokkaido",
"81763", "Fukuno\,\ Toyama",
"812572", "Kashiwazaki\,\ Niigata",
"818202", "Yanai\,\ Yamaguchi",
"818683", "Tsuyama\,\ Okayama",
"81975", "Oita\,\ Oita",
"815766", "Gero\,\ Gifu",
"815767", "Gero\,\ Gifu",
"819782", "Bungotakada\,\ Oita",
"818552", "Hamada\,\ Shimane",
"817714", "Kameoka\,\ Kyoto",
"814758", "Togane\,\ Chiba",
"818896", "Susaki\,\ Kochi",
"8199331", "Kagoshima\,\ Kagoshima",
"815395", "Hamamatsu\,\ Shizuoka",
"81554", "Otsuki\,\ Yamanashi",
"817952", "Nishiwaki\,\ Hyogo",
"81244", "Hobara\,\ Fukushima",
"811582", "Monbetsu\,\ Hokkaido",
"812384", "Yonezawa\,\ Yamagata",
"818895", "Susaki\,\ Kochi",
"81268", "Ueda\,\ Nagano",
"812583", "Nagaoka\,\ Niigata",
"815734", "Ena\,\ Gifu",
"811952", "Ninohe\,\ Iwate",
"8188099", "Tosashimizu\,\ Kochi",
"812243", "Shiroishi\,\ Miyagi",
"81988", "Naha\,\ Okinawa",
"815765", "Gero\,\ Gifu",
"8178", "Kobe\,\ Hyogo",
"817367", "Iwade\,\ Wakayama",
"819733", "Hita\,\ Oita",
"817366", "Iwade\,\ Wakayama",
"818973", "Niihama\,\ Ehime",
"811367", "Suttsu\,\ Hokkaido",
"81798", "Nishinomiya\,\ Hyogo",
"811653", "Shibetsu\,\ Hokkaido",
"819596", "Fukue\,\ Nagasaki",
"811366", "Suttsu\,\ Hokkaido",
"812968", "Kasama\,\ Ibaraki",
"81561", "Seto\,\ Aichi",
"812652", "Iida\,\ Nagano",
"819597", "Fukue\,\ Nagasaki",
"818365", "Ube\,\ Yamaguchi",
"81863", "Tamano\,\ Okayama",
"81124", "Ashibetsu\,\ Hokkaido",
"817683", "Wajima\,\ Ishikawa",
"818797", "Tonosho\,\ Kagawa",
"8199347", "Kagoshima\,\ Kagoshima",
"818374", "Nagato\,\ Yamaguchi",
"818796", "Tonosho\,\ Kagawa",
"812553", "Joetsu\,\ Niigata",
"81543", "Shizuoka\,\ Shizuoka",
"811552", "Obihiro\,\ Hokkaido",
"812744", "Fujioka\,\ Gunma",
"81985", "Miyazaki\,\ Miyazaki",
"811982", "Hanamaki\,\ Iwate",
"81547", "Shimada\,\ Shizuoka",
"812588", "Nagaoka\,\ Niigata",
"815992", "Toba\,\ Mie",
"818385", "Hagi\,\ Yamaguchi",
"817356", "Kushimoto\,\ Wakayama",
"81473", "Ichikawa\,\ Chiba",
"812894", "Utsunomiya\,\ Tochigi",
"818493", "Onomichi\,\ Hiroshima",
"817357", "Kushimoto\,\ Wakayama",
"811356", "Iwanai\,\ Hokkaido",
"81939", "Kitakyushu\,\ Fukuoka",
"812248", "Ogawara\,\ Miyagi",
"811357", "Iwanai\,\ Hokkaido",
"817723", "Miyazu\,\ Kyoto",
"81559", "Numazu\,\ Shizuoka",
"818978", "Hakata\,\ Ehime",
"812799", "Naganohara\,\ Gunma",
"819738", "Kusu\,\ Oita",
"817962", "Toyooka\,\ Hyogo",
"812963", "Shimodate\,\ Ibaraki",
"815755", "Sekigahara\,\ Gifu",
"811658", "Kamikawa\,\ Hokkaido",
"811562", "Honbetsu\,\ Hokkaido",
"817688", "Noto\,\ Ishikawa",
"814772", "Ichikawa\,\ Chiba",
"812563", "Sanjo\,\ Niigata",
"81266", "Suwa\,\ Nagano",
"818292", "Hiroshima\,\ Hiroshima",
"817707", "Obama\,\ Fukui",
"817706", "Obama\,\ Fukui",
"8125486", "Tsugawa\,\ Niigata",
"81986", "Miyakonojo\,\ Miyazaki",
"812375", "Murayama\,\ Yamagata",
"81272", "Maebashi\,\ Gunma",
"81196", "Morioka\,\ Iwate",
"814701", "Kamogawa\,\ Chiba",
"818806", "Sukumo\,\ Kochi",
"819945", "Kanoya\,\ Kagoshima",
"818807", "Sukumo\,\ Kochi",
"8125487", "Tsugawa\,\ Niigata",
"8153968", "Hamamatsu\,\ Shizuoka",
"814289", "Ome\,\ Tokyo",
"8153978", "Hamamatsu\,\ Shizuoka",
"819437", "Tanushimaru\,\ Fukuoka",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;