package OpenInteract2::SQLInstall::ObjectActivity;

# $Id: ObjectActivity.pm,v 1.2 2003/04/21 14:00:21 lachoy Exp $

use strict;
use base qw( OpenInteract2::SQLInstall );

my @TABLES = ( 'object_track.sql' );

my %FILES = (
 oracle => [ 'object_track_oracle.sql',
             'object_track_sequence.sql' ],
 pg     => [ 'object_track.sql',
             'object_track_sequence.sql' ],
 ib     => [ 'object_track_interbase.sql',
             'object_track_generator.sql' ],
);

sub get_structure_set {
    return 'object_action';
}

sub get_structure_file {
    my ( $self, $set, $type ) = @_;
    if ( $type eq 'Oracle' ) {
        return $FILES{oracle};
    }
    elsif ( $type eq 'Pg' ) {
        return $FILES{pg};
    }
    elsif ( $type eq 'InterBase' ) {
        return $FILES{ib};
    }
    else {
        return [ @TABLES ];
    }
}

sub get_security_file {
    return 'install_security.dat';
}

1;
