package OpenInteract::Handler::ObjectActivity;

# $Id: ObjectActivity.pm,v 1.2 2001/10/18 13:47:44 lachoy Exp $

use strict;
use OpenInteract::Handler::GenericDispatcher qw( DEFAULT_SECURITY_KEY );
use SPOPS::Secure qw( :level );
use SPOPS::SQLInterface;

@OpenInteract::Handler::ObjectActivity::ISA     = qw(
   OpenInteract::Handler::GenericDispatcher  SPOPS::Secure
);
$OpenInteract::Handler::ObjectActivity::VERSION           = sprintf("%d.%02d", q$Revision: 1.2 $ =~ /(\d+)\.(\d+)/);
$OpenInteract::Handler::ObjectActivity::author            = 'chris@cwinters.com';
$OpenInteract::Handler::ObjectActivity::default_method    = 'search_form';
@OpenInteract::Handler::ObjectActivity::forbidden_methods = ();
%OpenInteract::Handler::ObjectActivity::security          = ( DEFAULT_SECURITY_KEY() => SEC_LEVEL_READ );

sub search_form {
    my ( $class, $p ) = @_;
    my $R = OpenInteract::Request->instance;
    my %params = ();
    my $spops_conf = $R->CONFIG->{SPOPS};
    foreach my $object_key ( sort keys %{ $spops_conf } ) {
        push @{ $params{class_name_list} }, $object_key;
        push @{ $params{class_list} }, $spops_conf->{ $object_key }{class};
    }
    $R->{page}{title} = 'Search for Object Activity Records';
    return $R->template->handler( {}, \%params,
                                  { name => 'object_activity::search_form' } );
}

sub search {
    my ( $class, $p ) = @_;
    my $R        = OpenInteract::Request->instance;
    my %params = ();
    require OpenInteract::ObjectActivity;
    $params{activity_list} = OpenInteract::ObjectActivity->add_object_information(
                                                 OpenInteract::ObjectActivity->fetch_activity( $p ) );
    $R->{page}{title} = 'Object Activity Search Results';
    return $R->template->handler( {}, \%params,
                                  { name => 'object_activity::search_results' } );
}

1;
