package Task::Lingua::Any::Numbers;
use strict;
use vars qw( $VERSION );

$VERSION = '0.10';

1;

__END__

=pod

=head1 NAME

Task::Lingua::Any::Numbers - Installs all number to word modules.

=head1 SYNOPSIS

None.

=head1 DESCRIPTION

This is a tool to install everything needed for a full L<Lingua::Any::Numbers>
interface. See the L<Task> module for the rationale.

=head1 PREREQUISITIES

   Lingua::AF::Numbers
   Lingua::BG::Numbers
   Lingua::EN::Numbers
   Lingua::EU::Numbers
   Lingua::FR::Numbers
   Lingua::HU::Numbers
   Lingua::IT::Numbers
   Lingua::JA::Numbers
   Lingua::NL::Numbers
   Lingua::PL::Numbers
   Lingua::TR::Numbers
   Lingua::ZH::Numbers
   Lingua::CS::Num2Word
   Lingua::DE::Num2Word
   Lingua::ES::Numeros
   Lingua::ID::Nums2Words
   Lingua::NO::Num2Word
   Lingua::PT::Nums2Word
   Lingua::SV::Num2Word
   Lingua::Any::Numbers

=head1 SEE ALSO

L<Lingua::Any::Numbers>, L<Task>.

=head1 SUPPORT

=head2 BUG REPORTS

All bug reports and wishlist items B<must> be reported via
the CPAN RT system. It is accessible at
L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Task-Lingua-Any-Numbers>.

=head1 AUTHOR

Burak Gürsoy, E<lt>burakE<64>cpan.orgE<gt>

=head1 COPYRIGHT

Copyright 2009 Burak Gürsoy. All rights reserved.

=head1 LICENSE

This library is free software; you can redistribute it and/or modify 
it under the same terms as Perl itself, either Perl version 5.10.0 or, 
at your option, any later version of Perl 5 you may have available.

=cut
