#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "ppport.h"
#include "libimagequant.h"

/* There is some kind of collision between a file included by "perl.h"
   and "png.h" for very old versions of libpng, like the one used on
   Ubuntu Linux. */

#define PNG_SKIP_SETJMP_CHECK

#include <png.h>

#include "image-quantize-perl.c"

typedef image_quantize_t * Image__Quantize;
typedef image_quantize_t * Image__Quantize__PNG;

MODULE=Image::Quantize PACKAGE=Image::Quantize

PROTOTYPES: DISABLE

Image::Quantize internal_new ()
CODE:
	RETVAL = image_quantize_new ();
OUTPUT:
	RETVAL

void DESTROY (iq)
	Image::Quantize iq;
CODE:
	image_quantize_free (iq);

int max_colors (iq, colors = -1)
	Image::Quantize iq;
	int colors;
CODE:
	RETVAL = 0;
	if (colors == -1) {
		LIQ_CALL (liq_get_max_colors_2 (iq->attr, & RETVAL));
	}
	else {
		LIQ_CALL (liq_set_max_colors (iq->attr, colors));
		RETVAL = colors;
	}
OUTPUT:
	RETVAL

void quality (iq, minimum = -1, maximum = -1)
	Image::Quantize iq;
	int minimum;
	int maximum;
PPCODE:
	if (minimum == -1) {
		if (GIMME_V != G_ARRAY) {
		  	image_quantize_perl_error (iq, "quality () called in scalar/void context");
		}
		LIQ_CALL (liq_get_quality (iq->attr, & minimum, & maximum));
		EXTEND(SP, 2);
		PUSHs (sv_2mortal (newSViv (minimum)));
		PUSHs (sv_2mortal (newSViv (maximum)));
	}
	else {
		LIQ_CALL (liq_set_quality (iq->attr, minimum, maximum));
	}

SV * dithering_level (iq, dither_level = &PL_sv_undef)
	Image::Quantize iq;
	SV * dither_level
CODE:
	if (SvOK (dither_level)) {
		iq->dithering_level = SvNV (dither_level);
		iq->have_dithering_level = 1;
	}
	if (GIMME_V == G_SCALAR && iq->have_dithering_level) {
		RETVAL = newSVnv (iq->dithering_level);
	}
	else {
		RETVAL = &PL_sv_undef;
	}
OUTPUT:
	RETVAL

void default_dithering_level (iq)
	Image::Quantize iq;
CODE:
	iq->have_dithering_level = 0;

int speed (iq, s)
	Image::Quantize iq;
	int s;
PREINIT:
	liq_error error;
CODE:
	RETVAL = 0;
	error = liq_set_speed (iq->attr, s);
	if (error != LIQ_OK) {
		image_quantize_error (iq, error, "speed (%d)", s);
	}
OUTPUT:
	RETVAL

int min_opacity (iq, mo = -1)
	Image::Quantize iq;
	int mo;
PREINIT:
	liq_error error;
CODE:
	if (mo == -1) {
		error = liq_get_min_opacity_2 (iq->attr, & RETVAL);
		if (error != LIQ_OK) {
			image_quantize_error (iq, error, "min_opacity ()");
		}
	}
	else {
		RETVAL = mo;
		error = liq_set_min_opacity (iq->attr, mo);
		if (error != LIQ_OK) {
			image_quantize_error (iq, error, "min_opacity (%d)", mo);
		}
	}
OUTPUT:
	RETVAL

int min_posterization (iq, mp = -1)
	Image::Quantize iq;
	int mp;
PREINIT:
	liq_error error;
CODE:
	if (mp == -1) {
		error = liq_get_min_posterization_2 (iq->attr, & RETVAL);
		if (error != LIQ_OK) {
			image_quantize_error (iq, error, "min_posterization ()");
		}
	}
	else {
		RETVAL = mp;
		error = liq_set_min_posterization (iq->attr, mp);
		if (error != LIQ_OK) {
			image_quantize_error (iq, error, "min_posterization (%d)", mp);
		}
	}
OUTPUT:
	RETVAL

int last_index_transparent (iq, lit)
	Image::Quantize iq;
	SV * lit;
CODE:
	RETVAL = 0;
	liq_set_last_index_transparent (iq->attr, SvTRUE (lit));
OUTPUT:
	RETVAL

double quantization_error (iq)
	Image::Quantize iq;
CODE:
	RETVAL = liq_get_quantization_error (iq->result);
OUTPUT:
	RETVAL

double quantization_quality (iq)
	Image::Quantize iq;
CODE:
	RETVAL = liq_get_quantization_quality (iq->result);
OUTPUT:
	RETVAL

double output_gamma (iq, gamma)
	Image::Quantize iq;
	double gamma;
PREINIT:
	liq_error error;
CODE:
	RETVAL = 0;
	error = liq_set_output_gamma (iq->result, gamma);
OUTPUT:
	RETVAL

void
set_log_callback_internal (iq, function, data)
	Image::Quantize iq;
	SV * function;
	SV * data;
PREINIT:
	SV * fref;
CODE:
	if (SvOK (function)) {

		/* We have to extract the function reference here,
		because "function" itself is jus something on the Perl
		stack. */

		fref = (SV *) SvRV (function);
		iq->function = fref;
		/* Increment the refcount for data until we finished with it. */
		iq->data = SvREFCNT_inc (data);
		liq_set_log_callback (iq->attr, image_quantize_log_callback,
			              iq);
	}
	else {
		iq->function = 0;
		if (iq->data) {
			/* If there was some data in here, we don't want it 
			any more so release our refcount on it. */
			SvREFCNT_dec (data);
		}
		iq->data = 0;
		liq_set_log_callback (iq->attr, 0, 0);
	}


MODULE=Image::Quantize PACKAGE=Image::Quantize::PNG PREFIX=iqp_

PROTOTYPES: DISABLE

Image::Quantize::PNG iqp_internal_new_png ()
PREINIT:
	image_quantize_t * iq;
	iq_png_t * ip;
CODE:
	iq = image_quantize_new ();
	Newxz (ip, 1, iq_png_t);
	IQGET;
	iq->hook = ip;
	RETVAL = iq;
OUTPUT:
	RETVAL

void
iqp_DESTROY (iq)
	Image::Quantize::PNG iq;
CODE:
        Safefree (iq->hook);
        IQFREE;
	image_quantize_free (iq);

void iqp_quantize_internal (iq, in_png, in_info, out_png, out_info)
	Image::Quantize::PNG iq;
	SV * in_png;
	SV * in_info;
	SV * out_png;
	SV * out_info;
PREINIT:
	iq_png_t * ip;
	SV * image_data_sv;
	SV * row_pointers_sv;
PPCODE:
	ip = iq->hook;
	ip->in_png = INT2PTR (png_structp, SvIV (in_png));
	ip->in_info = INT2PTR (png_infop, SvIV (in_info));
	ip->out_png = INT2PTR (png_structp, SvIV (out_png));
	ip->out_info = INT2PTR (png_infop, SvIV (out_info));
	image_quantize_png_data_to_rgba (iq);
	image_quantize_png_quantize (iq);
	image_quantize_free_image (iq);
	image_data_sv = newSViv (PTR2IV (ip->image_data));
	row_pointers_sv = newSViv (PTR2IV (ip->row_pointers));
	XPUSHs (sv_2mortal (image_data_sv));
	XPUSHs (sv_2mortal (row_pointers_sv));
	ip->row_pointers = 0;
	ip->image_data = 0;
