package Image::PNG::Const;
require Exporter;
@ISA = qw(Exporter);
@EXPORT_OK = qw/
PNG_TEXT_COMPRESSION_NONE_WR
PNG_TEXT_COMPRESSION_zTXt_WR
PNG_TEXT_COMPRESSION_NONE
PNG_TEXT_COMPRESSION_zTXt
PNG_ITXT_COMPRESSION_NONE
PNG_ITXT_COMPRESSION_zTXt
PNG_COLOR_MASK_PALETTE
PNG_COLOR_MASK_COLOR
PNG_COLOR_MASK_ALPHA
PNG_COLOR_TYPE_GRAY
PNG_COLOR_TYPE_PALETTE
PNG_COLOR_TYPE_RGB
PNG_COLOR_TYPE_RGB_ALPHA
PNG_COLOR_TYPE_GRAY_ALPHA
PNG_COLOR_TYPE_RGBA
PNG_COLOR_TYPE_GA
PNG_COMPRESSION_TYPE_BASE
PNG_COMPRESSION_TYPE_DEFAULT
PNG_FILTER_TYPE_BASE
PNG_INTRAPIXEL_DIFFERENCING
PNG_FILTER_TYPE_DEFAULT
PNG_INTERLACE_NONE
PNG_INTERLACE_ADAM7
PNG_OFFSET_PIXEL
PNG_OFFSET_MICROMETER
PNG_EQUATION_LINEAR
PNG_EQUATION_BASE_E
PNG_EQUATION_ARBITRARY
PNG_EQUATION_HYPERBOLIC
PNG_SCALE_UNKNOWN
PNG_SCALE_METER
PNG_SCALE_RADIAN
PNG_RESOLUTION_UNKNOWN
PNG_RESOLUTION_METER
PNG_sRGB_INTENT_PERCEPTUAL
PNG_sRGB_INTENT_RELATIVE
PNG_sRGB_INTENT_SATURATION
PNG_sRGB_INTENT_ABSOLUTE
PNG_KEYWORD_MAX_LENGTH
PNG_MAX_PALETTE_LENGTH
PNG_INFO_gAMA
PNG_INFO_sBIT
PNG_INFO_cHRM
PNG_INFO_PLTE
PNG_INFO_tRNS
PNG_INFO_bKGD
PNG_INFO_hIST
PNG_INFO_pHYs
PNG_INFO_oFFs
PNG_INFO_tIME
PNG_INFO_pCAL
PNG_INFO_sRGB
PNG_INFO_iCCP
PNG_INFO_sPLT
PNG_INFO_sCAL
PNG_INFO_IDAT
PNG_TRANSFORM_IDENTITY
PNG_TRANSFORM_STRIP_16
PNG_TRANSFORM_STRIP_ALPHA
PNG_TRANSFORM_PACKING
PNG_TRANSFORM_PACKSWAP
PNG_TRANSFORM_EXPAND
PNG_TRANSFORM_INVERT_MONO
PNG_TRANSFORM_SHIFT
PNG_TRANSFORM_BGR
PNG_TRANSFORM_SWAP_ALPHA
PNG_TRANSFORM_SWAP_ENDIAN
PNG_TRANSFORM_INVERT_ALPHA
PNG_TRANSFORM_STRIP_FILLER
PNG_TRANSFORM_STRIP_FILLER_BEFORE
PNG_TRANSFORM_STRIP_FILLER_AFTER
PNG_TRANSFORM_GRAY_TO_RGB
PNG_FLAG_MNG_EMPTY_PLTE
PNG_FLAG_MNG_FILTER_64
PNG_ALL_MNG_FEATURES
PNG_FILLER_BEFORE
PNG_FILLER_AFTER
PNG_BACKGROUND_GAMMA_UNKNOWN
PNG_BACKGROUND_GAMMA_SCREEN
PNG_BACKGROUND_GAMMA_FILE
PNG_BACKGROUND_GAMMA_UNIQUE
PNG_CRC_DEFAULT
PNG_CRC_ERROR_QUIT
PNG_CRC_WARN_DISCARD
PNG_CRC_WARN_USE
PNG_CRC_QUIET_USE
PNG_CRC_NO_CHANGE
PNG_NO_FILTERS
PNG_FILTER_NONE
PNG_FILTER_SUB
PNG_FILTER_UP
PNG_FILTER_AVG
PNG_FILTER_PAETH
PNG_ALL_FILTERS
PNG_FILTER_VALUE_NONE
PNG_FILTER_VALUE_SUB
PNG_FILTER_VALUE_UP
PNG_FILTER_VALUE_AVG
PNG_FILTER_VALUE_PAETH
PNG_FILTER_HEURISTIC_DEFAULT
PNG_FILTER_HEURISTIC_UNWEIGHTED
PNG_FILTER_HEURISTIC_WEIGHTED
PNG_DESTROY_WILL_FREE_DATA
PNG_SET_WILL_FREE_DATA
PNG_USER_WILL_FREE_DATA
PNG_FREE_HIST
PNG_FREE_ICCP
PNG_FREE_SPLT
PNG_FREE_ROWS
PNG_FREE_PCAL
PNG_FREE_SCAL
PNG_FREE_UNKN
PNG_FREE_LIST
PNG_FREE_PLTE
PNG_FREE_TRNS
PNG_FREE_TEXT
PNG_FREE_ALL
PNG_FREE_MUL
PNG_HANDLE_CHUNK_AS_DEFAULT
PNG_HANDLE_CHUNK_NEVER
PNG_HANDLE_CHUNK_IF_SAFE
PNG_HANDLE_CHUNK_ALWAYS
PNG_IO_NONE
PNG_IO_READING
PNG_IO_WRITING
PNG_IO_SIGNATURE
PNG_IO_CHUNK_HDR
PNG_IO_CHUNK_DATA
PNG_IO_CHUNK_CRC
PNG_IO_MASK_OP
PNG_IO_MASK_LOC
PNG_HAVE_IHDR
PNG_HAVE_PLTE
PNG_HAVE_IDAT
PNG_AFTER_IDAT
PNG_HAVE_IEND
PNG_HAVE_gAMA
PNG_HAVE_cHRM
/;

%EXPORT_TAGS = ('all' => \@EXPORT_OK);

use warnings;
use strict;

use constant {
    PNG_TEXT_COMPRESSION_NONE_WR => -3,
    PNG_TEXT_COMPRESSION_zTXt_WR => -2,
    PNG_TEXT_COMPRESSION_NONE => -1,
    PNG_TEXT_COMPRESSION_zTXt => 0,
    PNG_ITXT_COMPRESSION_NONE => 1,
    PNG_ITXT_COMPRESSION_zTXt => 2,
    PNG_COLOR_MASK_PALETTE => 1,
    PNG_COLOR_MASK_COLOR => 2,
    PNG_COLOR_MASK_ALPHA => 4,
    PNG_COLOR_TYPE_GRAY => 0,
    PNG_COLOR_TYPE_PALETTE => (2 | 1),
    PNG_COLOR_TYPE_RGB => (2),
    PNG_COLOR_TYPE_RGB_ALPHA => (2 | 4),
    PNG_COLOR_TYPE_GRAY_ALPHA => (4),
    PNG_COLOR_TYPE_RGBA => (2 | 4),
    PNG_COLOR_TYPE_GA => (4),
    PNG_COMPRESSION_TYPE_BASE => 0,
    PNG_COMPRESSION_TYPE_DEFAULT => 0,
    PNG_FILTER_TYPE_BASE => 0,
    PNG_INTRAPIXEL_DIFFERENCING => 64,
    PNG_FILTER_TYPE_DEFAULT => 0,
    PNG_INTERLACE_NONE => 0,
    PNG_INTERLACE_ADAM7 => 1,
    PNG_OFFSET_PIXEL => 0,
    PNG_OFFSET_MICROMETER => 1,
    PNG_EQUATION_LINEAR => 0,
    PNG_EQUATION_BASE_E => 1,
    PNG_EQUATION_ARBITRARY => 2,
    PNG_EQUATION_HYPERBOLIC => 3,
    PNG_SCALE_UNKNOWN => 0,
    PNG_SCALE_METER => 1,
    PNG_SCALE_RADIAN => 2,
    PNG_RESOLUTION_UNKNOWN => 0,
    PNG_RESOLUTION_METER => 1,
    PNG_sRGB_INTENT_PERCEPTUAL => 0,
    PNG_sRGB_INTENT_RELATIVE => 1,
    PNG_sRGB_INTENT_SATURATION => 2,
    PNG_sRGB_INTENT_ABSOLUTE => 3,
    PNG_KEYWORD_MAX_LENGTH => 79,
    PNG_MAX_PALETTE_LENGTH => 256,
    PNG_INFO_gAMA => 0x0001,
    PNG_INFO_sBIT => 0x0002,
    PNG_INFO_cHRM => 0x0004,
    PNG_INFO_PLTE => 0x0008,
    PNG_INFO_tRNS => 0x0010,
    PNG_INFO_bKGD => 0x0020,
    PNG_INFO_hIST => 0x0040,
    PNG_INFO_pHYs => 0x0080,
    PNG_INFO_oFFs => 0x0100,
    PNG_INFO_tIME => 0x0200,
    PNG_INFO_pCAL => 0x0400,
    PNG_INFO_sRGB => 0x0800,
    PNG_INFO_iCCP => 0x1000,
    PNG_INFO_sPLT => 0x2000,
    PNG_INFO_sCAL => 0x4000,
    PNG_INFO_IDAT => 0x8000,
    PNG_TRANSFORM_IDENTITY => 0x0000,
    PNG_TRANSFORM_STRIP_16 => 0x0001,
    PNG_TRANSFORM_STRIP_ALPHA => 0x0002,
    PNG_TRANSFORM_PACKING => 0x0004,
    PNG_TRANSFORM_PACKSWAP => 0x0008,
    PNG_TRANSFORM_EXPAND => 0x0010,
    PNG_TRANSFORM_INVERT_MONO => 0x0020,
    PNG_TRANSFORM_SHIFT => 0x0040,
    PNG_TRANSFORM_BGR => 0x0080,
    PNG_TRANSFORM_SWAP_ALPHA => 0x0100,
    PNG_TRANSFORM_SWAP_ENDIAN => 0x0200,
    PNG_TRANSFORM_INVERT_ALPHA => 0x0400,
    PNG_TRANSFORM_STRIP_FILLER => 0x0800,
    PNG_TRANSFORM_STRIP_FILLER_BEFORE => 0x0800,
    PNG_TRANSFORM_STRIP_FILLER_AFTER => 0x1000,
    PNG_TRANSFORM_GRAY_TO_RGB => 0x2000,
    PNG_FLAG_MNG_EMPTY_PLTE => 0x01,
    PNG_FLAG_MNG_FILTER_64 => 0x04,
    PNG_ALL_MNG_FEATURES => 0x05,
    PNG_FILLER_BEFORE => 0,
    PNG_FILLER_AFTER => 1,
    PNG_BACKGROUND_GAMMA_UNKNOWN => 0,
    PNG_BACKGROUND_GAMMA_SCREEN => 1,
    PNG_BACKGROUND_GAMMA_FILE => 2,
    PNG_BACKGROUND_GAMMA_UNIQUE => 3,
    PNG_CRC_DEFAULT => 0,
    PNG_CRC_ERROR_QUIT => 1,
    PNG_CRC_WARN_DISCARD => 2,
    PNG_CRC_WARN_USE => 3,
    PNG_CRC_QUIET_USE => 4,
    PNG_CRC_NO_CHANGE => 5,
    PNG_NO_FILTERS => 0x00,
    PNG_FILTER_NONE => 0x08,
    PNG_FILTER_SUB => 0x10,
    PNG_FILTER_UP => 0x20,
    PNG_FILTER_AVG => 0x40,
    PNG_FILTER_PAETH => 0x80,
    PNG_ALL_FILTERS => (0x08 | 0x10 | 0x20 | 0x40 | 0x80),
    PNG_FILTER_VALUE_NONE => 0,
    PNG_FILTER_VALUE_SUB => 1,
    PNG_FILTER_VALUE_UP => 2,
    PNG_FILTER_VALUE_AVG => 3,
    PNG_FILTER_VALUE_PAETH => 4,
    PNG_FILTER_HEURISTIC_DEFAULT => 0,
    PNG_FILTER_HEURISTIC_UNWEIGHTED => 1,
    PNG_FILTER_HEURISTIC_WEIGHTED => 2,
    PNG_DESTROY_WILL_FREE_DATA => 1,
    PNG_SET_WILL_FREE_DATA => 1,
    PNG_USER_WILL_FREE_DATA => 2,
    PNG_FREE_HIST => 0x0008,
    PNG_FREE_ICCP => 0x0010,
    PNG_FREE_SPLT => 0x0020,
    PNG_FREE_ROWS => 0x0040,
    PNG_FREE_PCAL => 0x0080,
    PNG_FREE_SCAL => 0x0100,
    PNG_FREE_UNKN => 0x0200,
    PNG_FREE_LIST => 0x0400,
    PNG_FREE_PLTE => 0x1000,
    PNG_FREE_TRNS => 0x2000,
    PNG_FREE_TEXT => 0x4000,
    PNG_FREE_ALL => 0x7fff,
    PNG_FREE_MUL => 0x4220,
    PNG_HANDLE_CHUNK_AS_DEFAULT => 0,
    PNG_HANDLE_CHUNK_NEVER => 1,
    PNG_HANDLE_CHUNK_IF_SAFE => 2,
    PNG_HANDLE_CHUNK_ALWAYS => 3,
    PNG_IO_NONE => 0x0000,
    PNG_IO_READING => 0x0001,
    PNG_IO_WRITING => 0x0002,
    PNG_IO_SIGNATURE => 0x0010,
    PNG_IO_CHUNK_HDR => 0x0020,
    PNG_IO_CHUNK_DATA => 0x0040,
    PNG_IO_CHUNK_CRC => 0x0080,
    PNG_IO_MASK_OP => 0x000f,
    PNG_IO_MASK_LOC => 0x00f0,
    PNG_HAVE_IHDR => 0x01,
    PNG_HAVE_PLTE => 0x02,
    PNG_HAVE_IDAT => 0x04,
    PNG_AFTER_IDAT => 0x08,
    PNG_HAVE_IEND => 0x10,
    PNG_HAVE_gAMA => 0x20,
    PNG_HAVE_cHRM => 0x40,
};

=head1 NAME

Image::PNG::Const

=head1 SYNOPSIS

       # Get the constants you need:
       use Image::PNG::Const qw/PNG_TRANSFORM_INVERT_ALPHA
                               PNG_COLOR_MASK_ALPHA/;
       # Get everything:
       use Image::PNG::Const ':all';

This module contains no functions, only constants.

=head1 CONSTANTS

This file contains constants extracted from the header file of the PNG
library, C<png.h>. The constants in this file are

=over

=item PNG_TEXT_COMPRESSION_NONE_WR = -3

=item PNG_TEXT_COMPRESSION_zTXt_WR = -2

=item PNG_TEXT_COMPRESSION_NONE = -1

=item PNG_TEXT_COMPRESSION_zTXt = 0

=item PNG_ITXT_COMPRESSION_NONE = 1

=item PNG_ITXT_COMPRESSION_zTXt = 2

=item PNG_COLOR_MASK_PALETTE = 1

=item PNG_COLOR_MASK_COLOR = 2

=item PNG_COLOR_MASK_ALPHA = 4

=item PNG_COLOR_TYPE_GRAY = 0

=item PNG_COLOR_TYPE_PALETTE = (2 | 1)

=item PNG_COLOR_TYPE_RGB = (2)

=item PNG_COLOR_TYPE_RGB_ALPHA = (2 | 4)

=item PNG_COLOR_TYPE_GRAY_ALPHA = (4)

=item PNG_COLOR_TYPE_RGBA = (2 | 4)

=item PNG_COLOR_TYPE_GA = (4)

=item PNG_COMPRESSION_TYPE_BASE = 0

=item PNG_COMPRESSION_TYPE_DEFAULT = 0

=item PNG_FILTER_TYPE_BASE = 0

=item PNG_INTRAPIXEL_DIFFERENCING = 64

=item PNG_FILTER_TYPE_DEFAULT = 0

=item PNG_INTERLACE_NONE = 0

=item PNG_INTERLACE_ADAM7 = 1

=item PNG_OFFSET_PIXEL = 0

=item PNG_OFFSET_MICROMETER = 1

=item PNG_EQUATION_LINEAR = 0

=item PNG_EQUATION_BASE_E = 1

=item PNG_EQUATION_ARBITRARY = 2

=item PNG_EQUATION_HYPERBOLIC = 3

=item PNG_SCALE_UNKNOWN = 0

=item PNG_SCALE_METER = 1

=item PNG_SCALE_RADIAN = 2

=item PNG_RESOLUTION_UNKNOWN = 0

=item PNG_RESOLUTION_METER = 1

=item PNG_sRGB_INTENT_PERCEPTUAL = 0

=item PNG_sRGB_INTENT_RELATIVE = 1

=item PNG_sRGB_INTENT_SATURATION = 2

=item PNG_sRGB_INTENT_ABSOLUTE = 3

=item PNG_KEYWORD_MAX_LENGTH = 79

=item PNG_MAX_PALETTE_LENGTH = 256

=item PNG_INFO_gAMA = 0x0001

=item PNG_INFO_sBIT = 0x0002

=item PNG_INFO_cHRM = 0x0004

=item PNG_INFO_PLTE = 0x0008

=item PNG_INFO_tRNS = 0x0010

=item PNG_INFO_bKGD = 0x0020

=item PNG_INFO_hIST = 0x0040

=item PNG_INFO_pHYs = 0x0080

=item PNG_INFO_oFFs = 0x0100

=item PNG_INFO_tIME = 0x0200

=item PNG_INFO_pCAL = 0x0400

=item PNG_INFO_sRGB = 0x0800

=item PNG_INFO_iCCP = 0x1000

=item PNG_INFO_sPLT = 0x2000

=item PNG_INFO_sCAL = 0x4000

=item PNG_INFO_IDAT = 0x8000

=item PNG_TRANSFORM_IDENTITY = 0x0000

=item PNG_TRANSFORM_STRIP_16 = 0x0001

=item PNG_TRANSFORM_STRIP_ALPHA = 0x0002

=item PNG_TRANSFORM_PACKING = 0x0004

=item PNG_TRANSFORM_PACKSWAP = 0x0008

=item PNG_TRANSFORM_EXPAND = 0x0010

=item PNG_TRANSFORM_INVERT_MONO = 0x0020

=item PNG_TRANSFORM_SHIFT = 0x0040

=item PNG_TRANSFORM_BGR = 0x0080

=item PNG_TRANSFORM_SWAP_ALPHA = 0x0100

=item PNG_TRANSFORM_SWAP_ENDIAN = 0x0200

=item PNG_TRANSFORM_INVERT_ALPHA = 0x0400

=item PNG_TRANSFORM_STRIP_FILLER = 0x0800

=item PNG_TRANSFORM_STRIP_FILLER_BEFORE = 0x0800

=item PNG_TRANSFORM_STRIP_FILLER_AFTER = 0x1000

=item PNG_TRANSFORM_GRAY_TO_RGB = 0x2000

=item PNG_FLAG_MNG_EMPTY_PLTE = 0x01

=item PNG_FLAG_MNG_FILTER_64 = 0x04

=item PNG_ALL_MNG_FEATURES = 0x05

=item PNG_FILLER_BEFORE = 0

=item PNG_FILLER_AFTER = 1

=item PNG_BACKGROUND_GAMMA_UNKNOWN = 0

=item PNG_BACKGROUND_GAMMA_SCREEN = 1

=item PNG_BACKGROUND_GAMMA_FILE = 2

=item PNG_BACKGROUND_GAMMA_UNIQUE = 3

=item PNG_CRC_DEFAULT = 0

=item PNG_CRC_ERROR_QUIT = 1

=item PNG_CRC_WARN_DISCARD = 2

=item PNG_CRC_WARN_USE = 3

=item PNG_CRC_QUIET_USE = 4

=item PNG_CRC_NO_CHANGE = 5

=item PNG_NO_FILTERS = 0x00

=item PNG_FILTER_NONE = 0x08

=item PNG_FILTER_SUB = 0x10

=item PNG_FILTER_UP = 0x20

=item PNG_FILTER_AVG = 0x40

=item PNG_FILTER_PAETH = 0x80

=item PNG_ALL_FILTERS = (0x08 | 0x10 | 0x20 | 0x40 | 0x80)

=item PNG_FILTER_VALUE_NONE = 0

=item PNG_FILTER_VALUE_SUB = 1

=item PNG_FILTER_VALUE_UP = 2

=item PNG_FILTER_VALUE_AVG = 3

=item PNG_FILTER_VALUE_PAETH = 4

=item PNG_FILTER_HEURISTIC_DEFAULT = 0

=item PNG_FILTER_HEURISTIC_UNWEIGHTED = 1

=item PNG_FILTER_HEURISTIC_WEIGHTED = 2

=item PNG_DESTROY_WILL_FREE_DATA = 1

=item PNG_SET_WILL_FREE_DATA = 1

=item PNG_USER_WILL_FREE_DATA = 2

=item PNG_FREE_HIST = 0x0008

=item PNG_FREE_ICCP = 0x0010

=item PNG_FREE_SPLT = 0x0020

=item PNG_FREE_ROWS = 0x0040

=item PNG_FREE_PCAL = 0x0080

=item PNG_FREE_SCAL = 0x0100

=item PNG_FREE_UNKN = 0x0200

=item PNG_FREE_LIST = 0x0400

=item PNG_FREE_PLTE = 0x1000

=item PNG_FREE_TRNS = 0x2000

=item PNG_FREE_TEXT = 0x4000

=item PNG_FREE_ALL = 0x7fff

=item PNG_FREE_MUL = 0x4220

=item PNG_HANDLE_CHUNK_AS_DEFAULT = 0

=item PNG_HANDLE_CHUNK_NEVER = 1

=item PNG_HANDLE_CHUNK_IF_SAFE = 2

=item PNG_HANDLE_CHUNK_ALWAYS = 3

=item PNG_IO_NONE = 0x0000

=item PNG_IO_READING = 0x0001

=item PNG_IO_WRITING = 0x0002

=item PNG_IO_SIGNATURE = 0x0010

=item PNG_IO_CHUNK_HDR = 0x0020

=item PNG_IO_CHUNK_DATA = 0x0040

=item PNG_IO_CHUNK_CRC = 0x0080

=item PNG_IO_MASK_OP = 0x000f

=item PNG_IO_MASK_LOC = 0x00f0

=item PNG_HAVE_IHDR = 0x01

=item PNG_HAVE_PLTE = 0x02

=item PNG_HAVE_IDAT = 0x04

=item PNG_AFTER_IDAT = 0x08

=item PNG_HAVE_IEND = 0x10

=item PNG_HAVE_gAMA = 0x20

=item PNG_HAVE_cHRM = 0x40

=back

=head1 EXPORTS

Nothing is exported by default, but all the symbols in this module can
be exported on request. There is one export tag, 'all', which exports
all the symbols in this module:

    use Image::PNG::Const ':all';

=head1 ABOUT THIS MODULE

This Perl module was automatically created from C<png.h>. To rebuild
it, run the script "strip-constants.pl" in the top directory of the
L<Image::PNG> distribution. You need to have the L<Template> module
installed. You may need to edit the script somewhat, depending on your
environment.

The template for creating Const.pm is in directory C<tmpl> in the
Image::PNG distribution. Its name is C<Const.pm.tmpl>.

=head1 AUTHOR

Ben Bullock, <bkb@cpan.org>

=head1 COPYRIGHT & LICENCE

The Image::PNG package and associated files are copyright (C)
2011 Ben Bullock.

You can use, copy, modify and redistribute Image::PNG and
associated files under the Perl Artistic Licence or the GNU General
Public Licence.

=head1 SUPPORT

=head2 Mailing list

There is a mailing list at
L<http://groups.google.com/group/perlimagepng>. You don't need to be a
member of the list to post messages to the list or participate in
discussions. Your messages may be held for moderation though.

If you have anything at all to say about the module, whether it is bug
reports, feature requests, or anything else, I'd prefer to discuss it
on the mailing list because that way there is a public record which
everyone can access, rather than being restricted to email. That means
that, for example, if someone else takes over maintaining this module,
they can easily access records of previous discussions.

=head2 CPAN stuff

There is a bug tracker at .

=head1 FOR PROGRAMMERS

(This section is only for people who want to fix a bug or add an
improvement to this module, and who want to share the change with
other people by adding it to the public version of this module.)

If you want to alter this module, note very carefully that the
distributed files are not actually the source code of the module. The
source code lives in the "tmpl" directory of the distribution and the
distribution is created via scripts.

The original files of this distribution make very heavy use of the
L<Template> Perl module in order to cut down the amount of repetitive
stuff which needs to be put into various source and documentation
files. If you plan to alter the C file, you may also need a program
called "cfunctions" which you can download from sourceforge, which
generates the header file perl-libpng.h from perl-libpng.c.


