package String::Perl::Warnings;

use strict;
use warnings; # Duh >:)
use Regexp::Assemble;
use vars qw($VERSION);

$VERSION = '0.02';

require Exporter;
our @ISA = qw( Exporter );
our @EXPORT_OK = qw(is_warning);

my $lines = [
q{accept\(\)\ on\ closed\ socket\ .+?},
q{Allocation\ too\ large\:\ .+?},
q{\'\!\'\ allowed\ only\ after\ types\ .+?},
q{Ambiguous\ call\ resolved\ as\ CORE\:\:.+?\(\)\,\ qualify\ as\ such\ or\ use\ \&},
q{Ambiguous\ range\ in\ transliteration\ operator},
q{Ambiguous\ use\ of\ .+?\ resolved\ as\ .+?},
q{\'\|\'\ and\ \'\<\'\ may\ not\ both\ be\ specified\ on\ command\ line},
q{\'\|\'\ and\ \'\>\'\ may\ not\ both\ be\ specified\ on\ command\ line},
q{Applying\ .+?\ to\ .+?\ will\ act\ on\ scalar\(.+?\)},
q{Args\ must\ match\ \#\!\ line},
q{Arg\ too\ short\ for\ msgsnd},
q{.+?\ argument\ is\ not\ a\ HASH\ or\ ARRAY\ element},
q{.+?\ argument\ is\ not\ a\ HASH\ or\ ARRAY\ element\ or\ slice},
q{.+?\ argument\ is\ not\ a\ subroutine\ name},
q{Argument\ \".+?\"\ isn\'t\ numeric.+?},
q{Argument\ list\ not\ closed\ for\ PerlIO\ layer\ \".+?\"},
q{Array\ \@.+?\ missing\ the\ \@\ in\ argument\ .+?\ of\ .+?\(\)},
q{assertion\ botched\:\ .+?},
q{Assertion\ failed\:\ file\ \".+?\"},
q{Assignment\ to\ both\ a\ list\ and\ a\ scalar},
q{A\ thread\ exited\ while\ .+?\ threads\ were\ running},
q{Attempt\ to\ access\ disallowed\ key\ \'.+?\'\ in\ a\ restricted\ hash},
q{Attempt\ to\ bless\ into\ a\ reference},
q{Attempt\ to\ delete\ disallowed\ key\ \'.+?\'\ from\ a\ restricted\ hash},
q{Attempt\ to\ delete\ readonly\ key\ \'.+?\'\ from\ a\ restricted\ hash},
q{Attempt\ to\ free\ non\-arena\ SV\:\ 0x.+?},
q{Attempt\ to\ free\ nonexistent\ shared\ string},
q{Attempt\ to\ free\ temp\ prematurely},
q{Attempt\ to\ free\ unreferenced\ glob\ pointers},
q{Attempt\ to\ free\ unreferenced\ scalar},
q{Attempt\ to\ join\ self},
q{Attempt\ to\ pack\ pointer\ to\ temporary\ value},
q{Attempt\ to\ set\ length\ of\ freed\ array},
q{Attempt\ to\ use\ reference\ as\ lvalue\ in\ substr},
q{Bad\ arg\ length\ for\ .+?\,\ is\ .+?\,\ should\ be\ .+?},
q{Bad\ evalled\ substitution\ pattern},
q{Bad\ filehandle\:\ .+?},
q{Bad\ free\(\)\ ignored},
q{Bad\ hash},
q{Bad\ index\ while\ coercing\ array\ into\ hash},
q{Badly\ placed\ \(\)\'s},
q{Bad\ name\ after\ .+?\:\:},
q{Bad\ realloc\(\)\ ignored},
q{Bad\ symbol\ for\ array},
q{Bad\ symbol\ for\ filehandle},
q{Bad\ symbol\ for\ hash},
q{Bareword\ found\ in\ conditional},
q{Bareword\ \".+?\"\ not\ allowed\ while\ \"strict\ subs\"\ in\ use},
q{Bareword\ \".+?\"\ refers\ to\ nonexistent\ package},
q{BEGIN\ failed\-\-compilation\ aborted},
q{BEGIN\ not\ safe\ after\ errors\-\-compilation\ aborted},
q{\\1\ better\ written\ as\ \$1},
q{Binary\ number\ \>\ 0b11111111111111111111111111111111\ non\-portable},
q{bind\(\)\ on\ closed\ socket\ .+?},
q{binmode\(\)\ on\ closed\ filehandle\ .+?},
q{Bit\ vector\ size\ \>\ 32\ non\-portable},
q{Bizarre\ copy\ of\ .+?\ in\ .+?},
q{Buffer\ overflow\ in\ prime_env_iter\:\ .+?},
q{Callback\ called\ exit},
q{.+?\(\)\ called\ too\ early\ to\ check\ prototype},
q{Cannot\ compress\ integer\ in\ pack},
q{Cannot\ compress\ negative\ numbers\ in\ pack},
q{Can\ only\ compress\ unsigned\ integers\ in\ pack},
q{Can\'t\ bless\ non\-reference\ value},
q{Can\'t\ call\ method\ \".+?\"\ in\ empty\ package\ \".+?\"},
q{Can\'t\ call\ method\ \".+?\"\ on\ an\ undefined\ value},
q{Can\'t\ call\ method\ \".+?\"\ on\ unblessed\ reference},
q{Can\'t\ call\ method\ \".+?\"\ without\ a\ package\ or\ object\ reference},
q{Can\'t\ chdir\ to\ .+?},
q{Can\'t\ check\ filesystem\ of\ script\ \".+?\"\ for\ nosuid},
q{Can\'t\ coerce\ array\ into\ hash},
q{Can\'t\ coerce\ .+?\ to\ integer\ in\ .+?},
q{Can\'t\ coerce\ .+?\ to\ number\ in\ .+?},
q{Can\'t\ coerce\ .+?\ to\ string\ in\ .+?},
q{Can\'t\ create\ pipe\ mailbox},
q{Can\'t\ declare\ class\ for\ non\-scalar\ .+?\ in\ \".+?\"},
q{Can\'t\ declare\ .+?\ in\ \".+?\"},
q{Can\'t\ do\ inplace\ edit\:\ .+?\ is\ not\ a\ regular\ file},
q{Can\'t\ do\ inplace\ edit\ on\ .+?\:\ .+?},
q{Can\'t\ do\ inplace\ edit\ without\ backup},
q{Can\'t\ do\ inplace\ edit\:\ .+?\ would\ not\ be\ unique},
q{Can\'t\ do\ \{n\,m\}\ with\ n\ \>\ m\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Can\'t\ do\ setegid\!},
q{Can\'t\ do\ seteuid\!},
q{Can\'t\ do\ setuid},
q{Can\'t\ do\ waitpid\ with\ flags},
q{Can\'t\ emulate\ \-.+?\ on\ \#\!\ line},
q{Can\'t\ exec\ \".+?\"\:\ .+?},
q{Can\'t\ exec\ .+?},
q{Can\'t\ execute\ .+?},
q{Can\'t\ find\ an\ opnumber\ for\ \".+?\"},
q{Can\'t\ find\ .+?\ character\ property\ \".+?\"},
q{Can\'t\ find\ label\ .+?},
q{Can\'t\ find\ .+?\ on\ PATH},
q{Can\'t\ find\ .+?\ on\ PATH\,\ \'\.\'\ not\ in\ PATH},
q{Can\'t\ find\ .+?\ property\ definition\ .+?},
q{Can\'t\ find\ string\ terminator\ .+?\ anywhere\ before\ EOF},
q{Can\'t\ fork},
q{Can\'t\ get\ filespec\ \-\ stale\ stat\ buffer\?},
q{Can\'t\ get\ pipe\ mailbox\ device\ name},
q{Can\'t\ get\ SYSGEN\ parameter\ value\ for\ MAXBUF},
q{Can\'t\ \"goto\"\ into\ the\ middle\ of\ a\ foreach\ loop},
q{Can\'t\ \"goto\"\ out\ of\ a\ pseudo\ block},
q{Can\'t\ goto\ subroutine\ from\ an\ eval\-.+?},
q{Can\'t\ goto\ subroutine\ outside\ a\ subroutine},
q{Can\'t\ ignore\ signal\ CHLD\,\ forcing\ to\ default},
q{Can\'t\ \"last\"\ outside\ a\ loop\ block},
q{Can\'t\ load\ \'.+?\'\ for\ module\ .+?},
q{Can\'t\ localize\ lexical\ variable\ .+?},
q{Can\'t\ localize\ pseudo\-hash\ element},
q{Can\'t\ localize\ through\ a\ reference},
q{Can\'t\ locate\ .+?},
q{Can\'t\ locate\ auto\/.+?\.al\ in\ \@INC},
q{Can\'t\ locate\ loadable\ object\ for\ module\ .+?\ in\ \@INC},
q{Can\'t\ locate\ object\ method\ \".+?\"\ via\ package\ \".+?\"},
q{Can\'t\ locate\ package\ .+?\ for\ \@.+?\:\:ISA},
q{Can\'t\ locate\ PerlIO.+?},
q{Can\'t\ make\ list\ assignment\ to\ \\\%ENV\ on\ this\ system},
q{Can\'t\ modify\ .+?\ in\ .+?},
q{Can\'t\ modify\ nonexistent\ substring},
q{Can\'t\ modify\ non\-lvalue\ subroutine\ call},
q{Can\'t\ msgrcv\ to\ read\-only\ var},
q{Can\'t\ \"next\"\ outside\ a\ loop\ block},
q{Can\'t\ open\ .+?\:\ .+?},
q{Can\'t\ open\ a\ reference},
q{Can\'t\ open\ bidirectional\ pipe},
q{Can\'t\ open\ error\ file\ .+?\ as\ stderr},
q{Can\'t\ open\ input\ file\ .+?\ as\ stdin},
q{Can\'t\ open\ output\ file\ .+?\ as\ stdout},
q{Can\'t\ open\ output\ pipe\ \(name\:\ .+?\)},
q{Can\'t\ open\ perl\ script.+?},
q{Can\'t\ read\ CRTL\ environ},
q{Can\'t\ redefine\ active\ sort\ subroutine\ .+?},
q{Can\'t\ \"redo\"\ outside\ a\ loop\ block},
q{Can\'t\ remove\ .+?\:\ .+?\,\ skipping\ file},
q{Can\'t\ rename\ .+?\ to\ .+?\:\ .+?\,\ skipping\ file},
q{Can\'t\ reopen\ input\ pipe\ \(name\:\ .+?\)\ in\ binary\ mode},
q{Can\'t\ resolve\ method\ \`.+?\'\ overloading\ \`.+?\'\ in\ package\ \`.+?\'},
q{Can\'t\ reswap\ uid\ and\ euid},
q{Can\'t\ return\ .+?\ from\ lvalue\ subroutine},
q{Can\'t\ return\ outside\ a\ subroutine},
q{Can\'t\ return\ .+?\ to\ lvalue\ scalar\ context},
q{Can\'t\ stat\ script\ \".+?\"},
q{Can\'t\ swap\ uid\ and\ euid},
q{Can\'t\ take\ log\ of\ .+?},
q{Can\'t\ take\ sqrt\ of\ .+?},
q{Can\'t\ undef\ active\ subroutine},
q{Can\'t\ unshift},
q{Can\'t\ upgrade\ that\ kind\ of\ scalar},
q{Can\'t\ upgrade\ to\ undef},
q{Can\'t\ use\ anonymous\ symbol\ table\ for\ method\ lookup},
q{Can\'t\ use\ an\ undefined\ value\ as\ .+?\ reference},
q{Can\'t\ use\ bareword\ \(\".+?\"\)\ as\ .+?\ ref\ while\ \"strict\ refs\"\ in\ use},
q{Can\'t\ use\ \%\!\ because\ Errno\.pm\ is\ not\ available},
q{Can\'t\ use\ .+?\ for\ loop\ variable},
q{Can\'t\ use\ global\ .+?\ in\ \"my\"},
q{Can\'t\ use\ \"my\ .+?\"\ in\ sort\ comparison},
q{Can\'t\ use\ .+?\ ref\ as\ .+?\ ref},
q{Can\'t\ use\ string\ \(\".+?\"\)\ as\ .+?\ ref\ while\ \"strict\ refs\"\ in\ use},
q{Can\'t\ use\ subscript\ on\ .+?},
q{Can\'t\ use\ \\.+?\ to\ mean\ \$.+?\ in\ expression},
q{Can\'t\ weaken\ a\ nonreference},
q{Can\'t\ x\=\ to\ read\-only\ value},
q{Character\ in\ \"C\"\ format\ wrapped\ in\ pack},
q{Character\ in\ \"c\"\ format\ wrapped\ in\ pack},
q{close\(\)\ on\ unopened\ filehandle\ .+?},
q{Code\ missing\ after\ \'\/\'},
q{.+?\:\ Command\ not\ found},
q{Compilation\ failed\ in\ require},
q{Complex\ regular\ subexpression\ recursion\ limit\ \(.+?\)\ exceeded},
q{cond_broadcast\(\)\ called\ on\ unlocked\ variable},
q{cond_signal\(\)\ called\ on\ unlocked\ variable},
q{connect\(\)\ on\ closed\ socket\ .+?},
q{Constant\(.+?\).+?\:\ .+?},
q{Constant\ is\ not\ .+?\ reference},
q{Constant\ subroutine\ .+?\ redefined},
q{Constant\ subroutine\ .+?\ undefined},
q{Copy\ method\ did\ not\ return\ a\ reference},
q{CORE\:\:.+?\ is\ not\ a\ keyword},
q{corrupted\ regexp\ pointers},
q{corrupted\ regexp\ program},
q{Corrupt\ malloc\ ptr\ 0x.+?\ at\ 0x.+?},
q{Count\ after\ length\/code\ in\ unpack},
q{Deep\ recursion\ on\ subroutine\ \".+?\"},
q{defined\(\@array\)\ is\ deprecated},
q{defined\(.+?\)\ is\ deprecated},
q{.+?\ defines\ neither\ package\ nor\ VERSION\-\-version\ check\ failed},
q{Delimiter\ for\ here\ document\ is\ too\ long},
q{DESTROY\ created\ new\ reference\ to\ dead\ object\ \'.+?\'},
q{Did\ not\ produce\ a\ valid\ header},
q{.+?\ did\ not\ return\ a\ true\ value},
q{\(Did\ you\ mean\ \&.+?\ instead\?\)},
q{\(Did\ you\ mean\ \"local\"\ instead\ of\ \"our\"\?\)},
q{\(Did\ you\ mean\ \$\ or\ \@\ instead\ of\ \%\?\)},
q{Died},
q{Document\ contains\ no\ data},
q{.+?\ does\ not\ define\ .+?\:\:VERSION\-\-version\ check\ failed},
q{\'\/\'\ does\ not\ take\ a\ repeat\ count},
q{Don\'t\ know\ how\ to\ handle\ magic\ of\ type\ \'.+?\'},
q{do_study\:\ out\ of\ memory},
q{\(Do\ you\ need\ to\ predeclare\ .+?\?\)},
q{dump\(\)\ better\ written\ as\ CORE\:\:dump\(\)},
q{Duplicate\ free\(\)\ ignored},
q{Duplicate\ modifier\ \'.+?\'\ after\ \'.+?\'\ in\ .+?},
q{elseif\ should\ be\ elsif},
q{Empty\ .+?},
q{entering\ effective\ .+?\ failed},
q{\%ENV\ is\ aliased\ to\ .+?},
q{Error\ converting\ file\ specification\ .+?},
q{.+?\:\ Eval\-group\ in\ insecure\ regular\ expression},
q{.+?\:\ Eval\-group\ not\ allowed\ at\ run\ time},
q{.+?\:\ Eval\-group\ not\ allowed\,\ use\ re\ \'eval\'},
q{Excessively\ long\ \<\>\ operator},
q{exec\?\ I\'m\ not\ \*that\*\ kind\ of\ operating\ system},
q{Execution\ of\ .+?\ aborted\ due\ to\ compilation\ errors},
q{Exiting\ eval\ via\ .+?},
q{Exiting\ format\ via\ .+?},
q{Exiting\ pseudo\-block\ via\ .+?},
q{Exiting\ subroutine\ via\ .+?},
q{Exiting\ substitution\ via\ .+?},
q{Explicit\ blessing\ to\ \'\'\ \(assuming\ package\ main\)},
q{.+?\:\ Expression\ syntax},
q{.+?\ failed\-\-call\ queue\ aborted},
q{False\ \[\]\ range\ \".+?\"\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Fatal\ VMS\ error\ at\ .+?\,\ line\ .+?},
q{fcntl\ is\ not\ implemented},
q{Filehandle\ .+?\ opened\ only\ for\ input},
q{Filehandle\ .+?\ opened\ only\ for\ output},
q{Filehandle\ .+?\ reopened\ as\ .+?\ only\ for\ input},
q{Filehandle\ STDIN\ reopened\ as\ .+?\ only\ for\ output},
q{Final\ \$\ should\ be\ \\\$\ or\ \$name},
q{flock\(\)\ on\ closed\ filehandle\ .+?},
q{Format\ not\ terminated},
q{Format\ .+?\ redefined},
q{Found\ \=\ in\ conditional\,\ should\ be\ \=\=},
q{.+?\ found\ where\ operator\ expected},
q{gdbm\ store\ returned\ .+?\,\ errno\ .+?\,\ key\ \".+?\"},
q{gethostent\ not\ implemented},
q{get.+?\(\)\ on\ closed\ socket\ .+?},
q{getpwnam\ returned\ invalid\ UIC\ \%\#o\ for\ user\ \".+?\"},
q{getsockopt\(\)\ on\ closed\ socket\ .+?},
q{Global\ symbol\ \".+?\"\ requires\ explicit\ package\ name},
q{glob\ failed\ \(.+?\)},
q{Glob\ not\ terminated},
q{Got\ an\ error\ from\ DosAllocMem},
q{goto\ must\ have\ label},
q{\(\)\-group\ starts\ with\ a\ count},
q{.+?\ had\ compilation\ errors},
q{Had\ to\ create\ .+?\ unexpectedly},
q{Hash\ \%.+?\ missing\ the\ \%\ in\ argument\ .+?\ of\ .+?\(\)},
q{.+?\ has\ too\ many\ errors},
q{Hexadecimal\ number\ \>\ 0xffffffff\ non\-portable},
q{Identifier\ too\ long},
q{Illegal\ binary\ digit\ .+?},
q{Illegal\ binary\ digit\ .+?\ ignored},
q{Illegal\ character\ .+?\ \(carriage\ return\)},
q{Illegal\ character\ in\ prototype\ for\ .+?\ \:\ .+?},
q{Illegal\ declaration\ of\ anonymous\ subroutine},
q{Illegal\ declaration\ of\ subroutine\ .+?},
q{Illegal\ division\ by\ zero},
q{Illegal\ hexadecimal\ digit\ .+?\ ignored},
q{Illegal\ modulus\ zero},
q{Illegal\ number\ of\ bits\ in\ vec},
q{Illegal\ octal\ digit\ .+?},
q{Illegal\ octal\ digit\ .+?\ ignored},
q{Illegal\ switch\ in\ PERL5OPT\:\ .+?},
q{Ill\-formed\ CRTL\ environ\ value\ \".+?\"},
q{Ill\-formed\ message\ in\ prime_env_iter\:\ \|.+?\|},
q{\(in\ cleanup\)\ .+?},
q{In\ EBCDIC\ the\ v\-string\ components\ cannot\ exceed\ 2147483647},
q{Insecure\ dependency\ in\ .+?},
q{Insecure\ directory\ in\ .+?},
q{Insecure\ \$ENV\{.+?\}\ while\ running\ .+?},
q{Integer\ overflow\ in\ .+?\ number},
q{Internal\ disaster\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Internal\ inconsistency\ in\ tracking\ vforks},
q{Internal\ urp\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{.+?\ \(\.\.\.\)\ interpreted\ as\ function},
q{Invalid\ .+?\ attribute\:\ .+?},
q{Invalid\ .+?\ attributes\:\ .+?},
q{Invalid\ conversion\ in\ .+?\:\ \".+?\"},
q{Invalid\ \[\]\ range\ \".+?\"\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Invalid\ range\ \".+?\"\ in\ transliteration\ operator},
q{Invalid\ separator\ character\ .+?\ in\ attribute\ list},
q{Invalid\ separator\ character\ .+?\ in\ PerlIO\ layer\ specification\ .+?},
q{Invalid\ type\ \'.+?\'\ in\ .+?},
q{ioctl\ is\ not\ implemented},
q{ioctl\(\)\ on\ unopened\ .+?},
q{IO\ layers\ \(like\ \".+?\"\)\ unavailable},
q{IO\:\:Socket\:\:atmark\ not\ implemented\ on\ this\ architecture},
q{\`.+?\'\ is\ not\ a\ code\ reference},
q{\`.+?\'\ is\ not\ an\ overloadable\ type},
q{junk\ on\ end\ of\ regexp},
q{Label\ not\ found\ for\ \"last\ .+?\"},
q{Label\ not\ found\ for\ \"next\ .+?\"},
q{Label\ not\ found\ for\ \"redo\ .+?\"},
q{leaving\ effective\ .+?\ failed},
q{length\/code\ after\ end\ of\ string\ in\ unpack},
q{listen\(\)\ on\ closed\ socket\ .+?},
q{Lookbehind\ longer\ than\ .+?\ not\ implemented\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{lstat\(\)\ on\ filehandle\ .+?},
q{Lvalue\ subs\ returning\ .+?\ not\ implemented\ yet},
q{Malformed\ integer\ in\ \[\]\ in\ \ pack},
q{Malformed\ integer\ in\ \[\]\ in\ unpack},
q{Malformed\ PERLLIB_PREFIX},
q{Malformed\ prototype\ for\ .+?\:\ .+?},
q{Malformed\ UTF\-8\ character\ \(.+?\)},
q{Malformed\ UTF\-16\ surrogate},
q{.+?\ matches\ null\ string\ many\ times\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{\".+?\"\ may\ clash\ with\ future\ reserved\ word},
q{\%\ may\ not\ be\ used\ in\ pack},
q{Method\ for\ operation\ .+?\ not\ found\ in\ package\ .+?\ during\ blessing},
q{Method\ .+?\ not\ permitted},
q{Might\ be\ a\ runaway\ multi\-line\ .+?\ string\ starting\ on\ line\ .+?},
q{Misplaced\ _\ in\ number},
q{Missing\ argument\ to\ \-.+?},
q{Missing\ .+?.+?\ on\ \\N\{\}},
q{Missing\ comma\ after\ first\ argument\ to\ .+?\ function},
q{Missing\ command\ in\ piped\ open},
q{Missing\ control\ char\ name\ in\ \\c},
q{Missing\ name\ in\ \"my\ sub\"},
q{Missing\ \$\ on\ loop\ variable},
q{\(Missing\ operator\ before\ .+?\?\)},
q{Missing\ right\ brace\ on\ .+?},
q{Missing\ right\ curly\ or\ square\ bracket},
q{\(Missing\ semicolon\ on\ previous\ line\?\)},
q{Modification\ of\ a\ read\-only\ value\ attempted},
q{Modification\ of\ non\-creatable\ array\ value\ attempted\,\ .+?},
q{Modification\ of\ non\-creatable\ hash\ value\ attempted\,\ .+?},
q{Module\ name\ must\ be\ constant},
q{Module\ name\ required\ with\ \-.+?\ option},
q{More\ than\ one\ argument\ to\ open},
q{msg.+?\ not\ implemented},
q{Multidimensional\ syntax\ .+?\ not\ supported},
q{\'\/\'\ must\ be\ followed\ by\ \'a\*\'\,\ \'A\*\'\ or\ \'Z\*\'},
q{\'\/\'\ must\ follow\ a\ numeric\ type\ in\ unpack},
q{\"my\ sub\"\ not\ yet\ implemented},
q{\"my\"\ variable\ .+?\ can\'t\ be\ in\ a\ package},
q{Name\ \".+?\:\:.+?\"\ used\ only\ once\:\ possible\ typo},
q{Negative\ \'\/\'\ count\ in\ unpack},
q{Negative\ length},
q{Negative\ offset\ to\ vec\ in\ lvalue\ context},
q{Nested\ quantifiers\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{.+?\ never\ introduced},
q{Newline\ in\ left\-justified\ string\ for\ .+?},
q{No\ .+?\ allowed\ while\ running\ setuid},
q{No\ comma\ allowed\ after\ .+?},
q{No\ command\ into\ which\ to\ pipe\ on\ command\ line},
q{No\ DB\:\:DB\ routine\ defined},
q{No\ dbm\ on\ this\ machine},
q{No\ DB\:\:sub\ routine\ defined},
q{No\ B\<\-e\>\ allowed\ in\ setuid\ scripts},
q{No\ error\ file\ after\ 2\>\ or\ 2\>\>\ on\ command\ line},
q{No\ group\ ending\ character\ \'.+?\'\ found\ in\ template},
q{No\ input\ file\ after\ \<\ on\ command\ line},
q{No\ \#\!\ line},
q{\"no\"\ not\ allowed\ in\ expression},
q{No\ output\ file\ after\ \>\ on\ command\ line},
q{No\ output\ file\ after\ \>\ or\ \>\>\ on\ command\ line},
q{No\ package\ name\ allowed\ for\ variable\ .+?\ in\ \"our\"},
q{No\ Perl\ script\ found\ in\ input},
q{No\ setregid\ available},
q{No\ setreuid\ available},
q{No\ .+?\ specified\ for\ \-.+?},
q{No\ such\ class\ .+?},
q{No\ such\ pipe\ open},
q{No\ such\ pseudo\-hash\ field\ \".+?\"},
q{No\ such\ pseudo\-hash\ field\ \".+?\"\ in\ variable\ .+?\ of\ type\ .+?},
q{No\ such\ signal\:\ SIG.+?},
q{Not\ a\ CODE\ reference},
q{Not\ a\ format\ reference},
q{Not\ a\ GLOB\ reference},
q{Not\ a\ HASH\ reference},
q{Not\ an\ ARRAY\ reference},
q{Not\ a\ perl\ script},
q{Not\ a\ SCALAR\ reference},
q{Not\ a\ subroutine\ reference},
q{Not\ a\ subroutine\ reference\ in\ overload\ table},
q{Not\ enough\ arguments\ for\ .+?},
q{Not\ enough\ format\ arguments},
q{.+?\:\ not\ found},
q{no\ UTC\ offset\ information\;\ assuming\ local\ time\ is\ UTC},
q{Non\-string\ passed\ as\ bitmask},
q{Null\ filename\ used},
q{NULL\ OP\ IN\ RUN},
q{Null\ picture\ in\ formline},
q{Null\ realloc},
q{NULL\ regexp\ argument},
q{NULL\ regexp\ parameter},
q{Number\ too\ long},
q{Octal\ number\ in\ vector\ unsupported},
q{Octal\ number\ \>\ 037777777777\ non\-portable},
q{Odd\ number\ of\ arguments\ for\ overload\:\:constant},
q{Odd\ number\ of\ elements\ in\ anonymous\ hash},
q{Odd\ number\ of\ elements\ in\ hash\ assignment},
q{Offset\ outside\ string},
q{.+?\(\)\ on\ unopened\ .+?},
q{\-.+?\ on\ unopened\ filehandle\ .+?},
q{oops\:\ oopsAV},
q{oops\:\ oopsHV},
q{Operation\ \".+?\"\:\ no\ method\ found\,\ .+?},
q{Operator\ or\ semicolon\ missing\ before\ .+?},
q{\"our\"\ variable\ .+?\ redeclared},
q{Out\ of\ memory\!},
q{Out\ of\ memory\ during\ .+?\ extend},
q{Out\ of\ memory\ during\ \"large\"\ request\ for\ .+?},
q{Out\ of\ memory\ during\ request\ for\ .+?},
q{Out\ of\ memory\ during\ ridiculously\ large\ request},
q{Out\ of\ memory\ for\ yacc\ stack},
q{\'\@\'\ outside\ of\ string\ in\ unpack},
q{.+?\ package\ attribute\ may\ clash\ with\ future\ reserved\ word\:\ .+?},
q{pack\/unpack\ repeat\ count\ overflow},
q{page\ overflow},
q{panic\:\ .+?},
q{panic\:\ ck_grep},
q{panic\:\ ck_split},
q{panic\:\ corrupt\ saved\ stack\ index},
q{panic\:\ del_backref},
q{panic\:\ Devel\:\:DProf\ inconsistent\ subroutine\ return},
q{panic\:\ die\ .+?},
q{panic\:\ do_subst},
q{panic\:\ do_trans_.+?},
q{panic\:\ frexp},
q{panic\:\ goto},
q{panic\:\ INTERPCASEMOD},
q{panic\:\ INTERPCONCAT},
q{panic\:\ kid\ popen\ errno\ read},
q{panic\:\ last},
q{panic\:\ leave_scope\ clearsv},
q{panic\:\ leave_scope\ inconsistency},
q{panic\:\ magic_killbackrefs},
q{panic\:\ malloc},
q{panic\:\ mapstart},
q{panic\:\ memory\ wrap},
q{panic\:\ null\ array},
q{panic\:\ pad_alloc},
q{panic\:\ pad_free\ curpad},
q{panic\:\ pad_free\ po},
q{panic\:\ pad_reset\ curpad},
q{panic\:\ pad_sv\ po},
q{panic\:\ pad_swipe\ curpad},
q{panic\:\ pad_swipe\ po},
q{panic\:\ pp_iter},
q{panic\:\ pp_match.+?},
q{panic\:\ pp_split},
q{panic\:\ realloc},
q{panic\:\ restartop},
q{panic\:\ return},
q{panic\:\ scan_num},
q{panic\:\ sv_insert},
q{panic\:\ top_env},
q{panic\:\ utf16_to_utf8\:\ odd\ bytelen},
q{panic\:\ yylex},
q{Parentheses\ missing\ around\ \".+?\"\ list},
q{C\<\-p\>\ destination\:\ .+?},
q{\(perhaps\ you\ forgot\ to\ load\ \".+?\"\?\)},
q{Perl\ .+?\ required\-\-this\ is\ only\ version\ .+?\,\ stopped},
q{PERL_SH_DIR\ too\ long},
q{PERL_SIGNALS\ illegal\:\ \".+?\"},
q{perl\:\ warning\:\ Setting\ locale\ failed\.},
q{Permission\ denied},
q{pid\ .+?\ not\ a\ child},
q{\'P\'\ must\ have\ an\ explicit\ size\ in\ unpack},
q{B\<\-P\>\ not\ allowed\ for\ setuid\/setgid\ script},
q{POSIX\ class\ \[\:.+?\:\]\ unknown\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{POSIX\ getpgrp\ can\'t\ take\ an\ argument},
q{POSIX\ syntax\ \[.+?\]\ belongs\ inside\ character\ classes\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{POSIX\ syntax\ \[\.\ \.\]\ is\ reserved\ for\ future\ extensions\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{POSIX\ syntax\ \[\=\ \=\]\ is\ reserved\ for\ future\ extensions\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Possible\ attempt\ to\ put\ comments\ in\ qw\(\)\ list},
q{Possible\ attempt\ to\ separate\ words\ with\ commas},
q{Possible\ memory\ corruption\:\ .+?\ overflowed\ 3rd\ argument},
q{Possible\ precedence\ problem\ on\ bitwise\ .+?\ operator},
q{Possible\ unintended\ interpolation\ of\ .+?\ in\ string},
q{Possible\ Y2K\ bug\:\ .+?},
q{pragma\ \"attrs\"\ is\ deprecated\,\ use\ \"sub\ NAME\ \:\ ATTRS\"\ instead},
q{Precedence\ problem\:\ open\ .+?\ should\ be\ open\(.+?\)},
q{Premature\ end\ of\ script\ headers},
q{printf\(\)\ on\ closed\ filehandle\ .+?},
q{print\(\)\ on\ closed\ filehandle\ .+?},
q{Process\ terminated\ by\ SIG.+?},
q{Prototype\ mismatch\:\ .+?\ vs\ .+?},
q{Prototype\ not\ terminated},
q{Pseudo\-hashes\ are\ deprecated},
q{Quantifier\ follows\ nothing\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Quantifier\ in\ \{\,\}\ bigger\ than\ .+?\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Quantifier\ unexpected\ on\ zero\-length\ expression\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Range\ iterator\ outside\ integer\ range},
q{readline\(\)\ on\ closed\ filehandle\ .+?},
q{read\(\)\ on\ closed\ filehandle\ .+?},
q{read\(\)\ on\ unopened\ filehandle\ .+?},
q{Reallocation\ too\ large\:\ .+?},
q{realloc\(\)\ of\ freed\ memory\ ignored},
q{Recompile\ perl\ with\ B\<\-D\>DEBUGGING\ to\ use\ B\<\-D\>\ switch},
q{Recursive\ inheritance\ detected\ in\ package\ \'.+?\'},
q{Recursive\ inheritance\ detected\ while\ looking\ for\ method\ .+?},
q{Reference\ found\ where\ even\-sized\ list\ expected},
q{Reference\ is\ already\ weak},
q{Reference\ miscount\ in\ sv_replace\(\)},
q{Reference\ to\ nonexistent\ group\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{regexp\ memory\ corruption},
q{Regexp\ out\ of\ space},
q{Repeated\ format\ line\ will\ never\ terminate\ \(\~\~\ and\ \@\#\ incompatible\)},
q{Reversed\ .+?\=\ operator},
q{Runaway\ format},
q{Scalars\ leaked\:\ .+?},
q{Scalar\ value\ \@.+?\[.+?\]\ better\ written\ as\ \$.+?\[.+?\]},
q{Scalar\ value\ \@.+?\{.+?\}\ better\ written\ as\ \$.+?\{.+?\}},
q{Script\ is\ not\ setuid\/setgid\ in\ suidperl},
q{Search\ pattern\ not\ terminated},
q{Search\ pattern\ not\ terminated\ or\ ternary\ operator\ parsed\ as\ search\ pattern},
q{.+?\(\)\ on\ unopened\ filehandle},
q{select\ not\ implemented},
q{Self\-ties\ of\ arrays\ and\ hashes\ are\ not\ supported},
q{Semicolon\ seems\ to\ be\ missing},
q{semi\-panic\:\ attempt\ to\ dup\ freed\ string},
q{sem.+?\ not\ implemented},
q{send\(\)\ on\ closed\ socket\ .+?},
q{Sequence\ \(\?\ incomplete\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Sequence\ \(\?.+?\.\.\.\)\ not\ implemented\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Sequence\ \(\?.+?\.\.\.\)\ not\ recognized\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Sequence\ \(\?\#\.\.\.\ not\ terminated\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Sequence\ \(\?\{\.\.\.\}\)\ not\ terminated\ or\ not\ \{\}\-balanced\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{500\ Server\ error},
q{Server\ error},
q{setegid\(\)\ not\ implemented},
q{seteuid\(\)\ not\ implemented},
q{setpgrp\ can\'t\ take\ arguments},
q{setrgid\(\)\ not\ implemented},
q{setruid\(\)\ not\ implemented},
q{setsockopt\(\)\ on\ closed\ socket\ .+?},
q{Setuid\/gid\ script\ is\ writable\ by\ world},
q{Setuid\ script\ not\ plain\ file},
q{shm.+?\ not\ implemented},
q{\<\>\ should\ be\ quotes},
q{\/.+?\/\ should\ probably\ be\ written\ as\ \".+?\"},
q{shutdown\(\)\ on\ closed\ socket\ .+?},
q{SIG.+?\ handler\ \".+?\"\ not\ defined},
q{sort\ is\ now\ a\ reserved\ word},
q{Sort\ subroutine\ didn\'t\ return\ a\ numeric\ value},
q{Sort\ subroutine\ didn\'t\ return\ single\ value},
q{splice\(\)\ offset\ past\ end\ of\ array},
q{Split\ loop},
q{Statement\ unlikely\ to\ be\ reached},
q{stat\(\)\ on\ unopened\ filehandle\ .+?},
q{Stub\ found\ while\ resolving\ method\ \".+?\"\ overloading\ \".+?\"},
q{Subroutine\ .+?\ redefined},
q{Substitution\ loop},
q{Substitution\ pattern\ not\ terminated},
q{Substitution\ replacement\ not\ terminated},
q{substr\ outside\ of\ string},
q{suidperl\ is\ no\ longer\ needed\ since\ .+?},
q{Switch\ \(\?\(condition\)\.\.\.\ contains\ too\ many\ branches\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Switch\ condition\ not\ recognized\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{switching\ effective\ .+?\ is\ not\ implemented},
q{.+?\ syntax},
q{syntax\ error},
q{syntax\ error\ at\ line\ .+?\:\ \`.+?\'\ unexpected},
q{syntax\ error\ in\ file\ .+?\ at\ line\ .+?\,\ next\ 2\ tokens\ \".+?\"},
q{sysread\(\)\ on\ closed\ filehandle\ .+?},
q{sysread\(\)\ on\ unopened\ filehandle\ .+?},
q{System\ V\ .+?\ is\ not\ implemented\ on\ this\ machine},
q{syswrite\(\)\ on\ closed\ filehandle\ .+?},
q{C\<\-T\>\ and\ C\<\-B\>\ not\ implemented\ on\ filehandles},
q{Target\ of\ goto\ is\ too\ deeply\ nested},
q{tell\(\)\ on\ unopened\ filehandle},
q{That\ use\ of\ \$\[\ is\ unsupported},
q{The\ crypt\(\)\ function\ is\ unimplemented\ due\ to\ excessive\ paranoia},
q{The\ .+?\ function\ is\ unimplemented},
q{The\ stat\ preceding\ .+?\ wasn\'t\ an\ lstat},
q{The\ \'unique\'\ attribute\ may\ only\ be\ applied\ to\ \'our\'\ variables},
q{This\ Perl\ can\'t\ reset\ CRTL\ environ\ elements\ \(.+?\)},
q{This\ Perl\ can\'t\ set\ CRTL\ environ\ elements\ \(.+?\=.+?\)},
q{thread\ failed\ to\ start\:\ .+?},
q{5\.005\ threads\ are\ deprecated},
q{times\ not\ implemented},
q{\"\-T\"\ is\ on\ the\ \#\!\ line\,\ it\ must\ also\ be\ used\ on\ the\ command\ line},
q{To.+?\:\ illegal\ mapping\ \'.+?\'},
q{Too\ deeply\ nested\ \(\)\-groups},
q{Too\ few\ args\ to\ syscall},
q{Too\ late\ for\ \"\-.+?\"\ option},
q{Too\ late\ to\ run\ .+?\ block},
q{Too\ many\ args\ to\ syscall},
q{Too\ many\ arguments\ for\ .+?},
q{Too\ many\ \)\'s},
q{Too\ many\ \(\'s},
q{Trailing\ \\\ in\ regex\ m\/.+?\/},
q{Transliteration\ pattern\ not\ terminated},
q{Transliteration\ replacement\ not\ terminated},
q{\'.+?\'\ trapped\ by\ operation\ mask},
q{truncate\ not\ implemented},
q{Type\ of\ arg\ .+?\ to\ .+?\ must\ be\ .+?\ \(not\ .+?\)},
q{umask\ not\ implemented},
q{Unable\ to\ create\ sub\ named\ \".+?\"},
q{Unbalanced\ context\:\ .+?\ more\ PUSHes\ than\ POPs},
q{Unbalanced\ saves\:\ .+?\ more\ saves\ than\ restores},
q{Unbalanced\ scopes\:\ .+?\ more\ ENTERs\ than\ LEAVEs},
q{Unbalanced\ tmps\:\ .+?\ more\ allocs\ than\ frees},
q{Undefined\ format\ \".+?\"\ called},
q{Undefined\ sort\ subroutine\ \".+?\"\ called},
q{Undefined\ subroutine\ \&.+?\ called},
q{Undefined\ subroutine\ called},
q{Undefined\ subroutine\ in\ sort},
q{Undefined\ top\ format\ \".+?\"\ called},
q{Undefined\ value\ assigned\ to\ typeglob},
q{.+?\:\ Undefined\ variable},
q{unexec\ of\ .+?\ into\ .+?\ failed\!},
q{Unicode\ character\ .+?\ is\ illegal},
q{Unknown\ BYTEORDER},
q{Unknown\ open\(\)\ mode\ \'.+?\'},
q{Unknown\ PerlIO\ layer\ \".+?\"},
q{Unknown\ process\ .+?\ sent\ message\ to\ prime_env_iter\:\ .+?},
q{Unknown\ \"re\"\ subpragma\ \'.+?\'\ \(known\ ones\ are\:\ .+?\)},
q{Unknown\ switch\ condition\ \(\?\(\%\.2s\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unknown\ Unicode\ option\ letter\ \'.+?\'},
q{Unknown\ Unicode\ option\ value\ .+?},
q{Unknown\ warnings\ category\ \'.+?\'},
q{unmatched\ \[\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{unmatched\ \(\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unmatched\ right\ .+?\ bracket},
q{Unquoted\ string\ \".+?\"\ may\ clash\ with\ future\ reserved\ word},
q{Unrecognized\ character\ .+?},
q{\/.+?\/\:\ Unrecognized\ escape\ \\\\.+?\ in\ character\ class\ passed\ through},
q{Unrecognized\ escape\ \\\\.+?\ passed\ through},
q{Unrecognized\ escape\ \\\\.+?\ passed\ through\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unrecognized\ signal\ name\ \".+?\"},
q{Unrecognized\ switch\:\ \-.+?\ \ \(\-h\ will\ show\ valid\ options\)},
q{Unsuccessful\ .+?\ on\ filename\ containing\ newline},
q{Unsupported\ directory\ function\ \".+?\"\ called},
q{Unsupported\ function\ .+?},
q{Unsupported\ function\ fork},
q{Unsupported\ script\ encoding\ .+?},
q{Unsupported\ socket\ function\ \".+?\"\ called},
q{Unterminated\ attribute\ list},
q{Unterminated\ attribute\ parameter\ in\ attribute\ list},
q{Unterminated\ compressed\ integer},
q{Unterminated\ \<\>\ operator},
q{untie\ attempted\ while\ .+?\ inner\ references\ still\ exist},
q{Usage\:\ POSIX\:\:.+?\(.+?\)},
q{Usage\:\ Win32\:\:.+?\(.+?\)},
q{Useless\ \(\?\-.+?\)\ \-\ don\'t\ use\ \/.+?\ modifier\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Useless\ \(\?.+?\)\ \-\ use\ \/.+?\ modifier\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Useless\ use\ of\ .+?\ in\ void\ context},
q{Useless\ use\ of\ \"re\"\ pragma},
q{Useless\ use\ of\ sort\ in\ scalar\ context},
q{Useless\ use\ of\ .+?\ with\ no\ values},
q{\"use\"\ not\ allowed\ in\ expression},
q{Use\ of\ bare\ \<\<\ to\ mean\ \<\<\"\"\ is\ deprecated},
q{Use\ of\ chdir\(\'\'\)\ or\ chdir\(undef\)\ as\ chdir\(\)\ deprecated},
q{Use\ of\ \/c\ modifier\ is\ meaningless\ in\ s\/\/\/},
q{Use\ of\ \/c\ modifier\ is\ meaningless\ without\ \/g},
q{Use\ of\ freed\ value\ in\ iteration},
q{Use\ of\ \*glob\{FILEHANDLE\}\ is\ deprecated},
q{Use\ of\ \/g\ modifier\ is\ meaningless\ in\ split},
q{Use\ of\ implicit\ split\ to\ \@_\ is\ deprecated},
q{Use\ of\ inherited\ AUTOLOAD\ for\ non\-method\ .+?\(\)\ is\ deprecated},
q{Use\ of\ .+?\ in\ printf\ format\ not\ supported},
q{Use\ of\ \$\*\ is\ deprecated},
q{Use\ of\ \$\#\ is\ deprecated},
q{Use\ of\ .+?\ is\ deprecated},
q{Use\ of\ \-l\ on\ filehandle\ .+?},
q{Use\ of\ \"package\"\ with\ no\ arguments\ is\ deprecated},
q{Use\ of\ reference\ \".+?\"\ as\ array\ index},
q{Use\ of\ reserved\ word\ \".+?\"\ is\ deprecated},
q{Use\ of\ tainted\ arguments\ in\ .+?\ is\ deprecated},
q{Use\ of\ uninitialized\ value.+?},
q{Using\ a\ hash\ as\ a\ reference\ is\ deprecated},
q{Using\ an\ array\ as\ a\ reference\ is\ deprecated},
q{UTF\-16\ surrogate\ .+?},
q{Value\ of\ .+?\ can\ be\ \"0\"\;\ test\ with\ defined\(\)},
q{Value\ of\ CLI\ symbol\ \".+?\"\ too\ long},
q{Variable\ \".+?\"\ is\ not\ imported.+?},
q{Variable\ length\ lookbehind\ not\ implemented\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{\".+?\"\ variable\ .+?\ masks\ earlier\ declaration\ in\ same\ .+?},
q{Variable\ \".+?\"\ may\ be\ unavailable},
q{Variable\ syntax},
q{Variable\ \".+?\"\ will\ not\ stay\ shared},
q{Version\ number\ must\ be\ a\ constant\ number},
q{Warning\:\ something\'s\ wrong},
q{Warning\:\ unable\ to\ close\ filehandle\ .+?\ properly},
q{Warning\:\ Use\ of\ \".+?\"\ without\ parentheses\ is\ ambiguous},
q{Wide\ character\ in\ .+?},
q{Within\ \[\]\-length\ \'.+?\'\ not\ allowed},
q{write\(\)\ on\ closed\ filehandle\ .+?},
q{.+?\ \"\\x.+?\"\ does\ not\ map\ to\ Unicode},
q{\'X\'\ outside\ of\ string},
q{\'x\'\ outside\ of\ string\ in\ unpack},
q{YOU\ HAVEN\'T\ DISABLED\ SET\-ID\ SCRIPTS\ IN\ THE\ KERNEL\ YET\!},
q{You\ need\ to\ quote\ \".+?\"},
q{Your\ random\ numbers\ are\ not\ that\ random},
];

my $ra = Regexp::Assemble->new;
$ra->add($_) for @$lines;

sub is_warning {
  my $string = shift || return;
  return $string =~ $ra->re;
}

'Danger! Danger! High Voltage!';
__END__

=head1 NAME

String::Perl::Warnings - Determine if a string looks like a perl warning

=head1 SYNOPSIS

  use String::Perl::Warnings qw(is_warning);

  while( <> ) {
    chomp;
    next unless is_warning($_);
    # Looks like a warning
  }

=head1 DESCRIPTION

String::Perl::Warnings can be used to determine if a string of arbitary text appears to look
like a warning generated by perl.

It has one function C<is_warning>.

=head1 FUNCTIONS

=over

=item C<is_warning>

Takes an arbitary string of text and returns a true value if the string looks like a perl warning,
a false value otherwise.

=back

=head1 AUTHOR

Chris C<BinGOs> Williams

=head1 LICENSE

Copyright E<copy> Chris Williams

This module may be used, modified, and distributed under the same terms as Perl itself. Please see the license that came with your Perl distribution for details.

=head1 SEE ALSO

L<http://p3rl.org/perldiag>

