/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Text;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.SelectorSpecificity;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCanvasElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.StringUtils;
import org.w3c.css.sac.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputedCSSStyleDeclaration
extends CSSStyleDeclaration {
    private static final int PIXELS_PER_CHAR = 10;
    private static final Set<String> INHERITABLE_ATTRIBUTES = new HashSet<String>(Arrays.asList("azimuth", "border-collapse", "border-spacing", "caption-side", "color", "cursor", "direction", "elevation", "empty-cells", "font-family", "font-size", "font-style", "font-variant", "font-weight", "font", "letter-spacing", "line-height", "list-style-image", "list-style-position", "list-style-type", "list-style", "orphans", "pitch-range", "pitch", "quotes", "richness", "speak-header", "speak-numeral", "speak-punctuation", "speak", "speech-rate", "stress", "text-align", "text-indent", "text-transform", "visibility", "voice-fFamily", "volume", "white-space", "widows", "word-spacing"));
    private final SortedMap<String, CSSStyleDeclaration.StyleElement> localModifications_ = new TreeMap<String, CSSStyleDeclaration.StyleElement>();
    private Map<String, String> defaultDisplays_;
    private Integer width_;
    private Integer height_;
    private Integer height2_;
    private Integer paddingHorizontal_;
    private Integer paddingVertical_;
    private Integer borderHorizontal_;
    private Integer borderVertical_;
    private Integer top_;

    public ComputedCSSStyleDeclaration() {
    }

    public ComputedCSSStyleDeclaration(CSSStyleDeclaration style) {
        super(style.getElement());
        this.getElement().setDefaults(this);
    }

    @Override
    protected String getStyleAttribute(String name, Map<String, CSSStyleDeclaration.StyleElement> styleMap) {
        Element parent;
        String s = super.getStyleAttribute(name, null);
        if (s.length() == 0 && this.isInheritable(name) && (parent = this.getElement().getParentElement()) != null) {
            s = this.getWindow().jsxFunction_getComputedStyle(parent, null).getStyleAttribute(name, null);
        }
        return s;
    }

    private boolean isInheritable(String name) {
        return INHERITABLE_ATTRIBUTES.contains(name);
    }

    @Override
    protected void setStyleAttribute(String name, String newValue) {
    }

    public void applyStyleFromSelector(org.w3c.dom.css.CSSStyleDeclaration declaration, Selector selector) {
        SelectorSpecificity specificity = new SelectorSpecificity(selector);
        for (int k = 0; k < declaration.getLength(); ++k) {
            String name = declaration.item(k);
            String value = declaration.getPropertyValue(name);
            String priority = declaration.getPropertyPriority(name);
            this.applyLocalStyleAttribute(name, value, priority, specificity);
        }
    }

    private void applyLocalStyleAttribute(String name, String newValue, String priority, SelectorSpecificity specificity) {
        CSSStyleDeclaration.StyleElement existingElement;
        if (!"important".equals(priority) && (existingElement = (CSSStyleDeclaration.StyleElement)this.localModifications_.get(name)) != null) {
            if ("important".equals(existingElement.getPriority())) {
                return;
            }
            if (specificity.compareTo(existingElement.getSpecificity()) < 0) {
                return;
            }
        }
        CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(name, newValue, priority, specificity, this.getCurrentElementIndex());
        this.localModifications_.put(name, element);
    }

    public void setDefaultLocalStyleAttribute(String name, String newValue) {
        CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(name, newValue);
        this.localModifications_.put(name, element);
    }

    @Override
    protected Map<String, CSSStyleDeclaration.StyleElement> getStyleMap() {
        Map<String, CSSStyleDeclaration.StyleElement> styleMap = super.getStyleMap();
        if (this.localModifications_ != null) {
            for (CSSStyleDeclaration.StyleElement localStyleMod : this.localModifications_.values()) {
                CSSStyleDeclaration.StyleElement element;
                String key = localStyleMod.getName();
                CSSStyleDeclaration.StyleElement existent = styleMap.get(key);
                if (existent == null) {
                    element = new CSSStyleDeclaration.StyleElement(key, localStyleMod.getValue(), localStyleMod.getIndex());
                    styleMap.put(key, element);
                    continue;
                }
                if (!"important".equals(localStyleMod.getPriority())) continue;
                if ("important".equals(existent.getPriority())) {
                    if (existent.getSpecificity().compareTo(localStyleMod.getSpecificity()) >= 0) continue;
                    element = new CSSStyleDeclaration.StyleElement(key, localStyleMod.getValue(), localStyleMod.getIndex());
                    styleMap.put(key, element);
                    continue;
                }
                element = new CSSStyleDeclaration.StyleElement(key, localStyleMod.getValue(), localStyleMod.getIndex());
                styleMap.put(key, element);
            }
        }
        return styleMap;
    }

    @Override
    public String jsxGet_backgroundAttachment() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_backgroundAttachment(), (CharSequence)"scroll");
    }

    @Override
    public String jsxGet_backgroundColor() {
        String value = super.jsxGet_backgroundColor();
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = "transparent";
        } else if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_GET_BACKGROUND_COLOR_FOR_COMPUTED_STYLE_RETURNS_RGB)) {
            value = ComputedCSSStyleDeclaration.toRGBColor(value);
        }
        return value;
    }

    @Override
    public String jsxGet_backgroundImage() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_backgroundImage(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_backgroundPosition() {
        String bg = super.jsxGet_backgroundPosition();
        if (StringUtils.isNotBlank((CharSequence)bg)) {
            bg = StringUtils.replace((String)bg, (String)"left", (String)"0%");
            bg = StringUtils.replace((String)bg, (String)"right", (String)"100%");
            bg = StringUtils.replace((String)bg, (String)"center", (String)"50%");
            bg = StringUtils.replace((String)bg, (String)"top", (String)"0%");
            bg = StringUtils.replace((String)bg, (String)"bottom", (String)"100%");
        }
        return (String)StringUtils.defaultIfEmpty((CharSequence)bg, (CharSequence)"0% 0%");
    }

    @Override
    public String jsxGet_backgroundRepeat() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_backgroundRepeat(), (CharSequence)"repeat");
    }

    @Override
    public String jsxGet_borderBottomColor() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_borderBottomColor(), (CharSequence)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderBottomStyle() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_borderBottomStyle(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_borderBottomWidth() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_borderBottomWidth(), (CharSequence)"0px"));
    }

    @Override
    public String jsxGet_borderCollapse() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_borderCollapse(), (CharSequence)"separate");
    }

    @Override
    public String jsxGet_borderLeftColor() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_borderLeftColor(), (CharSequence)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderLeftStyle() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_borderLeftStyle(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_borderLeftWidth() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_borderLeftWidth(), (CharSequence)"0px"));
    }

    @Override
    public String jsxGet_borderRightColor() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_borderRightColor(), (CharSequence)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderRightStyle() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_borderRightStyle(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_borderRightWidth() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_borderRightWidth(), (CharSequence)"0px"));
    }

    @Override
    public String jsxGet_borderSpacing() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_borderSpacing(), (CharSequence)"0px 0px");
    }

    @Override
    public String jsxGet_borderTopColor() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_borderTopColor(), (CharSequence)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderTopStyle() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_borderTopStyle(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_borderTopWidth() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_borderTopWidth(), (CharSequence)"0px"));
    }

    @Override
    public String jsxGet_bottom() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_bottom(), (CharSequence)"auto");
    }

    @Override
    public String jsxGet_captionSide() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_captionSide(), (CharSequence)"top");
    }

    @Override
    public String jsxGet_clear() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_clear(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_clip() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_clip(), (CharSequence)"auto");
    }

    @Override
    public String jsxGet_content() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_content(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_color() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_color(), (CharSequence)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_counterIncrement() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_counterIncrement(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_counterReset() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_counterReset(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_cssFloat() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_cssFloat(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_cursor() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_cursor(), (CharSequence)"auto");
    }

    @Override
    public String jsxGet_direction() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_direction(), (CharSequence)"ltr");
    }

    @Override
    public String jsxGet_display() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_display(), (CharSequence)this.getDefaultStyleDisplay());
    }

    private String getDefaultStyleDisplay() {
        String defaultValue;
        if (this.defaultDisplays_ == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("A", "inline");
            map.put("CODE", "inline");
            map.put("SPAN", "inline");
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DISPLAY_DEFAULT)) {
                map.put("LI", "list-item");
                map.put("TABLE", "table");
                map.put("TBODY", "table-row-group");
                map.put("TD", "table-cell");
                map.put("TH", "table-cell");
                map.put("THEAD", "table-header-group");
                map.put("TR", "table-row");
            }
            this.defaultDisplays_ = Collections.unmodifiableMap(map);
        }
        if ((defaultValue = this.defaultDisplays_.get(this.getElement().jsxGet_tagName())) == null) {
            return "block";
        }
        return defaultValue;
    }

    @Override
    public String jsxGet_emptyCells() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_emptyCells(), (CharSequence)"-moz-show-background");
    }

    @Override
    public String jsxGet_fontFamily() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_fontFamily(), (CharSequence)"serif");
    }

    @Override
    public String jsxGet_fontSize() {
        Element parent;
        String value = super.jsxGet_fontSize();
        if (value.length() == 0 && (parent = this.getElement().getParentElement()) != null) {
            value = parent.jsxGet_currentStyle().jsxGet_fontSize();
        }
        if (value.length() == 0) {
            value = "16px";
        }
        return value;
    }

    @Override
    public String jsxGet_fontSizeAdjust() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_fontSizeAdjust(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_fontStretch() {
        String defaultStretch = "";
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_FONT_STRECH_DEFAULT_NORMAL)) {
            defaultStretch = "normal";
        }
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_fontStretch(), (CharSequence)defaultStretch);
    }

    @Override
    public String jsxGet_fontStyle() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_fontStyle(), (CharSequence)"normal");
    }

    @Override
    public String jsxGet_fontVariant() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_fontVariant(), (CharSequence)"normal");
    }

    @Override
    public String jsxGet_fontWeight() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_fontWeight(), (CharSequence)"400");
    }

    @Override
    public String jsxGet_height() {
        return this.pixelString(this.getElement(), new CSSStyleDeclaration.CssValue(605){

            public String get(ComputedCSSStyleDeclaration style) {
                return (String)StringUtils.defaultIfEmpty((CharSequence)style.getStyleAttribute("height", null), (CharSequence)"362px");
            }
        });
    }

    @Override
    public String jsxGet_imeMode() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_imeMode(), (CharSequence)"auto");
    }

    @Override
    public String jsxGet_left() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_left(), (CharSequence)"auto");
    }

    @Override
    public String jsxGet_letterSpacing() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_letterSpacing(), (CharSequence)"normal");
    }

    @Override
    public String jsxGet_lineHeight() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_lineHeight(), (CharSequence)"20px");
    }

    @Override
    public String jsxGet_listStyleImage() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_listStyleImage(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_listStylePosition() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_listStylePosition(), (CharSequence)"outside");
    }

    @Override
    public String jsxGet_listStyleType() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_listStyleType(), (CharSequence)"disc");
    }

    @Override
    public String jsxGet_marginBottom() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_marginBottom(), (CharSequence)"0px"));
    }

    @Override
    public String jsxGet_marginLeft() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_marginLeft(), (CharSequence)"0px"));
    }

    @Override
    public String jsxGet_marginRight() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_marginRight(), (CharSequence)"0px"));
    }

    @Override
    public String jsxGet_marginTop() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_marginTop(), (CharSequence)"0px"));
    }

    @Override
    public String jsxGet_markerOffset() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_markerOffset(), (CharSequence)"auto");
    }

    @Override
    public String jsxGet_maxHeight() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_maxHeight(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_maxWidth() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_maxWidth(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_minHeight() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_minHeight(), (CharSequence)"0px");
    }

    @Override
    public String jsxGet_minWidth() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_minWidth(), (CharSequence)"0px");
    }

    @Override
    public String jsxGet_MozAppearance() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozAppearance(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_MozBackgroundClip() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBackgroundClip(), (CharSequence)"border");
    }

    @Override
    public String jsxGet_MozBackgroundInlinePolicy() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBackgroundInlinePolicy(), (CharSequence)"continuous");
    }

    @Override
    public String jsxGet_MozBackgroundOrigin() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBackgroundOrigin(), (CharSequence)"padding");
    }

    @Override
    public String jsxGet_MozBackgroundSize() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBackgroundSize(), (CharSequence)"auto auto");
    }

    @Override
    public String jsxGet_MozBinding() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBinding(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_MozBorderBottomColors() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBorderBottomColors(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_MozBorderImage() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBorderImage(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_MozBorderLeftColors() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBorderLeftColors(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_MozBorderRadiusBottomleft() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBorderRadiusBottomleft(), (CharSequence)"0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusBottomright() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBorderRadiusBottomright(), (CharSequence)"0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusTopleft() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBorderRadiusTopleft(), (CharSequence)"0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusTopright() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBorderRadiusTopright(), (CharSequence)"0px");
    }

    @Override
    public String jsxGet_MozBorderRightColors() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBorderRightColors(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_MozBorderTopColors() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBorderTopColors(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_MozBoxAlign() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBoxAlign(), (CharSequence)"stretch");
    }

    @Override
    public String jsxGet_MozBoxDirection() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBoxDirection(), (CharSequence)"normal");
    }

    @Override
    public String jsxGet_MozBoxFlex() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBoxFlex(), (CharSequence)"0");
    }

    @Override
    public String jsxGet_MozBoxOrdinalGroup() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBoxOrdinalGroup(), (CharSequence)"1");
    }

    @Override
    public String jsxGet_MozBoxOrient() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBoxOrient(), (CharSequence)"horizontal");
    }

    @Override
    public String jsxGet_MozBoxShadow() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBoxShadow(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_MozBoxPack() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBoxPack(), (CharSequence)"start");
    }

    @Override
    public String jsxGet_MozBoxSizing() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozBoxSizing(), (CharSequence)"content-box");
    }

    @Override
    public String jsxGet_MozColumnCount() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozColumnCount(), (CharSequence)"auto");
    }

    @Override
    public String jsxGet_MozColumnGap() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozColumnGap(), (CharSequence)"16px");
    }

    @Override
    public String jsxGet_MozColumnRuleColor() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozColumnRuleColor(), (CharSequence)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_MozColumnRuleStyle() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozColumnRuleStyle(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_MozColumnRuleWidth() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozColumnRuleWidth(), (CharSequence)"0px");
    }

    @Override
    public String jsxGet_MozColumnWidth() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozColumnWidth(), (CharSequence)"auto");
    }

    @Override
    public String jsxGet_MozFloatEdge() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozFloatEdge(), (CharSequence)"content-box");
    }

    @Override
    public String jsxGet_MozForceBrokenImageIcon() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozForceBrokenImageIcon(), (CharSequence)"0");
    }

    @Override
    public String jsxGet_MozImageRegion() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozImageRegion(), (CharSequence)"auto");
    }

    @Override
    public String jsxGet_MozOpacity() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozOpacity(), (CharSequence)"1");
    }

    @Override
    public String jsxGet_MozOutlineColor() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozOutlineColor(), (CharSequence)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_MozOutlineOffset() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozOutlineOffset(), (CharSequence)"0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusBottomleft() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozOutlineRadiusBottomleft(), (CharSequence)"0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusBottomright() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozOutlineRadiusBottomright(), (CharSequence)"0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusTopleft() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozOutlineRadiusTopleft(), (CharSequence)"0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusTopright() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozOutlineRadiusTopright(), (CharSequence)"0px");
    }

    @Override
    public String jsxGet_MozOutlineStyle() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozOutlineStyle(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_MozOutlineWidth() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozOutlineWidth(), (CharSequence)"0px");
    }

    @Override
    public String jsxGet_MozStackSizing() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozStackSizing(), (CharSequence)"stretch-to-fit");
    }

    @Override
    public String jsxGet_MozTransform() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozTransform(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_MozTransformOrigin() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozTransformOrigin(), (CharSequence)"50% 50%");
    }

    @Override
    public String jsxGet_MozUserFocus() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozUserFocus(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_MozUserInput() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozUserInput(), (CharSequence)"auto");
    }

    @Override
    public String jsxGet_MozUserModify() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozUserModify(), (CharSequence)"read-only");
    }

    @Override
    public String jsxGet_MozUserSelect() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozUserSelect(), (CharSequence)"auto");
    }

    @Override
    public String jsxGet_MozWindowShadow() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_MozWindowShadow(), (CharSequence)"default");
    }

    @Override
    public String jsxGet_opacity() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_opacity(), (CharSequence)"1");
    }

    @Override
    public String jsxGet_outlineColor() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_outlineColor(), (CharSequence)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_outlineOffset() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_outlineOffset(), (CharSequence)"0px");
    }

    @Override
    public String jsxGet_outlineStyle() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_outlineStyle(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_outlineWidth() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_outlineWidth(), (CharSequence)"0px");
    }

    @Override
    public String jsxGet_overflow() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_overflow(), (CharSequence)"visible");
    }

    @Override
    public String jsxGet_overflowX() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_overflowX(), (CharSequence)"visible");
    }

    @Override
    public String jsxGet_overflowY() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_overflowY(), (CharSequence)"visible");
    }

    @Override
    public String jsxGet_pageBreakAfter() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_pageBreakAfter(), (CharSequence)"auto");
    }

    @Override
    public String jsxGet_pageBreakBefore() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_pageBreakBefore(), (CharSequence)"auto");
    }

    @Override
    public String jsxGet_paddingBottom() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_paddingBottom(), (CharSequence)"0px"));
    }

    @Override
    public String jsxGet_paddingLeft() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_paddingLeft(), (CharSequence)"0px"));
    }

    @Override
    public String jsxGet_paddingRight() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_paddingRight(), (CharSequence)"0px"));
    }

    @Override
    public String jsxGet_paddingTop() {
        return this.pixelString((String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_paddingTop(), (CharSequence)"0px"));
    }

    @Override
    public String jsxGet_pointerEvents() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_pointerEvents(), (CharSequence)"auto");
    }

    @Override
    public String jsxGet_position() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_position(), (CharSequence)"static");
    }

    @Override
    public String jsxGet_right() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_right(), (CharSequence)"auto");
    }

    @Override
    public String jsxGet_tableLayout() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_tableLayout(), (CharSequence)"auto");
    }

    @Override
    public String jsxGet_textAlign() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_textAlign(), (CharSequence)"start");
    }

    @Override
    public String jsxGet_textDecoration() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_textDecoration(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_textIndent() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_textIndent(), (CharSequence)"0px");
    }

    @Override
    public String jsxGet_textShadow() {
        String shadow = "";
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_TEXT_SHADOW_DEFAULT_NONE)) {
            shadow = "none";
        }
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_textShadow(), (CharSequence)shadow);
    }

    @Override
    public String jsxGet_textTransform() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_textTransform(), (CharSequence)"none");
    }

    @Override
    public String jsxGet_top() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_top(), (CharSequence)"auto");
    }

    @Override
    public String jsxGet_unicodeBidi() {
        String unicodeBidi = "embed";
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_UNICODE_BIDI_DEFAULT_NORMAL)) {
            unicodeBidi = "normal";
        }
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_unicodeBidi(), (CharSequence)unicodeBidi);
    }

    @Override
    public String jsxGet_verticalAlign() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_verticalAlign(), (CharSequence)"baseline");
    }

    @Override
    public String jsxGet_visibility() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_visibility(), (CharSequence)"visible");
    }

    @Override
    public String jsxGet_whiteSpace() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_whiteSpace(), (CharSequence)"normal");
    }

    @Override
    public String jsxGet_width() {
        if ("none".equals(this.jsxGet_display())) {
            return "auto";
        }
        final String defaultWidth = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_WIDTH_AUTO) ? "auto" : "1256px";
        return this.pixelString(this.getElement(), new CSSStyleDeclaration.CssValue(1256){

            public String get(ComputedCSSStyleDeclaration style) {
                String value = style.getStyleAttribute("width", null);
                if (StringUtils.isEmpty((CharSequence)value)) {
                    Object domNode;
                    String content;
                    if (!ComputedCSSStyleDeclaration.this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_WIDTH_AUTO) && "absolute".equals(ComputedCSSStyleDeclaration.this.getStyleAttribute("position", null)) && null != (content = ((DomNode)(domNode = ComputedCSSStyleDeclaration.this.getDomNodeOrDie())).getTextContent()) && content.length() < 13) {
                        return content.length() * 7 + "px";
                    }
                    return defaultWidth;
                }
                return value;
            }
        });
    }

    public int getCalculatedWidth(boolean includeBorder, boolean includePadding) {
        int width = this.getCalculatedWidth();
        if (includeBorder) {
            width += this.getBorderHorizontal();
        }
        if (includePadding) {
            width += this.getPaddingHorizontal();
        }
        return width;
    }

    private int getCalculatedWidth() {
        int width;
        if (this.width_ != null) {
            return this.width_;
        }
        DomElement node = this.getElement().getDomNodeOrDie();
        if (!node.mayBeDisplayed()) {
            this.width_ = 0;
            return 0;
        }
        String display = this.jsxGet_display();
        if ("none".equals(display)) {
            this.width_ = 0;
            return 0;
        }
        String styleWidth = super.jsxGet_width();
        DomNode parent = node.getParentNode();
        if (StringUtils.isEmpty((CharSequence)styleWidth) && parent instanceof HtmlElement) {
            if (this.getElement() instanceof HTMLCanvasElement) {
                return 300;
            }
            String cssFloat = this.jsxGet_cssFloat();
            if ("right".equals(cssFloat) || "left".equals(cssFloat)) {
                width = ((DomNode)this.getDomNodeOrDie()).getTextContent().length() * 10;
            } else if ("block".equals(display)) {
                HTMLElement parentJS = (HTMLElement)parent.getScriptObject();
                String parentWidth = this.getWindow().jsxFunction_getComputedStyle(parentJS, null).jsxGet_width();
                width = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_WIDTH_AUTO) && "auto".equals(parentWidth) ? 1256 : ComputedCSSStyleDeclaration.pixelValue(parentJS, new CSSStyleDeclaration.CssValue(1256){

                    public String get(ComputedCSSStyleDeclaration style) {
                        return style.jsxGet_width();
                    }
                });
                width -= this.getBorderHorizontal() + this.getPaddingHorizontal();
            } else {
                width = this.getContentWidth();
            }
        } else {
            width = ComputedCSSStyleDeclaration.pixelValue(this.getElement(), new CSSStyleDeclaration.CssValue(1256){

                public String get(ComputedCSSStyleDeclaration style) {
                    return style.getStyleAttribute("width", null);
                }
            });
        }
        this.width_ = width;
        return width;
    }

    public int getContentWidth() {
        int width = 0;
        for (DomNode child : ((DomNode)this.getDomNodeOrDie()).getChildren()) {
            if (child.getScriptObject() instanceof HTMLElement) {
                HTMLElement e = (HTMLElement)child.getScriptObject();
                int w = e.jsxGet_currentStyle().getCalculatedWidth(true, true);
                width += w;
                continue;
            }
            if (!(child.getScriptObject() instanceof Text)) continue;
            width += child.getTextContent().length() * 10;
        }
        return width;
    }

    public int getCalculatedHeight(boolean includeBorder, boolean includePadding) {
        int height = this.getCalculatedHeight();
        if (includeBorder) {
            height += this.getBorderVertical();
        }
        if (includePadding) {
            height += this.getPaddingVertical();
        }
        return height;
    }

    private int getCalculatedHeight() {
        if (this.height_ != null) {
            return this.height_;
        }
        int elementHeight = this.getEmptyHeight();
        if (elementHeight == 0) {
            this.height_ = elementHeight;
            return elementHeight;
        }
        int contentHeight = this.getContentHeight();
        boolean useDefaultHeight = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_ELMENT_HEIGHT_MARKS_MIN);
        boolean explicitHeightSpecified = super.jsxGet_height().length() > 0;
        int height = contentHeight > 0 && (useDefaultHeight && contentHeight > elementHeight || !useDefaultHeight && !explicitHeightSpecified) ? contentHeight : elementHeight;
        this.height_ = height;
        return height;
    }

    private int getEmptyHeight() {
        if (this.height2_ != null) {
            return this.height2_;
        }
        DomElement node = this.getElement().getDomNodeOrDie();
        if (!node.mayBeDisplayed()) {
            this.height2_ = 0;
            return 0;
        }
        if ("none".equals(this.jsxGet_display())) {
            this.height2_ = 0;
            return 0;
        }
        if (this.getElement() instanceof HTMLBodyElement) {
            this.height2_ = 605;
            return 605;
        }
        boolean explicitHeightSpecified = super.jsxGet_height().length() > 0;
        int defaultHeight = 20;
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_ELMENT_HEIGHT_15)) {
            defaultHeight = 15;
        }
        int defaultValue = this.getElement() instanceof HTMLCanvasElement ? 150 : 605;
        int height = ComputedCSSStyleDeclaration.pixelValue(this.getElement(), new CSSStyleDeclaration.CssValue(defaultValue){

            public String get(ComputedCSSStyleDeclaration style) {
                return style.getStyleAttribute("height", null);
            }
        });
        boolean useDefaultHeight = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_ELMENT_HEIGHT_MARKS_MIN);
        if (height == 0 && !explicitHeightSpecified || useDefaultHeight && height < defaultHeight) {
            height = defaultHeight;
        }
        this.height2_ = height;
        return height;
    }

    public int getContentHeight() {
        DomElement node = this.getElement().getDomNodeOrDie();
        if (!node.mayBeDisplayed()) {
            return 0;
        }
        HTMLElement lastFlowing = null;
        HashSet<HTMLElement> independent = new HashSet<HTMLElement>();
        for (DomNode child : node.getChildren()) {
            if (!child.mayBeDisplayed() || !(child.getScriptObject() instanceof HTMLElement)) continue;
            HTMLElement e = (HTMLElement)child.getScriptObject();
            ComputedCSSStyleDeclaration style = e.jsxGet_currentStyle();
            String pos = style.getPositionWithInheritance();
            if ("static".equals(pos) || "relative".equals(pos)) {
                lastFlowing = e;
                continue;
            }
            if (!"absolute".equals(pos)) continue;
            independent.add(e);
        }
        HashSet<HTMLElement> relevant = new HashSet<HTMLElement>();
        relevant.addAll(independent);
        if (lastFlowing != null) {
            relevant.add(lastFlowing);
        }
        int max = 0;
        for (HTMLElement e : relevant) {
            ComputedCSSStyleDeclaration style = e.jsxGet_currentStyle();
            int h = style.getTop(true, false, false) + style.getCalculatedHeight(true, true);
            if (h <= max) continue;
            max = h;
        }
        return max;
    }

    public boolean isScrollable(boolean horizontal) {
        Element node = this.getElement();
        String overflow = this.jsxGet_overflow();
        boolean scrollable = horizontal ? (node instanceof HTMLBodyElement || "scroll".equals(overflow) || "auto".equals(overflow)) && this.getContentWidth() > this.getCalculatedWidth() : (node instanceof HTMLBodyElement || "scroll".equals(overflow) || "auto".equals(overflow)) && this.getContentHeight() > this.getEmptyHeight();
        return scrollable;
    }

    public int getTop(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        int top;
        if (null == this.top_) {
            String p = this.getPositionWithInheritance();
            String t = this.getTopWithInheritance();
            String b = this.getBottomWithInheritance();
            if ("absolute".equals(p) && !"auto".equals(t)) {
                top = ComputedCSSStyleDeclaration.pixelValue(t);
            } else if ("absolute".equals(p) && !"auto".equals(b)) {
                top = 0;
                for (DomNode child = this.getElement().getDomNodeOrDie().getParentNode().getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!(child instanceof HtmlElement) || !child.mayBeDisplayed()) continue;
                    top += 20;
                }
                top -= ComputedCSSStyleDeclaration.pixelValue(b);
            } else {
                DomNode prev;
                top = 0;
                for (prev = this.getElement().getDomNodeOrDie().getPreviousSibling(); prev != null && !(prev instanceof HtmlElement); prev = prev.getPreviousSibling()) {
                }
                if (prev != null) {
                    HTMLElement e = (HTMLElement)((HtmlElement)prev).getScriptObject();
                    ComputedCSSStyleDeclaration style = e.jsxGet_currentStyle();
                    top = style.getTop(true, false, false) + style.getCalculatedHeight(true, true);
                }
                if ("relative".equals(p)) {
                    top += ComputedCSSStyleDeclaration.pixelValue(t);
                }
            }
            this.top_ = top;
        } else {
            top = this.top_;
        }
        if (includeMargin) {
            int margin = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_marginTop());
            top += margin;
        }
        if (includeBorder) {
            int border = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderTopWidth());
            top += border;
        }
        if (includePadding) {
            int padding = this.getPaddingTop();
            top += padding;
        }
        return top;
    }

    public int getLeft(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        Element parent;
        int left;
        String p = this.getPositionWithInheritance();
        String l = this.getLeftWithInheritance();
        String r = this.getRightWithInheritance();
        if ("fixed".equals(p) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.TREATS_POSITION_FIXED_LIKE_POSITION_STATIC)) {
            p = "static";
        }
        if ("absolute".equals(p) && !"auto".equals(l)) {
            left = ComputedCSSStyleDeclaration.pixelValue(l);
        } else if ("absolute".equals(p) && !"auto".equals(r)) {
            parent = this.getElement().getParentElement();
            int parentWidth = parent.jsxGet_currentStyle().getCalculatedWidth(false, false);
            left = parentWidth - ComputedCSSStyleDeclaration.pixelValue(r);
        } else if ("fixed".equals(p) && "auto".equals(l)) {
            parent = this.getElement().getParentElement();
            left = ComputedCSSStyleDeclaration.pixelValue(parent.jsxGet_currentStyle().getLeftWithInheritance());
        } else if ("static".equals(p)) {
            left = 0;
            for (Object n = this.getDomNodeOrDie(); n != null; n = ((DomNode)n).getPreviousSibling()) {
                if (((DomNode)n).getScriptObject() instanceof HTMLElement) {
                    HTMLElement e = (HTMLElement)((DomNode)n).getScriptObject();
                    String d = e.jsxGet_currentStyle().jsxGet_display();
                    if ("block".equals(d)) break;
                    if (!"none".equals(d)) {
                        left += e.jsxGet_currentStyle().getCalculatedWidth(true, true);
                    }
                } else if (((DomNode)n).getScriptObject() instanceof Text) {
                    left += ((DomNode)n).getTextContent().length() * 10;
                }
                if (!(n instanceof HtmlTableRow)) {
                    continue;
                }
                break;
            }
        } else {
            left = ComputedCSSStyleDeclaration.pixelValue(l);
        }
        if (includeMargin) {
            int margin = this.getMarginLeft();
            left += margin;
        }
        if (includeBorder) {
            int border = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderLeftWidth());
            left += border;
        }
        if (includePadding) {
            int padding = this.getPaddingLeft();
            left += padding;
        }
        return left;
    }

    public String getPositionWithInheritance() {
        String p = this.jsxGet_position();
        if ("inherit".equals(p)) {
            Element parent;
            p = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = this.getElement().getParentElement()) != null ? parent.jsxGet_currentStyle().getPositionWithInheritance() : "static") : "static";
        }
        return p;
    }

    public String getLeftWithInheritance() {
        String left = this.jsxGet_left();
        if ("inherit".equals(left)) {
            Element parent;
            left = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = this.getElement().getParentElement()) != null ? parent.jsxGet_currentStyle().getLeftWithInheritance() : "auto") : "auto";
        }
        return left;
    }

    public String getRightWithInheritance() {
        String right = this.jsxGet_right();
        if ("inherit".equals(right)) {
            Element parent;
            right = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = this.getElement().getParentElement()) != null ? parent.jsxGet_currentStyle().getRightWithInheritance() : "auto") : "auto";
        }
        return right;
    }

    public String getTopWithInheritance() {
        String top = this.jsxGet_top();
        if ("inherit".equals(top)) {
            Element parent;
            top = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = this.getElement().getParentElement()) != null ? parent.jsxGet_currentStyle().getTopWithInheritance() : "auto") : "auto";
        }
        return top;
    }

    public String getBottomWithInheritance() {
        String bottom = this.jsxGet_bottom();
        if ("inherit".equals(bottom)) {
            Element parent;
            bottom = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = this.getElement().getParentElement()) != null ? parent.jsxGet_currentStyle().getBottomWithInheritance() : "auto") : "auto";
        }
        return bottom;
    }

    public int getMarginLeft() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_marginLeft());
    }

    public int getMarginRight() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_marginRight());
    }

    public int getMarginTop() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_marginTop());
    }

    public int getMarginBottom() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_marginBottom());
    }

    public int getPaddingLeft() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_paddingLeft());
    }

    public int getPaddingRight() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_paddingRight());
    }

    public int getPaddingTop() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_paddingTop());
    }

    public int getPaddingBottom() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_paddingBottom());
    }

    private int getPaddingHorizontal() {
        if (this.paddingHorizontal_ == null) {
            this.paddingHorizontal_ = "none".equals(this.jsxGet_display()) ? 0 : this.getPaddingLeft() + this.getPaddingRight();
        }
        return this.paddingHorizontal_;
    }

    private int getPaddingVertical() {
        if (this.paddingVertical_ == null) {
            this.paddingVertical_ = "none".equals(this.jsxGet_display()) ? 0 : this.getPaddingTop() + this.getPaddingBottom();
        }
        return this.paddingVertical_;
    }

    public int getBorderLeft() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderLeftWidth());
    }

    public int getBorderRight() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderRightWidth());
    }

    public int getBorderTop() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderTopWidth());
    }

    public int getBorderBottom() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderBottomWidth());
    }

    private int getBorderHorizontal() {
        if (this.borderHorizontal_ == null) {
            this.borderHorizontal_ = "none".equals(this.jsxGet_display()) ? 0 : this.getBorderLeft() + this.getBorderRight();
        }
        return this.borderHorizontal_;
    }

    private int getBorderVertical() {
        if (this.borderVertical_ == null) {
            this.borderVertical_ = "none".equals(this.jsxGet_display()) ? 0 : this.getBorderTop() + this.getBorderBottom();
        }
        return this.borderVertical_;
    }

    @Override
    public String jsxGet_wordSpacing() {
        String wordSpacing = "0px";
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_WORD_SPACING_DEFAULT_NORMAL)) {
            wordSpacing = "normal";
        }
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_wordSpacing(), (CharSequence)wordSpacing);
    }

    @Override
    public String jsxGet_wordWrap() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)super.jsxGet_wordWrap(), (CharSequence)"normal");
    }

    @Override
    public Object jsxGet_zIndex() {
        Object response = super.jsxGet_zIndex();
        if (response.toString().length() == 0) {
            return "auto";
        }
        return response;
    }

    @Override
    public String jsxFunction_getPropertyValue(String name) {
        Object property = ComputedCSSStyleDeclaration.getProperty((Scriptable)this, (String)ComputedCSSStyleDeclaration.camelize(name));
        if (property == NOT_FOUND) {
            return super.jsxFunction_getPropertyValue(name);
        }
        return Context.toString((Object)property);
    }

    protected String pixelString(String value) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_LENGTH_WITHOUT_PX)) {
            return value;
        }
        if (value.endsWith("px")) {
            return value;
        }
        return ComputedCSSStyleDeclaration.pixelValue(value) + "px";
    }

    protected String pixelString(Element element, CSSStyleDeclaration.CssValue value) {
        String s = value.get(element);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_LENGTH_WITHOUT_PX)) {
            return s;
        }
        if (s.endsWith("px")) {
            return s;
        }
        return ComputedCSSStyleDeclaration.pixelValue(element, value) + "px";
    }
}

