package Promises6::Evo::Builder;
use Evo::Base 'Promises6::Builder';
use Evo::Manager;

# run always in 1 depth
sub train { state $train = Evo::Manager->singleton->build_train }

has deferred_class => sub {
  require Promises6::Evo::Deferred;
  'Promises6::Evo::Deferred';
};

1;

# ABSTRACT: A builder

__END__

=pod

=encoding UTF-8

=head1 NAME

Promises6::Evo::Builder - A builder

=head1 VERSION

version 0.002

=head1 ATTRIBUTES

=head2 deferred_class

Loads and returns Promises6::Evo::Deferred

=head1 METHODS

=head2 train

Returns a running engine

=head1 AUTHOR

alexbyk <alexbyk.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
