package Evo::Class::Common::RoleFunctions;
use Evo '-Export *, -import; -Internal::Util';
use Evo 'Carp croak';
use Evo::Class::Meta;

no warnings 'once';

sub META ($me, $dest) : ExportGen {
  sub { Evo::Class::Meta->find_or_croak($dest); };
}

sub requires ($me, $dest) : ExportGen {

  sub (@names) {
    my $meta = Evo::Class::Meta->find_or_croak($dest);
    $meta->reg_requirement($_) for @names;
  };
}

sub implements ($me, $dest) : ExportGen {

  sub (@interfaces) {
    my $meta = Evo::Class::Meta->find_or_croak($dest);
    foreach my $inter (@interfaces) {
      $inter = Evo::Internal::Util::resolve_package($dest, $inter);
      my $inter_meta = $meta->find_or_croak($inter);
      $meta->check_implementation($inter);
    }
  };
}


sub Over ($dest, $code, $name) : Attr {
  Evo::Class::Meta->find_or_croak($dest)->mark_as_overridden($name);
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Class::Common::RoleFunctions

=head1 VERSION

version 0.0226

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
