#============================================================= -*-Perl-*-
#
# Template::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Andy Wardley   <abw@kfs.org>
#
# COPYRIGHT
#   Copyright (C) 1996-2000 Andy Wardley.  All Rights Reserved.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#------------------------------------------------------------------------
#
# NOTE: this module is constructed from the parser/Grammar.pm.skel
# file by running the parser/yc script.  You only need to do this if 
# you have modified the grammar in the parser/Parser.yp file and need
# to-recompile it.  See the README in the 'parser' directory for more
# information (sub-directory of the Template distribution).
#
#------------------------------------------------------------------------
#
# $Id: Grammar.pm,v 2.10 2001/06/14 11:40:32 abw Exp $
#
#========================================================================

package Template::Grammar;

require 5.004;

use strict;
use vars qw( $VERSION );

$VERSION  = sprintf("%d.%02d", q$Revision: 2.10 $ =~ /(\d+)\.(\d+)/);

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================

# Reserved words, comparison and binary operators
#========================================================================

@RESERVED = qw( 
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE PLUGIN FILTER MACRO PERL RAWPERL TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW
    );

%CMPOP = qw( != ne  == eq  < <  > >  >= >=  <= <= );


#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case, 
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{ 
#    my @tokens = qw< ( ) [ ] { } ${ $ / ; : ? >;
    my @tokens = qw< ( ) [ ] { } ${ $ + / ; : ? >;
    my @cmpop  = keys %CMPOP;
#    my @binop  = qw( + - * % );              # '/' above, in @tokens
    my @binop  = qw( - * % );              # '+' and '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens } 
	= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}


#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
	LEXTABLE => $LEXTABLE,
	STATES   => $STATES,
	RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical 
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			"\"" => 45,
			'BLOCK' => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			"[" => 53,
			'DEFAULT' => 52,
			"{" => 17,
			'THROW' => 57,
			'CALL' => 56,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 30,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'loop' => 55,
			'defblock' => 54,
			'capture' => 18,
			'template' => 42,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 1
		DEFAULT => -100
	},
	{#State 2
		DEFAULT => -109
	},
	{#State 3
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 73,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 4
		DEFAULT => -24
	},
	{#State 5
		ACTIONS => {
			";" => -20
		},
		DEFAULT => -27
	},
	{#State 6
		DEFAULT => -75,
		GOTOS => {
			'@4-1' => 75
		}
	},
	{#State 7
		ACTIONS => {
			'IDENT' => 76
		}
	},
	{#State 8
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81,
			"\$" => 78
		},
		GOTOS => {
			'nameargs' => 86,
			'filename' => 80,
			'filepart' => 85,
			'names' => 87,
			'name' => 82
		}
	},
	{#State 9
		ACTIONS => {
			'DOT' => 88,
			'ASSIGN' => 89
		},
		DEFAULT => -105
	},
	{#State 10
		DEFAULT => -15
	},
	{#State 11
		DEFAULT => -6
	},
	{#State 12
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 51,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 91,
			'assign' => 92,
			'item' => 25,
			'ident' => 90,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 13
		DEFAULT => -21
	},
	{#State 14
		DEFAULT => -12
	},
	{#State 15
		ACTIONS => {
			";" => 93
		}
	},
	{#State 16
		ACTIONS => {
			'IDENT' => 95
		},
		GOTOS => {
			'meta' => 96,
			'metadata' => 94
		}
	},
	{#State 17
		ACTIONS => {
			'LITERAL' => 99,
			'IDENT' => 98
		},
		DEFAULT => -115,
		GOTOS => {
			'param' => 101,
			'params' => 97,
			'hash' => 100
		}
	},
	{#State 18
		DEFAULT => -11
	},
	{#State 19
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 109,
			'OR' => 107,
			";" => -16,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 110,
			"?" => 103
		},
		DEFAULT => -26
	},
	{#State 20
		DEFAULT => -99
	},
	{#State 21
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81,
			"\$" => 78
		},
		GOTOS => {
			'nameargs' => 111,
			'filename' => 80,
			'filepart' => 85,
			'names' => 87,
			'name' => 82
		}
	},
	{#State 22
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81,
			"\$" => 78
		},
		GOTOS => {
			'nameargs' => 112,
			'filename' => 80,
			'filepart' => 85,
			'names' => 87,
			'name' => 82
		}
	},
	{#State 23
		ACTIONS => {
			"\${" => 49,
			'LITERAL' => 115,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'assign' => 69,
			'setlist' => 114,
			'item' => 25,
			'ident' => 113,
			'node' => 58
		}
	},
	{#State 24
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 116,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 25
		ACTIONS => {
			"(" => 117
		},
		DEFAULT => -124
	},
	{#State 26
		ACTIONS => {
			'COMMA' => 118,
			"\${" => 49,
			'LITERAL' => 115,
			'IDENT' => 28,
			"\$" => 7
		},
		DEFAULT => -19,
		GOTOS => {
			'assign' => 119,
			'item' => 25,
			'ident' => 113,
			'node' => 58
		}
	},
	{#State 27
		DEFAULT => -5
	},
	{#State 28
		DEFAULT => -126
	},
	{#State 29
		ACTIONS => {
			";" => 120
		}
	},
	{#State 30
		DEFAULT => -1
	},
	{#State 31
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 121,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 32
		ACTIONS => {
			"\${" => 49,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'item' => 25,
			'ident' => 122,
			'node' => 58
		}
	},
	{#State 33
		ACTIONS => {
			'IDENT' => 123
		}
	},
	{#State 34
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81,
			"\$" => 78
		},
		GOTOS => {
			'nameargs' => 124,
			'filename' => 80,
			'filepart' => 85,
			'names' => 87,
			'name' => 82
		}
	},
	{#State 35
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81,
			"\$" => 78
		},
		GOTOS => {
			'nameargs' => 125,
			'filename' => 80,
			'filepart' => 85,
			'names' => 87,
			'name' => 82
		}
	},
	{#State 36
		DEFAULT => -8
	},
	{#State 37
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 130,
			"\${" => 49,
			'FILENAME' => 79,
			'LITERAL' => 131,
			'IDENT' => 128,
			"\$" => 126
		},
		GOTOS => {
			'lvalue' => 132,
			'lnameargs' => 129,
			'nameargs' => 133,
			'item' => 127,
			'filename' => 80,
			'filepart' => 85,
			'name' => 82,
			'names' => 87
		}
	},
	{#State 38
		DEFAULT => -36
	},
	{#State 39
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 134,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 40
		DEFAULT => -41
	},
	{#State 41
		DEFAULT => -39
	},
	{#State 42
		ACTIONS => {
			'' => 135
		}
	},
	{#State 43
		ACTIONS => {
			";" => 136
		}
	},
	{#State 44
		ACTIONS => {
			'NUMBER' => 77,
			'FILENAME' => 79,
			'LITERAL' => 142,
			'IDENT' => 140
		},
		DEFAULT => -83,
		GOTOS => {
			'meta' => 96,
			'blockname' => 141,
			'filename' => 139,
			'blockargs' => 137,
			'filepart' => 85,
			'metadata' => 138
		}
	},
	{#State 45
		DEFAULT => -171,
		GOTOS => {
			'quoted' => 143
		}
	},
	{#State 46
		DEFAULT => -22
	},
	{#State 47
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 130,
			"\${" => 49,
			'FILENAME' => 79,
			'LITERAL' => 131,
			'IDENT' => 128,
			"\$" => 126
		},
		GOTOS => {
			'lvalue' => 132,
			'lnameargs' => 144,
			'nameargs' => 133,
			'item' => 127,
			'filename' => 80,
			'filepart' => 85,
			'name' => 82,
			'names' => 87
		}
	},
	{#State 48
		DEFAULT => -10
	},
	{#State 49
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			"\${" => 49,
			'REF' => 32,
			'LITERAL' => 74,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'sterm' => 145,
			'item' => 25,
			'ident' => 72,
			'node' => 58
		}
	},
	{#State 50
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -2,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 146,
			'atomdir' => 5,
			'switch' => 46,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 51
		ACTIONS => {
			'ASSIGN' => 147
		},
		DEFAULT => -108
	},
	{#State 52
		ACTIONS => {
			"\${" => 49,
			'LITERAL' => 115,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'assign' => 69,
			'setlist' => 148,
			'item' => 25,
			'ident' => 113,
			'node' => 58
		}
	},
	{#State 53
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			"]" => 151,
			'REF' => 32,
			"\${" => 49
		},
		GOTOS => {
			'sterm' => 149,
			'list' => 150,
			'range' => 152,
			'item' => 25,
			'ident' => 72,
			'term' => 153,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 54
		DEFAULT => -9
	},
	{#State 55
		DEFAULT => -23
	},
	{#State 56
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 154,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 57
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81,
			"\$" => 78
		},
		GOTOS => {
			'nameargs' => 155,
			'filename' => 80,
			'filepart' => 85,
			'names' => 87,
			'name' => 82
		}
	},
	{#State 58
		DEFAULT => -123
	},
	{#State 59
		DEFAULT => -37
	},
	{#State 60
		DEFAULT => -14
	},
	{#State 61
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 156,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 25,
			'ident' => 72,
			'term' => 158,
			'lterm' => 20,
			'loopvar' => 157,
			'node' => 58
		}
	},
	{#State 62
		DEFAULT => -25
	},
	{#State 63
		DEFAULT => -38
	},
	{#State 64
		DEFAULT => -42
	},
	{#State 65
		DEFAULT => -13
	},
	{#State 66
		DEFAULT => -40
	},
	{#State 67
		ACTIONS => {
			'FOR' => 163,
			'UNLESS' => 159,
			'IF' => 164,
			'WHILE' => 161,
			'FILTER' => 162,
			'WRAPPER' => 160
		}
	},
	{#State 68
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 165,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 69
		DEFAULT => -144
	},
	{#State 70
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 166,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 71
		DEFAULT => -141
	},
	{#State 72
		ACTIONS => {
			'DOT' => 88
		},
		DEFAULT => -105
	},
	{#State 73
		ACTIONS => {
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 109,
			'DIV' => 108,
			"/" => 110
		},
		DEFAULT => -137
	},
	{#State 74
		DEFAULT => -108
	},
	{#State 75
		ACTIONS => {
			";" => 167
		}
	},
	{#State 76
		DEFAULT => -128
	},
	{#State 77
		DEFAULT => -169
	},
	{#State 78
		ACTIONS => {
			"\${" => 49,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'item' => 25,
			'ident' => 168,
			'node' => 58
		}
	},
	{#State 79
		DEFAULT => -167
	},
	{#State 80
		ACTIONS => {
			'DOT' => 169
		},
		DEFAULT => -163
	},
	{#State 81
		DEFAULT => -168
	},
	{#State 82
		DEFAULT => -161
	},
	{#State 83
		DEFAULT => -171,
		GOTOS => {
			'quoted' => 170
		}
	},
	{#State 84
		DEFAULT => -164
	},
	{#State 85
		DEFAULT => -166
	},
	{#State 86
		DEFAULT => -34
	},
	{#State 87
		ACTIONS => {
			"(" => 172,
			"+" => 173
		},
		DEFAULT => -151,
		GOTOS => {
			'args' => 171
		}
	},
	{#State 88
		ACTIONS => {
			'NUMBER' => 174,
			"\${" => 49,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'item' => 25,
			'node' => 175
		}
	},
	{#State 89
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 179,
			"\"" => 45,
			'NOT' => 3,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			"(" => 12,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		GOTOS => {
			'directive' => 178,
			'sterm' => 1,
			'mdir' => 176,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'atomdir' => 5,
			'wrapper' => 40,
			'switch' => 46,
			'atomexpr' => 67,
			'loop' => 55,
			'expr' => 177,
			'assign' => 69,
			'perl' => 62,
			'ident' => 90,
			'term' => 71,
			'filter' => 64,
			'lterm' => 20,
			'node' => 58,
			'condition' => 13
		}
	},
	{#State 90
		ACTIONS => {
			'DOT' => 88,
			'ASSIGN' => 180
		},
		DEFAULT => -105
	},
	{#State 91
		ACTIONS => {
			'MOD' => 102,
			")" => 181,
			'BINOP' => 104,
			"+" => 109,
			'OR' => 107,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 110,
			"?" => 103
		}
	},
	{#State 92
		ACTIONS => {
			")" => 182
		}
	},
	{#State 93
		DEFAULT => -7
	},
	{#State 94
		ACTIONS => {
			'COMMA' => 183,
			'IDENT' => 95
		},
		DEFAULT => -17,
		GOTOS => {
			'meta' => 184
		}
	},
	{#State 95
		ACTIONS => {
			'ASSIGN' => 185
		}
	},
	{#State 96
		DEFAULT => -95
	},
	{#State 97
		ACTIONS => {
			'COMMA' => 186,
			'LITERAL' => 99,
			'IDENT' => 98
		},
		DEFAULT => -114,
		GOTOS => {
			'param' => 187
		}
	},
	{#State 98
		ACTIONS => {
			'ASSIGN' => 188
		}
	},
	{#State 99
		ACTIONS => {
			'ASSIGN' => 189
		}
	},
	{#State 100
		ACTIONS => {
			"}" => 190
		}
	},
	{#State 101
		DEFAULT => -118
	},
	{#State 102
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 191,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 103
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 192,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 104
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 193,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 105
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 194,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 106
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 195,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 107
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 196,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 108
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 197,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 109
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 198,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 110
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 199,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 111
		ACTIONS => {
			";" => 200
		}
	},
	{#State 112
		DEFAULT => -32
	},
	{#State 113
		ACTIONS => {
			'DOT' => 88,
			'ASSIGN' => 180
		}
	},
	{#State 114
		ACTIONS => {
			'LITERAL' => 115,
			'IDENT' => 28,
			"\$" => 7,
			'COMMA' => 118,
			"\${" => 49
		},
		DEFAULT => -30,
		GOTOS => {
			'assign' => 119,
			'item' => 25,
			'ident' => 113,
			'node' => 58
		}
	},
	{#State 115
		ACTIONS => {
			'ASSIGN' => 147
		}
	},
	{#State 116
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 109,
			'OR' => 107,
			";" => 201,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 110,
			"?" => 103
		}
	},
	{#State 117
		DEFAULT => -151,
		GOTOS => {
			'args' => 202
		}
	},
	{#State 118
		DEFAULT => -143
	},
	{#State 119
		DEFAULT => -142
	},
	{#State 120
		DEFAULT => -73,
		GOTOS => {
			'@3-2' => 203
		}
	},
	{#State 121
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 109,
			'OR' => 107,
			";" => 204,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 110,
			"?" => 103
		}
	},
	{#State 122
		ACTIONS => {
			'DOT' => 88
		},
		DEFAULT => -106
	},
	{#State 123
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 179,
			"\"" => 45,
			'NOT' => 3,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			"(" => 205,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		GOTOS => {
			'directive' => 178,
			'sterm' => 1,
			'mdir' => 206,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'atomdir' => 5,
			'wrapper' => 40,
			'switch' => 46,
			'atomexpr' => 67,
			'loop' => 55,
			'expr' => 207,
			'assign' => 69,
			'perl' => 62,
			'ident' => 90,
			'term' => 71,
			'filter' => 64,
			'lterm' => 20,
			'node' => 58,
			'condition' => 13
		}
	},
	{#State 124
		DEFAULT => -33
	},
	{#State 125
		ACTIONS => {
			";" => 208
		}
	},
	{#State 126
		ACTIONS => {
			"\${" => 49,
			'IDENT' => 209,
			"\$" => 7
		},
		GOTOS => {
			'item' => 25,
			'ident' => 168,
			'node' => 58
		}
	},
	{#State 127
		DEFAULT => -154
	},
	{#State 128
		ACTIONS => {
			'ASSIGN' => -126
		},
		DEFAULT => -168
	},
	{#State 129
		DEFAULT => -70
	},
	{#State 130
		DEFAULT => -171,
		GOTOS => {
			'quoted' => 210
		}
	},
	{#State 131
		ACTIONS => {
			'ASSIGN' => -156
		},
		DEFAULT => -164
	},
	{#State 132
		ACTIONS => {
			'ASSIGN' => 211
		}
	},
	{#State 133
		DEFAULT => -153
	},
	{#State 134
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 109,
			'OR' => 107,
			";" => 212,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 110,
			"?" => 103
		}
	},
	{#State 135
		DEFAULT => -0
	},
	{#State 136
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 213,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 137
		ACTIONS => {
			";" => 214
		}
	},
	{#State 138
		ACTIONS => {
			'COMMA' => 183,
			'IDENT' => 95
		},
		DEFAULT => -82,
		GOTOS => {
			'meta' => 184
		}
	},
	{#State 139
		ACTIONS => {
			'DOT' => 169
		},
		DEFAULT => -80
	},
	{#State 140
		ACTIONS => {
			'ASSIGN' => 185
		},
		DEFAULT => -168
	},
	{#State 141
		ACTIONS => {
			'IDENT' => 95
		},
		DEFAULT => -83,
		GOTOS => {
			'meta' => 96,
			'blockargs' => 215,
			'metadata' => 138
		}
	},
	{#State 142
		DEFAULT => -81
	},
	{#State 143
		ACTIONS => {
			"\"" => 219,
			"\${" => 49,
			'TEXT' => 217,
			";" => 218,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'quotable' => 220,
			'item' => 25,
			'ident' => 216,
			'node' => 58
		}
	},
	{#State 144
		ACTIONS => {
			";" => 221
		}
	},
	{#State 145
		ACTIONS => {
			"}" => 222
		}
	},
	{#State 146
		DEFAULT => -4
	},
	{#State 147
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 223,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 148
		ACTIONS => {
			'LITERAL' => 115,
			'IDENT' => 28,
			"\$" => 7,
			'COMMA' => 118,
			"\${" => 49
		},
		DEFAULT => -31,
		GOTOS => {
			'assign' => 119,
			'item' => 25,
			'ident' => 113,
			'node' => 58
		}
	},
	{#State 149
		ACTIONS => {
			'TO' => 224
		},
		DEFAULT => -100
	},
	{#State 150
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			'COMMA' => 226,
			"{" => 17,
			"]" => 225,
			'REF' => 32,
			"\${" => 49
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 25,
			'ident' => 72,
			'term' => 227,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 151
		DEFAULT => -103
	},
	{#State 152
		ACTIONS => {
			"]" => 228
		}
	},
	{#State 153
		DEFAULT => -112
	},
	{#State 154
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 109,
			'OR' => 107,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 110,
			"?" => 103
		},
		DEFAULT => -29
	},
	{#State 155
		DEFAULT => -35
	},
	{#State 156
		ACTIONS => {
			'ASSIGN' => 229
		},
		DEFAULT => -126
	},
	{#State 157
		ACTIONS => {
			";" => 230
		}
	},
	{#State 158
		DEFAULT => -151,
		GOTOS => {
			'args' => 231
		}
	},
	{#State 159
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 232,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 160
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81,
			"\$" => 78
		},
		GOTOS => {
			'nameargs' => 233,
			'filename' => 80,
			'filepart' => 85,
			'names' => 87,
			'name' => 82
		}
	},
	{#State 161
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 234,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 162
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 130,
			"\${" => 49,
			'FILENAME' => 79,
			'LITERAL' => 131,
			'IDENT' => 128,
			"\$" => 126
		},
		GOTOS => {
			'lvalue' => 132,
			'lnameargs' => 235,
			'nameargs' => 133,
			'item' => 127,
			'filename' => 80,
			'filepart' => 85,
			'name' => 82,
			'names' => 87
		}
	},
	{#State 163
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 156,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 25,
			'ident' => 72,
			'term' => 158,
			'lterm' => 20,
			'loopvar' => 236,
			'node' => 58
		}
	},
	{#State 164
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 237,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 165
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 109,
			'OR' => 107,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 110,
			"?" => 103
		},
		DEFAULT => -28
	},
	{#State 166
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 109,
			'OR' => 107,
			";" => 238,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 110,
			"?" => 103
		}
	},
	{#State 167
		ACTIONS => {
			'TEXT' => 239
		}
	},
	{#State 168
		ACTIONS => {
			'DOT' => 88
		},
		DEFAULT => -151,
		GOTOS => {
			'args' => 240
		}
	},
	{#State 169
		ACTIONS => {
			'NUMBER' => 77,
			'FILENAME' => 79,
			'IDENT' => 81
		},
		GOTOS => {
			'filepart' => 241
		}
	},
	{#State 170
		ACTIONS => {
			"\"" => 242,
			"\${" => 49,
			'TEXT' => 217,
			";" => 218,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'quotable' => 220,
			'item' => 25,
			'ident' => 216,
			'node' => 58
		}
	},
	{#State 171
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'IDENT' => 244,
			"\$" => 7,
			'REF' => 32,
			"\${" => 49,
			'LITERAL' => 245,
			"[" => 53,
			"{" => 17,
			'COMMA' => 246
		},
		DEFAULT => -158,
		GOTOS => {
			'sterm' => 1,
			'param' => 247,
			'item' => 25,
			'ident' => 243,
			'term' => 248,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 172
		DEFAULT => -151,
		GOTOS => {
			'args' => 249
		}
	},
	{#State 173
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81
		},
		GOTOS => {
			'filename' => 80,
			'filepart' => 85,
			'name' => 250
		}
	},
	{#State 174
		DEFAULT => -122
	},
	{#State 175
		DEFAULT => -121
	},
	{#State 176
		DEFAULT => -85
	},
	{#State 177
		ACTIONS => {
			'IDENT' => -145,
			"\$" => -145,
			'AND' => 105,
			"\${" => -145,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			'OR' => 107,
			"+" => 109,
			";" => -145,
			'LITERAL' => -145,
			'COMMA' => -145,
			'DIV' => 108,
			"/" => 110,
			"?" => 103
		},
		DEFAULT => -26
	},
	{#State 178
		DEFAULT => -88
	},
	{#State 179
		ACTIONS => {
			";" => 251
		}
	},
	{#State 180
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 252,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 181
		DEFAULT => -140
	},
	{#State 182
		DEFAULT => -139
	},
	{#State 183
		DEFAULT => -94
	},
	{#State 184
		DEFAULT => -93
	},
	{#State 185
		ACTIONS => {
			'NUMBER' => 253,
			"\"" => 254,
			'LITERAL' => 255
		}
	},
	{#State 186
		DEFAULT => -117
	},
	{#State 187
		DEFAULT => -116
	},
	{#State 188
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 256,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 189
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 257,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 190
		DEFAULT => -104
	},
	{#State 191
		DEFAULT => -133
	},
	{#State 192
		ACTIONS => {
			'MOD' => 102,
			'AND' => 105,
			'BINOP' => 104,
			'DIV' => 108,
			":" => 258,
			'CMPOP' => 106,
			"/" => 110,
			"+" => 109,
			'OR' => 107,
			"?" => 103
		}
	},
	{#State 193
		ACTIONS => {
			'MOD' => 102,
			"+" => 109,
			'DIV' => 108,
			"/" => 110
		},
		DEFAULT => -129
	},
	{#State 194
		ACTIONS => {
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 109,
			'DIV' => 108,
			"/" => 110
		},
		DEFAULT => -135
	},
	{#State 195
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 109,
			'DIV' => 108,
			"/" => 110
		},
		DEFAULT => -134
	},
	{#State 196
		ACTIONS => {
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 109,
			'DIV' => 108,
			"/" => 110
		},
		DEFAULT => -136
	},
	{#State 197
		ACTIONS => {
			'MOD' => 102
		},
		DEFAULT => -132
	},
	{#State 198
		ACTIONS => {
			'MOD' => 102,
			'DIV' => 108,
			"/" => 110
		},
		DEFAULT => -131
	},
	{#State 199
		ACTIONS => {
			'MOD' => 102,
			'DIV' => 108
		},
		DEFAULT => -130
	},
	{#State 200
		DEFAULT => -71,
		GOTOS => {
			'@2-3' => 259
		}
	},
	{#State 201
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 260,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 202
		ACTIONS => {
			")" => 261,
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 245,
			"[" => 53,
			'IDENT' => 244,
			"\$" => 7,
			'COMMA' => 246,
			"{" => 17,
			'REF' => 32,
			"\${" => 49
		},
		GOTOS => {
			'sterm' => 1,
			'param' => 247,
			'item' => 25,
			'ident' => 243,
			'term' => 248,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 203
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 262,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 204
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 263,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 205
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 51,
			"[" => 53,
			'IDENT' => 264,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 91,
			'assign' => 92,
			'margs' => 265,
			'item' => 25,
			'ident' => 90,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 206
		DEFAULT => -87
	},
	{#State 207
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 109,
			'OR' => 107,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 110,
			"?" => 103
		},
		DEFAULT => -26
	},
	{#State 208
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 266,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 209
		ACTIONS => {
			'ASSIGN' => -128
		},
		DEFAULT => -126
	},
	{#State 210
		ACTIONS => {
			"\"" => 267,
			"\${" => 49,
			'TEXT' => 217,
			";" => 218,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'quotable' => 220,
			'item' => 25,
			'ident' => 216,
			'node' => 58
		}
	},
	{#State 211
		ACTIONS => {
			'NUMBER' => 77,
			"\"" => 83,
			'FILENAME' => 79,
			'LITERAL' => 84,
			'IDENT' => 81,
			"\$" => 78
		},
		GOTOS => {
			'nameargs' => 268,
			'filename' => 80,
			'filepart' => 85,
			'names' => 87,
			'name' => 82
		}
	},
	{#State 212
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 269,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 213
		ACTIONS => {
			'CATCH' => 270,
			'FINAL' => 272
		},
		DEFAULT => -69,
		GOTOS => {
			'final' => 271
		}
	},
	{#State 214
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 273,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 215
		ACTIONS => {
			";" => 274
		}
	},
	{#State 216
		ACTIONS => {
			'DOT' => 88
		},
		DEFAULT => -172
	},
	{#State 217
		DEFAULT => -173
	},
	{#State 218
		DEFAULT => -174
	},
	{#State 219
		DEFAULT => -107
	},
	{#State 220
		DEFAULT => -170
	},
	{#State 221
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 275,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 222
		DEFAULT => -127
	},
	{#State 223
		ACTIONS => {
			'AND' => 105,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			'OR' => 107,
			"+" => 109,
			'DIV' => 108,
			"/" => 110,
			"?" => 103
		},
		DEFAULT => -146
	},
	{#State 224
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			"\${" => 49,
			'REF' => 32,
			'LITERAL' => 74,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'sterm' => 276,
			'item' => 25,
			'ident' => 72,
			'node' => 58
		}
	},
	{#State 225
		DEFAULT => -101
	},
	{#State 226
		DEFAULT => -111
	},
	{#State 227
		DEFAULT => -110
	},
	{#State 228
		DEFAULT => -102
	},
	{#State 229
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 25,
			'ident' => 72,
			'term' => 277,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 230
		DEFAULT => -55,
		GOTOS => {
			'@1-3' => 278
		}
	},
	{#State 231
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 245,
			"[" => 53,
			'IDENT' => 244,
			"\$" => 7,
			'COMMA' => 246,
			"{" => 17,
			'REF' => 32,
			"\${" => 49
		},
		DEFAULT => -61,
		GOTOS => {
			'sterm' => 1,
			'param' => 247,
			'item' => 25,
			'ident' => 243,
			'term' => 248,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 232
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 109,
			'OR' => 107,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 110,
			"?" => 103
		},
		DEFAULT => -46
	},
	{#State 233
		DEFAULT => -63
	},
	{#State 234
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 109,
			'OR' => 107,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 110,
			"?" => 103
		},
		DEFAULT => -59
	},
	{#State 235
		DEFAULT => -78
	},
	{#State 236
		DEFAULT => -57
	},
	{#State 237
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 109,
			'OR' => 107,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 110,
			"?" => 103
		},
		DEFAULT => -44
	},
	{#State 238
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 279,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 239
		ACTIONS => {
			'END' => 280
		}
	},
	{#State 240
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'IDENT' => 244,
			"\$" => 7,
			'REF' => 32,
			"\${" => 49,
			'LITERAL' => 245,
			"[" => 53,
			"{" => 17,
			'COMMA' => 246
		},
		DEFAULT => -157,
		GOTOS => {
			'sterm' => 1,
			'param' => 247,
			'item' => 25,
			'ident' => 243,
			'term' => 248,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 241
		DEFAULT => -165
	},
	{#State 242
		DEFAULT => -162
	},
	{#State 243
		ACTIONS => {
			'DOT' => 88,
			'ASSIGN' => 281
		},
		DEFAULT => -105
	},
	{#State 244
		ACTIONS => {
			'ASSIGN' => 188
		},
		DEFAULT => -126
	},
	{#State 245
		ACTIONS => {
			'ASSIGN' => 189
		},
		DEFAULT => -108
	},
	{#State 246
		DEFAULT => -150
	},
	{#State 247
		DEFAULT => -148
	},
	{#State 248
		DEFAULT => -147
	},
	{#State 249
		ACTIONS => {
			")" => 282,
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 245,
			"[" => 53,
			'IDENT' => 244,
			"\$" => 7,
			'COMMA' => 246,
			"{" => 17,
			'REF' => 32,
			"\${" => 49
		},
		GOTOS => {
			'sterm' => 1,
			'param' => 247,
			'item' => 25,
			'ident' => 243,
			'term' => 248,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 250
		DEFAULT => -160
	},
	{#State 251
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 283,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 252
		ACTIONS => {
			'AND' => 105,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			'OR' => 107,
			"+" => 109,
			'DIV' => 108,
			"/" => 110,
			"?" => 103
		},
		DEFAULT => -145
	},
	{#State 253
		DEFAULT => -98
	},
	{#State 254
		ACTIONS => {
			'TEXT' => 284
		}
	},
	{#State 255
		DEFAULT => -96
	},
	{#State 256
		ACTIONS => {
			'AND' => 105,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			'OR' => 107,
			"+" => 109,
			'DIV' => 108,
			"/" => 110,
			"?" => 103
		},
		DEFAULT => -120
	},
	{#State 257
		ACTIONS => {
			'AND' => 105,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			'OR' => 107,
			"+" => 109,
			'DIV' => 108,
			"/" => 110,
			"?" => 103
		},
		DEFAULT => -119
	},
	{#State 258
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 285,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 259
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 286,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 260
		ACTIONS => {
			'CASE' => 288
		},
		DEFAULT => -54,
		GOTOS => {
			'case' => 287
		}
	},
	{#State 261
		DEFAULT => -125
	},
	{#State 262
		ACTIONS => {
			'END' => 289
		}
	},
	{#State 263
		ACTIONS => {
			'ELSE' => 290,
			'ELSIF' => 292
		},
		DEFAULT => -49,
		GOTOS => {
			'else' => 291
		}
	},
	{#State 264
		ACTIONS => {
			'IDENT' => -92,
			")" => -92,
			'COMMA' => -92
		},
		DEFAULT => -126
	},
	{#State 265
		ACTIONS => {
			'COMMA' => 295,
			")" => 294,
			'IDENT' => 293
		}
	},
	{#State 266
		ACTIONS => {
			'END' => 296
		}
	},
	{#State 267
		ACTIONS => {
			'ASSIGN' => -155
		},
		DEFAULT => -162
	},
	{#State 268
		DEFAULT => -152
	},
	{#State 269
		ACTIONS => {
			'END' => 297
		}
	},
	{#State 270
		ACTIONS => {
			'NUMBER' => 77,
			'FILENAME' => 79,
			";" => 298,
			'DEFAULT' => 300,
			'IDENT' => 81
		},
		GOTOS => {
			'filename' => 299,
			'filepart' => 85
		}
	},
	{#State 271
		ACTIONS => {
			'END' => 301
		}
	},
	{#State 272
		ACTIONS => {
			";" => 302
		}
	},
	{#State 273
		ACTIONS => {
			'END' => 303
		}
	},
	{#State 274
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 30,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'template' => 304,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 275
		ACTIONS => {
			'END' => 305
		}
	},
	{#State 276
		DEFAULT => -113
	},
	{#State 277
		DEFAULT => -151,
		GOTOS => {
			'args' => 306
		}
	},
	{#State 278
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 307,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 279
		ACTIONS => {
			'ELSE' => 290,
			'ELSIF' => 292
		},
		DEFAULT => -49,
		GOTOS => {
			'else' => 308
		}
	},
	{#State 280
		DEFAULT => -76
	},
	{#State 281
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 309,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 282
		DEFAULT => -159
	},
	{#State 283
		ACTIONS => {
			'END' => 310
		}
	},
	{#State 284
		ACTIONS => {
			"\"" => 311
		}
	},
	{#State 285
		ACTIONS => {
			'AND' => 105,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			'OR' => 107,
			"+" => 109,
			'DIV' => 108,
			"/" => 110,
			"?" => 103
		},
		DEFAULT => -138
	},
	{#State 286
		ACTIONS => {
			'END' => 312
		}
	},
	{#State 287
		ACTIONS => {
			'END' => 313
		}
	},
	{#State 288
		ACTIONS => {
			"{" => 17,
			'NUMBER' => 2,
			"\"" => 45,
			"\${" => 49,
			'REF' => 32,
			'LITERAL' => 74,
			";" => 314,
			'DEFAULT' => 315,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 25,
			'ident' => 72,
			'term' => 316,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 289
		DEFAULT => -74
	},
	{#State 290
		ACTIONS => {
			";" => 317
		}
	},
	{#State 291
		ACTIONS => {
			'END' => 318
		}
	},
	{#State 292
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 74,
			"[" => 53,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 49,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 319,
			'item' => 25,
			'ident' => 72,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 293
		DEFAULT => -90
	},
	{#State 294
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 179,
			"\"" => 45,
			'NOT' => 3,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			"(" => 12,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		GOTOS => {
			'directive' => 178,
			'sterm' => 1,
			'mdir' => 320,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'atomdir' => 5,
			'wrapper' => 40,
			'switch' => 46,
			'atomexpr' => 67,
			'loop' => 55,
			'expr' => 207,
			'assign' => 69,
			'perl' => 62,
			'ident' => 90,
			'term' => 71,
			'filter' => 64,
			'lterm' => 20,
			'node' => 58,
			'condition' => 13
		}
	},
	{#State 295
		DEFAULT => -91
	},
	{#State 296
		DEFAULT => -62
	},
	{#State 297
		DEFAULT => -58
	},
	{#State 298
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 321,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 299
		ACTIONS => {
			'DOT' => 169,
			";" => 322
		}
	},
	{#State 300
		ACTIONS => {
			";" => 323
		}
	},
	{#State 301
		DEFAULT => -64
	},
	{#State 302
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 324,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 303
		DEFAULT => -84
	},
	{#State 304
		ACTIONS => {
			'END' => 325
		}
	},
	{#State 305
		DEFAULT => -77
	},
	{#State 306
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 245,
			"[" => 53,
			'IDENT' => 244,
			"\$" => 7,
			'COMMA' => 246,
			"{" => 17,
			'REF' => 32,
			"\${" => 49
		},
		DEFAULT => -60,
		GOTOS => {
			'sterm' => 1,
			'param' => 247,
			'item' => 25,
			'ident' => 243,
			'term' => 248,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 307
		ACTIONS => {
			'END' => 326
		}
	},
	{#State 308
		ACTIONS => {
			'END' => 327
		}
	},
	{#State 309
		ACTIONS => {
			'AND' => 105,
			'CMPOP' => 106,
			'MOD' => 102,
			'BINOP' => 104,
			'OR' => 107,
			"+" => 109,
			'DIV' => 108,
			"/" => 110,
			"?" => 103
		},
		DEFAULT => -149
	},
	{#State 310
		DEFAULT => -89
	},
	{#State 311
		DEFAULT => -97
	},
	{#State 312
		DEFAULT => -72
	},
	{#State 313
		DEFAULT => -50
	},
	{#State 314
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 328,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 315
		ACTIONS => {
			";" => 329
		}
	},
	{#State 316
		ACTIONS => {
			";" => 330
		}
	},
	{#State 317
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 331,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 318
		DEFAULT => -45
	},
	{#State 319
		ACTIONS => {
			'MOD' => 102,
			'BINOP' => 104,
			"+" => 109,
			'OR' => 107,
			";" => 332,
			'AND' => 105,
			'DIV' => 108,
			'CMPOP' => 106,
			"/" => 110,
			"?" => 103
		}
	},
	{#State 320
		DEFAULT => -86
	},
	{#State 321
		ACTIONS => {
			'CATCH' => 270,
			'FINAL' => 272
		},
		DEFAULT => -69,
		GOTOS => {
			'final' => 333
		}
	},
	{#State 322
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 334,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 323
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 335,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 324
		DEFAULT => -68
	},
	{#State 325
		DEFAULT => -79
	},
	{#State 326
		DEFAULT => -56
	},
	{#State 327
		DEFAULT => -43
	},
	{#State 328
		DEFAULT => -53
	},
	{#State 329
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 336,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 330
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 337,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 331
		DEFAULT => -48
	},
	{#State 332
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 49,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 51,
			'DEFAULT' => 52,
			"[" => 53,
			"{" => 17,
			'CALL' => 56,
			'THROW' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 59,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 61,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 63,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 66,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 68,
			'IF' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 60,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'switch' => 46,
			'block' => 338,
			'anonblock' => 48,
			'perl' => 62,
			'ident' => 9,
			'filter' => 64,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 65,
			'statement' => 15,
			'chunks' => 50,
			'wrapper' => 40,
			'atomexpr' => 67,
			'defblock' => 54,
			'loop' => 55,
			'capture' => 18,
			'expr' => 19,
			'assign' => 69,
			'term' => 71,
			'lterm' => 20,
			'node' => 58
		}
	},
	{#State 333
		DEFAULT => -67
	},
	{#State 334
		ACTIONS => {
			'CATCH' => 270,
			'FINAL' => 272
		},
		DEFAULT => -69,
		GOTOS => {
			'final' => 339
		}
	},
	{#State 335
		ACTIONS => {
			'CATCH' => 270,
			'FINAL' => 272
		},
		DEFAULT => -69,
		GOTOS => {
			'final' => 340
		}
	},
	{#State 336
		DEFAULT => -52
	},
	{#State 337
		ACTIONS => {
			'CASE' => 288
		},
		DEFAULT => -54,
		GOTOS => {
			'case' => 341
		}
	},
	{#State 338
		ACTIONS => {
			'ELSE' => 290,
			'ELSIF' => 292
		},
		DEFAULT => -49,
		GOTOS => {
			'else' => 342
		}
	},
	{#State 339
		DEFAULT => -65
	},
	{#State 340
		DEFAULT => -66
	},
	{#State 341
		DEFAULT => -51
	},
	{#State 342
		DEFAULT => -47
	}
]; 


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 63 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 66 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 67 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 70 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
					if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 72 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 75 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2, undef
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1, undef
	],
	[#Rule 16
		 'statement', 1,
sub
#line 88 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 17
		 'statement', 2,
sub
#line 89 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 18
		 'statement', 0, undef
	],
	[#Rule 19
		 'directive', 1,
sub
#line 93 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 20
		 'directive', 1, undef
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'directive', 1, undef
	],
	[#Rule 26
		 'atomexpr', 1,
sub
#line 107 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 27
		 'atomexpr', 1, undef
	],
	[#Rule 28
		 'atomdir', 2,
sub
#line 111 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 29
		 'atomdir', 2,
sub
#line 112 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 113 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 114 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 115 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 116 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 117 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 35
		 'atomdir', 2,
sub
#line 118 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 36
		 'atomdir', 1,
sub
#line 119 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 37
		 'atomdir', 1,
sub
#line 120 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 121 "Parser.yp"
{ "\$output = '';";                   }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 122 "Parser.yp"
{ 'last;'                             }
	],
	[#Rule 40
		 'atomdir', 1,
sub
#line 123 "Parser.yp"
{ $_[0]->{ INFOR }
					? $factory->next()
				        : 'next;'                         }
	],
	[#Rule 41
		 'atomdir', 1, undef
	],
	[#Rule 42
		 'atomdir', 1, undef
	],
	[#Rule 43
		 'condition', 6,
sub
#line 131 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 44
		 'condition', 3,
sub
#line 132 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 45
		 'condition', 6,
sub
#line 134 "Parser.yp"
{ $factory->if("!($_[2])", @_[4, 5])  }
	],
	[#Rule 46
		 'condition', 3,
sub
#line 135 "Parser.yp"
{ $factory->if("!($_[3])", $_[1])     }
	],
	[#Rule 47
		 'else', 5,
sub
#line 139 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
				      $_[5];                              }
	],
	[#Rule 48
		 'else', 3,
sub
#line 141 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 49
		 'else', 0,
sub
#line 142 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 50
		 'switch', 6,
sub
#line 146 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 51
		 'case', 5,
sub
#line 150 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
				      $_[5];                              }
	],
	[#Rule 52
		 'case', 4,
sub
#line 152 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 53
		 'case', 3,
sub
#line 153 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 54
		 'case', 0,
sub
#line 154 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 55
		 '@1-3', 0,
sub
#line 157 "Parser.yp"
{ $_[0]->{ INFOR }++                  }
	],
	[#Rule 56
		 'loop', 6,
sub
#line 158 "Parser.yp"
{ $_[0]->{ INFOR }--;
				      $factory->foreach(@{$_[2]}, $_[5])  }
	],
	[#Rule 57
		 'loop', 3,
sub
#line 162 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 58
		 'loop', 5,
sub
#line 164 "Parser.yp"
{ $factory->while(@_[2, 4])           }
	],
	[#Rule 59
		 'loop', 3,
sub
#line 165 "Parser.yp"
{ $factory->while(@_[3, 1])           }
	],
	[#Rule 60
		 'loopvar', 4,
sub
#line 168 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 61
		 'loopvar', 2,
sub
#line 169 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 62
		 'wrapper', 5,
sub
#line 173 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 63
		 'wrapper', 3,
sub
#line 175 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 64
		 'try', 5,
sub
#line 179 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 65
		 'final', 5,
sub
#line 183 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
				      $_[5];                              }
	],
	[#Rule 66
		 'final', 5,
sub
#line 186 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
				      $_[5];                              }
	],
	[#Rule 67
		 'final', 4,
sub
#line 189 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
				      $_[4];                              }
	],
	[#Rule 68
		 'final', 3,
sub
#line 191 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 69
		 'final', 0,
sub
#line 192 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 70
		 'use', 2,
sub
#line 195 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 71
		 '@2-3', 0,
sub
#line 198 "Parser.yp"
{ $_[0]->push_defblock();		  }
	],
	[#Rule 72
		 'view', 6,
sub
#line 199 "Parser.yp"
{ $factory->view(@_[2,5], 
						     $_[0]->pop_defblock) }
	],
	[#Rule 73
		 '@3-2', 0,
sub
#line 203 "Parser.yp"
{ ${$_[0]->{ INPERL }}++;             }
	],
	[#Rule 74
		 'perl', 5,
sub
#line 204 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
				      $_[0]->{ EVAL_PERL } 
				      ? $factory->perl($_[4])             
				      : $factory->no_perl();              }
	],
	[#Rule 75
		 '@4-1', 0,
sub
#line 210 "Parser.yp"
{ ${$_[0]->{ INPERL }}++; 
				      $rawstart = ${$_[0]->{'LINE'}};     }
	],
	[#Rule 76
		 'rawperl', 5,
sub
#line 212 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
				      $_[0]->{ EVAL_PERL } 
				      ? $factory->rawperl($_[4], $rawstart)
				      : $factory->no_perl();              }
	],
	[#Rule 77
		 'filter', 5,
sub
#line 219 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 78
		 'filter', 3,
sub
#line 221 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 79
		 'defblock', 6,
sub
#line 229 "Parser.yp"
{ local $" = ', ';
				      print STDERR "experimental block args: [@{ $_[3] }]\n"
					  if $_[3];
				      $_[0]->define_block(@_[2, 5]); 
				      undef                               }
	],
	[#Rule 80
		 'blockname', 1, undef
	],
	[#Rule 81
		 'blockname', 1,
sub
#line 237 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 82
		 'blockargs', 1, undef
	],
	[#Rule 83
		 'blockargs', 0, undef
	],
	[#Rule 84
		 'anonblock', 5,
sub
#line 245 "Parser.yp"
{ local $" = ', ';
				      print STDERR "experimental block args: [@{ $_[2] }]\n"
					  if $_[2];
				      $factory->anon_block($_[4])         }
	],
	[#Rule 85
		 'capture', 3,
sub
#line 251 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 86
		 'macro', 6,
sub
#line 255 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 87
		 'macro', 3,
sub
#line 256 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 88
		 'mdir', 1, undef
	],
	[#Rule 89
		 'mdir', 4,
sub
#line 260 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 90
		 'margs', 2,
sub
#line 263 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 91
		 'margs', 2,
sub
#line 264 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 92
		 'margs', 1,
sub
#line 265 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 93
		 'metadata', 2,
sub
#line 268 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 94
		 'metadata', 2, undef
	],
	[#Rule 95
		 'metadata', 1, undef
	],
	[#Rule 96
		 'meta', 3,
sub
#line 273 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$//; 
						       s/\\'/'/g  }; 
					 [ @_[1,3] ] }
	],
	[#Rule 97
		 'meta', 5,
sub
#line 276 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 98
		 'meta', 3,
sub
#line 277 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 99
		 'term', 1, undef
	],
	[#Rule 100
		 'term', 1, undef
	],
	[#Rule 101
		 'lterm', 3,
sub
#line 289 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 102
		 'lterm', 3,
sub
#line 290 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 103
		 'lterm', 2,
sub
#line 291 "Parser.yp"
{ "[ ]"                               }
	],
	[#Rule 104
		 'lterm', 3,
sub
#line 292 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 105
		 'sterm', 1,
sub
#line 295 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 106
		 'sterm', 2,
sub
#line 296 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 107
		 'sterm', 3,
sub
#line 297 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 108
		 'sterm', 1, undef
	],
	[#Rule 109
		 'sterm', 1, undef
	],
	[#Rule 110
		 'list', 2,
sub
#line 302 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 111
		 'list', 2, undef
	],
	[#Rule 112
		 'list', 1, undef
	],
	[#Rule 113
		 'range', 3,
sub
#line 307 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 114
		 'hash', 1, undef
	],
	[#Rule 115
		 'hash', 0,
sub
#line 312 "Parser.yp"
{ "" }
	],
	[#Rule 116
		 'params', 2,
sub
#line 315 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 117
		 'params', 2, undef
	],
	[#Rule 118
		 'params', 1, undef
	],
	[#Rule 119
		 'param', 3,
sub
#line 323 "Parser.yp"
{ "$_[1] => $_[3]"                    }
	],
	[#Rule 120
		 'param', 3,
sub
#line 324 "Parser.yp"
{ "'$_[1]' => $_[3]"                  }
	],
	[#Rule 121
		 'ident', 3,
sub
#line 327 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 122
		 'ident', 3,
sub
#line 328 "Parser.yp"
{ push(@{$_[1]}, 
					   map {($_, 0)} split(/\./, $_[3]));
				      $_[1];			          }
	],
	[#Rule 123
		 'ident', 1, undef
	],
	[#Rule 124
		 'node', 1,
sub
#line 334 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 125
		 'node', 4,
sub
#line 335 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 126
		 'item', 1,
sub
#line 338 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 127
		 'item', 3,
sub
#line 339 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 128
		 'item', 2,
sub
#line 340 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
				       ? "'$_[2]'" 
				       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 129
		 'expr', 3,
sub
#line 345 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 130
		 'expr', 3,
sub
#line 346 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 131
		 'expr', 3,
sub
#line 347 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 132
		 'expr', 3,
sub
#line 348 "Parser.yp"
{ "int($_[1] / $_[3])"                }
	],
	[#Rule 133
		 'expr', 3,
sub
#line 349 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 134
		 'expr', 3,
sub
#line 350 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 135
		 'expr', 3,
sub
#line 351 "Parser.yp"
{ "($_[1]) && ($_[3])"                }
	],
	[#Rule 136
		 'expr', 3,
sub
#line 352 "Parser.yp"
{ "($_[1]) || ($_[3])"                }
	],
	[#Rule 137
		 'expr', 2,
sub
#line 353 "Parser.yp"
{ "!($_[2])"                          }
	],
	[#Rule 138
		 'expr', 5,
sub
#line 354 "Parser.yp"
{ "(($_[1]) ? ($_[3]) : ($_[5]))"     }
	],
	[#Rule 139
		 'expr', 3,
sub
#line 355 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 140
		 'expr', 3,
sub
#line 356 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 141
		 'expr', 1, undef
	],
	[#Rule 142
		 'setlist', 2,
sub
#line 360 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 143
		 'setlist', 2, undef
	],
	[#Rule 144
		 'setlist', 1, undef
	],
	[#Rule 145
		 'assign', 3,
sub
#line 366 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 146
		 'assign', 3,
sub
#line 367 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 147
		 'args', 2,
sub
#line 374 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 148
		 'args', 2,
sub
#line 375 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 149
		 'args', 4,
sub
#line 376 "Parser.yp"
{ push(@{$_[1]->[0]}, "'', " . 
				      $factory->assign(@_[2,4])); $_[1]  }
	],
	[#Rule 150
		 'args', 2,
sub
#line 378 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 151
		 'args', 0,
sub
#line 379 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 152
		 'lnameargs', 3,
sub
#line 389 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 153
		 'lnameargs', 1, undef
	],
	[#Rule 154
		 'lvalue', 1, undef
	],
	[#Rule 155
		 'lvalue', 3,
sub
#line 394 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 156
		 'lvalue', 1, undef
	],
	[#Rule 157
		 'nameargs', 3,
sub
#line 398 "Parser.yp"
{ [ [$factory->ident($_[2])], $_[3] ]   }
	],
	[#Rule 158
		 'nameargs', 2,
sub
#line 399 "Parser.yp"
{ [ @_[1,2] ] }
	],
	[#Rule 159
		 'nameargs', 4,
sub
#line 400 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 160
		 'names', 3,
sub
#line 403 "Parser.yp"
{ push(@{$_[1]}, $_[3]); $_[1] }
	],
	[#Rule 161
		 'names', 1,
sub
#line 404 "Parser.yp"
{ [ $_[1] ]                    }
	],
	[#Rule 162
		 'name', 3,
sub
#line 407 "Parser.yp"
{ $factory->quoted($_[2])  }
	],
	[#Rule 163
		 'name', 1,
sub
#line 408 "Parser.yp"
{ "'$_[1]'" }
	],
	[#Rule 164
		 'name', 1, undef
	],
	[#Rule 165
		 'filename', 3,
sub
#line 420 "Parser.yp"
{ "$_[1].$_[3]" }
	],
	[#Rule 166
		 'filename', 1, undef
	],
	[#Rule 167
		 'filepart', 1, undef
	],
	[#Rule 168
		 'filepart', 1, undef
	],
	[#Rule 169
		 'filepart', 1, undef
	],
	[#Rule 170
		 'quoted', 2,
sub
#line 434 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
				          if defined $_[2]; $_[1]         }
	],
	[#Rule 171
		 'quoted', 0,
sub
#line 436 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 172
		 'quotable', 1,
sub
#line 439 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 173
		 'quotable', 1,
sub
#line 440 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 174
		 'quotable', 1,
sub
#line 441 "Parser.yp"
{ undef                               }
	]
];



1;












