/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import com.sun.media.jai.util.CacheDiagnostics;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JaiI18N;
import com.sun.media.jai.util.SunCachedTile;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.TileCache;
import javax.media.jai.util.ImagingListener;

public final class SunTileCache
extends Observable
implements TileCache,
CacheDiagnostics {
    private static final long DEFAULT_MEMORY_CAPACITY = 0x1000000L;
    private static final int DEFAULT_HASHTABLE_CAPACITY = 1009;
    private static final float LOAD_FACTOR = 0.5f;
    private Hashtable cache;
    private SortedSet cacheSortedSet;
    private long memoryCapacity;
    private long memoryUsage = 0L;
    private float memoryThreshold = 0.75f;
    private long timeStamp = 0L;
    private Comparator comparator = null;
    private SunCachedTile first = null;
    private SunCachedTile last = null;
    private long tileCount = 0L;
    private long hitCount = 0L;
    private long missCount = 0L;
    private boolean diagnostics = false;
    private static final int ADD = 0;
    private static final int REMOVE = 1;
    private static final int REMOVE_FROM_FLUSH = 2;
    private static final int REMOVE_FROM_MEMCON = 3;
    private static final int UPDATE_FROM_ADD = 4;
    private static final int UPDATE_FROM_GETTILE = 5;
    private static final int ABOUT_TO_REMOVE = 6;

    public static EnumeratedParameter[] getCachedTileActions() {
        return new EnumeratedParameter[]{new EnumeratedParameter("add", 0), new EnumeratedParameter("remove", 1), new EnumeratedParameter("remove_by_flush", 2), new EnumeratedParameter("remove_by_memorycontrol", 3), new EnumeratedParameter("timestamp_update_by_add", 4), new EnumeratedParameter("timestamp_update_by_gettile", 5), new EnumeratedParameter("preremove", 6)};
    }

    public SunTileCache() {
        this(0x1000000L);
    }

    public SunTileCache(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileCache"));
        }
        this.memoryCapacity = l;
        this.cache = new Hashtable(1009, 0.5f);
    }

    public void add(RenderedImage renderedImage, int n, int n2, Raster raster) {
        this.add(renderedImage, n, n2, raster, null);
    }

    public synchronized void add(RenderedImage renderedImage, int n, int n2, Raster raster, Object object) {
        if (this.memoryCapacity == 0L) {
            return;
        }
        Object object2 = SunCachedTile.hashKey(renderedImage, n, n2);
        SunCachedTile sunCachedTile = (SunCachedTile)this.cache.get(object2);
        if (sunCachedTile != null) {
            sunCachedTile.timeStamp = this.timeStamp++;
            if (sunCachedTile != this.first) {
                if (sunCachedTile == this.last) {
                    this.last = sunCachedTile.previous;
                    this.last.next = null;
                } else {
                    sunCachedTile.previous.next = sunCachedTile.next;
                    sunCachedTile.next.previous = sunCachedTile.previous;
                }
                sunCachedTile.previous = null;
                sunCachedTile.next = this.first;
                this.first.previous = sunCachedTile;
                this.first = sunCachedTile;
            }
            ++this.hitCount;
            if (this.diagnostics) {
                sunCachedTile.action = 4;
                this.setChanged();
                this.notifyObservers(sunCachedTile);
            }
        } else {
            sunCachedTile = new SunCachedTile(renderedImage, n, n2, raster, object);
            sunCachedTile.timeStamp = this.timeStamp++;
            sunCachedTile.previous = null;
            sunCachedTile.next = this.first;
            if (this.first == null && this.last == null) {
                this.first = sunCachedTile;
                this.last = sunCachedTile;
            } else {
                this.first.previous = sunCachedTile;
                this.first = sunCachedTile;
            }
            if (this.cache.put(sunCachedTile.key, sunCachedTile) == null) {
                this.memoryUsage += sunCachedTile.memorySize;
                ++this.tileCount;
                if (this.cacheSortedSet != null) {
                    this.cacheSortedSet.add(sunCachedTile);
                }
                if (this.diagnostics) {
                    sunCachedTile.action = 0;
                    this.setChanged();
                    this.notifyObservers(sunCachedTile);
                }
            }
            if (this.memoryUsage > this.memoryCapacity) {
                this.memoryControl();
            }
        }
    }

    public synchronized void remove(RenderedImage renderedImage, int n, int n2) {
        if (this.memoryCapacity == 0L) {
            return;
        }
        Object object = SunCachedTile.hashKey(renderedImage, n, n2);
        SunCachedTile sunCachedTile = (SunCachedTile)this.cache.get(object);
        if (sunCachedTile != null) {
            sunCachedTile.action = 6;
            this.setChanged();
            this.notifyObservers(sunCachedTile);
            sunCachedTile = (SunCachedTile)this.cache.remove(object);
            if (sunCachedTile != null) {
                this.memoryUsage -= sunCachedTile.memorySize;
                --this.tileCount;
                if (this.cacheSortedSet != null) {
                    this.cacheSortedSet.remove(sunCachedTile);
                }
                if (sunCachedTile == this.first) {
                    if (sunCachedTile == this.last) {
                        this.first = null;
                        this.last = null;
                    } else {
                        this.first = sunCachedTile.next;
                        this.first.previous = null;
                    }
                } else if (sunCachedTile == this.last) {
                    this.last = sunCachedTile.previous;
                    this.last.next = null;
                } else {
                    sunCachedTile.previous.next = sunCachedTile.next;
                    sunCachedTile.next.previous = sunCachedTile.previous;
                }
                if (this.diagnostics) {
                    sunCachedTile.action = 1;
                    this.setChanged();
                    this.notifyObservers(sunCachedTile);
                }
                sunCachedTile.previous = null;
                sunCachedTile.next = null;
                sunCachedTile = null;
            }
        }
    }

    public synchronized Raster getTile(RenderedImage renderedImage, int n, int n2) {
        Raster raster = null;
        if (this.memoryCapacity == 0L) {
            return null;
        }
        Object object = SunCachedTile.hashKey(renderedImage, n, n2);
        SunCachedTile sunCachedTile = (SunCachedTile)this.cache.get(object);
        if (sunCachedTile == null) {
            ++this.missCount;
        } else {
            raster = sunCachedTile.getTile();
            sunCachedTile.timeStamp = this.timeStamp++;
            if (sunCachedTile != this.first) {
                if (sunCachedTile == this.last) {
                    this.last = sunCachedTile.previous;
                    this.last.next = null;
                } else {
                    sunCachedTile.previous.next = sunCachedTile.next;
                    sunCachedTile.next.previous = sunCachedTile.previous;
                }
                sunCachedTile.previous = null;
                sunCachedTile.next = this.first;
                this.first.previous = sunCachedTile;
                this.first = sunCachedTile;
            }
            ++this.hitCount;
            if (this.diagnostics) {
                sunCachedTile.action = 5;
                this.setChanged();
                this.notifyObservers(sunCachedTile);
            }
        }
        return raster;
    }

    public synchronized Raster[] getTiles(RenderedImage renderedImage) {
        Raster[] rasterArray = null;
        if (this.memoryCapacity == 0L) {
            return null;
        }
        int n = Math.min(renderedImage.getNumXTiles() * renderedImage.getNumYTiles(), (int)this.tileCount);
        if (n > 0) {
            int n2;
            int n3 = renderedImage.getMinTileX();
            int n4 = renderedImage.getMinTileY();
            int n5 = n3 + renderedImage.getNumXTiles();
            int n6 = n4 + renderedImage.getNumYTiles();
            Vector<Raster> vector = new Vector<Raster>(10, 20);
            int n7 = n4;
            while (n7 < n6) {
                n2 = n3;
                while (n2 < n5) {
                    Raster raster = null;
                    Object object = SunCachedTile.hashKey(renderedImage, n2, n7);
                    SunCachedTile sunCachedTile = (SunCachedTile)this.cache.get(object);
                    if (sunCachedTile == null) {
                        raster = null;
                        ++this.missCount;
                    } else {
                        raster = sunCachedTile.getTile();
                        ++this.timeStamp;
                        sunCachedTile.timeStamp = sunCachedTile.timeStamp;
                        if (sunCachedTile != this.first) {
                            if (sunCachedTile == this.last) {
                                this.last = sunCachedTile.previous;
                                this.last.next = null;
                            } else {
                                sunCachedTile.previous.next = sunCachedTile.next;
                                sunCachedTile.next.previous = sunCachedTile.previous;
                            }
                            sunCachedTile.previous = null;
                            sunCachedTile.next = this.first;
                            this.first.previous = sunCachedTile;
                            this.first = sunCachedTile;
                        }
                        ++this.hitCount;
                        if (this.diagnostics) {
                            sunCachedTile.action = 5;
                            this.setChanged();
                            this.notifyObservers(sunCachedTile);
                        }
                    }
                    if (raster != null) {
                        vector.add(raster);
                    }
                    ++n2;
                }
                ++n7;
            }
            n2 = vector.size();
            if (n2 > 0) {
                rasterArray = vector.toArray(new Raster[n2]);
            }
        }
        return rasterArray;
    }

    public void removeTiles(RenderedImage renderedImage) {
        if (this.memoryCapacity > 0L) {
            int n = renderedImage.getMinTileX();
            int n2 = renderedImage.getMinTileY();
            int n3 = n + renderedImage.getNumXTiles();
            int n4 = n2 + renderedImage.getNumYTiles();
            int n5 = n2;
            while (n5 < n4) {
                int n6 = n;
                while (n6 < n3) {
                    this.remove(renderedImage, n6, n5);
                    ++n6;
                }
                ++n5;
            }
        }
    }

    public synchronized void addTiles(RenderedImage renderedImage, Point[] pointArray, Raster[] rasterArray, Object object) {
        if (this.memoryCapacity == 0L) {
            return;
        }
        int n = 0;
        while (n < pointArray.length) {
            int n2 = pointArray[n].x;
            int n3 = pointArray[n].y;
            Raster raster = rasterArray[n];
            Object object2 = SunCachedTile.hashKey(renderedImage, n2, n3);
            SunCachedTile sunCachedTile = (SunCachedTile)this.cache.get(object2);
            if (sunCachedTile != null) {
                ++this.timeStamp;
                sunCachedTile.timeStamp = sunCachedTile.timeStamp;
                if (sunCachedTile != this.first) {
                    if (sunCachedTile == this.last) {
                        this.last = sunCachedTile.previous;
                        this.last.next = null;
                    } else {
                        sunCachedTile.previous.next = sunCachedTile.next;
                        sunCachedTile.next.previous = sunCachedTile.previous;
                    }
                    sunCachedTile.previous = null;
                    sunCachedTile.next = this.first;
                    this.first.previous = sunCachedTile;
                    this.first = sunCachedTile;
                }
                ++this.hitCount;
                if (this.diagnostics) {
                    sunCachedTile.action = 4;
                    this.setChanged();
                    this.notifyObservers(sunCachedTile);
                }
            } else {
                sunCachedTile = new SunCachedTile(renderedImage, n2, n3, raster, object);
                ++this.timeStamp;
                sunCachedTile.timeStamp = sunCachedTile.timeStamp;
                sunCachedTile.previous = null;
                sunCachedTile.next = this.first;
                if (this.first == null && this.last == null) {
                    this.first = sunCachedTile;
                    this.last = sunCachedTile;
                } else {
                    this.first.previous = sunCachedTile;
                    this.first = sunCachedTile;
                }
                if (this.cache.put(sunCachedTile.key, sunCachedTile) == null) {
                    this.memoryUsage += sunCachedTile.memorySize;
                    ++this.tileCount;
                    if (this.cacheSortedSet != null) {
                        this.cacheSortedSet.add(sunCachedTile);
                    }
                    if (this.diagnostics) {
                        sunCachedTile.action = 0;
                        this.setChanged();
                        this.notifyObservers(sunCachedTile);
                    }
                }
                if (this.memoryUsage > this.memoryCapacity) {
                    this.memoryControl();
                }
            }
            ++n;
        }
    }

    public synchronized Raster[] getTiles(RenderedImage renderedImage, Point[] pointArray) {
        if (this.memoryCapacity == 0L) {
            return null;
        }
        Raster[] rasterArray = new Raster[pointArray.length];
        int n = 0;
        while (n < rasterArray.length) {
            int n2 = pointArray[n].x;
            int n3 = pointArray[n].y;
            Object object = SunCachedTile.hashKey(renderedImage, n2, n3);
            SunCachedTile sunCachedTile = (SunCachedTile)this.cache.get(object);
            if (sunCachedTile == null) {
                rasterArray[n] = null;
                ++this.missCount;
            } else {
                rasterArray[n] = sunCachedTile.getTile();
                ++this.timeStamp;
                sunCachedTile.timeStamp = sunCachedTile.timeStamp;
                if (sunCachedTile != this.first) {
                    if (sunCachedTile == this.last) {
                        this.last = sunCachedTile.previous;
                        this.last.next = null;
                    } else {
                        sunCachedTile.previous.next = sunCachedTile.next;
                        sunCachedTile.next.previous = sunCachedTile.previous;
                    }
                    sunCachedTile.previous = null;
                    sunCachedTile.next = this.first;
                    this.first.previous = sunCachedTile;
                    this.first = sunCachedTile;
                }
                ++this.hitCount;
                if (this.diagnostics) {
                    sunCachedTile.action = 5;
                    this.setChanged();
                    this.notifyObservers(sunCachedTile);
                }
            }
            ++n;
        }
        return rasterArray;
    }

    public synchronized void flush() {
        Enumeration enumeration = this.cache.keys();
        this.hitCount = 0L;
        this.missCount = 0L;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            SunCachedTile sunCachedTile = (SunCachedTile)this.cache.remove(k);
            if (sunCachedTile == null) continue;
            this.memoryUsage -= sunCachedTile.memorySize;
            --this.tileCount;
            if (sunCachedTile == this.first) {
                if (sunCachedTile == this.last) {
                    this.first = null;
                    this.last = null;
                } else {
                    this.first = sunCachedTile.next;
                    this.first.previous = null;
                }
            } else if (sunCachedTile == this.last) {
                this.last = sunCachedTile.previous;
                this.last.next = null;
            } else {
                sunCachedTile.previous.next = sunCachedTile.next;
                sunCachedTile.next.previous = sunCachedTile.previous;
            }
            sunCachedTile.previous = null;
            sunCachedTile.next = null;
            if (!this.diagnostics) continue;
            sunCachedTile.action = 2;
            this.setChanged();
            this.notifyObservers(sunCachedTile);
        }
        if (this.memoryCapacity > 0L) {
            this.cache = new Hashtable(1009, 0.5f);
        }
        if (this.cacheSortedSet != null) {
            this.cacheSortedSet.clear();
            this.cacheSortedSet = Collections.synchronizedSortedSet(new TreeSet(this.comparator));
        }
        this.tileCount = 0L;
        this.timeStamp = 0L;
        this.memoryUsage = 0L;
    }

    public int getTileCapacity() {
        return 0;
    }

    public void setTileCapacity(int n) {
    }

    public long getMemoryCapacity() {
        return this.memoryCapacity;
    }

    public void setMemoryCapacity(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileCache"));
        }
        if (l == 0L) {
            this.flush();
        }
        this.memoryCapacity = l;
        if (this.memoryUsage > l) {
            this.memoryControl();
        }
    }

    public void enableDiagnostics() {
        this.diagnostics = true;
    }

    public void disableDiagnostics() {
        this.diagnostics = false;
    }

    public long getCacheTileCount() {
        return this.tileCount;
    }

    public long getCacheMemoryUsed() {
        return this.memoryUsage;
    }

    public long getCacheHitCount() {
        return this.hitCount;
    }

    public long getCacheMissCount() {
        return this.missCount;
    }

    public void resetCounts() {
        this.hitCount = 0L;
        this.missCount = 0L;
    }

    public void setMemoryThreshold(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileCache"));
        }
        this.memoryThreshold = f;
        this.memoryControl();
    }

    public float getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ": memoryCapacity = " + Long.toHexString(this.memoryCapacity) + " memoryUsage = " + Long.toHexString(this.memoryUsage) + " #tilesInCache = " + Integer.toString(this.cache.size());
    }

    public Object getCachedObject() {
        return this.cache;
    }

    public synchronized void memoryControl() {
        if (this.cacheSortedSet == null) {
            this.standard_memory_control();
        } else {
            this.custom_memory_control();
        }
    }

    private final void standard_memory_control() {
        long l = (long)((float)this.memoryCapacity * this.memoryThreshold);
        while (this.memoryUsage > l && this.last != null) {
            SunCachedTile sunCachedTile = (SunCachedTile)this.cache.get(this.last.key);
            if (sunCachedTile == null) continue;
            sunCachedTile = (SunCachedTile)this.cache.remove(this.last.key);
            this.memoryUsage -= this.last.memorySize;
            --this.tileCount;
            this.last = this.last.previous;
            if (this.last != null) {
                this.last.next.previous = null;
                this.last.next = null;
            } else {
                this.first = null;
            }
            if (!this.diagnostics) continue;
            sunCachedTile.action = 3;
            this.setChanged();
            this.notifyObservers(sunCachedTile);
        }
    }

    private final void custom_memory_control() {
        long l = (long)((float)this.memoryCapacity * this.memoryThreshold);
        Iterator iterator = this.cacheSortedSet.iterator();
        while (iterator.hasNext() && this.memoryUsage > l) {
            SunCachedTile sunCachedTile;
            block12: {
                block10: {
                    block11: {
                        sunCachedTile = (SunCachedTile)iterator.next();
                        this.memoryUsage -= sunCachedTile.memorySize;
                        --this.tileCount;
                        try {
                            iterator.remove();
                        }
                        catch (ConcurrentModificationException concurrentModificationException) {
                            ImagingListener imagingListener = ImageUtil.getImagingListener((RenderingHints)null);
                            imagingListener.errorOccurred(JaiI18N.getString("SunTileCache0"), concurrentModificationException, this, false);
                        }
                        if (sunCachedTile != this.first) break block10;
                        if (sunCachedTile != this.last) break block11;
                        this.first = null;
                        this.last = null;
                        break block12;
                    }
                    this.first = sunCachedTile.next;
                    if (this.first == null) break block12;
                    this.first.previous = null;
                    this.first.next = sunCachedTile.next.next;
                    break block12;
                }
                if (sunCachedTile == this.last) {
                    this.last = sunCachedTile.previous;
                    if (this.last != null) {
                        this.last.next = null;
                        this.last.previous = sunCachedTile.previous.previous;
                    }
                } else {
                    SunCachedTile sunCachedTile2 = this.first.next;
                    while (sunCachedTile2 != null) {
                        if (sunCachedTile2 == sunCachedTile) {
                            if (sunCachedTile2.previous != null) {
                                sunCachedTile2.previous.next = sunCachedTile2.next;
                            }
                            if (sunCachedTile2.next == null) break;
                            sunCachedTile2.next.previous = sunCachedTile2.previous;
                            break;
                        }
                        sunCachedTile2 = sunCachedTile2.next;
                    }
                }
            }
            this.cache.remove(sunCachedTile.key);
            if (!this.diagnostics) continue;
            sunCachedTile.action = 3;
            this.setChanged();
            this.notifyObservers(sunCachedTile);
        }
        if (this.memoryUsage > l) {
            this.standard_memory_control();
        }
    }

    public synchronized void setTileComparator(Comparator comparator) {
        this.comparator = comparator;
        if (this.comparator == null) {
            if (this.cacheSortedSet != null) {
                this.cacheSortedSet.clear();
                this.cacheSortedSet = null;
            }
        } else {
            this.cacheSortedSet = Collections.synchronizedSortedSet(new TreeSet(this.comparator));
            Enumeration enumeration = this.cache.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = this.cache.get(k);
                this.cacheSortedSet.add(v);
            }
        }
    }

    public Comparator getTileComparator() {
        return this.comparator;
    }

    public void dump() {
        System.out.println("first = " + this.first);
        System.out.println("last  = " + this.last);
        Iterator iterator = this.cacheSortedSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            SunCachedTile sunCachedTile = (SunCachedTile)iterator.next();
            System.out.println(n++);
            System.out.println(sunCachedTile);
        }
    }

    void sendExceptionToListener(String string, Exception exception) {
        ImagingListener imagingListener = ImageUtil.getImagingListener((RenderingHints)null);
        imagingListener.errorOccurred(string, exception, this, false);
    }
}

