/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import net.jcip.annotations.ThreadSafe;
import thredds.filesystem.CacheFile;
import thredds.inventory.MFile;

@ThreadSafe
class MFileCached
implements MFile {
    private final String parentDirName;
    private final CacheFile cfile;
    private Object auxInfo;

    MFileCached(String parentDirName, CacheFile cfile) {
        this.parentDirName = parentDirName;
        this.cfile = cfile;
    }

    public long getLastModified() {
        return this.cfile.lastModified;
    }

    public long getLength() {
        return this.cfile.length;
    }

    public boolean isDirectory() {
        return this.cfile.isDirectory;
    }

    public String getPath() {
        return this.parentDirName + "/" + this.cfile.getShortName();
    }

    public String getName() {
        return this.cfile.getShortName();
    }

    public int compareTo(MFile o) {
        return this.getPath().compareTo(o.getPath());
    }

    public Object getAuxInfo() {
        return this.auxInfo;
    }

    public void setAuxInfo(Object auxInfo) {
        this.auxInfo = auxInfo;
    }
}

