/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model.types;

import org.apache.poi.hdf.model.hdftypes.HDFType;
import org.apache.poi.util.BitField;
import org.apache.poi.util.Internal;

@Internal
public abstract class FLDAbstractType
implements HDFType {
    protected byte field_1_chHolder;
    private static BitField ch = new BitField(31);
    private static BitField reserved = new BitField(224);
    protected byte field_2_flt;
    private static BitField fDiffer = new BitField(1);
    private static BitField fZombieEmbed = new BitField(2);
    private static BitField fResultDirty = new BitField(4);
    private static BitField fResultEdited = new BitField(8);
    private static BitField fLocked = new BitField(16);
    private static BitField fPrivateResult = new BitField(32);
    private static BitField fNested = new BitField(64);
    private static BitField fHasSep = new BitField(64);

    protected void fillFields(byte[] data, int offset) {
        this.field_1_chHolder = data[0 + offset];
        this.field_2_flt = data[1 + offset];
    }

    public void serialize(byte[] data, int offset) {
        data[0 + offset] = this.field_1_chHolder;
        data[1 + offset] = this.field_2_flt;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FLD]\n");
        buffer.append("    .chHolder             = ");
        buffer.append(" (").append(this.getChHolder()).append(" )\n");
        buffer.append("         .ch                       = ").append(this.getCh()).append('\n');
        buffer.append("         .reserved                 = ").append(this.getReserved()).append('\n');
        buffer.append("    .flt                  = ");
        buffer.append(" (").append(this.getFlt()).append(" )\n");
        buffer.append("         .fDiffer                  = ").append(this.isFDiffer()).append('\n');
        buffer.append("         .fZombieEmbed             = ").append(this.isFZombieEmbed()).append('\n');
        buffer.append("         .fResultDirty             = ").append(this.isFResultDirty()).append('\n');
        buffer.append("         .fResultEdited            = ").append(this.isFResultEdited()).append('\n');
        buffer.append("         .fLocked                  = ").append(this.isFLocked()).append('\n');
        buffer.append("         .fPrivateResult           = ").append(this.isFPrivateResult()).append('\n');
        buffer.append("         .fNested                  = ").append(this.isFNested()).append('\n');
        buffer.append("         .fHasSep                  = ").append(this.isFHasSep()).append('\n');
        buffer.append("[/FLD]\n");
        return buffer.toString();
    }

    public static int getSize() {
        return 6;
    }

    public byte getChHolder() {
        return this.field_1_chHolder;
    }

    public void setChHolder(byte field_1_chHolder) {
        this.field_1_chHolder = field_1_chHolder;
    }

    public byte getFlt() {
        return this.field_2_flt;
    }

    public void setFlt(byte field_2_flt) {
        this.field_2_flt = field_2_flt;
    }

    public void setCh(byte value) {
        this.field_1_chHolder = (byte)ch.setValue(this.field_1_chHolder, value);
    }

    public byte getCh() {
        return (byte)ch.getValue(this.field_1_chHolder);
    }

    public void setReserved(byte value) {
        this.field_1_chHolder = (byte)reserved.setValue(this.field_1_chHolder, value);
    }

    public byte getReserved() {
        return (byte)reserved.getValue(this.field_1_chHolder);
    }

    public void setFDiffer(boolean value) {
        this.field_2_flt = (byte)fDiffer.setBoolean(this.field_2_flt, value);
    }

    public boolean isFDiffer() {
        return fDiffer.isSet(this.field_2_flt);
    }

    public void setFZombieEmbed(boolean value) {
        this.field_2_flt = (byte)fZombieEmbed.setBoolean(this.field_2_flt, value);
    }

    public boolean isFZombieEmbed() {
        return fZombieEmbed.isSet(this.field_2_flt);
    }

    public void setFResultDirty(boolean value) {
        this.field_2_flt = (byte)fResultDirty.setBoolean(this.field_2_flt, value);
    }

    public boolean isFResultDirty() {
        return fResultDirty.isSet(this.field_2_flt);
    }

    public void setFResultEdited(boolean value) {
        this.field_2_flt = (byte)fResultEdited.setBoolean(this.field_2_flt, value);
    }

    public boolean isFResultEdited() {
        return fResultEdited.isSet(this.field_2_flt);
    }

    public void setFLocked(boolean value) {
        this.field_2_flt = (byte)fLocked.setBoolean(this.field_2_flt, value);
    }

    public boolean isFLocked() {
        return fLocked.isSet(this.field_2_flt);
    }

    public void setFPrivateResult(boolean value) {
        this.field_2_flt = (byte)fPrivateResult.setBoolean(this.field_2_flt, value);
    }

    public boolean isFPrivateResult() {
        return fPrivateResult.isSet(this.field_2_flt);
    }

    public void setFNested(boolean value) {
        this.field_2_flt = (byte)fNested.setBoolean(this.field_2_flt, value);
    }

    public boolean isFNested() {
        return fNested.isSet(this.field_2_flt);
    }

    public void setFHasSep(boolean value) {
        this.field_2_flt = (byte)fHasSep.setBoolean(this.field_2_flt, value);
    }

    public boolean isFHasSep() {
        return fHasSep.isSet(this.field_2_flt);
    }
}

