/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.AbstractMediaHeaderBox;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CroppedTrack
extends AbstractTrack {
    Track origTrack;
    private int fromSample;
    private int toSample;
    private long[] syncSampleArray;

    public CroppedTrack(Track origTrack, long fromSample, long toSample) {
        this.origTrack = origTrack;
        assert (fromSample <= Integer.MAX_VALUE);
        assert (toSample <= Integer.MAX_VALUE);
        this.fromSample = (int)fromSample;
        this.toSample = (int)toSample;
    }

    @Override
    public List<ByteBuffer> getSamples() {
        return this.origTrack.getSamples().subList(this.fromSample, this.toSample);
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.origTrack.getSampleDescriptionBox();
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        if (this.origTrack.getDecodingTimeEntries() != null && !this.origTrack.getDecodingTimeEntries().isEmpty()) {
            long[] decodingTimes = TimeToSampleBox.blowupTimeToSamples(this.origTrack.getDecodingTimeEntries());
            long[] nuDecodingTimes = new long[this.toSample - this.fromSample];
            System.arraycopy(decodingTimes, this.fromSample, nuDecodingTimes, 0, this.toSample - this.fromSample);
            LinkedList<TimeToSampleBox.Entry> returnDecodingEntries = new LinkedList<TimeToSampleBox.Entry>();
            long[] lArray = nuDecodingTimes;
            int n = nuDecodingTimes.length;
            int n2 = 0;
            while (n2 < n) {
                TimeToSampleBox.Entry e;
                long nuDecodingTime = lArray[n2];
                if (returnDecodingEntries.isEmpty() || returnDecodingEntries.getLast().getDelta() != nuDecodingTime) {
                    e = new TimeToSampleBox.Entry(1L, nuDecodingTime);
                    returnDecodingEntries.add(e);
                } else {
                    e = returnDecodingEntries.getLast();
                    e.setCount(e.getCount() + 1L);
                }
                ++n2;
            }
            return returnDecodingEntries;
        }
        return null;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        if (this.origTrack.getCompositionTimeEntries() != null && !this.origTrack.getCompositionTimeEntries().isEmpty()) {
            int[] compositionTime = CompositionTimeToSample.blowupCompositionTimes(this.origTrack.getCompositionTimeEntries());
            int[] nuCompositionTimes = new int[this.toSample - this.fromSample];
            System.arraycopy(compositionTime, this.fromSample, nuCompositionTimes, 0, this.toSample - this.fromSample);
            LinkedList<CompositionTimeToSample.Entry> returnDecodingEntries = new LinkedList<CompositionTimeToSample.Entry>();
            int[] nArray = nuCompositionTimes;
            int n = nuCompositionTimes.length;
            int n2 = 0;
            while (n2 < n) {
                CompositionTimeToSample.Entry e;
                int nuDecodingTime = nArray[n2];
                if (returnDecodingEntries.isEmpty() || returnDecodingEntries.getLast().getOffset() != nuDecodingTime) {
                    e = new CompositionTimeToSample.Entry(1, nuDecodingTime);
                    returnDecodingEntries.add(e);
                } else {
                    e = returnDecodingEntries.getLast();
                    e.setCount(e.getCount() + 1);
                }
                ++n2;
            }
            return returnDecodingEntries;
        }
        return null;
    }

    @Override
    public synchronized long[] getSyncSamples() {
        if (this.syncSampleArray == null) {
            if (this.origTrack.getSyncSamples() != null && this.origTrack.getSyncSamples().length > 0) {
                LinkedList<Long> syncSamples = new LinkedList<Long>();
                long[] lArray = this.origTrack.getSyncSamples();
                int n = lArray.length;
                int n2 = 0;
                while (n2 < n) {
                    long l = lArray[n2];
                    if (l >= (long)this.fromSample && l < (long)this.toSample) {
                        syncSamples.add(l - (long)this.fromSample);
                    }
                    ++n2;
                }
                this.syncSampleArray = new long[syncSamples.size()];
                int i = 0;
                while (i < this.syncSampleArray.length) {
                    this.syncSampleArray[i] = (Long)syncSamples.get(i);
                    ++i;
                }
                return this.syncSampleArray;
            }
            return null;
        }
        return this.syncSampleArray;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        if (this.origTrack.getSampleDependencies() != null && !this.origTrack.getSampleDependencies().isEmpty()) {
            return this.origTrack.getSampleDependencies().subList(this.fromSample, this.toSample);
        }
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.origTrack.getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.origTrack.getHandler();
    }

    @Override
    public AbstractMediaHeaderBox getMediaHeaderBox() {
        return this.origTrack.getMediaHeaderBox();
    }
}

