/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.pdfread;

import at.ac.tuwien.dbai.pdfwrap.model.document.CharSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.CompositeSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.ImageSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.LineSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.RectSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextFragment;
import at.ac.tuwien.dbai.pdfwrap.pdfread.PDFPage;
import at.ac.tuwien.dbai.pdfwrap.utils.SegmentUtils;
import at.ac.tuwien.dbai.pdfwrap.utils.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.encryption.PDEncryptionDictionary;
import org.apache.pdfbox.pdmodel.encryption.PDStandardEncryption;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFStreamEngine;
import org.apache.pdfbox.util.ResourceLoader;
import org.apache.pdfbox.util.TextPosition;

public class PDFObjectExtractor
extends PDFStreamEngine {
    public static final byte[] SPACE_BYTES = new byte[]{32};
    private Graphics2D graphics;
    protected Dimension pageSize;
    protected PDPage page;
    private List lineSubPaths = new ArrayList();
    private GeneralPath linePath = new GeneralPath();
    private Color strokingColor = Color.BLACK;
    private Color nonStrokingColor = Color.BLACK;
    private Color currentColor = Color.black;
    private List<ImageSegment> imageList = new ArrayList<ImageSegment>();
    private List<TextFragment> fragmentList = new ArrayList<TextFragment>();
    private List<LineSegment> lineList = new ArrayList<LineSegment>();
    private List<RectSegment> rectList = new ArrayList<RectSegment>();
    private List<CharSegment> charList = new ArrayList<CharSegment>();
    private List<LineSegment> currentLines = new ArrayList<LineSegment>();
    private List<RectSegment> currentRects = new ArrayList<RectSegment>();
    private List<LineSegment> linesToAdd = new ArrayList<LineSegment>();
    private List<RectSegment> rectsToAdd = new ArrayList<RectSegment>();
    private boolean pathContainsCurve = false;
    private float pathBeginX;
    private float pathBeginY;
    private boolean pathBeginSet = false;
    private boolean pathClosed = false;
    private GenericSegment clipBounds = null;
    private Stack clipBoundsStack = new Stack();
    private float currentX = -1.0f;
    private float currentY = -1.0f;
    private boolean newPath = false;
    private CompositeSegment lastStringFragment = null;
    private boolean newTextFragment = false;
    private boolean mergeAcrossTextInstructions = false;
    private int currentPageNo = 0;
    private int startPage = 1;
    private int endPage = Integer.MAX_VALUE;
    private PDOutlineItem startBookmark = null;
    private int startBookmarkPageNumber = -1;
    private PDOutlineItem endBookmark = null;
    private int endBookmarkPageNumber = -1;
    private PDDocument document;
    private boolean suppressDuplicateOverlappingText = true;
    private boolean shouldSeparateByBeads = true;
    private boolean sortByPosition = false;
    private List pageArticles = null;
    protected Vector charactersByArticle = new Vector();
    private Map characterListMapping = new HashMap();
    private String lineSeparator = System.getProperty("line.separator");
    private String pageSeparator = System.getProperty("line.separator");
    private String wordSeparator = " ";

    public PDFObjectExtractor() throws IOException {
        super(ResourceLoader.loadProperties((String)"Resources/PDFObjectExtractor.properties", (boolean)false));
    }

    public void drawPage(Graphics g, PDPage p, Dimension pageDimension) throws IOException {
        this.graphics = (Graphics2D)g;
        this.page = p;
        this.pageSize = pageDimension;
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PDResources resources = this.page.findResources();
        this.processStream(this.page, resources, this.page.getContents().getStream());
        List annotations = this.page.getAnnotations();
        int i = 0;
        while (i < annotations.size()) {
            PDAnnotation annot = (PDAnnotation)annotations.get(i);
            PDRectangle rect = annot.getRectangle();
            String appearanceName = annot.getAppearanceStream();
            PDAppearanceDictionary appearDictionary = annot.getAppearance();
            if (appearDictionary != null) {
                Map appearanceMap;
                PDAppearanceStream appearance;
                if (appearanceName == null) {
                    appearanceName = "default";
                }
                if ((appearance = (PDAppearanceStream)(appearanceMap = appearDictionary.getNormalAppearance()).get(appearanceName)) != null) {
                    g.translate((int)rect.getLowerLeftX(), (int)(-rect.getLowerLeftY()));
                    this.processSubStream(this.page, appearance.getResources(), appearance.getStream());
                    g.translate((int)(-rect.getLowerLeftX()), (int)rect.getLowerLeftY());
                }
            }
            ++i;
        }
    }

    public void showString(byte[] string) throws IOException {
        float horizontalScaling;
        ArrayList<CharSegment> charactersToAdd = new ArrayList<CharSegment>();
        float[] individualWidths = new float[2048];
        float spaceWidth = 0.0f;
        float spacing = 0.0f;
        StringBuffer stringResult = new StringBuffer(string.length);
        float characterHorizontalDisplacement = 0.0f;
        float characterVerticalDisplacement = 0.0f;
        float spaceDisplacement = 0.0f;
        float fontSize = this.getGraphicsState().getTextState().getFontSize();
        float verticalScaling = horizontalScaling = this.getGraphicsState().getTextState().getHorizontalScalingPercent() / 100.0f;
        float rise = this.getGraphicsState().getTextState().getRise();
        float wordSpacing = this.getGraphicsState().getTextState().getWordSpacing();
        float characterSpacing = this.getGraphicsState().getTextState().getCharacterSpacing();
        float wordSpacingDisplacement = 0.0f;
        PDFont font = this.getGraphicsState().getTextState().getFont();
        float glyphSpaceToTextSpaceFactor = 1.0f / font.getFontMatrix().getValue(0, 0);
        float averageWidth = font.getAverageFontWidth();
        Matrix initialMatrix = new Matrix();
        initialMatrix.setValue(0, 0, 1.0f);
        initialMatrix.setValue(0, 1, 0.0f);
        initialMatrix.setValue(0, 2, 0.0f);
        initialMatrix.setValue(1, 0, 0.0f);
        initialMatrix.setValue(1, 1, 1.0f);
        initialMatrix.setValue(1, 2, 0.0f);
        initialMatrix.setValue(2, 0, 0.0f);
        initialMatrix.setValue(2, 1, rise);
        initialMatrix.setValue(2, 2, 1.0f);
        int codeLength = 1;
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        spaceDisplacement = font.getFontWidth(SPACE_BYTES, 0, 1) / glyphSpaceToTextSpaceFactor;
        if (spaceDisplacement == 0.0f) {
            spaceDisplacement = averageWidth / glyphSpaceToTextSpaceFactor;
            spaceDisplacement *= 0.8f;
        }
        int pageRotation = this.page.findRotation();
        Matrix trm = initialMatrix.multiply(this.getTextMatrix()).multiply(ctm);
        float x = trm.getValue(2, 0);
        float y = trm.getValue(2, 1);
        if (pageRotation == 0) {
            trm.setValue(2, 1, -y + this.page.findMediaBox().getHeight());
        } else if (pageRotation == 90 || pageRotation == -270) {
            trm.setValue(2, 0, y);
            trm.setValue(2, 1, x);
        } else if (pageRotation == 270 || pageRotation == -90) {
            trm.setValue(2, 0, -y + this.page.findMediaBox().getHeight());
            trm.setValue(2, 1, x);
        }
        float xScale = trm.getXScale();
        float yScale = trm.getYScale();
        float xPos = trm.getXPosition();
        float yPos = trm.getYPosition();
        spaceWidth = spaceDisplacement * xScale * fontSize;
        wordSpacingDisplacement = wordSpacing * xScale * fontSize;
        float totalStringWidth = 0.0f;
        float xPosBefore2 = this.getTextMatrix().getXPosition();
        float yPosBefore2 = this.getTextMatrix().getYPosition();
        float xTrans = 0.0f;
        float yTrans = 0.0f;
        if (pageRotation == 0) {
            xTrans = xPos - xPosBefore2;
            yTrans = yPos - yPosBefore2;
        } else if (pageRotation == 90 || pageRotation == -270) {
            xTrans = xPos - yPosBefore2;
            yTrans = yPos - xPosBefore2;
        } else if (pageRotation == 270 || pageRotation == -90) {
            yTrans = xPos - yPosBefore2;
            xTrans = yPos - xPosBefore2;
        }
        int i = 0;
        while (i < string.length) {
            CharSegment thisChar;
            codeLength = 1;
            String c = font.encode(string, i, codeLength);
            if (c == null && i + 1 < string.length) {
                c = font.encode(string, i, ++codeLength);
            }
            characterHorizontalDisplacement = font.getFontWidth(string, i, codeLength) / glyphSpaceToTextSpaceFactor;
            characterVerticalDisplacement = Math.max(characterVerticalDisplacement, font.getFontHeight(string, i, codeLength) / glyphSpaceToTextSpaceFactor);
            spacing = string[i] == 32 && c != null && c.equals(" ") ? wordSpacing + characterSpacing : characterSpacing;
            float adjustment = 0.0f;
            float ty = 0.0f;
            float tx = ((characterHorizontalDisplacement - adjustment / glyphSpaceToTextSpaceFactor) * fontSize + spacing) * horizontalScaling;
            float tx2 = (characterHorizontalDisplacement - adjustment / glyphSpaceToTextSpaceFactor) * fontSize * horizontalScaling;
            tx2 = characterHorizontalDisplacement * fontSize * horizontalScaling;
            Matrix td = new Matrix();
            td.setValue(2, 0, tx);
            td.setValue(2, 1, ty);
            Matrix td2 = new Matrix();
            td2.setValue(2, 0, tx2);
            td2.setValue(2, 1, ty);
            float xPosBefore = this.getTextMatrix().getXPosition();
            float yPosBefore = this.getTextMatrix().getYPosition();
            Matrix textMatrix2 = (Matrix)this.getTextMatrix().clone();
            this.setTextMatrix(td.multiply(this.getTextMatrix()));
            textMatrix2 = td2.multiply(textMatrix2);
            float width = 0.0f;
            float width2 = 0.0f;
            if (pageRotation == 0) {
                width = this.getTextMatrix().getXPosition() - xPosBefore;
                width2 = textMatrix2.getXPosition() - xPosBefore;
            } else if (pageRotation == 90 || pageRotation == -270) {
                width = this.getTextMatrix().getYPosition() - yPosBefore;
                width2 = textMatrix2.getYPosition() - yPosBefore;
            } else if (pageRotation == 270 || pageRotation == -90) {
                width = yPosBefore - this.getTextMatrix().getYPosition();
                width2 = yPosBefore - textMatrix2.getYPosition();
            }
            if (c != null) {
                float widthOfEachCharacterForCode = width / (float)c.length();
                int j = 0;
                while (j < c.length()) {
                    if (stringResult.length() + j < individualWidths.length) {
                        c.equals("-");
                        individualWidths[stringResult.length() + j] = widthOfEachCharacterForCode;
                    }
                    ++j;
                }
            }
            totalStringWidth += width;
            if (pageRotation == 0) {
                thisChar = new CharSegment(xPosBefore + xTrans, xPosBefore + width2 + xTrans, yPos, yPos + fontSize * yScale, c, font, fontSize * yScale);
                charactersToAdd.add(thisChar);
            } else {
                thisChar = new CharSegment(yPosBefore + xTrans, yPosBefore + width2 + xTrans, yPos, yPos + fontSize * xScale, c, font, fontSize * xScale);
                if (pageRotation == 270 || pageRotation == 90) {
                    charactersToAdd.add(thisChar);
                } else {
                    charactersToAdd.add(thisChar);
                }
            }
            stringResult.append(c);
            i += codeLength;
        }
        float totalStringHeight = characterVerticalDisplacement * fontSize * yScale;
        String resultingString = stringResult.toString();
        if (individualWidths.length != resultingString.length()) {
            float[] tmp = new float[resultingString.length()];
            System.arraycopy(individualWidths, 0, tmp, 0, Math.min(individualWidths.length, resultingString.length()));
            individualWidths = tmp;
            resultingString.equals("- ");
        }
        float charX1 = xPos;
        float charX2 = xPos + totalStringWidth;
        float charY1 = yPos;
        float charY2 = yPos + fontSize * yScale;
        String c = stringResult.toString();
        CompositeSegment thisStringFragment = new CompositeSegment();
        thisStringFragment.setText(stringResult.toString());
        thisStringFragment.getItems().addAll(charactersToAdd);
        thisStringFragment.findBoundingBox();
        float tolerance = fontSize * yScale * 0.05f;
        if (!(this.lastStringFragment != null && thisStringFragment.getText().equals(this.lastStringFragment.getText()) && Utils.within(thisStringFragment.getX1(), this.lastStringFragment.getX1(), tolerance) && Utils.within(thisStringFragment.getX2(), this.lastStringFragment.getX2(), tolerance) && Utils.within(thisStringFragment.getY1(), this.lastStringFragment.getY1(), tolerance) && Utils.within(thisStringFragment.getY2(), this.lastStringFragment.getY2(), tolerance))) {
            for (CharSegment thisChar : charactersToAdd) {
                if (pageRotation == 270 || pageRotation == -90) {
                    this.addCharacter(thisChar, true);
                    continue;
                }
                this.addCharacter(thisChar, false);
            }
        }
        this.lastStringFragment = thisStringFragment;
    }

    public void addCharacter(CharSegment thisChar, boolean reverseCoords) {
        boolean concatenate = false;
        if (this.fragmentList.size() > 0) {
            TextFragment lastFragment = this.fragmentList.get(this.fragmentList.size() - 1);
            CharSegment lastChar = (CharSegment)lastFragment.getItems().get(lastFragment.getItems().size() - 1);
            boolean overprint = false;
            float tolerance = thisChar.getFontSize() * 0.05f;
            if (lastChar.getText().equals(thisChar.getText()) && lastChar.getFontSize() == thisChar.getFontSize() && Utils.within(lastChar.getX1(), thisChar.getX1(), tolerance) && Utils.within(lastChar.getX2(), thisChar.getX2(), tolerance) && Utils.within(lastChar.getY1(), thisChar.getY1(), tolerance) && Utils.within(lastChar.getY2(), thisChar.getY2(), tolerance) && lastChar.getFontName() == thisChar.getFontName()) {
                overprint = true;
            }
            if (overprint) {
                lastChar.setOverprint(true);
            } else {
                float spacing;
                float tcWidth;
                float lfWidth;
                boolean sameLine = Utils.within(lastFragment.getY1(), thisChar.getY1(), tolerance);
                if (reverseCoords) {
                    lfWidth = lastFragment.getWidth();
                    tcWidth = thisChar.getWidth();
                    lastFragment.setX1(0.0f - lastFragment.getX1());
                    lastFragment.setX2(lastFragment.getX1() + lfWidth);
                    thisChar.setX1(0.0f - thisChar.getX1());
                    thisChar.setX2(thisChar.getX1() + tcWidth);
                }
                boolean sameWord = (double)(spacing = thisChar.getX1() - lastFragment.getX2()) < (double)thisChar.getWidth() * 0.25 && (double)spacing > 0.0 - (double)thisChar.getWidth() * 1.0;
                concatenate = sameLine && sameWord;
                if (this.mergeAcrossTextInstructions) {
                    boolean bl = concatenate = !this.newTextFragment;
                }
                if (concatenate) {
                    lastFragment.setX2(thisChar.getX2());
                    lastFragment.setText(lastFragment.getText().concat(thisChar.getText()));
                    lastFragment.getItems().add(thisChar);
                }
                if (reverseCoords) {
                    lfWidth = lastFragment.getWidth();
                    tcWidth = thisChar.getWidth();
                    lastFragment.setX1(0.0f - lastFragment.getX1());
                    lastFragment.setX2(lastFragment.getX1() + lfWidth);
                    thisChar.setX1(0.0f - thisChar.getX1());
                    thisChar.setX2(thisChar.getX1() + tcWidth);
                }
                if (!concatenate) {
                    TextFragment newFrag = new TextFragment(thisChar);
                    this.fragmentList.add(newFrag);
                }
            }
        } else {
            TextFragment newFrag = new TextFragment(thisChar);
            this.fragmentList.add(newFrag);
        }
        if (!thisChar.getText().equals(" ")) {
            this.charList.add(thisChar);
        }
        this.setNewTextFragment(false);
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public PDPage getPage() {
        return this.page;
    }

    public Dimension getPageSize() {
        return this.pageSize;
    }

    public double fixY(double x, double y) {
        return this.pageSize.getHeight() - y;
    }

    public GeneralPath getLinePath() {
        return this.linePath;
    }

    public void setLinePath(GeneralPath newLinePath) {
        if (this.linePath == null || this.linePath.getCurrentPoint() == null) {
            this.linePath = newLinePath;
        } else {
            this.linePath.append(newLinePath, false);
        }
    }

    public List getLineSubPaths() {
        return this.lineSubPaths;
    }

    public void setLineSubPaths(List newLineSubPaths) {
        this.lineSubPaths = newLineSubPaths;
    }

    public void fillPath(int windingRule) throws IOException {
        this.graphics.setColor(this.getGraphicsState().getNonStrokingColor().getJavaColor());
        this.getLinePath().setWindingRule(windingRule);
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        List subPaths = this.getLineSubPaths();
        int i = 0;
        while (i < subPaths.size()) {
            GeneralPath subPath = (GeneralPath)subPaths.get(i);
            if (subPath.getCurrentPoint() != null) {
                subPath.closePath();
            }
            this.graphics.fill(subPath);
            ++i;
        }
        this.graphics.fill(this.getLinePath());
        this.getLinePath().reset();
    }

    public void setStroke(BasicStroke newStroke) {
        this.getGraphics().setStroke(newStroke);
    }

    public void StrokePath() throws IOException {
        this.graphics.setColor(this.getGraphicsState().getStrokingColor().getJavaColor());
        List subPaths = this.getLineSubPaths();
        int i = 0;
        while (i < subPaths.size()) {
            GeneralPath subPath = (GeneralPath)subPaths.get(i);
            this.graphics.draw(subPath);
            ++i;
        }
        subPaths.clear();
        GeneralPath path = this.getLinePath();
        this.graphics.draw(path);
        path.reset();
    }

    public Color getNonStrokingColor() {
        return this.nonStrokingColor;
    }

    public void setNonStrokingColor(Color newNonStrokingColor) {
        this.currentColor = this.nonStrokingColor = newNonStrokingColor;
    }

    public Color getStrokingColor() {
        return this.strokingColor;
    }

    public void setStrokingColor(Color newStrokingColor) {
        this.currentColor = this.strokingColor = newStrokingColor;
    }

    public void ColorChanged(Boolean bStroking) throws IOException {
    }

    public Point2D.Double TransformedPoint(double x, double y) {
        double scaleX = 0.0;
        double scaleY = 0.0;
        double transX = 0.0;
        double transY = 0.0;
        double finalX = x;
        double finalY = y;
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        AffineTransform at = ctm.createAffineTransform();
        scaleX = at.getScaleX();
        scaleY = at.getScaleY();
        transX = at.getTranslateX();
        transY = at.getTranslateY();
        Point2D.Double Pscale = this.ScaledPoint(finalX, finalY, scaleX, scaleY);
        finalX = ((Point2D)Pscale).getX();
        finalY = ((Point2D)Pscale).getY();
        finalY += transY;
        finalY = this.fixY(finalX += transX, finalY);
        return new Point2D.Double(finalX, finalY -= 0.6);
    }

    public Point2D.Double ScaledPoint(double x, double y, double scaleX, double scaleY) {
        double finalX = 0.0;
        double finalY = 0.0;
        if (scaleX > 0.0) {
            finalX = x * scaleX;
        }
        if (scaleY > 0.0) {
            finalY = y * scaleY;
        }
        return new Point2D.Double(finalX, finalY);
    }

    public Point2D.Double ScaledPoint(double x, double y) {
        double scaleX = 0.0;
        double scaleY = 0.0;
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        AffineTransform at = ctm.createAffineTransform();
        scaleX = at.getScaleX();
        scaleY = at.getScaleY();
        return this.ScaledPoint(x, y, scaleX, scaleY);
    }

    protected void startPage(PDPage page) throws IOException {
    }

    protected void endPage(PDPage page) throws IOException {
    }

    public void setStartPage(int startPageValue) {
        this.startPage = startPageValue;
    }

    public void setEndPage(int endPageValue) {
        this.endPage = endPageValue;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public BufferedImage pageImage(PDDocument doc, int pageNo) throws IOException {
        Iterator imageIter;
        List allPages;
        PDPage page;
        PDResources resources;
        Map images;
        PDStandardEncryption stdEncryption;
        PDEncryptionDictionary encDictionary = doc.getEncryptionDictionary();
        if (encDictionary instanceof PDStandardEncryption && !doc.wasDecryptedWithOwnerPassword() && !(stdEncryption = (PDStandardEncryption)encDictionary).canExtractContent()) {
            throw new IOException("You do not have permission to extract text");
        }
        this.currentPageNo = 1;
        this.document = doc;
        if (this.document.isEncrypted()) {
            try {
                this.document.decrypt("");
            }
            catch (CryptographyException e) {
                throw new IOException("Error decrypting document, details: " + e.getMessage());
            }
            catch (InvalidPasswordException e) {
                throw new IOException("Error: document is encrypted");
            }
        }
        if ((images = (resources = (page = (PDPage)(allPages = this.document.getDocumentCatalog().getAllPages()).get(pageNo)).getResources()).getImages()) != null && (imageIter = images.keySet().iterator()).hasNext()) {
            String key = (String)imageIter.next();
            PDXObjectImage image = (PDXObjectImage)images.get(key);
            BufferedImage retVal = image.getRGBImage();
            return retVal;
        }
        throw new IOException("No images found");
    }

    public List<PDFPage> findObjects(PDDocument doc) throws IOException {
        PDStandardEncryption stdEncryption;
        PDEncryptionDictionary encDictionary = doc.getEncryptionDictionary();
        if (encDictionary instanceof PDStandardEncryption && !doc.wasDecryptedWithOwnerPassword() && !(stdEncryption = (PDStandardEncryption)encDictionary).canExtractContent()) {
            throw new IOException("You do not have permission to extract text");
        }
        this.currentPageNo = 1;
        this.document = doc;
        if (this.document.isEncrypted()) {
            try {
                this.document.decrypt("");
            }
            catch (CryptographyException e) {
                throw new IOException("Error decrypting document, details: " + e.getMessage());
            }
            catch (InvalidPasswordException e) {
                throw new IOException("Error: document is encrypted");
            }
        }
        List allPages = this.document.getDocumentCatalog().getAllPages();
        int numPages = allPages.size();
        if (this.startPage < 0) {
            this.startPage = numPages + this.startPage;
        }
        if (this.endPage < 0) {
            this.endPage = numPages + this.endPage;
        }
        if (this.startPage > this.endPage) {
            int tempVar = this.startPage;
            this.startPage = this.endPage;
            this.endPage = tempVar;
        }
        return this.processPages(allPages);
    }

    protected List<PDFPage> processPages(List pages) throws IOException {
        ArrayList<PDFPage> retVal = new ArrayList<PDFPage>();
        if (this.startBookmark != null) {
            this.startBookmarkPageNumber = this.currentPageNumber(this.startBookmark, pages);
        }
        if (this.endBookmark != null) {
            this.endBookmarkPageNumber = this.currentPageNumber(this.endBookmark, pages);
        }
        if (this.startBookmarkPageNumber == -1 && this.startBookmark != null && this.endBookmarkPageNumber == -1 && this.endBookmark != null && this.startBookmark.getCOSObject() == this.endBookmark.getCOSObject()) {
            this.startBookmarkPageNumber = 0;
            this.endBookmarkPageNumber = 0;
        }
        Iterator pageIter = pages.iterator();
        while (pageIter.hasNext()) {
            COSStream contents;
            GenericSegment pageDim;
            PDPage nextPage;
            this.page = nextPage = (PDPage)pageIter.next();
            try {
                System.out.println("Current page no: " + this.currentPageNo);
                if (this.page.getArtBox() != null) {
                    System.out.println("Art Box: " + new GenericSegment(this.page.getArtBox()));
                }
                if (this.page.getBleedBox() != null) {
                    System.out.println("Bleed Box: " + new GenericSegment(this.page.getBleedBox()));
                }
                if (this.page.getCropBox() != null) {
                    System.out.println("Crop Box: " + new GenericSegment(this.page.getCropBox()));
                }
                if (this.page.getMediaBox() != null) {
                    System.out.println("Media Box: " + new GenericSegment(this.page.getMediaBox()));
                }
                if (this.page.getTrimBox() != null) {
                    System.out.println("Trim Box: " + new GenericSegment(this.page.getTrimBox()));
                }
                if (this.page.getMediaBox() == null) {
                    if (this.page.getBleedBox() != null) {
                        this.page.setMediaBox(this.page.getBleedBox());
                    } else if (this.page.getCropBox() != null) {
                        this.page.setMediaBox(this.page.getCropBox());
                    } else if (this.page.getTrimBox() != null) {
                        this.page.setMediaBox(this.page.getTrimBox());
                    } else if (this.page.getArtBox() != null) {
                        this.page.setMediaBox(this.page.getArtBox());
                    }
                }
            }
            catch (NullPointerException npe) {
                System.out.println("at least one of the boxes is missing!");
                npe.printStackTrace();
            }
            int pageRotation = this.page.findRotation();
            System.out.println("Page rotation: " + pageRotation);
            PDStream contentStream = nextPage.getContents();
            if (this.page.getMediaBox() != null && this.page.getTrimBox() != null) {
                GenericSegment mediaBox = new GenericSegment(this.page.getMediaBox());
                GenericSegment trimBox = new GenericSegment(this.page.getTrimBox());
                pageDim = new GenericSegment(trimBox.getX1(), trimBox.getX2(), trimBox.getY1(), trimBox.getY2());
            } else if (this.page.getMediaBox() != null) {
                pageDim = new GenericSegment(this.page.getMediaBox());
            } else if (this.page.getArtBox() != null) {
                pageDim = new GenericSegment(this.page.getArtBox());
            } else {
                throw new IOException("Cannot find a suitable page bounding box!");
            }
            System.out.println("Processing page: " + this.currentPageNo);
            if (!(this.currentPageNo < this.startPage || this.currentPageNo > this.endPage || this.startBookmarkPageNumber != -1 && this.currentPageNo < this.startBookmarkPageNumber || this.endBookmarkPageNumber != -1 && this.currentPageNo > this.endBookmarkPageNumber)) {
                if (contentStream == null) continue;
                contents = contentStream.getStream();
                PDFPage thePage = this.processPage(nextPage, contents);
                retVal.add(thePage);
                continue;
            }
            if (contentStream == null) continue;
            contents = contentStream.getStream();
            ++this.currentPageNo;
        }
        return retVal;
    }

    private int currentPageNumber(PDOutlineItem bookmark, List allPages) throws IOException {
        int pageNumber = -1;
        PDPage page = bookmark.findDestinationPage(this.document);
        if (page != null) {
            pageNumber = allPages.indexOf(page) + 1;
        }
        return pageNumber;
    }

    protected PDFPage processPage(PDPage page, COSStream content) throws IOException {
        this.clipBounds = new GenericSegment(Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY);
        this.page = page;
        PDResources resources = page.findResources();
        PDFPage thisPage = new PDFPage();
        GenericSegment pageDim = page.getCropBox() != null ? new GenericSegment(page.getCropBox()) : new GenericSegment(page.findMediaBox());
        this.pageSize = page.findMediaBox().createDimension();
        if (page.getRotation() == null) {
            thisPage.setRotation(0);
        } else {
            thisPage.setRotation(page.getRotation());
        }
        int scaling = 2;
        PDRectangle mBox = page.findMediaBox();
        int width = (int)mBox.getWidth();
        int height = (int)mBox.getHeight();
        Dimension pageDimension = new Dimension(width, height);
        BufferedImage retval = new BufferedImage(width * scaling, height * scaling, 13);
        this.graphics = (Graphics2D)retval.getGraphics();
        this.graphics.setColor(Color.WHITE);
        this.graphics.fillRect(0, 0, width * scaling, height * scaling);
        this.graphics.scale(scaling, scaling);
        this.imageList = new ArrayList<ImageSegment>();
        this.lineList = new ArrayList<LineSegment>();
        this.rectList = new ArrayList<RectSegment>();
        this.fragmentList = new ArrayList<TextFragment>();
        this.charList = new ArrayList<CharSegment>();
        thisPage.setX1(pageDim.getX1());
        thisPage.setX2(pageDim.getX2());
        thisPage.setY1(pageDim.getY1());
        thisPage.setY2(pageDim.getY2());
        List pageItems = thisPage.getItems();
        long start = System.currentTimeMillis();
        ++this.currentPageNo;
        this.startPage(page);
        this.pageArticles = page.getThreadBeads();
        int numberOfArticleSections = 1 + this.pageArticles.size() * 2;
        if (!this.shouldSeparateByBeads) {
            numberOfArticleSections = 1;
        }
        int originalSize = this.charactersByArticle.size();
        this.charactersByArticle.setSize(numberOfArticleSections);
        int i = 0;
        while (i < numberOfArticleSections) {
            if (numberOfArticleSections < originalSize) {
                ((List)this.charactersByArticle.get(i)).clear();
            } else {
                this.charactersByArticle.set(i, new ArrayList());
            }
            ++i;
        }
        this.characterListMapping.clear();
        long startProcess = System.currentTimeMillis();
        this.processStream(page, page.findResources(), content);
        long stopProcess = System.currentTimeMillis();
        long startFlush = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < this.charactersByArticle.size()) {
            List textList = (List)this.charactersByArticle.get(i2);
            for (TextPosition thisPos : textList) {
                pageItems.add(new TextFragment(thisPos, pageDim));
                System.out.println("text fragment by article found");
            }
            ++i2;
        }
        thisPage.getItems().addAll(this.fragmentList);
        thisPage.getItems().addAll(this.charList);
        if (page.getCropBox() != null) {
            GenericSegment cropBox = new GenericSegment(page.getCropBox());
            float new_Y2 = page.getMediaBox().getHeight() - cropBox.getY1();
            float new_Y1 = page.getMediaBox().getHeight() - cropBox.getY2();
            cropBox.setY1(new_Y1);
            cropBox.setY2(new_Y2);
            if (thisPage.getRotation() == 270 || thisPage.getRotation() == -90) {
                cropBox = new GenericSegment(cropBox.getX1(), cropBox.getX1() + cropBox.getHeight(), cropBox.getY1(), cropBox.getY1() + cropBox.getWidth());
                cropBox = new GenericSegment(cropBox.getX1(), cropBox.getX1() + cropBox.getHeight(), cropBox.getY1(), cropBox.getY1() + cropBox.getWidth());
                cropBox = new GenericSegment(cropBox.getX1(), cropBox.getX1() + cropBox.getHeight(), cropBox.getY1(), cropBox.getY1() + cropBox.getWidth());
            } else if (thisPage.getRotation() == 90 || thisPage.getRotation() == -270) {
                cropBox = new GenericSegment(cropBox.getX1(), cropBox.getX1() + cropBox.getHeight(), cropBox.getY1(), cropBox.getY1() + cropBox.getWidth());
            }
            int n = 0;
            while (n < pageItems.size()) {
                GenericSegment gs = (GenericSegment)pageItems.get(n);
                if (!SegmentUtils.intersects(gs, cropBox)) {
                    pageItems.remove(gs);
                    --n;
                }
                ++n;
            }
        }
        if (thisPage.getRotation() == 270 || thisPage.getRotation() == -90) {
            thisPage.reverseYCoordinatesPDF();
            thisPage.setBoundingBox(new float[]{thisPage.getY1(), thisPage.getY2(), thisPage.getY2() - thisPage.getWidth(), thisPage.getY2()});
            thisPage.normalizeCoordinates();
            thisPage.reverseXCoordinates();
        }
        pageItems.addAll(this.rectList);
        pageItems.addAll(this.lineList);
        pageItems.addAll(this.imageList);
        thisPage.normalizeCoordinates();
        thisPage.reverseYCoordinatesPDF();
        long stopFlush = System.currentTimeMillis();
        this.endPage(page);
        long stop = System.currentTimeMillis();
        return thisPage;
    }

    public boolean isNewTextFragment() {
        return this.newTextFragment;
    }

    public void setNewTextFragment(boolean newTextFragment) {
        this.newTextFragment = newTextFragment;
    }

    public void pushClipBounds() {
        this.clipBoundsStack.push(this.clipBounds.clone());
    }

    public void popClipBounds() {
        this.clipBounds = (GenericSegment)this.clipBoundsStack.pop();
    }

    public void simpleModifyClippingPath() {
        this.clipBounds.shrinkBoundingBox(this.currentPathBounds());
    }

    public GenericSegment currentPathBounds() {
        CompositeSegment retVal = new CompositeSegment();
        retVal.getItems().addAll(this.linesToAdd);
        retVal.getItems().addAll(this.rectsToAdd);
        retVal.getItems().addAll(this.currentLines);
        retVal.getItems().addAll(this.currentRects);
        retVal.findBoundingBox();
        return retVal;
    }

    public void newPath() {
        this.linesToAdd.addAll(this.currentLines);
        this.rectsToAdd.addAll(this.currentRects);
        this.newPath = true;
        this.pathContainsCurve = false;
        this.pathBeginSet = false;
        this.pathClosed = false;
        this.currentLines = new ArrayList<LineSegment>();
        this.currentRects = new ArrayList<RectSegment>();
    }

    public void endPath() {
        this.newPath = true;
        this.pathContainsCurve = false;
        this.pathBeginSet = false;
        this.pathClosed = false;
        this.linesToAdd = new ArrayList<LineSegment>();
        this.rectsToAdd = new ArrayList<RectSegment>();
    }

    public void simpleCurveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.pathContainsCurve = true;
        LineSegment l1 = new LineSegment(this.currentX, x1, this.currentY, y1);
        LineSegment l2 = new LineSegment(x1, x2, y1, y2);
        LineSegment l3 = new LineSegment(x2, x3, y2, y3);
        l1.setCurve(true);
        l2.setCurve(true);
        l3.setCurve(true);
        this.currentLines.add(l1);
        this.currentLines.add(l2);
        this.currentLines.add(l3);
        this.currentX = x3;
        this.currentY = y3;
    }

    public void simpleClosePath() {
        if (this.pathBeginSet && !this.pathClosed) {
            this.simpleLineTo(this.pathBeginX, this.pathBeginY);
            this.pathClosed = true;
        }
    }

    public void simpleMoveTo(float x, float y) {
        Point2D.Double Ppos = this.TransformedPoint(x, y);
        this.currentX = (float)((Point2D)Ppos).getX();
        this.currentY = (float)((Point2D)Ppos).getY();
    }

    public void simpleLineTo(float x, float y) {
        float[] comp = this.getStrokingColor().getRGBColorComponents(null);
        Point2D.Double Pto = this.TransformedPoint(x, y);
        LineSegment newLine = new LineSegment(this.currentX, (float)((Point2D)Pto).getX(), this.currentY, (float)((Point2D)Pto).getY());
        newLine.correctNegativeDimensions();
        newLine.rotate(this.page);
        this.linesToAdd.add(newLine);
        this.currentX = (float)((Point2D)Pto).getX();
        this.currentY = (float)((Point2D)Pto).getY();
    }

    public void simpleAddRect(float x, float y, float w, float h) {
        float[] comp = this.getStrokingColor().getRGBColorComponents(null);
        RectSegment newRect = new RectSegment(x, x + w, y, y + h);
        newRect.rotate(this.page);
        newRect.correctNegativeDimensions();
        this.rectsToAdd.add(newRect);
        this.currentX = x;
        this.currentY = y;
    }

    public void simpleDrawImage(float x1, float x2, float y1, float y2) {
        ImageSegment newImageSegment = new ImageSegment(x1, x2, y1, y2);
        newImageSegment.correctNegativeDimensions();
        newImageSegment.rotate(this.page);
        newImageSegment.shrinkBoundingBox(this.clipBounds);
        if (!newImageSegment.isZeroSize()) {
            this.imageList.add(newImageSegment);
        }
    }

    public void simpleStrokePath() {
        this.newPath();
        try {
            this.graphics.setColor(this.getGraphicsState().getStrokingColor().getJavaColor());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        float[] comp = this.graphics.getColor().getRGBColorComponents(null);
        if (!((double)comp[0] > 0.9 && (double)comp[1] > 0.9 && (double)comp[2] > 0.9)) {
            for (LineSegment ls : this.linesToAdd) {
                ls.shrinkBoundingBox(this.clipBounds);
                if (ls.isZeroSize()) continue;
                this.lineList.add(ls);
            }
            for (RectSegment rs : this.rectsToAdd) {
                rs.setFilled(false);
                rs.shrinkBoundingBox(this.clipBounds);
                if (rs.isZeroSize()) continue;
                this.rectList.add(rs);
            }
        }
        this.endPath();
    }

    public void simpleFillPath() {
        this.newPath();
        try {
            this.graphics.setColor(this.getGraphicsState().getNonStrokingColor().getJavaColor());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        float[] comp = this.graphics.getColor().getRGBColorComponents(null);
        if (!((double)comp[0] > 0.9 && (double)comp[1] > 0.9 && (double)comp[2] > 0.9)) {
            for (RectSegment rs : this.rectsToAdd) {
                rs.setFilled(true);
                rs.shrinkBoundingBox(this.clipBounds);
                if (rs.isZeroSize()) continue;
                this.rectList.add(rs);
            }
            GenericSegment lineRect = null;
            for (LineSegment ls : this.linesToAdd) {
                if (lineRect == null) {
                    lineRect = new RectSegment(ls.getX1(), ls.getX2(), ls.getY1(), ls.getY2());
                    continue;
                }
                lineRect.growBoundingBox(ls);
            }
            if (lineRect != null) {
                this.rectList.add((RectSegment)lineRect);
            }
        }
        this.endPath();
    }
}

