/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.analysis;

import at.ac.tuwien.dbai.pdfwrap.analysis.CandidateCluster;
import at.ac.tuwien.dbai.pdfwrap.analysis.LineProcessor;
import at.ac.tuwien.dbai.pdfwrap.analysis.PageSegmenter;
import at.ac.tuwien.dbai.pdfwrap.analysis.RulingObjectProcessor;
import at.ac.tuwien.dbai.pdfwrap.comparators.YComparator;
import at.ac.tuwien.dbai.pdfwrap.gui.EdgeSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.CharSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.CompositeSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.ImageSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.LineFragment;
import at.ac.tuwien.dbai.pdfwrap.model.document.LineSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.Page;
import at.ac.tuwien.dbai.pdfwrap.model.document.RectSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextBlock;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextFragment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextLine;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextSegment;
import at.ac.tuwien.dbai.pdfwrap.model.graph.AdjacencyEdge;
import at.ac.tuwien.dbai.pdfwrap.model.graph.AdjacencyGraph;
import at.ac.tuwien.dbai.pdfwrap.pdfread.PDFPage;
import at.ac.tuwien.dbai.pdfwrap.utils.ListUtils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PageProcessor {
    public static final int PP_INSTRUCTION = 1;
    public static final int PP_FRAGMENT = 2;
    public static final int PP_CHAR = 3;
    public static final int PP_LINE = 4;
    public static final int PP_BLOCK = 5;
    public static final int PP_MERGED_LINES = 16;
    protected Page retVal;
    protected List<CharSegment> charList;
    protected List<TextFragment> fragList;
    protected List<ImageSegment> imageList;
    protected List<LineSegment> lineList;
    protected List<RectSegment> rectList;
    protected List<GenericSegment> processingResult;
    protected List<EdgeSegment> edgeSegmentList;
    protected List<TextLine> textLines;
    protected List<TextBlock> mergedLines;
    protected List<TextBlock> textBlocks;
    protected RulingObjectProcessor rop;
    protected AdjacencyGraph<GenericSegment> adjGraph;
    float currentX = 0.0f;
    float currentY = 0.0f;
    protected int processType = 5;
    protected boolean rulingLines = true;
    protected boolean processSpaces = false;
    protected int noIterations = -1;
    private Vector charactersByArticle = new Vector();
    private Map characterListMapping = new HashMap();
    private String lineSeparator = System.getProperty("line.separator");
    private String pageSeparator = System.getProperty("line.separator");
    private String wordSeparator = " ";

    public PageProcessor() {
    }

    public PageProcessor(int processType) {
        this.processType = processType;
    }

    public static List<Page> processDocPages(List<Page> thePages, BufferedImage pageImage) {
        return thePages;
    }

    public Page processPage(PDFPage thisPage) {
        Page retVal = this.doProcessPage(thisPage);
        this.postProcessing(this.processType, retVal);
        return retVal;
    }

    protected Page doProcessPage(PDFPage thisPage) {
        long startProcess = System.currentTimeMillis();
        this.retVal = new Page();
        this.retVal.setBoundingBox(thisPage.getBoundingBox());
        this.retVal.setRotation(thisPage.getRotation());
        this.charList = ListUtils.selectCharacters(thisPage.getItems());
        this.fragList = ListUtils.selectTextFragments(thisPage.getItems());
        this.imageList = ListUtils.selectImageSegments(thisPage.getItems());
        this.lineList = ListUtils.selectLineSegments(thisPage.getItems());
        this.rectList = ListUtils.selectRectSegments(thisPage.getItems());
        this.processingResult = new ArrayList<GenericSegment>();
        this.edgeSegmentList = new ArrayList<EdgeSegment>();
        this.textLines = new ArrayList<TextLine>();
        this.mergedLines = new ArrayList<TextBlock>();
        this.textBlocks = new ArrayList<TextBlock>();
        this.rop = new RulingObjectProcessor();
        System.out.println("time A: " + (System.currentTimeMillis() - startProcess));
        if (this.processType != 3 && this.processType != 2) {
            System.out.println("time E: " + (System.currentTimeMillis() - startProcess));
            this.textLines = this.processSpaces ? LineProcessor.findLinesFromCharacters(this.charList, 0.7f, false, false) : LineProcessor.findLinesFromTextFragments(this.fragList, 0.8f, false, false);
            AdjacencyGraph<TextLine> lineAG = new AdjacencyGraph<TextLine>();
            lineAG.addList(this.textLines);
            System.out.println("number of items pageFromLines: " + this.textLines.size());
            System.out.println("Time for preprocessing: " + (System.currentTimeMillis() - startProcess));
            long before = System.currentTimeMillis();
            lineAG.generateEdgesSingle();
            System.out.println("Time for AG generation: " + (System.currentTimeMillis() - before));
            before = System.currentTimeMillis();
            if (this.rulingLines) {
                this.rop.addRulingObjects(this.lineList);
                this.rop.addRulingObjects(this.rectList);
                this.rop.removeDuplicateLines();
                this.lineList = this.rop.getRulingLines();
                this.rectList = new ArrayList<RectSegment>();
            }
            int blockIterations = this.noIterations;
            if (this.processType != 5) {
                blockIterations = 0;
            }
            HashMap<GenericSegment, CandidateCluster> clustHash = new HashMap<GenericSegment, CandidateCluster>();
            this.textBlocks = PageSegmenter.clusterLinesIntoTextBlocks(lineAG, blockIterations, clustHash);
            System.out.println("Time for ordered edge cluster: " + (System.currentTimeMillis() - before));
            before = System.currentTimeMillis();
            for (TextBlock c : this.textBlocks) {
                CandidateCluster cc = new CandidateCluster();
                for (TextSegment textSegment : c.getItems()) {
                    cc.getItems().add(textSegment);
                }
                cc.findLinesWidth();
                for (CompositeSegment compositeSegment : cc.getFoundLines()) {
                    TextBlock lineBlock = new TextBlock();
                    lineBlock.setCalculatedFields(compositeSegment);
                    for (TextSegment i : compositeSegment.getItems()) {
                        if (i.getClass() == TextLine.class) {
                            lineBlock.getItems().add((TextLine)i);
                        }
                        if (i.getClass() == LineFragment.class) {
                            TextLine tl = new TextLine();
                            tl.getItems().add((LineFragment)i);
                            tl.setCalculatedFields(i);
                            lineBlock.getItems().add(tl);
                            continue;
                        }
                        if (i.getClass() == TextFragment.class) {
                            LineFragment lf = new LineFragment();
                            lf.getItems().add((TextFragment)i);
                            lf.setCalculatedFields(i);
                            TextLine tl = new TextLine();
                            tl.getItems().add(lf);
                            tl.setCalculatedFields(lf);
                            lineBlock.getItems().add(tl);
                            continue;
                        }
                        if (i.getClass() != CharSegment.class) continue;
                        TextFragment tf = new TextFragment();
                        tf.getItems().add((CharSegment)i);
                        tf.setCalculatedFields(i);
                        LineFragment lf = new LineFragment();
                        lf.getItems().add(tf);
                        lf.setCalculatedFields(tf);
                        TextLine tl = new TextLine();
                        tl.getItems().add(lf);
                        tl.setCalculatedFields(lf);
                        lineBlock.getItems().add(tl);
                    }
                    this.mergedLines.add(lineBlock);
                }
            }
            System.out.println("total pp time: " + (System.currentTimeMillis() - startProcess));
        }
        return this.retVal;
    }

    public void postProcessing(int processType, Page retVal) {
        if (processType == 3) {
            for (CharSegment c : this.charList) {
                TextFragment tf = new TextFragment();
                tf.getItems().add(c);
                tf.setCalculatedFields(c);
                LineFragment lf = new LineFragment();
                lf.getItems().add(tf);
                lf.setCalculatedFields(tf);
                TextLine tl = new TextLine();
                tl.getItems().add(lf);
                tl.setCalculatedFields(lf);
                TextBlock tb = new TextBlock();
                tb.getItems().add(tl);
                tb.setCalculatedFields(tl);
                this.processingResult.add(tb);
            }
        } else if (processType == 2) {
            for (TextFragment tf : this.fragList) {
                LineFragment lf = new LineFragment();
                lf.getItems().add(tf);
                lf.setCalculatedFields(tf);
                TextLine tl = new TextLine();
                tl.getItems().add(lf);
                tl.setCalculatedFields(lf);
                TextBlock tb = new TextBlock();
                tb.getItems().add(tl);
                tb.setCalculatedFields(tl);
                this.processingResult.add(tb);
            }
        } else if (processType == 4) {
            for (TextLine tl : this.textLines) {
                TextBlock tb = new TextBlock();
                tb.getItems().add(tl);
                tb.setCalculatedFields(tl);
                this.processingResult.add(tb);
            }
        } else if (processType == 16) {
            this.processingResult.addAll(this.mergedLines);
        } else if (processType == 5) {
            this.processingResult.addAll(this.textBlocks);
        }
        if (processType != 1 && processType != 2 && processType != 3) {
            this.adjGraph = new AdjacencyGraph();
            this.adjGraph.addList(this.processingResult);
            this.adjGraph.generateEdgesSingle();
            System.out.println("PP.edges: " + this.adjGraph.getEdges().size());
            ArrayList<EdgeSegment> edgeList = new ArrayList<EdgeSegment>();
            for (AdjacencyEdge<GenericSegment> ae : this.adjGraph.getEdges()) {
                edgeList.add(new EdgeSegment(ae));
            }
        }
        retVal.getItems().addAll(this.processingResult);
        retVal.getItems().addAll(this.textLines);
        retVal.getItems().addAll(this.imageList);
        retVal.getItems().addAll(this.lineList);
        retVal.getItems().addAll(this.rectList);
        retVal.getItems().addAll(this.edgeSegmentList);
        Collections.sort(retVal.getItems(), new YComparator());
    }

    public void customProcessing(int processType) {
    }

    public AdjacencyGraph<GenericSegment> getAdjGraph() {
        return this.adjGraph;
    }

    public void setAdjGraph(AdjacencyGraph<GenericSegment> adjGraph) {
        this.adjGraph = adjGraph;
    }

    public int getProcessType() {
        return this.processType;
    }

    public void setProcessType(int processType) {
        this.processType = processType;
    }

    public boolean isRulingLines() {
        return this.rulingLines;
    }

    public void setRulingLines(boolean rulingLines) {
        this.rulingLines = rulingLines;
    }

    public boolean isProcessSpaces() {
        return this.processSpaces;
    }

    public void setProcessSpaces(boolean processSpaces) {
        this.processSpaces = processSpaces;
    }

    public int getNoIterations() {
        return this.noIterations;
    }

    public void setNoIterations(int noIterations) {
        this.noIterations = noIterations;
    }
}

