/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image;

import java.awt.Point;
import jj2000.j2k.NoNextElementException;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;

public class ImgDataJoiner
implements BlkImgDataSrc {
    private int w;
    private int h;
    private int nc;
    private BlkImgDataSrc[] imageData;
    private int[] compIdx;
    private int[] subsX;
    private int[] subsY;

    public ImgDataJoiner(BlkImgDataSrc[] imD, int[] cIdx) {
        int i;
        this.imageData = imD;
        this.compIdx = cIdx;
        if (this.imageData.length != this.compIdx.length) {
            throw new IllegalArgumentException("imD and cIdx must have the same length");
        }
        this.nc = imD.length;
        this.subsX = new int[this.nc];
        this.subsY = new int[this.nc];
        for (i = 0; i < this.nc; ++i) {
            if (imD[i].getNumTiles() == 1 && imD[i].getCompULX(cIdx[i]) == 0 && imD[i].getCompULY(cIdx[i]) == 0) continue;
            throw new IllegalArgumentException("All input components must, not use tiles and must have the origin at the canvas origin");
        }
        int maxW = 0;
        int maxH = 0;
        for (i = 0; i < this.nc; ++i) {
            if (imD[i].getCompImgWidth(cIdx[i]) > maxW) {
                maxW = imD[i].getCompImgWidth(cIdx[i]);
            }
            if (imD[i].getCompImgHeight(cIdx[i]) <= maxH) continue;
            maxH = imD[i].getCompImgHeight(cIdx[i]);
        }
        this.w = maxW;
        this.h = maxH;
        for (i = 0; i < this.nc; ++i) {
            this.subsX[i] = (maxW + imD[i].getCompImgWidth(cIdx[i]) - 1) / imD[i].getCompImgWidth(cIdx[i]);
            this.subsY[i] = (maxH + imD[i].getCompImgHeight(cIdx[i]) - 1) / imD[i].getCompImgHeight(cIdx[i]);
            if ((maxW + this.subsX[i] - 1) / this.subsX[i] == imD[i].getCompImgWidth(cIdx[i]) && (maxH + this.subsY[i] - 1) / this.subsY[i] == imD[i].getCompImgHeight(cIdx[i])) continue;
            throw new Error("Can not compute component subsampling factors: strange subsampling.");
        }
    }

    public int getTileWidth() {
        return this.w;
    }

    public int getTileHeight() {
        return this.h;
    }

    public int getNomTileWidth() {
        return this.w;
    }

    public int getNomTileHeight() {
        return this.h;
    }

    public int getImgWidth() {
        return this.w;
    }

    public int getImgHeight() {
        return this.h;
    }

    public int getNumComps() {
        return this.nc;
    }

    public int getCompSubsX(int c) {
        return this.subsX[c];
    }

    public int getCompSubsY(int c) {
        return this.subsY[c];
    }

    public int getTileCompWidth(int t, int c) {
        return this.imageData[c].getTileCompWidth(t, this.compIdx[c]);
    }

    public int getTileCompHeight(int t, int c) {
        return this.imageData[c].getTileCompHeight(t, this.compIdx[c]);
    }

    public int getCompImgWidth(int c) {
        return this.imageData[c].getCompImgWidth(this.compIdx[c]);
    }

    public int getCompImgHeight(int n) {
        return this.imageData[n].getCompImgHeight(this.compIdx[n]);
    }

    public int getNomRangeBits(int c) {
        return this.imageData[c].getNomRangeBits(this.compIdx[c]);
    }

    public int getFixedPoint(int c) {
        return this.imageData[c].getFixedPoint(this.compIdx[c]);
    }

    public DataBlk getInternCompData(DataBlk blk, int c) {
        return this.imageData[c].getInternCompData(blk, this.compIdx[c]);
    }

    public DataBlk getCompData(DataBlk blk, int c) {
        return this.imageData[c].getCompData(blk, this.compIdx[c]);
    }

    public void setTile(int x, int y) {
        if (x != 0 || y != 0) {
            throw new IllegalArgumentException();
        }
    }

    public void nextTile() {
        throw new NoNextElementException();
    }

    public Point getTile(Point co) {
        if (co != null) {
            co.x = 0;
            co.y = 0;
            return co;
        }
        return new Point(0, 0);
    }

    public int getTileIdx() {
        return 0;
    }

    public int getCompULX(int c) {
        return 0;
    }

    public int getCompULY(int c) {
        return 0;
    }

    public int getTilePartULX() {
        return 0;
    }

    public int getTilePartULY() {
        return 0;
    }

    public int getImgULX() {
        return 0;
    }

    public int getImgULY() {
        return 0;
    }

    public Point getNumTiles(Point co) {
        if (co != null) {
            co.x = 1;
            co.y = 1;
            return co;
        }
        return new Point(1, 1);
    }

    public int getNumTiles() {
        return 1;
    }

    public String toString() {
        String string = "ImgDataJoiner: WxH = " + this.w + "x" + this.h;
        for (int i = 0; i < this.nc; ++i) {
            string = string + "\n- Component " + i + " " + this.imageData[i];
        }
        return string;
    }
}

