# Generated by default/object.tt
package Paws::Chime::Proxy;
  use Moose;
  has DefaultSessionExpiryMinutes => (is => 'ro', isa => 'Int');
  has Disabled => (is => 'ro', isa => 'Bool');
  has FallBackPhoneNumber => (is => 'ro', isa => 'Str');
  has PhoneNumberCountries => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Chime::Proxy

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Chime::Proxy object:

  $service_obj->Method(Att1 => { DefaultSessionExpiryMinutes => $value, ..., PhoneNumberCountries => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Chime::Proxy object:

  $result = $service_obj->Method(...);
  $result->Att1->DefaultSessionExpiryMinutes

=head1 DESCRIPTION

The proxy configuration for an Amazon Chime Voice Connector.

=head1 ATTRIBUTES


=head2 DefaultSessionExpiryMinutes => Int

The default number of minutes allowed for proxy sessions.


=head2 Disabled => Bool

When true, stops proxy sessions from being created on the specified
Amazon Chime Voice Connector.


=head2 FallBackPhoneNumber => Str

The phone number to route calls to after a proxy session expires.


=head2 PhoneNumberCountries => ArrayRef[Str|Undef]

The countries for proxy phone numbers to be selected from.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Chime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

