# Generated by default/object.tt
package Paws::S3::ServerSideEncryptionRule;
  use Moose;
  has ApplyServerSideEncryptionByDefault => (is => 'ro', isa => 'Paws::S3::ServerSideEncryptionByDefault');
  has BucketKeyEnabled => (is => 'ro', isa => 'Bool');

1;

### main pod documentation begin ###

=head1 NAME

Paws::S3::ServerSideEncryptionRule

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::S3::ServerSideEncryptionRule object:

  $service_obj->Method(Att1 => { ApplyServerSideEncryptionByDefault => $value, ..., BucketKeyEnabled => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::S3::ServerSideEncryptionRule object:

  $result = $service_obj->Method(...);
  $result->Att1->ApplyServerSideEncryptionByDefault

=head1 DESCRIPTION

Specifies the default server-side encryption configuration.

=head1 ATTRIBUTES


=head2 ApplyServerSideEncryptionByDefault => L<Paws::S3::ServerSideEncryptionByDefault>

Specifies the default server-side encryption to apply to new objects in
the bucket. If a PUT Object request doesn't specify any server-side
encryption, this default encryption will be applied.


=head2 BucketKeyEnabled => Bool

Specifies whether Amazon S3 should use an S3 Bucket Key with
server-side encryption using KMS (SSE-KMS) for new objects in the
bucket. Existing objects are not affected. Setting the
C<BucketKeyEnabled> element to C<true> causes Amazon S3 to use an S3
Bucket Key. By default, S3 Bucket Key is not enabled.

For more information, see Amazon S3 Bucket Keys
(https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) in
the I<Amazon S3 User Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::S3>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

