# Generated by default/object.tt
package Paws::CodeArtifact::RepositoryExternalConnectionInfo;
  use Moose;
  has ExternalConnectionName => (is => 'ro', isa => 'Str', request_name => 'externalConnectionName', traits => ['NameInRequest']);
  has PackageFormat => (is => 'ro', isa => 'Str', request_name => 'packageFormat', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeArtifact::RepositoryExternalConnectionInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeArtifact::RepositoryExternalConnectionInfo object:

  $service_obj->Method(Att1 => { ExternalConnectionName => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeArtifact::RepositoryExternalConnectionInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->ExternalConnectionName

=head1 DESCRIPTION

Contains information about the external connection of a repository.

=head1 ATTRIBUTES


=head2 ExternalConnectionName => Str

The name of the external connection associated with a repository.


=head2 PackageFormat => Str

The package format associated with a repository's external connection.
The valid package formats are:

=over

=item *

C<npm>: A Node Package Manager (npm) package.

=item *

C<pypi>: A Python Package Index (PyPI) package.

=item *

C<maven>: A Maven package that contains compiled code in a
distributable format, such as a JAR file.

=back



=head2 Status => Str

The status of the external connection of a repository. There is one
valid value, C<Available>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeArtifact>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

