package ShiftJIS::Regexp::Const;
use strict;
use Carp;

use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
use vars qw(%AbbrevProp %Re %Err $Char $Trail $PadA $PadG $PadGA);

$VERSION = '1.03';

require Exporter;
@ISA       = qw(Exporter);
@EXPORT    = qw();
@EXPORT_OK = qw(%AbbrevProp %Re %Err $Char $Trail $PadA $PadG $PadGA);

my $PACKAGE = 'ShiftJIS::Regexp';

my $Open = 5.005 > $] ? '(?:' : '(?-i:';
my $Close = ')';

my $SBC   = '[\x00-\x7F\xA1-\xDF]';
my $DBC   = '[\x81-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]';

$Char = "(?:$SBC|$DBC)";
$Trail = '[\x40-\x7E\x80-\xFC]';

$PadA  = '(?:\A|[\x00-\x80\xA0-\xDF])(?:[\x81-\x9F\xE0-\xFC]{2})*?';

$PadG  = '\G(?:|[\x00-\xFF]*?'.
	       '[\x00-\x80\xA0-\xDF])(?:[\x81-\x9F\xE0-\xFC]{2})*?';
#$PadG = '(?:\G|[\x00-\x80\xA0-\xDF])(?:[\x81-\x9F\xE0-\xFC]{2})*?';

#$PadGA = '(?:\G\A|\G(?:[\x81-\x9F\xE0-\xFC]{2})+?|'.
#	 '[\x00-\x80\xA0-\xDF](?:[\x81-\x9F\xE0-\xFC]{2})*?)';
$PadGA = '\G(?:\A|(?:[\x81-\x9F\xE0-\xFC]{2})+?|[\x00-\xFF]*?'.
	 '[\x00-\x80\xA0-\xDF](?:[\x81-\x9F\xE0-\xFC]{2})*?)';

%Err = (
    'Code'	=> $PACKAGE.' Sequence (?{...}) not terminated or not {}-balanced',
    'Undef'	=> $PACKAGE.' "%s" is not defined',
    'notTermin'	=> $PACKAGE.' %s is not terminated ("%s" missing)',
    'notASCII'	=> $PACKAGE.' "%s" is not followed by an ASCII, [\x21-\x7e]',
    'notAlnum'	=> $PACKAGE.' "%s" is not followed by an Alnum, [0-9A-Za-z]',
    'notBrace'	=> $PACKAGE.' "%s" is not followed by a brace',
    'backtips'	=> $PACKAGE.' Trailing \ in regexp',
    'oddTrail'	=> $PACKAGE.' "\\x%02x" is not followed by trail byte',
    'revRange'	=> $PACKAGE.' Invalid [] range (reverse) %d > %d',
    'invalRng'	=> $PACKAGE.' Invalid [] range "%s"',
    'invalMch'	=> $PACKAGE.' Invalid Metacharacter "%s"',
    'invalHex'	=> $PACKAGE.' Invalid Hexadecimal %s following "\x"',
    'invalFlw'	=> $PACKAGE.' Invalid byte "\\x%02x" following "%s" (only "%s" allowed)',
);

%Re = (
  '\R{pada}'  => $PadA,
  '\R{padg}'  => $PadG,
  '\R{padga}' => $PadGA,

  '\C' => '[\x00-\xFF]',
  '\j' => $Char,
  '\J' => "(?:(?!\\n)$Char)",
  '\d' => '[0-9]',
  '\D' => '(?:[\x00-\x2F\x3A-\x7F\xA1-\xDF]|' . $DBC . ')',
  '\w' => '[0-9A-Za-z\x5F]',
  '\W' => '(?:[\x00-\x2F\x3A-\x40\x5B-\x5E\x60\x7B-\x7F\xA1-\xDF]|'.$DBC.')',
  '\s' => '[\x09\x0A\x0C\x0D\x20]',
  '\S' => '(?:[\x00-\x08\x0B\x0E-\x1F\x21-\x7F\xA1-\xDF]|' . $DBC . ')',

  '\p{xdigit}'	=> '[0-9A-Fa-f]',
  '\P{xdigit}'	=> $Open.'[\x00-\x2F\x3A-\x40\x47-\x60\x67-\x7F\xA1-\xDF]|'
		. $DBC .$Close,

  '\p{digit}'	=> $Open.'[\x30-\x39]|\x82[\x4F-\x58]'.$Close,
  '\P{digit}'	=> $Open.'[\x00-\x2F\x3A-\x7F\xA1-\xDF]'
		. '|[\x81\x83-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'
		. '|\x82[\x40-\x4E\x59-\x7E\x80-\xFC]'
		. $Close,

  '\p{upper}'	=> $Open.'[\x41-\x5A]|\x82[\x60-\x79]'.$Close,
  '\P{upper}'	=> $Open.'[\x00-\x40\x5B-\x7F\xA1-\xDF]'
		. '|[\x81\x83-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'
		. '|\x82[\x40-\x5F\x7A-\x7E\x80-\xFC]'
		. $Close,

  '\p{lower}'	=> $Open.'[\x61-\x7A]|\x82[\x81-\x9A]'.$Close,
  '\P{lower}'	=> $Open.'[\x00-\x60\x7B-\x7F\xA1-\xDF]'
		. '|[\x81\x83-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'
		. '|\x82[\x40-\x7E\x80\x9B-\xFC]'. $Close,

  '\p{alpha}'	=> $Open.'[\x41-\x5A\x61-\x7A]|\x82[\x60-\x79\x81-\x9A]'.$Close,
  '\P{alpha}'	=> $Open.'[\x00-\x40\x5B-\x60\x7B-\x7F\xA1-\xDF]'
		. '|[\x81\x83-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'
		. '|\x82[\x40-\x5F\x7A-\x7E\x80\x9B-\xFC]'. $Close,

  '\p{alnum}'	=> $Open.'[0-9A-Za-z]|\x82[\x4F-\x58\x60-\x79\x81-\x9A]'.$Close,
  '\P{alnum}'	=> $Open.'[\x00-\x2F\x3A-\x40\x5B-\x60\x7B-\x7F\xA1-\xDF]'
		. '|[\x81\x83-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'
		. '|\x82[\x40-\x4E\x59-\x5F\x7A-\x7E\x80\x9B-\xFC]'. $Close,

  '\p{blank}'	=> $Open.'[\x09\x20]|\x81\x40'.$Close,
  '\P{blank}'	=> $Open.'[\x00-\x08\x0A-\x1F\x21-\x7F\xA1-\xDF]'
		. '|\x81[\x41-\x7E\x80-\xFC]'
		. '|[\x82-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'. $Close,

  '\p{space}'	=> $Open.'[\x09-\x0D\x20]|\x81\x40'.$Close,
  '\P{space}'	=> $Open.'[\x00-\x08\x0E-\x1F\x21-\x7F\xA1-\xDF]'
		. '|\x81[\x41-\x7E\x80-\xFC]'
		. '|[\x82-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'. $Close,

  '\p{punct}'	=> $Open.'[\x21-\x2F\x3A-\x40\x5B-\x60\x7B-\x7E\xA1-\xA5]'
		. '|\x81[\x41-\x49\x4C-\x51\x5C-\x7E\x80-\xAC\xB8-\xBF'
		. '\xC8-\xCE\xDA-\xE8\xF0-\xF7\xFC]|\x84[\x9F-\xBE]'. $Close,
  '\P{punct}'	=> $Open.'[\x00-\x20\x30-\x39\x41-\x5A\x61-\x7A\x7F\xA6-\xDF]'
		. '|\x81[\x40\x4A\x4B\x52-\x5B\xAD-\xB7\xC0-\xC7\xCF-\xD9'
		. '\xE9-\xEF\xF8-\xFB]|\x84[\x40-\x7E\x80-\x9E\xBF-\xFC]'
		. '|[\x82\x83\x85-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'. $Close,

  '\p{graph}'	=> $Open.'[\x21-\x7E\xA1-\xDF]|\x81[\x41-\x7E'
		. '\x80-\xAC\xB8-\xBF\xC8-\xCE\xDA-\xE8\xF0-\xF7\xFC]|'
		. '\x82[\x4F-\x58\x60-\x79\x81-\x9A\x9F-\xF1]|'
		. '\x83[\x40-\x7E\x80-\x96\x9F-\xB6\xBF-\xD6]|'
		. '\x84[\x40-\x60\x70-\x7E\x80-\x91\x9F-\xBE]|'
		. '\x88[\x9F-\xFC]|\x98[\x40-\x72\x9F-\xFC]|'
		. '[\x89-\x97\x99-\x9F\xE0-\xE9][\x40-\x7E\x80-\xFC]|'
		. '\xEA[\x40-\x7E\x80-\xA4]'
		. $Close,

  '\P{graph}'	=> $Open.'[\x00-\x20\x7F]|'
		. '\x81[\x40\xAD-\xB7\xC0-\xC7\xCF-\xD9\xE9-\xEF\xF8-\xFB]|'
		. '\x82[\x40-\x4E\x59-\x5F\x7A-\x7E\x80\x9B-\x9E\xF2-\xFC]|'
		. '\x83[\x97-\x9E\xB7-\xBE\xD7-\xFC]|'
		. '\x84[\x61-\x6F\x92-\x9E\xBF-\xFC]|'
		. '[\x85-\x87\xEB-\xFC][\x40-\x7E\x80-\xFC]|'
		. '\x88[\x40-\x7E\x80-\x9E]|\x98[\x73-\x7E\x80-\x9E]|'
		. '\xEA[\xA5-\xFC]'
		.$Close,

  '\p{print}'	=> $Open.'[\x20-\x7E\xA1-\xDF]|\x81[\x40-\x7E'
		. '\x80-\xAC\xB8-\xBF\xC8-\xCE\xDA-\xE8\xF0-\xF7\xFC]|'
		. '\x82[\x4F-\x58\x60-\x79\x81-\x9A\x9F-\xF1]|'
		. '\x83[\x40-\x7E\x80-\x96\x9F-\xB6\xBF-\xD6]|'
		. '\x84[\x40-\x60\x70-\x7E\x80-\x91\x9F-\xBE]|'
		. '\x88[\x9F-\xFC]|\x98[\x40-\x72\x9F-\xFC]|'
		. '[\x89-\x97\x99-\x9F\xE0-\xE9][\x40-\x7E\x80-\xFC]|'
		. '\xEA[\x40-\x7E\x80-\xA4]'
		. $Close,

  '\P{print}'	=> $Open.'[\x00-\x1F\x7F]|'
		. '\x81[\xAD-\xB7\xC0-\xC7\xCF-\xD9\xE9-\xEF\xF8-\xFB]|'
		. '\x82[\x40-\x4E\x59-\x5F\x7A-\x7E\x80\x9B-\x9E\xF2-\xFC]|'
		. '\x83[\x97-\x9E\xB7-\xBE\xD7-\xFC]|'
		. '\x84[\x61-\x6F\x92-\x9E\xBF-\xFC]|'
		. '[\x85-\x87\xEB-\xFC][\x40-\x7E\x80-\xFC]|'
		. '\x88[\x40-\x7E\x80-\x9E]|\x98[\x73-\x7E\x80-\x9E]|'
		. '\xEA[\xA5-\xFC]'
		. $Close,

  '\p{cntrl}'	=> $Open.'[\x00-\x1F\x7F]'.$Close,
  '\P{cntrl}'	=> $Open.'[\x20-\x7E\xA1-\xDF]|'.$DBC.$Close,

  '\p{ascii}'	=> $Open.'[\x00-\x7F]'.$Close,
  '\P{ascii}'	=> $Open.'[\xA1-\xDF]|'.$DBC.$Close,

  '\p{roman}'	=> $Open.'[\x21-\x7E]'.$Close,
  '\P{roman}'	=> $Open.'[\x00-\x20\x7F\xA1-\xDF]|'.$DBC.$Close,

  '\p{word}'	=> $Open
		. '[0-9A-Za-z\x5F\xA6-\xDF]|\x81[\x4A\x4B\x52-\x5B]|'
		. '\x82[\x4F-\x58\x60-\x79\x81-\x9A\x9F-\xF1]|'
		. '\x83[\x40-\x7E\x80-\x96\x9F-\xB6\xBF-\xD6]|'
		. '\x84[\x40-\x60\x70-\x7E\x80-\x91]|\x88[\x9F-\xFC]|'
		. '[\x89-\x97\x99-\x9F\xE0-\xE9][\x40-\x7E\x80-\xFC]|'
		. '\x98[\x40-\x72\x9F-\xFC]|\xEA[\x40-\x7E\x80-\xA4]'
		. $Close,

  '\P{word}'	=> $Open
		. '[\x00-\x2F\x3A-\x40\x5B-\x5E\x60\x7B-\x7F\xA1-\xA5]|'
		. '\x81[\x40-\x49\x4C-\x51\x5C-\x7E\x80-\xFC]|'
		. '\x82[\x40-\x4E\x59-\x5F\x7A-\x7E\x80\x9B-\x9E\xF2-\xFC]|'
		. '\x83[\x97-\x9E\xB7-\xBE\xD7-\xFC]|'
		. '\x84[\x61-\x6F\x92-\xFC]|'
		. '[\x85-\x87\xEB-\xFC][\x40-\x7E\x80-\xFC]|'
		. '\x88[\x40-\x7E\x80-\x9E]|\x98[\x73-\x7E\x80-\x9E]|'
		. '\xEA[\xA5-\xFC]'.$Close,

  '\p{halfwidth}' => '[\x21\x23-\x26\x28-\x2C\x2E-\x7E]',
  '\P{halfwidth}' => $Open.'[\x00-\x20\x22\x27\x2D\x7F\xA1-\xDF]|'
		. $DBC.$Close,

  '\p{fullwidth}' => $Open.'\x81[\x43\x44\x46-\x49\x4d\x4f\x50\x51\x5e'
		. '\x62\x69\x6a\x6d-\x70\x7b\x81\x83\x84\x8f\x90\x93-\x97]|'
		. '\x82[\x4f-\x58\x60-\x79\x81-\x9a]'.$Close,

  '\P{fullwidth}' => $Open.$SBC
		. '|\x81[\x40-\x42\x45\x4a-\x4c\x4e\x52-\x5d\x5f-\x61'
		. '\x63-\x68\x6b\x6c\x71-\x7a\x7c-\x7e\x80\x82\x85-\x8e'
		. '\x91\x92\x98-\xfc]'
		. '|\x82[\x40-\x4e\x59-\x5f\x7a-\x7e\x80\x9b-\xfc]'
		. '|[\x83-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'. $Close,

  '\p{hankaku}'	=> $Open.'[\xA1-\xDF]'.$Close,
  '\P{hankaku}'	=> $Open.'[\x00-\x7F]|'.$DBC.$Close,
  '\p{zenkaku}'	=> "$Open$DBC$Close",
  '\P{zenkaku}'	=> "$Open$SBC$Close",

  '\p{x0201}'	=> $Open.'[\x20-\x7F\xA1-\xDF]'.$Close,
  '\P{x0201}'	=> $Open.'[\x00-\x1F]|'.$DBC.$Close,

  '\p{x0211}'	=> $Open.'[\x00-\x1F]'.$Close,
  '\P{x0211}'	=> $Open.'[\x20-\x7F\xA1-\xDF]|'.$DBC.$Close,

  '\p{x0208}'	=> $Open.'\x81[\x40-\x7E'
		. '\x80-\xAC\xB8-\xBF\xC8-\xCE\xDA-\xE8\xF0-\xF7\xFC]|'
		. '\x82[\x4F-\x58\x60-\x79\x81-\x9A\x9F-\xF1]|'
		. '\x83[\x40-\x7E\x80-\x96\x9F-\xB6\xBF-\xD6]|'
		. '\x84[\x40-\x60\x70-\x7E\x80-\x91\x9F-\xBE]|'
		. '\x88[\x9F-\xFC]|\x98[\x40-\x72\x9F-\xFC]|'
		. '[\x89-\x97\x99-\x9F\xE0-\xE9][\x40-\x7E\x80-\xFC]|'
		. '\xEA[\x40-\x7E\x80-\xA4]'
		.$Close,

  '\P{x0208}'	=> $Open.$SBC
		. '|\x81[\xAD-\xB7\xC0-\xC7\xCF-\xD9\xE9-\xEF\xF8-\xFB]'
		. '|\x82[\x40-\x4E\x59-\x5F\x7A-\x7E\x80\x9B-\x9E\xF2-\xFC]'
		. '|\x83[\x97-\x9E\xB7-\xBE\xD7-\xFC]'
		. '|\x84[\x61-\x6F\x92-\x9E\xBF-\xFC]'
		. '|[\x85-\x87\xEB-\xFC][\x40-\x7E\x80-\xFC]'
		. '|\x88[\x40-\x7E\x80-\x9E]|\x98[\x73-\x7E\x80-\x9E]'
		. '|\xEA[\xA5-\xFC]'.$Close,

  '\p{jis}'	=> $Open.$SBC.'|\x81[\x40-\x7E'
		. '\x80-\xAC\xB8-\xBF\xC8-\xCE\xDA-\xE8\xF0-\xF7\xFC]|'
		. '\x82[\x4F-\x58\x60-\x79\x81-\x9A\x9F-\xF1]|'
		. '\x83[\x40-\x7E\x80-\x96\x9F-\xB6\xBF-\xD6]|'
		. '\x84[\x40-\x60\x70-\x7E\x80-\x91\x9F-\xBE]|'
		. '\x88[\x9F-\xFC]|\x98[\x40-\x72\x9F-\xFC]|'
		. '[\x89-\x97\x99-\x9F\xE0-\xE9][\x40-\x7E\x80-\xFC]|'
		. '\xEA[\x40-\x7E\x80-\xA4]'. $Close,

  '\P{jis}'	=> $Open
		. '\x81[\xAD-\xB7\xC0-\xC7\xCF-\xD9\xE9-\xEF\xF8-\xFB]|'
		. '\x82[\x40-\x4E\x59-\x5F\x7A-\x7E\x80\x9B-\x9E\xF2-\xFC]|'
		. '\x83[\x97-\x9E\xB7-\xBE\xD7-\xFC]|'
		. '\x84[\x61-\x6F\x92-\x9E\xBF-\xFC]|'
		. '[\x85-\x87\xEB-\xFC][\x40-\x7E\x80-\xFC]|'
		. '\x88[\x40-\x7E\x80-\x9E]|\x98[\x73-\x7E\x80-\x9E]|'
		. '\xEA[\xA5-\xFC]'
		.$Close,

  '\p{latin}'	=> $Open.'[\x41-\x5A\x61-\x7A]'.$Close,
  '\P{latin}'	=> $Open.'[\x00-\x40\x5B-\x60\x7B-\x7F\xA1-\xDF]|'.$DBC.$Close,

  '\p{fulllatin}' => $Open.'\x82[\x60-\x79\x81-\x9A]'.$Close,
  '\P{fulllatin}' => $Open.$SBC.'|\x82[\x40-\x5F\x7A-\x7E\x80\x9B-\xFC]|'
		. '[\x81\x83-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'. $Close,

  '\p{greek}'	=> $Open.'\x83[\x9f-\xb6\xbf-\xd6]'.$Close,
  '\P{greek}'	=> $Open.$SBC.'|\x83[\x40-\x7E\x80-\x9e\xb7-\xbe\xd7-\xFC]|'
		. '[\x81\x82\x84-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'. $Close,

  '\p{cyrillic}' => $Open.'\x84[\x40-\x60\x70-\x7E\x80-\x91]'.$Close,
  '\P{cyrillic}' => $Open.$SBC.'|\x84[\x61-\x6f\x92-\xFC]|'
		. '[\x81-\x83\x85-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'. $Close,

  '\p{european}' => $Open.'[\x41-\x5A\x61-\x7A]|\x82[\x60-\x79\x81-\x9A]|'
		. '\x83[\x9f-\xb6\xbf-\xd6]|\x84[\x40-\x60\x70-\x7E\x80-\x91]'
		. $Close,

  '\P{european}' => $Open.'[\x00-\x40\x5B-\x60\x7B-\x7F\xA1-\xDF]|'
		. '[\x81\x85-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]|'
		. '\x82[\x40-\x5F\x7A-\x7E\x80\x9B-\xFC]|'
		. '\x83[\x40-\x7E\x80-\x9e\xb7-\xbe\xd7-\xFC]|'
		. '\x84[\x61-\x6f\x92-\xFC]'. $Close,

  '\p{halfkana}' => $Open.'[\xA6-\xDF]'.$Close,
  '\P{halfkana}' => $Open.'[\x00-\x7F\xA1-\xA5]|' .$DBC.$Close,

  '\p{hiragana}' => $Open.'\x82[\x9F-\xF1]|\x81[\x4A\x4B\x54\x55]'.$Close,
  '\P{hiragana}' => $Open.$SBC.'|[\x83-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'
		. '|\x82[\x40-\x7E\x80-\x9E\xF2-\xFC]'
		. '|\x81[\x40-\x49\x4C-\x53\x56-\x7E\x80-\xFC]'. $Close,

  '\p{katakana}' => $Open.'\x83[\x40-\x7E\x80-\x96]|\x81[\x52\x53\x5B]'.$Close,
  '\P{katakana}' => $Open.$SBC
		. '|[\x82\x84-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'
		. '|\x83[\x97-\xFC]|\x81[\x40-\x51\x54-\x5A\x5C-\x7E\x80-\xFC]'
		. $Close,

  '\p{fullkana}' => $Open.'\x82[\x9F-\xF1]|\x83[\x40-\x7E\x80-\x96]|'
		    . '\x81[\x4A\x4B\x5B\x52-\x55]'.$Close,
  '\P{fullkana}' => $Open.$SBC.'|[\x84-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'
		. '|\x82[\x40-\x7E\x80-\x9E\xF2-\xFC]|\x83[\x97-\xFC]'
		. '|\x81[\x40-\x49\x4C-\x51\x56-\x5A\x5C-\x7E\x80-\xFC]'
		. $Close,

  '\p{kana}'	=> $Open.'[\xA6-\xDF]|\x82[\x9F-\xF1]|\x83[\x40-\x7E\x80-\x96]|'
		. '\x81[\x4A\x4B\x5B\x52-\x55]'.$Close,
  '\P{kana}'	=> $Open.'[\x00-\x7F\xA1-\xA5]|'
		. '[\x84-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]|'
		. '\x82[\x40-\x7E\x80-\x9E\xF2-\xFC]|\x83[\x97-\xFC]|'
		. '\x81[\x40-\x49\x4C-\x51\x56-\x5A\x5C-\x7E\x80-\xFC]'
		. $Close,

  '\p{kanji0}'	=> $Open.'\x81[\x56-\x5A]'.$Close,
  '\P{kanji0}'	=> $Open.$SBC.'|\x81[\x40-\x55\x5b-\x7E\x80-\xFC]'
		. '|[\x82-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'. $Close,

  '\p{kanji1}'	=> $Open.'\x88[\x9F-\xFC]|\x98[\x40-\x72]|'
		. '[\x89-\x97][\x40-\x7E\x80-\xFC]'.$Close,
  '\P{kanji1}'	=> $Open.$SBC.'|\x88[\x40-\x7E\x80-\x9E]|'
		. '\x98[\x73-\x7E\x80-\xFC]|'
		. '[\x81-\x87\x99-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'
		. $Close,

  '\p{kanji2}'	=> $Open.'\x98[\x9F-\xFC]|[\x99-\x9F\xE0-\xE9]'
		. '[\x40-\x7E\x80-\xFC]|\xEA[\x40-\x7E\x80-\xA4]'
		. $Close,
  '\P{kanji2}'	=> $Open.$SBC.'|\x98[\x40-\x7E\x80-\x9E]|'
		. '[\x81-\x97\xEB-\xFC][\x40-\x7E\x80-\xFC]|\xEA[\xA5-\xFC]'
		. $Close,

  '\p{kanji}'	=> $Open.'\x81[\x56-\x5A]|\x88[\x9F-\xFC]'
		. '|[\x89-\x97\x99-\x9F\xE0-\xE9][\x40-\x7E\x80-\xFC]'
		. '|\x98[\x40-\x72\x9F-\xFC]|\xEA[\x40-\x7E\x80-\xA4]'
		. $Close,
  '\P{kanji}'	=> $Open.$SBC
		. '|\x81[\x40-\x55\x5b-\x7E\x80-\xFC]'
		. '|\x88[\x40-\x7E\x80-\x9E]|\x98[\x73-\x7E\x80-\x9E]'
		. '|[\x82-\x87\xEB-\xFC][\x40-\x7E\x80-\xFC]'
		. '|\xEA[\xA5-\xFC]'. $Close,

  '\p{boxdrawing}' => $Open.'\x84[\x9F-\xBE]'.$Close,
  '\P{boxdrawing}' => $Open.$SBC
		. '|[\x81-\x83\x85-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]'
		. '|\x84[\x40-\x7E\x80-\x9E\xBF-\xFC]'. $Close,

  '\p{nec}'	=> $Open. '\x87[\x40-\x5d\x5f-\x75\x7e\x80-\x9c]'
		. '|\xed[\x40-\x7e\x80-\xfc]|\xee[\x40-\x7e\x80-\xec\xef-\xfc]'
		. $Close,

  '\p{ibm}'	=> $Open.'[\xfa-\xfb][\x40-\x7e\x80-\xfc]|\xfc[\x40-\x4b]'.$Close,

  '\p{vendor}'	=> $Open. '\x87[\x40-\x5d\x5f-\x75\x7e\x80-\x9c]'
		. '|[\xed\xfa-\xfb][\x40-\x7e\x80-\xfc]'
		. '|\xee[\x40-\x7e\x80-\xec\xef-\xfc]|\xfc[\x40-\x4b]'
		. $Close,

  '\p{mswin}'	=> $Open.'[\x00-\x7f\xa1-\xdf]|'
	. '\x81[\x40-\x7e\x80-\xac\xb8-\xbf\xc8-\xce\xda-\xe8\xf0-\xf7\xfc]|'
	. '\x82[\x4f-\x58\x60-\x79\x81-\x9a\x9f-\xf1]|'
	. '\x83[\x40-\x7e\x80-\x96\x9f-\xb6\xbf-\xd6]|'
	. '\x84[\x40-\x60\x70-\x7e\x80-\x91\x9f-\xbe]|'
	. '\x88[\x9f-\xfc]|\x98[\x40-\x72\x9f-\xfc]|\xea[\x40-\x7e\x80-\xa4]|'
	. '[\x89-\x97\x99-\x9f\xe0-\xe9][\x40-\x7e\x80-\xfc]|'
	. '\x87[\x40-\x5d\x5f-\x75\x7e\x80-\x9c]|'
	. '\xed[\x40-\x7e\x80-\xfc]|\xee[\x40-\x7e\x80-\xec\xef-\xfc]|'
	. '[\xfa\xfb][\x40-\x7e\x80-\xfc]|\xfc[\x40-\x4b]'
	. $Close,
);

for (qw/ nec ibm mswin vendor /) {
    $Re{"\\P{$_}"} = $Open.'(?!'. $Re{ "\\p{$_}" } .')'. $Char.$Close;
}

%AbbrevProp = qw(
  X  xdigit
  D  digit
  U  upper
  L  lower
  A  alpha
  Q  alnum
  W  word
  P  punct
  G  graph
  T  print
  S  space
  B  blank
  C  cntrl
  R  roman
  Y  hankaku
  Z  zenkaku
  F  fullwidth
  J  jis
  N  nec
  I  ibm
  V  vendor
  M  mswin
  E  european
  H  hiragana
  K  katakana
  0  kanji0
  1  kanji1
  2  kanji2
);

1;
__END__
