---
myst:
  html_meta:
    keywords: LaTeX,schéma,composants électroniques,symboles,dessin technique
---
# Comment dessiner des circuits électroniques ?

Le choix se fera en fonction de l'outil de dessin qu’on préfère (Metafont, PSTricks ou
TikZ) et des besoins de votre projet. Toutes les extensions ne sont pas maintenues au même
niveau.

## Avec l'extension <ctanpkg:pst-circ>

L'extension <ctanpkg:pst-circ> permet de dessiner des circuits électroniques grâce à
[PSTricks](ctanpkg:pstricks).

Il permet de faire les même choses que CircuitTi*k*Z. Le choix entre ces deux packages
est en partie une affaire de goût.

## Avec l'extension <ctanpkg:CircuiTikZ>

L'extension <ctanpkg:CircuiTikZ> permet de dessiner des circuits électroniques grâce à
<ctanpkg:TikZ>.

Ce pakage permet de faire les mêmes choses que <ctanpkg:pst-circ>. Les
enseignant·es de physique-chimie du secondaire le préfèreront peut-être car,
étant basé sur Ti*k*Z, une partie de sa syntaxe est commune avec
<ctanpgkg:chemfig>
([](/4_domaines_specialises/sciences/chimie/representer_des_molecules_avec_chemfig.md))

Pour des détails sur cette extension : [](/4_domaines_specialises/sciences/electronique/dessiner_circuits_avec_circuitikz.md)

## Avec l'extension <ctanpkg:circuit-macros>

L'extension <ctanpkg:circuit-macros> est beaucoup plus évoluée et plus puissante. Par
défaut, elle produit du code [pic](wp:Pic_language), mais ses versions récentes peuvent
également produire du code PSTricks, TikZ ou SVG. Elle nécessite l'utilisation de
[m4](wpfr:M4_(langage)), qui n'est disponible que sous les environnements de type Unix.


## Avec le programme `xfig`

Si vous préférez dessiner dans une interface graphique, le programme <ctanpkg:xfig>
possède [des librairies permettant de tracer des circuits
électroniques.](https://www.oocities.org/eqys/simple/simple.html)

## Avec l'extension <ctanpkg:circ>

L'extension <ctanpkg:circ> permet de dessiner des circuits électroniques grâce à
[Metafont](ctanpkg:metafont).

Ce package ne semble plus maintenu (dernière activité en 2006).

```{todo}
Package à tester 
```

## Avec l'extension <ctanpkg:MakeCirc>

L'extension <ctanpkg:MakeCirc> fait, elle, appel à [Metapost](ctanpkg:metapost).

```{caution}
Ce package ne semble plus maintenu (dernière activité en 2003).

```

```{todo}
Package à tester
```


