/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.totp.conf;

import com.google.inject.Inject;
import inet.ipaddr.IPAddress;
import java.util.Collections;
import java.util.List;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.properties.EnumGuacamoleProperty;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.guacamole.properties.IPAddressListProperty;
import org.apache.guacamole.properties.IntegerGuacamoleProperty;
import org.apache.guacamole.properties.StringGuacamoleProperty;
import org.apache.guacamole.totp.TOTPGenerator;

public class ConfigurationService {
    @Inject
    private Environment environment;
    private static final StringGuacamoleProperty TOTP_ISSUER = new StringGuacamoleProperty(){

        public String getName() {
            return "totp-issuer";
        }
    };
    private static final IntegerGuacamoleProperty TOTP_DIGITS = new IntegerGuacamoleProperty(){

        public String getName() {
            return "totp-digits";
        }
    };
    private static final IntegerGuacamoleProperty TOTP_PERIOD = new IntegerGuacamoleProperty(){

        public String getName() {
            return "totp-period";
        }
    };
    private static final EnumGuacamoleProperty<TOTPGenerator.Mode> TOTP_MODE = new EnumGuacamoleProperty<TOTPGenerator.Mode>(TOTPGenerator.Mode.class){

        public String getName() {
            return "totp-mode";
        }
    };
    private static final IPAddressListProperty TOTP_BYPASS_HOSTS = new IPAddressListProperty(){

        public String getName() {
            return "totp-bypass-hosts";
        }
    };
    private static final IPAddressListProperty TOTP_ENFORCE_HOSTS = new IPAddressListProperty(){

        public String getName() {
            return "totp-enforce-hosts";
        }
    };

    public String getIssuer() throws GuacamoleException {
        return (String)this.environment.getProperty((GuacamoleProperty)TOTP_ISSUER, (Object)"Apache Guacamole");
    }

    public int getDigits() throws GuacamoleException {
        int digits = (Integer)this.environment.getProperty((GuacamoleProperty)TOTP_DIGITS, (Object)6);
        if (digits < 6 || digits > 8) {
            throw new GuacamoleServerException("TOTP codes may have no fewer than 6 digits and no more than 8 digits.");
        }
        return digits;
    }

    public int getPeriod() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)TOTP_PERIOD, (Object)30);
    }

    public TOTPGenerator.Mode getMode() throws GuacamoleException {
        return (TOTPGenerator.Mode)((Object)this.environment.getProperty(TOTP_MODE, (Object)TOTPGenerator.Mode.SHA1));
    }

    public List<IPAddress> getBypassHosts() throws GuacamoleException {
        return (List)this.environment.getProperty((GuacamoleProperty)TOTP_BYPASS_HOSTS, Collections.emptyList());
    }

    public List<IPAddress> getEnforceHosts() throws GuacamoleException {
        return (List)this.environment.getProperty((GuacamoleProperty)TOTP_ENFORCE_HOSTS, Collections.emptyList());
    }
}

