/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.snmp;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.logstash.snmp.SnmpClient;
import org.logstash.snmp.SnmpUtils;
import org.logstash.snmp.mib.MibManager;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OctetString;

public final class SnmpClientBuilder {
    private final MibManager mib;
    private final int port;
    private OctetString localEngineId = new OctetString(MPv3.createLocalEngineID());
    private final Set<String> supportedTransports;
    private Set<Integer> supportedVersions = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(3));
    private String host = "0.0.0.0";
    private final List<UsmUser> usmUsers = new ArrayList<UsmUser>();
    private int messageDispatcherPoolSize = 1;
    private String messageDispatcherPoolName = "SnmpMessageDispatcherWorker";
    private Duration closeTimeoutDuration;
    private boolean mapOidVariableValues = false;

    public SnmpClientBuilder(MibManager mib, Set<String> supportedTransports, int port) {
        this.mib = mib;
        this.supportedTransports = supportedTransports;
        this.port = port;
    }

    public SnmpClientBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    public SnmpClientBuilder setLocalEngineId(String localEngineId) {
        this.localEngineId = new OctetString(localEngineId);
        return this;
    }

    public SnmpClientBuilder addUsmUser(String securityName, String authProtocol, String authPassphrase, String privProtocol, String privPassphrase) {
        this.usmUsers.add(new UsmUser(new OctetString(securityName), SnmpUtils.parseAuthProtocol(authProtocol), SnmpUtils.parseNullableOctetString(authPassphrase), SnmpUtils.parsePrivProtocol(privProtocol), SnmpUtils.parseNullableOctetString(privPassphrase)));
        return this;
    }

    public SnmpClientBuilder setMessageDispatcherPoolName(String messageDispatcherPoolName) {
        this.messageDispatcherPoolName = messageDispatcherPoolName;
        return this;
    }

    public SnmpClientBuilder setMessageDispatcherPoolSize(int messageDispatcherPoolSize) {
        this.messageDispatcherPoolSize = Math.max(1, messageDispatcherPoolSize);
        return this;
    }

    public SnmpClientBuilder setSupportedVersions(Set<String> supportedVersions) {
        Set versions = supportedVersions.stream().map(SnmpUtils::parseSnmpVersion).collect(Collectors.toCollection(HashSet::new));
        if (versions.isEmpty()) {
            throw new IllegalArgumentException("at least one SNMP version must be supported");
        }
        this.supportedVersions = versions;
        return this;
    }

    SnmpClientBuilder setCloseTimeoutDuration(Duration closeTimeoutDuration) {
        this.closeTimeoutDuration = closeTimeoutDuration;
        return this;
    }

    public SnmpClientBuilder setMapOidVariableValues(boolean mapOidVariableValues) {
        this.mapOidVariableValues = mapOidVariableValues;
        return this;
    }

    public SnmpClient build() throws IOException {
        SnmpClient client = new SnmpClient(this.mib, this.supportedTransports, this.supportedVersions, this.host, this.port, this.messageDispatcherPoolName, this.messageDispatcherPoolSize, this.usmUsers, this.localEngineId, this.mapOidVariableValues);
        if (this.closeTimeoutDuration != null) {
            client.setCloseTimeoutDuration(this.closeTimeoutDuration);
        }
        return client;
    }
}

