/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.Limit;

public class CounterOutputStream
extends OutputStream
implements Limit {
    protected OutputStream out;
    private int count;
    private int limit = -1;

    public void setOutputStream(OutputStream out) {
        this.out = out;
        this.setLimit(-1);
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public void setLimit(int limit) {
        this.count = 0;
        this.limit = limit;
    }

    @Override
    public int clearLimit() {
        int unused = this.limit - this.count;
        this.limit = 0;
        return unused;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.limit >= 0 && this.count + 1 > this.limit) {
            throw new EOFException();
        }
        if (this.out != null) {
            this.out.write(b);
        }
        ++this.count;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.limit >= 0 && this.count + len > this.limit) {
            throw new EOFException();
        }
        if (this.out != null) {
            this.out.write(b, off, len);
        }
        this.count += len;
    }
}

