/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import com.google.common.collect.Sets;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.component.ComponentWithCoordinates;
import org.gradle.api.component.SoftwareComponentVariant;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.provider.Provider;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.TargetMachine;
import org.gradle.util.internal.GUtil;

public class NativeVariantIdentity
implements SoftwareComponentInternal,
ComponentWithCoordinates {
    private final String name;
    private final Provider<String> baseName;
    private final Provider<String> group;
    private final Provider<String> version;
    private final boolean debuggable;
    private final boolean optimized;
    private final TargetMachine targetMachine;
    private final SoftwareComponentVariant linkVariant;
    private final SoftwareComponentVariant runtimeVariant;
    private final Linkage linkage;
    private final Set<UsageContext> variants;

    public NativeVariantIdentity(String name, Provider<String> baseName, Provider<String> group, Provider<String> version, boolean debuggable, boolean optimized, TargetMachine targetMachine, UsageContext linkVariant, UsageContext runtimeVariant) {
        this(name, baseName, group, version, debuggable, optimized, targetMachine, linkVariant, runtimeVariant, null);
    }

    public NativeVariantIdentity(String name, Provider<String> baseName, Provider<String> group, Provider<String> version, boolean debuggable, boolean optimized, TargetMachine targetMachine, UsageContext linkVariant, UsageContext runtimeVariant, Linkage linkage) {
        this.name = name;
        this.baseName = baseName;
        this.group = group;
        this.version = version;
        this.debuggable = debuggable;
        this.optimized = optimized;
        this.targetMachine = targetMachine;
        this.linkVariant = linkVariant;
        this.runtimeVariant = runtimeVariant;
        this.linkage = linkage;
        this.variants = Sets.newLinkedHashSet();
        if (linkVariant != null) {
            this.variants.add(linkVariant);
        }
        if (runtimeVariant != null) {
            this.variants.add(runtimeVariant);
        }
    }

    public boolean isDebuggable() {
        return this.debuggable;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public TargetMachine getTargetMachine() {
        return this.targetMachine;
    }

    public Linkage getLinkage() {
        return this.linkage;
    }

    public ModuleVersionIdentifier getCoordinates() {
        return DefaultModuleVersionIdentifier.newId((String)((String)this.group.get()), (String)((String)this.baseName.get() + "_" + GUtil.toWords((CharSequence)this.name, (char)'_')), (String)((String)this.version.get()));
    }

    public Set<? extends UsageContext> getUsages() {
        return this.variants;
    }

    public String getName() {
        return this.name;
    }

    public SoftwareComponentVariant getRuntimeVariant() {
        return this.runtimeVariant;
    }

    public SoftwareComponentVariant getLinkVariant() {
        return this.linkVariant;
    }
}

