/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFunction;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.PermissionDeniedException;
import com.google.api.gax.rpc.UnavailableException;
import com.google.cloud.opentelemetry.metric.GoogleCloudMetricExporter;
import com.google.cloud.opentelemetry.metric.MetricConfiguration;
import com.google.cloud.opentelemetry.metric.MonitoredResourceDescription;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.grpc.ManagedChannelBuilder;
import io.grpc.opentelemetry.GrpcOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.contrib.gcp.resource.GCPResourceProvider;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.resources.Resource;
import java.math.BigDecimal;
import java.math.MathContext;
import java.net.NoRouteToHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.stream.Collectors;

final class OpenTelemetryBootstrappingUtils {
    private static final Collection<String> METRICS_TO_ENABLE = ImmutableList.of((Object)"grpc.lb.wrr.rr_fallback", (Object)"grpc.lb.wrr.endpoint_weight_not_yet_usable", (Object)"grpc.lb.wrr.endpoint_weight_stale", (Object)"grpc.lb.wrr.endpoint_weights", (Object)"grpc.lb.rls.cache_entries", (Object)"grpc.lb.rls.cache_size", (Object)"grpc.lb.rls.default_target_picks", (Object)"grpc.lb.rls.target_picks", (Object)"grpc.lb.rls.failed_picks", (Object)"grpc.xds_client.connected", (Object)"grpc.xds_client.server_failure", (Object)"grpc.xds_client.resource_updates_valid", (Object[])new String[]{"grpc.xds_client.resource_updates_invalid", "grpc.xds_client.resources"});
    private static final Collection<String> METRICS_ENABLED_BY_DEFAULT = ImmutableList.of((Object)"grpc.client.attempt.sent_total_compressed_message_size", (Object)"grpc.client.attempt.rcvd_total_compressed_message_size", (Object)"grpc.client.attempt.started", (Object)"grpc.client.attempt.duration", (Object)"grpc.client.call.duration");
    static final Logger log = Logger.getLogger(OpenTelemetryBootstrappingUtils.class.getName());

    OpenTelemetryBootstrappingUtils() {
    }

    static void enableGrpcMetrics(InstantiatingGrpcChannelProvider.Builder channelProviderBuilder, String endpoint, String projectId, String universeDomain, boolean shouldSuppressExceptions) {
        String metricServiceEndpoint = OpenTelemetryBootstrappingUtils.getCloudMonitoringEndpoint(endpoint, universeDomain);
        SdkMeterProvider provider = OpenTelemetryBootstrappingUtils.createMeterProvider(metricServiceEndpoint, projectId, shouldSuppressExceptions);
        OpenTelemetrySdk openTelemetrySdk = OpenTelemetrySdk.builder().setMeterProvider(provider).build();
        GrpcOpenTelemetry grpcOpenTelemetry = GrpcOpenTelemetry.newBuilder().sdk((OpenTelemetry)openTelemetrySdk).addOptionalLabel("grpc.lb.locality").enableMetrics(METRICS_TO_ENABLE).build();
        ApiFunction channelConfigurator = channelProviderBuilder.getChannelConfigurator();
        channelProviderBuilder.setChannelConfigurator(b -> {
            grpcOpenTelemetry.configureChannelBuilder(b);
            if (channelConfigurator != null) {
                return (ManagedChannelBuilder)channelConfigurator.apply(b);
            }
            return b;
        });
    }

    @VisibleForTesting
    static String getCloudMonitoringEndpoint(String endpoint, String universeDomain) {
        String metricServiceEndpoint = "monitoring.googleapis.com";
        if (universeDomain != null && endpoint.contains("storage." + universeDomain)) {
            metricServiceEndpoint = "monitoring." + universeDomain;
        } else if (!endpoint.contains("storage.googleapis.com")) {
            String match;
            String canonicalEndpoint = "storage.googleapis.com";
            String privateEndpoint = "private.googleapis.com";
            String restrictedEndpoint = "restricted.googleapis.com";
            if (universeDomain != null) {
                canonicalEndpoint = "storage." + universeDomain;
                privateEndpoint = "private." + universeDomain;
                restrictedEndpoint = "restricted." + universeDomain;
            }
            if (!StringUtils.isNullOrEmpty((String)(match = ImmutableList.of((Object)canonicalEndpoint, (Object)privateEndpoint, (Object)restrictedEndpoint).stream().filter(s -> endpoint.contains((CharSequence)s) || endpoint.contains("google-c2p:///" + s)).collect(Collectors.joining())))) {
                metricServiceEndpoint = match;
            }
        }
        return metricServiceEndpoint + ":" + endpoint.split(":")[1];
    }

    @VisibleForTesting
    static SdkMeterProvider createMeterProvider(String metricServiceEndpoint, String projectId, boolean shouldSuppressExceptions) {
        String projectIdToUse;
        GCPResourceProvider resourceProvider = new GCPResourceProvider();
        Attributes detectedAttributes = resourceProvider.getAttributes();
        String detectedProjectId = (String)detectedAttributes.get(AttributeKey.stringKey((String)"cloud.account.id"));
        String string = projectIdToUse = detectedProjectId == null ? projectId : detectedProjectId;
        if (!projectIdToUse.equals(projectId)) {
            log.warning("The Project ID configured for metrics is " + projectIdToUse + ", but the Project ID of the storage client is " + projectId + ". Make sure that the service account in use has the required metric writing role (roles/monitoring.metricWriter) in the project " + projectIdToUse + ", or metrics will not be written.");
        }
        MonitoredResourceDescription monitoredResourceDescription = new MonitoredResourceDescription("storage.googleapis.com/Client", (Set)ImmutableSet.of((Object)"project_id", (Object)"location", (Object)"cloud_platform", (Object)"host_id", (Object)"instance_id", (Object)"api", (Object[])new String[0]));
        MetricExporter cloudMonitoringExporter = GoogleCloudMetricExporter.createWithConfiguration((MetricConfiguration)MetricConfiguration.builder().setMonitoredResourceDescription(monitoredResourceDescription).setInstrumentationLibraryLabelsEnabled(false).setMetricServiceEndpoint(metricServiceEndpoint).setPrefix("storage.googleapis.com/client").setUseServiceTimeSeries(true).setProjectId(projectIdToUse).build());
        SdkMeterProviderBuilder providerBuilder = SdkMeterProvider.builder();
        for (String metric : ImmutableList.copyOf((Iterable)Iterables.concat(METRICS_TO_ENABLE, METRICS_ENABLED_BY_DEFAULT))) {
            providerBuilder.registerView(InstrumentSelector.builder().setName(metric).build(), View.builder().setName(metric.replace(".", "/")).build());
        }
        MetricExporter exporter = shouldSuppressExceptions ? new PermissionDeniedSingleReportMetricsExporter(cloudMonitoringExporter) : cloudMonitoringExporter;
        AttributesBuilder attributesBuilder = Attributes.builder().put("gcp.resource_type", "storage.googleapis.com/Client").put("project_id", projectIdToUse).put("instance_id", UUID.randomUUID().toString()).put("api", "grpc");
        String detectedLocation = (String)detectedAttributes.get(AttributeKey.stringKey((String)"cloud.region"));
        if (detectedLocation != null) {
            attributesBuilder.put("location", detectedLocation);
        } else {
            attributesBuilder.put("location", "global");
        }
        String detectedCloudPlatform = (String)detectedAttributes.get(AttributeKey.stringKey((String)"cloud.platform"));
        if (detectedCloudPlatform != null) {
            attributesBuilder.put("cloud_platform", detectedCloudPlatform);
        } else {
            attributesBuilder.put("cloud_platform", "unknown");
        }
        String detectedHostId = (String)detectedAttributes.get(AttributeKey.stringKey((String)"host.id"));
        if (detectedHostId != null) {
            attributesBuilder.put("host_id", detectedHostId);
        } else {
            attributesBuilder.put("host_id", "unknown");
        }
        providerBuilder.registerMetricReader((MetricReader)PeriodicMetricReader.builder((MetricExporter)exporter).setInterval(Duration.ofSeconds(60L)).build()).setResource(Resource.create((Attributes)attributesBuilder.build()));
        OpenTelemetryBootstrappingUtils.addHistogramView(providerBuilder, OpenTelemetryBootstrappingUtils.latencyHistogramBoundaries(), "grpc/client/attempt/duration", "s");
        OpenTelemetryBootstrappingUtils.addHistogramView(providerBuilder, OpenTelemetryBootstrappingUtils.sizeHistogramBoundaries(), "grpc/client/attempt/rcvd_total_compressed_message_size", "By");
        OpenTelemetryBootstrappingUtils.addHistogramView(providerBuilder, OpenTelemetryBootstrappingUtils.sizeHistogramBoundaries(), "grpc/client/attempt/sent_total_compressed_message_size", "By");
        return providerBuilder.build();
    }

    private static void addHistogramView(SdkMeterProviderBuilder provider, List<Double> boundaries, String name, String unit) {
        InstrumentSelector instrumentSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setUnit(unit).setName(name).setMeterName("grpc-java").setMeterSchemaUrl("").build();
        View view = View.builder().setName(name).setDescription("A view of " + name + " with histogram boundaries more appropriate for Google Cloud Storage RPCs").setAggregation(Aggregation.explicitBucketHistogram(boundaries)).build();
        provider.registerView(instrumentSelector, view);
    }

    private static List<Double> latencyHistogramBoundaries() {
        int i;
        ArrayList<Double> boundaries = new ArrayList<Double>();
        BigDecimal boundary = new BigDecimal(0, MathContext.UNLIMITED);
        BigDecimal increment = new BigDecimal("0.002", MathContext.UNLIMITED);
        for (i = 0; i != 50; ++i) {
            boundaries.add(boundary.doubleValue());
            boundary = boundary.add(increment);
        }
        increment = new BigDecimal("0.01", MathContext.UNLIMITED);
        for (i = 0; i != 150 && boundary.compareTo(new BigDecimal(300)) < 1; ++i) {
            boundaries.add(boundary.doubleValue());
            if (i != 0 && i % 10 == 0) {
                increment = increment.multiply(new BigDecimal(2));
            }
            boundary = boundary.add(increment);
        }
        return boundaries;
    }

    private static List<Double> sizeHistogramBoundaries() {
        long kb = 1024L;
        long mb = 1024L * kb;
        long gb = 1024L * mb;
        ArrayList<Double> boundaries = new ArrayList<Double>();
        long boundary = 0L;
        long increment = 128L * kb;
        while (boundaries.size() < 200 && boundary <= 16L * gb) {
            boundaries.add(Double.valueOf(boundary));
            if ((boundary += increment) < 4L * mb) continue;
            increment *= 2L;
        }
        return boundaries;
    }

    private static final class PermissionDeniedSingleReportMetricsExporter
    implements MetricExporter {
        private final MetricExporter delegate;
        private final AtomicBoolean seenPermissionDenied = new AtomicBoolean(false);
        private final AtomicBoolean seenNoRouteToHost = new AtomicBoolean(false);

        private PermissionDeniedSingleReportMetricsExporter(MetricExporter delegate) {
            this.delegate = delegate;
        }

        public CompletableResultCode export(Collection<MetricData> metrics) {
            if (this.seenPermissionDenied.get() && this.seenNoRouteToHost.get()) {
                return CompletableResultCode.ofFailure();
            }
            try {
                return this.delegate.export(metrics);
            }
            catch (PermissionDeniedException e) {
                if (!this.seenPermissionDenied.get()) {
                    this.seenPermissionDenied.set(true);
                    throw e;
                }
                return CompletableResultCode.ofFailure();
            }
            catch (UnavailableException e) {
                if (this.seenPermissionDenied.get() && !this.seenNoRouteToHost.get() && PermissionDeniedSingleReportMetricsExporter.ultimateCause(e, NoRouteToHostException.class)) {
                    this.seenNoRouteToHost.set(true);
                    throw e;
                }
                return CompletableResultCode.ofFailure();
            }
        }

        public Aggregation getDefaultAggregation(InstrumentType instrumentType) {
            return this.delegate.getDefaultAggregation(instrumentType);
        }

        public MemoryMode getMemoryMode() {
            return this.delegate.getMemoryMode();
        }

        public CompletableResultCode flush() {
            return this.delegate.flush();
        }

        public CompletableResultCode shutdown() {
            return this.delegate.shutdown();
        }

        public void close() {
            this.delegate.close();
        }

        public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
            return this.delegate.getAggregationTemporality(instrumentType);
        }

        public DefaultAggregationSelector with(InstrumentType instrumentType, Aggregation aggregation) {
            return this.delegate.with(instrumentType, aggregation);
        }

        private static boolean ultimateCause(Throwable t, Class<? extends Throwable> c) {
            if (t == null) {
                return false;
            }
            Throwable cause = t.getCause();
            if (cause != null && c.isAssignableFrom(cause.getClass())) {
                return true;
            }
            return PermissionDeniedSingleReportMetricsExporter.ultimateCause(cause, c);
        }
    }
}

