/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.viewer.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import org.graalvm.visualvm.gotosource.SourceHandle;
import org.graalvm.visualvm.gotosource.viewer.internal.InternalSourceAppearance;
import org.graalvm.visualvm.gotosource.viewer.internal.InternalSourceViewerComponent;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class InternalSourceViewerTopComponent
extends TopComponent {
    private static final String ICON_PATH = "org/graalvm/visualvm/gotosource/resources/gotosource.png";
    private final InternalSourceViewerComponent viewerComponent;
    private Component lastFocusOwner;
    private final PropertyChangeListener focusListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Component c = evt.getNewValue() instanceof Component ? (Component)evt.getNewValue() : null;
            this.processFocusedComponent(c);
        }

        private void processFocusedComponent(Component c) {
            Component cc = c;
            while (c != null) {
                if (c == InternalSourceViewerTopComponent.this) {
                    InternalSourceViewerTopComponent.this.lastFocusOwner = cc;
                    return;
                }
                c = c.getParent();
            }
        }
    };

    static void showSource(String uri, String text, int offset, int endOffset, InternalSourceAppearance appearance) {
        String file = SourceHandle.simpleUri(uri);
        InternalSourceViewerTopComponent container = InternalSourceViewerTopComponent.findOpened(file);
        if (container == null) {
            container = new InternalSourceViewerTopComponent(file, text, offset, endOffset, appearance);
            container.open();
        } else {
            container.setOffset(offset, endOffset);
        }
        container.requestActive();
    }

    private static InternalSourceViewerTopComponent findOpened(String file) {
        for (TopComponent opened : WindowManager.getDefault().getRegistry().getOpened()) {
            if (!(opened instanceof InternalSourceViewerTopComponent) || !file.equals(opened.getToolTipText())) continue;
            return (InternalSourceViewerTopComponent)opened;
        }
        return null;
    }

    private InternalSourceViewerTopComponent(String file, String text, int offset, int endOffset, InternalSourceAppearance appearance) {
        this.setDisplayName(new File(file).getName());
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.setToolTipText(file);
        this.viewerComponent = new InternalSourceViewerComponent(text, offset, endOffset, appearance);
        this.setLayout(new BorderLayout());
        this.add(this.viewerComponent, "Center");
    }

    private void setOffset(int offset, int endOffset) {
        this.viewerComponent.setOffset(offset, endOffset);
    }

    protected void componentClosed() {
        super.componentClosed();
        this.viewerComponent.cleanup();
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return this.getDisplayName();
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected void componentActivated() {
        super.componentActivated();
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else {
            Component defaultFocusOwner = this.defaultFocusOwner();
            if (defaultFocusOwner != null) {
                defaultFocusOwner.requestFocus();
            }
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.focusListener);
    }

    protected void componentDeactivated() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this.focusListener);
        super.componentDeactivated();
    }

    protected Component defaultFocusOwner() {
        return this.viewerComponent.defaultFocusOwner();
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }
}

