/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.model;

import java.util.Set;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.DataChangeEvent;
import org.graalvm.visualvm.core.datasupport.DataChangeListener;
import org.graalvm.visualvm.core.model.AbstractModelProvider;
import org.graalvm.visualvm.core.model.ModelFactory;
import org.graalvm.visualvm.core.model.ModelProvider;
import org.graalvm.visualvm.jfr.model.JFRModel;

public final class JFRModelFactory
extends ModelFactory<JFRModel, DataSource> {
    private static JFRModelFactory FACTORY;
    private boolean hasProviders;
    private boolean hasGenericProvider;

    private JFRModelFactory() {
        this.addFactoryChangeListener((DataChangeListener)new DataChangeListener<ModelProvider<JFRModel, DataSource>>(){

            public void dataChanged(DataChangeEvent<ModelProvider<JFRModel, DataSource>> dce) {
                Set providers = dce.getCurrent();
                JFRModelFactory.this.hasProviders = !providers.isEmpty();
                JFRModelFactory.this.hasGenericProvider = JFRModelFactory.this.hasProviders && providers.toString().contains("generic loader");
            }
        });
    }

    public static synchronized JFRModelFactory getDefault() {
        if (FACTORY == null) {
            FACTORY = new JFRModelFactory();
        }
        return FACTORY;
    }

    public static JFRModel getJFRModelFor(DataSource app) {
        JFRModel model = (JFRModel)JFRModelFactory.getDefault().getModel(app);
        return model == JFRModel.OOME ? null : model;
    }

    public final boolean hasProviders() {
        return this.hasProviders;
    }

    public final boolean hasGenericProvider() {
        return this.hasGenericProvider;
    }

    @Deprecated
    public static void cleanupModel__Workaround(JFRModel model) {
        AbstractModelProvider<JFRModel, DataSource> workaround = new AbstractModelProvider<JFRModel, DataSource>(){

            public JFRModel createModelFor(DataSource b) {
                return null;
            }
        };
        JFRModelFactory.getDefault().registerProvider((ModelProvider)workaround);
        JFRModelFactory.getDefault().unregisterProvider((ModelProvider)workaround);
    }
}

