/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ci;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.ci.ciMetadata;
import sun.jvm.hotspot.ci.ciObject;
import sun.jvm.hotspot.ci.ciSymbol;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VirtualBaseConstructor;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.GrowableArray;

public class ciObjectFactory
extends VMObject {
    private static AddressField unloadedMethodsField;
    private static AddressField ciMetadataField;
    private static AddressField symbolsField;
    private static VirtualBaseConstructor<ciObject> ciObjectConstructor;
    private static VirtualBaseConstructor<ciMetadata> ciMetadataConstructor;
    private static VirtualBaseConstructor<ciSymbol> ciSymbolConstructor;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("ciObjectFactory");
        unloadedMethodsField = type.getAddressField("_unloaded_methods");
        ciMetadataField = type.getAddressField("_ci_metadata");
        symbolsField = type.getAddressField("_symbols");
        ciObjectConstructor = new VirtualBaseConstructor(db, db.lookupType("ciObject"), "sun.jvm.hotspot.ci", ciObject.class);
        ciMetadataConstructor = new VirtualBaseConstructor(db, db.lookupType("ciMetadata"), "sun.jvm.hotspot.ci", ciMetadata.class);
        ciSymbolConstructor = new VirtualBaseConstructor(db, db.lookupType("ciSymbol"), "sun.jvm.hotspot.ci", ciSymbol.class);
    }

    public static ciObject get(Address addr) {
        if (addr == null) {
            return null;
        }
        return ciObjectConstructor.instantiateWrapperFor(addr);
    }

    public static ciMetadata getMetadata(Address addr) {
        if (addr == null) {
            return null;
        }
        return ciMetadataConstructor.instantiateWrapperFor(addr);
    }

    public GrowableArray<ciMetadata> objects() {
        return GrowableArray.create(ciMetadataField.getValue(this.getAddress()), ciMetadataConstructor);
    }

    public GrowableArray<ciSymbol> symbols() {
        return GrowableArray.create(symbolsField.getValue(this.getAddress()), ciSymbolConstructor);
    }

    public ciObjectFactory(Address addr) {
        super(addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ciObjectFactory.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

