.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XUnmapWindow __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XUnmapWindow, XUnmapSubwindows \- unmap windows
.SH SYNTAX
.HP
int XUnmapWindow\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^);
.HP
int XUnmapSubwindows\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIw\fP 1i
Specifies the window.
.SH DESCRIPTION
The
.B XUnmapWindow
function unmaps the specified window and causes the X server to generate an
.B UnmapNotify
event.
If the specified window is already unmapped,
.B XUnmapWindow
has no effect.
Normal exposure processing on formerly obscured windows is performed.
Any child window will no longer be visible until another map call is
made on the parent.
In other words, the subwindows are still mapped but are not visible
until the parent is mapped.
Unmapping a window will generate
.B Expose
events on windows that were formerly obscured by it.
.LP
.B XUnmapWindow
can generate a
.B BadWindow
error.
.LP
The
.B XUnmapSubwindows
function unmaps all subwindows for the specified window in bottom-to-top
stacking order.
It causes the X server to generate an
.B UnmapNotify
event on each subwindow and
.B Expose
events on formerly obscured windows.
Using this function is much more efficient than unmapping multiple windows
one at a time because the server needs to perform much of the work
only once, for all of the windows, rather than for each window.
.LP
.B XUnmapSubwindows
can generate a
.B BadWindow
error.
.SH DIAGNOSTICS
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
.BR XChangeWindowAttributes (__libmansuffix__),
.BR XConfigureWindow (__libmansuffix__),
.BR XCreateWindow (__libmansuffix__),
.BR XDestroyWindow (__libmansuffix__),
.BR XMapWindow (__libmansuffix__)
.BR XRaiseWindow (__libmansuffix__)
.br
\fI\*(xL\fP
