.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XQueryBestSize __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XQueryBestSize, XQueryBestTile, XQueryBestStipple \- determine efficient sizes
.SH SYNTAX
.HP
Status XQueryBestSize\^(\^Display *\fIdisplay\fP\^, int \fIclass\fP\^,
Drawable \fIwhich_screen\fP\^, unsigned int \fIwidth\fP, unsigned int
\fIheight\fP\^, unsigned int *\fIwidth_return\fP, unsigned int
*\fIheight_return\fP\^);
.HP
Status XQueryBestTile\^(\^Display *\fIdisplay\fP\^, Drawable
\fIwhich_screen\fP\^, unsigned int \fIwidth\fP, unsigned int \fIheight\fP\^,
unsigned int *\fIwidth_return\fP, unsigned int *\fIheight_return\fP\^);
.HP
Status XQueryBestStipple\^(\^Display *\fIdisplay\fP\^, Drawable
\fIwhich_screen\fP\^, unsigned int \fIwidth\fP, unsigned int \fIheight\fP\^,
unsigned int *\fIwidth_return\fP, unsigned int *\fIheight_return\fP\^);
.SH ARGUMENTS
.IP \fIclass\fP 1i
Specifies the class that you are interested in.
You can pass
.BR TileShape ,
.BR CursorShape ,
or
.BR StippleShape .
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIwidth\fP 1i
.br
.ns
.IP \fIheight\fP 1i
Specify the width and height.
.IP \fIwhich_screen\fP 1i
Specifies any drawable on the screen.
.IP \fIwidth_return\fP 1i
.br
.ns
.IP \fIheight_return\fP 1i
Return the width and height of the object best supported
by the display hardware.
.SH DESCRIPTION
The
.B XQueryBestSize
function returns the best or closest size to the specified size.
For
.BR CursorShape ,
this is the largest size that can be fully displayed on the screen specified by
which_screen.
For
.BR TileShape ,
this is the size that can be tiled fastest.
For
.BR StippleShape ,
this is the size that can be stippled fastest.
For
.BR CursorShape ,
the drawable indicates the desired screen.
For
.B TileShape
and
.BR StippleShape ,
the drawable indicates the screen and possibly the window class and depth.
An
.B InputOnly
window cannot be used as the drawable for
.B TileShape
or
.BR StippleShape ,
or a
.B BadMatch
error results.
.LP
.B XQueryBestSize
can generate
.BR BadDrawable ,
.BR BadMatch ,
and
.B BadValue
errors.
.LP
The
.B XQueryBestTile
function returns the best or closest size, that is, the size that can be
tiled fastest on the screen specified by which_screen.
The drawable indicates the screen and possibly the window class and depth.
If an
.B InputOnly
window is used as the drawable, a
.B BadMatch
error results.
.LP
.B XQueryBestTile
can generate
.B BadDrawable
and
.B BadMatch
errors.
.LP
The
.B XQueryBestStipple
function returns the best or closest size, that is, the size that can be
stippled fastest on the screen specified by which_screen.
The drawable indicates the screen and possibly the window class and depth.
If an
.B InputOnly
window is used as the drawable, a
.B BadMatch
error results.
.LP
.B XQueryBestStipple
can generate
.B BadDrawable
and
.B BadMatch
errors.
.SH DIAGNOSTICS
.TP 1i
.B BadMatch
An
.B InputOnly
window is used as a Drawable.
.TP 1i
.B BadDrawable
A value for a Drawable argument does not name a defined Window or Pixmap.
.TP 1i
.B BadMatch
The values do not exist for an
.B InputOnly
window.
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
.BR XCreateGC (__libmansuffix__),
.BR XSetArcMode (__libmansuffix__),
.BR XSetClipOrigin (__libmansuffix__),
.BR XSetFillStyle (__libmansuffix__),
.BR XSetFont (__libmansuffix__),
.BR XSetLineAttributes (__libmansuffix__),
.BR XSetState (__libmansuffix__),
.BR XSetTile (__libmansuffix__)
.br
\fI\*(xL\fP
