# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, Callable, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._operations._operations import (
    build_confidential_ledger_create_ledger_entry_request,
    build_confidential_ledger_create_or_update_ledger_user_request,
    build_confidential_ledger_create_or_update_user_request,
    build_confidential_ledger_create_user_defined_endpoint_request,
    build_confidential_ledger_create_user_defined_function_request,
    build_confidential_ledger_create_user_defined_role_request,
    build_confidential_ledger_delete_ledger_user_request,
    build_confidential_ledger_delete_user_defined_function_request,
    build_confidential_ledger_delete_user_defined_role_request,
    build_confidential_ledger_delete_user_request,
    build_confidential_ledger_execute_user_defined_function_request,
    build_confidential_ledger_get_constitution_request,
    build_confidential_ledger_get_current_ledger_entry_request,
    build_confidential_ledger_get_enclave_quotes_request,
    build_confidential_ledger_get_ledger_entry_request,
    build_confidential_ledger_get_ledger_user_request,
    build_confidential_ledger_get_receipt_request,
    build_confidential_ledger_get_runtime_options_request,
    build_confidential_ledger_get_transaction_status_request,
    build_confidential_ledger_get_user_defined_endpoint_request,
    build_confidential_ledger_get_user_defined_endpoints_module_request,
    build_confidential_ledger_get_user_defined_function_request,
    build_confidential_ledger_get_user_defined_role_request,
    build_confidential_ledger_get_user_request,
    build_confidential_ledger_list_collections_request,
    build_confidential_ledger_list_consortium_members_request,
    build_confidential_ledger_list_ledger_entries_request,
    build_confidential_ledger_list_ledger_users_request,
    build_confidential_ledger_list_user_defined_functions_request,
    build_confidential_ledger_list_users_request,
    build_confidential_ledger_update_runtime_options_request,
    build_confidential_ledger_update_user_defined_role_request,
)
from ..._utils.model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from ..._utils.utils import ClientMixinABC
from .._configuration import ConfidentialLedgerClientConfiguration

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, dict[str, Any]], Any]]


class _ConfidentialLedgerClientOperationsMixin(  # pylint: disable=too-many-public-methods
    ClientMixinABC[AsyncPipelineClient[HttpRequest, AsyncHttpResponse], ConfidentialLedgerClientConfiguration]
):

    @distributed_trace_async
    async def get_constitution(self, **kwargs: Any) -> _models.Constitution:
        """Gets the constitution used for governance.

        The constitution is a script that assesses and applies proposals from
        consortium members.

        :return: Constitution. The Constitution is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.Constitution
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Constitution] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_constitution_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Constitution, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_consortium_members(self, **kwargs: Any) -> AsyncItemPaged["_models.ConsortiumMember"]:
        """Lists the consortium members.

        Consortium members can manage the Confidential Ledger.

        :return: An iterator like instance of ConsortiumMember
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.confidentialledger.models.ConsortiumMember]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.ConsortiumMember]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_confidential_ledger_list_consortium_members_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.ConsortiumMember], deserialized.get("members", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_enclave_quotes(self, **kwargs: Any) -> _models.ConfidentialLedgerEnclaves:
        """Gets quotes for all nodes of the Confidential Ledger.

        A quote is an SGX enclave measurement that can be used to verify the validity
        of a node and its enclave.

        :return: ConfidentialLedgerEnclaves. The ConfidentialLedgerEnclaves is compatible with
         MutableMapping
        :rtype: ~azure.confidentialledger.models.ConfidentialLedgerEnclaves
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ConfidentialLedgerEnclaves] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_enclave_quotes_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ConfidentialLedgerEnclaves, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_collections(self, **kwargs: Any) -> AsyncItemPaged["_models.Collection"]:
        """Retrieves a list of collection ids present in the Confidential Ledger.

        Collection ids are user-created collections of ledger entries.

        :return: An iterator like instance of Collection
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.confidentialledger.models.Collection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.Collection]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_confidential_ledger_list_collections_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.Collection], deserialized.get("collections", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_ledger_entries(
        self,
        *,
        collection_id: Optional[str] = None,
        from_transaction_id: Optional[str] = None,
        to_transaction_id: Optional[str] = None,
        tag: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.LedgerEntry"]:
        """Gets ledger entries from a collection corresponding to a range.

        A collection id may optionally be specified. Only entries in the specified (or
        default) collection will be returned.

        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :keyword from_transaction_id: Specify the first transaction ID in a range. Default value is
         None.
        :paramtype from_transaction_id: str
        :keyword to_transaction_id: Specify the last transaction ID in a range. Default value is None.
        :paramtype to_transaction_id: str
        :keyword tag: Single tag. Default value is None.
        :paramtype tag: str
        :return: An iterator like instance of LedgerEntry
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.confidentialledger.models.LedgerEntry]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.LedgerEntry]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_confidential_ledger_list_ledger_entries_request(
                    collection_id=collection_id,
                    from_transaction_id=from_transaction_id,
                    to_transaction_id=to_transaction_id,
                    tag=tag,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.LedgerEntry], deserialized.get("entries", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def create_ledger_entry(
        self,
        entry: _models.LedgerEntry,
        *,
        collection_id: Optional[str] = None,
        tags: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LedgerWriteResult:
        """Writes a ledger entry.

        A collection id may optionally be specified.

        :param entry: Ledger entry. Required.
        :type entry: ~azure.confidentialledger.models.LedgerEntry
        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :keyword tags: Comma separated tags. Default value is None.
        :paramtype tags: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: LedgerWriteResult. The LedgerWriteResult is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.LedgerWriteResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_ledger_entry(
        self,
        entry: JSON,
        *,
        collection_id: Optional[str] = None,
        tags: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LedgerWriteResult:
        """Writes a ledger entry.

        A collection id may optionally be specified.

        :param entry: Ledger entry. Required.
        :type entry: JSON
        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :keyword tags: Comma separated tags. Default value is None.
        :paramtype tags: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: LedgerWriteResult. The LedgerWriteResult is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.LedgerWriteResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_ledger_entry(
        self,
        entry: IO[bytes],
        *,
        collection_id: Optional[str] = None,
        tags: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LedgerWriteResult:
        """Writes a ledger entry.

        A collection id may optionally be specified.

        :param entry: Ledger entry. Required.
        :type entry: IO[bytes]
        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :keyword tags: Comma separated tags. Default value is None.
        :paramtype tags: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: LedgerWriteResult. The LedgerWriteResult is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.LedgerWriteResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_ledger_entry(
        self,
        entry: Union[_models.LedgerEntry, JSON, IO[bytes]],
        *,
        collection_id: Optional[str] = None,
        tags: Optional[str] = None,
        **kwargs: Any
    ) -> _models.LedgerWriteResult:
        """Writes a ledger entry.

        A collection id may optionally be specified.

        :param entry: Ledger entry. Is one of the following types: LedgerEntry, JSON, IO[bytes]
         Required.
        :type entry: ~azure.confidentialledger.models.LedgerEntry or JSON or IO[bytes]
        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :keyword tags: Comma separated tags. Default value is None.
        :paramtype tags: str
        :return: LedgerWriteResult. The LedgerWriteResult is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.LedgerWriteResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LedgerWriteResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(entry, (IOBase, bytes)):
            _content = entry
        else:
            _content = json.dumps(entry, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_confidential_ledger_create_ledger_entry_request(
            collection_id=collection_id,
            tags=tags,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-ccf-transaction-id"] = self._deserialize(
            "str", response.headers.get("x-ms-ccf-transaction-id")
        )

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LedgerWriteResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_ledger_entry(
        self, transaction_id: str, *, collection_id: Optional[str] = None, **kwargs: Any
    ) -> _models.LedgerQueryResult:
        """Gets the ledger entry at the specified transaction id. A collection id may
        optionally be specified to indicate the collection from which to fetch the
        value.

        To return older ledger entries, the relevant sections of the ledger must be
        read from disk and validated. To prevent blocking within the enclave, the
        response will indicate whether the entry is ready and part of the response, or
        if the loading is still ongoing.

        :param transaction_id: Identifies a write transaction. Required.
        :type transaction_id: str
        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :return: LedgerQueryResult. The LedgerQueryResult is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.LedgerQueryResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LedgerQueryResult] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_ledger_entry_request(
            transaction_id=transaction_id,
            collection_id=collection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LedgerQueryResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_receipt(self, transaction_id: str, **kwargs: Any) -> _models.TransactionReceipt:
        """Gets a receipt certifying ledger contents at a particular transaction id.

        Gets a receipt certifying ledger contents at a particular transaction id.

        :param transaction_id: Identifies a write transaction. Required.
        :type transaction_id: str
        :return: TransactionReceipt. The TransactionReceipt is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.TransactionReceipt
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TransactionReceipt] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_receipt_request(
            transaction_id=transaction_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TransactionReceipt, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_transaction_status(self, transaction_id: str, **kwargs: Any) -> _models.TransactionStatus:
        """Gets the status of an entry identified by a transaction id.

        Gets the status of an entry identified by a transaction id.

        :param transaction_id: Identifies a write transaction. Required.
        :type transaction_id: str
        :return: TransactionStatus. The TransactionStatus is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.TransactionStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TransactionStatus] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_transaction_status_request(
            transaction_id=transaction_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TransactionStatus, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_current_ledger_entry(
        self, *, collection_id: Optional[str] = None, **kwargs: Any
    ) -> _models.LedgerEntry:
        """Gets the current value available in the ledger.

        A collection id may optionally be specified.

        :keyword collection_id: The collection id. Default value is None.
        :paramtype collection_id: str
        :return: LedgerEntry. The LedgerEntry is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.LedgerEntry
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LedgerEntry] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_current_ledger_entry_request(
            collection_id=collection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LedgerEntry, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_users(self, **kwargs: Any) -> AsyncItemPaged["_models.LedgerUser"]:
        """Gets details on a list of users.

        All users' object IDs and single role per user will be returned.

        :return: An iterator like instance of LedgerUser
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.confidentialledger.models.LedgerUser]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.LedgerUser]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_confidential_ledger_list_users_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.LedgerUser], deserialized.get("ledgerUsers", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_ledger_users(self, **kwargs: Any) -> AsyncItemPaged["_models.LedgerUserMultipleRoles"]:
        """Gets details on a list of users.

        All users' object IDs and multiple roles will be returned.

        :return: An iterator like instance of LedgerUserMultipleRoles
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.confidentialledger.models.LedgerUserMultipleRoles]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.LedgerUserMultipleRoles]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_confidential_ledger_list_ledger_users_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.LedgerUserMultipleRoles], deserialized.get("ledgerUsers", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def delete_user(self, user_id: str, **kwargs: Any) -> None:
        """Deletes a user from the Confidential Ledger.

        Deletes a user from the Confidential Ledger.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_delete_user_request(
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_user(self, user_id: str, **kwargs: Any) -> _models.LedgerUser:
        """Gets a user.

        Gets a user.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :return: LedgerUser. The LedgerUser is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.LedgerUser
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LedgerUser] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_user_request(
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LedgerUser, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_user(
        self,
        user_id: str,
        user_details: _models.LedgerUser,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.LedgerUser:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_details: Details about a Confidential Ledger user. Required.
        :type user_details: ~azure.confidentialledger.models.LedgerUser
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: LedgerUser. The LedgerUser is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.LedgerUser
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_user(
        self, user_id: str, user_details: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.LedgerUser:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_details: Details about a Confidential Ledger user. Required.
        :type user_details: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: LedgerUser. The LedgerUser is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.LedgerUser
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_user(
        self,
        user_id: str,
        user_details: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.LedgerUser:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_details: Details about a Confidential Ledger user. Required.
        :type user_details: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: LedgerUser. The LedgerUser is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.LedgerUser
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_user(
        self, user_id: str, user_details: Union[_models.LedgerUser, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.LedgerUser:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_details: Details about a Confidential Ledger user. Is one of the following types:
         LedgerUser, JSON, IO[bytes] Required.
        :type user_details: ~azure.confidentialledger.models.LedgerUser or JSON or IO[bytes]
        :return: LedgerUser. The LedgerUser is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.LedgerUser
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LedgerUser] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(user_details, (IOBase, bytes)):
            _content = user_details
        else:
            _content = json.dumps(user_details, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_confidential_ledger_create_or_update_user_request(
            user_id=user_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LedgerUser, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_ledger_user(self, user_id: str, **kwargs: Any) -> None:
        """Deletes a user with multiple roles from the Confidential Ledger.

        Deletes a user with multiple roles from the Confidential Ledger.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_delete_ledger_user_request(
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_ledger_user(self, user_id: str, **kwargs: Any) -> _models.LedgerUserMultipleRoles:
        """Gets a user with multiple roles.

        Gets a user with multiple roles.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :return: LedgerUserMultipleRoles. The LedgerUserMultipleRoles is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.LedgerUserMultipleRoles
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LedgerUserMultipleRoles] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_ledger_user_request(
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LedgerUserMultipleRoles, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_ledger_user(
        self,
        user_id: str,
        user_multiple_roles: _models.LedgerUserMultipleRoles,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.LedgerUserMultipleRoles:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_multiple_roles: Details about a Confidential Ledger user with multiple roles.
         Required.
        :type user_multiple_roles: ~azure.confidentialledger.models.LedgerUserMultipleRoles
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: LedgerUserMultipleRoles. The LedgerUserMultipleRoles is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.LedgerUserMultipleRoles
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_ledger_user(
        self,
        user_id: str,
        user_multiple_roles: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.LedgerUserMultipleRoles:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_multiple_roles: Details about a Confidential Ledger user with multiple roles.
         Required.
        :type user_multiple_roles: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: LedgerUserMultipleRoles. The LedgerUserMultipleRoles is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.LedgerUserMultipleRoles
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_ledger_user(
        self,
        user_id: str,
        user_multiple_roles: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.LedgerUserMultipleRoles:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_multiple_roles: Details about a Confidential Ledger user with multiple roles.
         Required.
        :type user_multiple_roles: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: LedgerUserMultipleRoles. The LedgerUserMultipleRoles is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.LedgerUserMultipleRoles
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_ledger_user(
        self, user_id: str, user_multiple_roles: Union[_models.LedgerUserMultipleRoles, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.LedgerUserMultipleRoles:
        """Adds a user or updates a user's fields.

        A JSON merge patch is applied for existing users.

        :param user_id: The user id, either an AAD object ID or certificate fingerprint. Required.
        :type user_id: str
        :param user_multiple_roles: Details about a Confidential Ledger user with multiple roles. Is
         one of the following types: LedgerUserMultipleRoles, JSON, IO[bytes] Required.
        :type user_multiple_roles: ~azure.confidentialledger.models.LedgerUserMultipleRoles or JSON or
         IO[bytes]
        :return: LedgerUserMultipleRoles. The LedgerUserMultipleRoles is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.LedgerUserMultipleRoles
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LedgerUserMultipleRoles] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(user_multiple_roles, (IOBase, bytes)):
            _content = user_multiple_roles
        else:
            _content = json.dumps(user_multiple_roles, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_confidential_ledger_create_or_update_ledger_user_request(
            user_id=user_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LedgerUserMultipleRoles, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_user_defined_endpoint(self, **kwargs: Any) -> _models.Bundle:
        """Gets a user defined endpoint.

        Returns the user defined endpoint in the ACL instance.

        :return: Bundle. The Bundle is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.Bundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Bundle] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_user_defined_endpoint_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Bundle, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_user_defined_endpoint(
        self, bundle: _models.Bundle, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Creates a user defined endpoint.

        Creates the user defined endpoint in the ACL instance.

        :param bundle: Specify a user defined endpoint. Required.
        :type bundle: ~azure.confidentialledger.models.Bundle
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_user_defined_endpoint(
        self, bundle: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Creates a user defined endpoint.

        Creates the user defined endpoint in the ACL instance.

        :param bundle: Specify a user defined endpoint. Required.
        :type bundle: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_user_defined_endpoint(
        self, bundle: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Creates a user defined endpoint.

        Creates the user defined endpoint in the ACL instance.

        :param bundle: Specify a user defined endpoint. Required.
        :type bundle: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_user_defined_endpoint(self, bundle: Union[_models.Bundle, JSON, IO[bytes]], **kwargs: Any) -> None:
        """Creates a user defined endpoint.

        Creates the user defined endpoint in the ACL instance.

        :param bundle: Specify a user defined endpoint. Is one of the following types: Bundle, JSON,
         IO[bytes] Required.
        :type bundle: ~azure.confidentialledger.models.Bundle or JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(bundle, (IOBase, bytes)):
            _content = bundle
        else:
            _content = json.dumps(bundle, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_confidential_ledger_create_user_defined_endpoint_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_runtime_options(self, **kwargs: Any) -> _models.JsRuntimeOptions:
        """Runtime options for user defined endpoints.

        It returns the runtime options.

        :return: JsRuntimeOptions. The JsRuntimeOptions is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.JsRuntimeOptions
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.JsRuntimeOptions] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_runtime_options_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.JsRuntimeOptions, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_runtime_options(
        self, js_runtime_options: _models.JsRuntimeOptions, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.JsRuntimeOptions:
        """Runtime options for user defined endpoints.

        Updates the runtime options.

        :param js_runtime_options: JS Runtime options. Required.
        :type js_runtime_options: ~azure.confidentialledger.models.JsRuntimeOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JsRuntimeOptions. The JsRuntimeOptions is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.JsRuntimeOptions
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_runtime_options(
        self, js_runtime_options: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.JsRuntimeOptions:
        """Runtime options for user defined endpoints.

        Updates the runtime options.

        :param js_runtime_options: JS Runtime options. Required.
        :type js_runtime_options: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JsRuntimeOptions. The JsRuntimeOptions is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.JsRuntimeOptions
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_runtime_options(
        self, js_runtime_options: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.JsRuntimeOptions:
        """Runtime options for user defined endpoints.

        Updates the runtime options.

        :param js_runtime_options: JS Runtime options. Required.
        :type js_runtime_options: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JsRuntimeOptions. The JsRuntimeOptions is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.JsRuntimeOptions
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_runtime_options(
        self, js_runtime_options: Union[_models.JsRuntimeOptions, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.JsRuntimeOptions:
        """Runtime options for user defined endpoints.

        Updates the runtime options.

        :param js_runtime_options: JS Runtime options. Is one of the following types: JsRuntimeOptions,
         JSON, IO[bytes] Required.
        :type js_runtime_options: ~azure.confidentialledger.models.JsRuntimeOptions or JSON or
         IO[bytes]
        :return: JsRuntimeOptions. The JsRuntimeOptions is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.JsRuntimeOptions
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.JsRuntimeOptions] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(js_runtime_options, (IOBase, bytes)):
            _content = js_runtime_options
        else:
            _content = json.dumps(js_runtime_options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_confidential_ledger_update_runtime_options_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.JsRuntimeOptions, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_user_defined_endpoints_module(self, *, module_name: str, **kwargs: Any) -> _models.ModuleDef:
        """Module for user defined endpoints.

        It gets the module for the user defined endpoint.

        :keyword module_name: module name of the user defined endpoint. Required.
        :paramtype module_name: str
        :return: ModuleDef. The ModuleDef is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.ModuleDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ModuleDef] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_user_defined_endpoints_module_request(
            module_name=module_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ModuleDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_user_defined_functions(self, **kwargs: Any) -> AsyncItemPaged["_models.UserDefinedFunction"]:
        """Retrieves a list of user defined functions present in the Confidential Ledger.

        User defined functions stored in the Confidential Ledger.

        :return: An iterator like instance of UserDefinedFunction
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.confidentialledger.models.UserDefinedFunction]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.UserDefinedFunction]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_confidential_ledger_list_user_defined_functions_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "ledgerEndpoint": self._serialize.url(
                        "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.UserDefinedFunction], deserialized.get("functions", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def delete_user_defined_function(self, function_id: str, **kwargs: Any) -> None:
        """Deletes a user defined function from the Confidential Ledger.

        Deletes a user defined function from the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_delete_user_defined_function_request(
            function_id=function_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_user_defined_function(self, function_id: str, **kwargs: Any) -> _models.UserDefinedFunction:
        """Gets a user defined function.

        Returns the user defined function in the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :return: UserDefinedFunction. The UserDefinedFunction is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.UserDefinedFunction
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.UserDefinedFunction] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_user_defined_function_request(
            function_id=function_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.UserDefinedFunction, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_user_defined_function(
        self,
        function_id: str,
        user_defined_function: _models.UserDefinedFunction,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.UserDefinedFunction:
        """Creates a user defined function.

        Creates the user defined function in the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :param user_defined_function: Specify a user defined function of a Confidential Ledger.
         Required.
        :type user_defined_function: ~azure.confidentialledger.models.UserDefinedFunction
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: UserDefinedFunction. The UserDefinedFunction is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.UserDefinedFunction
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_user_defined_function(
        self, function_id: str, user_defined_function: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.UserDefinedFunction:
        """Creates a user defined function.

        Creates the user defined function in the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :param user_defined_function: Specify a user defined function of a Confidential Ledger.
         Required.
        :type user_defined_function: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: UserDefinedFunction. The UserDefinedFunction is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.UserDefinedFunction
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_user_defined_function(
        self,
        function_id: str,
        user_defined_function: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.UserDefinedFunction:
        """Creates a user defined function.

        Creates the user defined function in the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :param user_defined_function: Specify a user defined function of a Confidential Ledger.
         Required.
        :type user_defined_function: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: UserDefinedFunction. The UserDefinedFunction is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.UserDefinedFunction
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_user_defined_function(
        self,
        function_id: str,
        user_defined_function: Union[_models.UserDefinedFunction, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.UserDefinedFunction:
        """Creates a user defined function.

        Creates the user defined function in the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :param user_defined_function: Specify a user defined function of a Confidential Ledger. Is one
         of the following types: UserDefinedFunction, JSON, IO[bytes] Required.
        :type user_defined_function: ~azure.confidentialledger.models.UserDefinedFunction or JSON or
         IO[bytes]
        :return: UserDefinedFunction. The UserDefinedFunction is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.UserDefinedFunction
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.UserDefinedFunction] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(user_defined_function, (IOBase, bytes)):
            _content = user_defined_function
        else:
            _content = json.dumps(user_defined_function, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_confidential_ledger_create_user_defined_function_request(
            function_id=function_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-ccf-transaction-id"] = self._deserialize(
            "str", response.headers.get("x-ms-ccf-transaction-id")
        )

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.UserDefinedFunction, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def execute_user_defined_function(
        self,
        function_id: str,
        user_defined_function_execution_properties: Optional[_models.UserDefinedFunctionExecutionProperties] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.UserDefinedFunctionExecutionResponse:
        """Executes a user defined function.

        Executes the user defined function in the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :param user_defined_function_execution_properties: Specify user defined function execution
         properties. Default value is None.
        :type user_defined_function_execution_properties:
         ~azure.confidentialledger.models.UserDefinedFunctionExecutionProperties
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: UserDefinedFunctionExecutionResponse. The UserDefinedFunctionExecutionResponse is
         compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.UserDefinedFunctionExecutionResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def execute_user_defined_function(
        self,
        function_id: str,
        user_defined_function_execution_properties: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.UserDefinedFunctionExecutionResponse:
        """Executes a user defined function.

        Executes the user defined function in the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :param user_defined_function_execution_properties: Specify user defined function execution
         properties. Default value is None.
        :type user_defined_function_execution_properties: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: UserDefinedFunctionExecutionResponse. The UserDefinedFunctionExecutionResponse is
         compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.UserDefinedFunctionExecutionResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def execute_user_defined_function(
        self,
        function_id: str,
        user_defined_function_execution_properties: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.UserDefinedFunctionExecutionResponse:
        """Executes a user defined function.

        Executes the user defined function in the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :param user_defined_function_execution_properties: Specify user defined function execution
         properties. Default value is None.
        :type user_defined_function_execution_properties: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: UserDefinedFunctionExecutionResponse. The UserDefinedFunctionExecutionResponse is
         compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.UserDefinedFunctionExecutionResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def execute_user_defined_function(
        self,
        function_id: str,
        user_defined_function_execution_properties: Optional[
            Union[_models.UserDefinedFunctionExecutionProperties, JSON, IO[bytes]]
        ] = None,
        **kwargs: Any
    ) -> _models.UserDefinedFunctionExecutionResponse:
        """Executes a user defined function.

        Executes the user defined function in the Confidential Ledger.

        :param function_id: Identifies a user defined function. Required.
        :type function_id: str
        :param user_defined_function_execution_properties: Specify user defined function execution
         properties. Is one of the following types: UserDefinedFunctionExecutionProperties, JSON,
         IO[bytes] Default value is None.
        :type user_defined_function_execution_properties:
         ~azure.confidentialledger.models.UserDefinedFunctionExecutionProperties or JSON or IO[bytes]
        :return: UserDefinedFunctionExecutionResponse. The UserDefinedFunctionExecutionResponse is
         compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.UserDefinedFunctionExecutionResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if user_defined_function_execution_properties else None
        cls: ClsType[_models.UserDefinedFunctionExecutionResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if user_defined_function_execution_properties else None
        _content = None
        if isinstance(user_defined_function_execution_properties, (IOBase, bytes)):
            _content = user_defined_function_execution_properties
        else:
            if user_defined_function_execution_properties is not None:
                _content = json.dumps(user_defined_function_execution_properties, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_confidential_ledger_execute_user_defined_function_request(
            function_id=function_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.UserDefinedFunctionExecutionResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_user_defined_role(self, *, role_name: str, **kwargs: Any) -> _models.Roles:
        """Gets role actions for user defined roles.

        user defined roles allow users to define and manage app specific AuthZ policy.

        :keyword role_name: user defined role name. Required.
        :paramtype role_name: str
        :return: Roles. The Roles is compatible with MutableMapping
        :rtype: ~azure.confidentialledger.models.Roles
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Roles] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_get_user_defined_role_request(
            role_name=role_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Roles, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_user_defined_role(
        self, body: _models.Roles, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Creates new roles and their actions.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param body: Request body. Required.
        :type body: ~azure.confidentialledger.models.Roles
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_user_defined_role(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Creates new roles and their actions.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param body: Request body. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_user_defined_role(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Creates new roles and their actions.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param body: Request body. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_user_defined_role(self, body: Union[_models.Roles, JSON, IO[bytes]], **kwargs: Any) -> None:
        """Creates new roles and their actions.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param body: Request body. Is one of the following types: Roles, JSON, IO[bytes] Required.
        :type body: ~azure.confidentialledger.models.Roles or JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_confidential_ledger_create_user_defined_role_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def update_user_defined_role(
        self, body: _models.Roles, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Patch replaces the allowed action on existing roles,if the desire is to remove
        an existing action, the role must be deleted and recreated.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param body: Request body. Required.
        :type body: ~azure.confidentialledger.models.Roles
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_user_defined_role(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Patch replaces the allowed action on existing roles,if the desire is to remove
        an existing action, the role must be deleted and recreated.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param body: Request body. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_user_defined_role(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Patch replaces the allowed action on existing roles,if the desire is to remove
        an existing action, the role must be deleted and recreated.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param body: Request body. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_user_defined_role(self, body: Union[_models.Roles, JSON, IO[bytes]], **kwargs: Any) -> None:
        """Patch replaces the allowed action on existing roles,if the desire is to remove
        an existing action, the role must be deleted and recreated.

        User defined roles allow users to define and manage app specific AuthZ policy.

        :param body: Request body. Is one of the following types: Roles, JSON, IO[bytes] Required.
        :type body: ~azure.confidentialledger.models.Roles or JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_confidential_ledger_update_user_defined_role_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def delete_user_defined_role(self, *, role_name: str, **kwargs: Any) -> None:
        """Deletes user defined roles.

        A user defined role allows the users to create and manage their own role
        actions using the API.

        :keyword role_name: user defined role name. Required.
        :paramtype role_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_confidential_ledger_delete_user_defined_role_request(
            role_name=role_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "ledgerEndpoint": self._serialize.url(
                "self._config.ledger_endpoint", self._config.ledger_endpoint, "str", skip_quote=True
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ConfidentialLedgerError, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
