/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */
"use strict";

function handleRequest(request, response) {
  response.processAsync();

  const params = new Map(
    request.queryString
      .replace("?", "")
      .split("&")
      .map(s => s.split("="))
  );
  const delay = params.has("delay") ? params.get("delay") : 2000;

  let timer = Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer);
  timer.initWithCallback(
    () => {
      // to avoid garbage collection
      timer = null;
      response.setStatusLine(request.httpVersion, 200, "OK");
      response.setHeader("Content-Type", "image/svg+xml", false);
      // This is the mozilla logo
      response.write(`<svg viewBox="0 0 280 80" width="280" height="80" xmlns="http://www.w3.org/2000/svg">
        <path d="M0 0h279.77v80H0z"/>
        <path d="M267.208 57.423c-.545.154-1.007.238-1.468.238-1.637 0-2.406-.7-2.406-2.714V39.74c0-7.987-6.365-11.876-13.891-11.876-5.75 0-8.84.7-14.982 3.175l-1.37 8.058 7.987.853 1.133-3.945c1.637-.853 3.26-1.007 5.357-1.007 5.666 0 5.75 4.267 5.75 7.834v1.16c-1.79-.237-3.805-.307-5.75-.307-7.987 0-16.296 2.014-16.296 10.631 0 7.288 5.735 10.016 10.785 10.016 5.665 0 9.232-3.413 11.247-6.98.461 4.266 3.021 6.98 7.68 6.98 2.168 0 4.42-.615 6.28-1.637l-.056-5.273zm-21.486-.224c-3.022 0-4.113-1.79-4.113-4.043 0-3.805 3.106-4.812 6.673-4.812 1.623 0 3.413.238 5.05.462-.238 5.833-4.043 8.393-7.61 8.393zm-13.443-47.03l-15.136 53.395h-9.861l15.135-53.394h9.862zm-20.325 0l-15.136 53.395h-9.848l15.136-53.394h9.848zm-42.022 18.396h10.478v12.561h-10.478V28.565zm0 22.423h10.478v12.576h-10.478V50.988zm-15.247-.462l7.917.77-2.168 12.268h-30.579l-1.007-5.274 19.248-22.116h-10.939l-1.552 5.428-7.219-.784 1.245-12.267h30.733l.784 5.273-19.417 22.13h11.331l1.623-5.428zm-50.149-22.66c-12.576 0-18.786 8.462-18.786 18.702 0 11.177 7.455 17.765 18.24 17.765 11.177 0 19.249-7.064 19.249-18.24 0-9.779-6.141-18.228-18.703-18.228zm-.238 28.787c-5.427 0-8.225-4.658-8.225-10.715 0-6.602 3.175-10.393 8.31-10.393 4.727 0 8.532 3.175 8.532 10.24 0 6.672-3.413 10.868-8.617 10.868zm-27.557-.699h4.658v7.61H66.725v-19.71c0-6.057-2.014-8.38-5.973-8.38-4.812 0-6.756 3.414-6.756 8.31v12.17h4.658v7.61h-14.66v-19.71c0-6.057-2.015-8.38-5.973-8.38-4.812 0-6.757 3.414-6.757 8.31v12.17h6.673v7.61H16.604v-7.61h4.659V36.16h-4.659v-7.61h14.66v5.274c2.099-3.72 5.75-5.973 10.632-5.973 5.05 0 9.694 2.406 11.414 7.526 1.945-4.658 5.903-7.526 11.415-7.526 6.28 0 12.03 3.805 12.03 12.1v16.003z" fill="#fff"/>
      </svg>`);
      response.finish();
    },
    delay,
    Ci.nsITimer.TYPE_ONE_SHOT
  );
}
