/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2025 MediaTek Inc.
 * Author: Guodong Liu <Guodong.Liu@mediatek.com>
 */

#ifndef __PINCTRL_MTK_MT8196_H
#define __PINCTRL_MTK_MT8196_H

#include "pinctrl-paris.h"
#define EINT_INVALID_BASE 0xff

static const struct mtk_pin_desc mtk_pins_mt8196[] = {
	MTK_PIN(
		0, "GPIO0",
		MTK_EINT_FUNCTION(0, 0),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO0"),
		MTK_FUNCTION(1, "DMIC1_CLK"),
		MTK_FUNCTION(3, "SPI3_A_MO"),
		MTK_FUNCTION(4, "FMI2S_B_LRCK"),
		MTK_FUNCTION(5, "SCP_DMIC1_CLK"),
		MTK_FUNCTION(6, "TP_GPIO14_AO")
	),
	MTK_PIN(
		1, "GPIO1",
		MTK_EINT_FUNCTION(0, 1),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO1"),
		MTK_FUNCTION(1, "DMIC1_DAT"),
		MTK_FUNCTION(2, "SRCLKENAI1"),
		MTK_FUNCTION(3, "SPI3_A_MI"),
		MTK_FUNCTION(4, "FMI2S_B_DI"),
		MTK_FUNCTION(5, "SCP_DMIC1_DAT"),
		MTK_FUNCTION(6, "TP_GPIO15_AO")
	),
	MTK_PIN(
		2, "GPIO2",
		MTK_EINT_FUNCTION(0, 2),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO2"),
		MTK_FUNCTION(1, "PWM_VLP"),
		MTK_FUNCTION(2, "DSI_HSYNC"),
		MTK_FUNCTION(5, "RG_TSFDC_LDO_EN"),
		MTK_FUNCTION(6, "TP_GPIO8_AO")
	),
	MTK_PIN(
		3, "GPIO3",
		MTK_EINT_FUNCTION(0, 3),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO3"),
		MTK_FUNCTION(1, "MD_INT0"),
		MTK_FUNCTION(2, "DSI1_HSYNC"),
		MTK_FUNCTION(5, "DA_TSFDC_LDO_MODE"),
		MTK_FUNCTION(6, "TP_GPIO9_AO")
	),
	MTK_PIN(
		4, "GPIO4",
		MTK_EINT_FUNCTION(0, 4),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO4"),
		MTK_FUNCTION(1, "DISP_PWM1"),
		MTK_FUNCTION(2, "MD32_0_GPIO0")
	),
	MTK_PIN(
		5, "GPIO5",
		MTK_EINT_FUNCTION(0, 5),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO5"),
		MTK_FUNCTION(1, "LCM1_RST"),
		MTK_FUNCTION(2, "SPI7_A_CLK")
	),
	MTK_PIN(
		6, "GPIO6",
		MTK_EINT_FUNCTION(0, 6),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO6"),
		MTK_FUNCTION(1, "DSI1_TE"),
		MTK_FUNCTION(2, "SPI7_A_CSB")
	),
	MTK_PIN(
		7, "GPIO7",
		MTK_EINT_FUNCTION(0, 7),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO7"),
		MTK_FUNCTION(2, "SPI7_A_MO"),
		MTK_FUNCTION(3, "GPS_PPS0")
	),
	MTK_PIN(
		8, "GPIO8",
		MTK_EINT_FUNCTION(0, 8),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO8"),
		MTK_FUNCTION(2, "SPI7_A_MI"),
		MTK_FUNCTION(3, "EDP_TX_HPD")
	),
	MTK_PIN(
		9, "GPIO9",
		MTK_EINT_FUNCTION(0, 9),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO9"),
		MTK_FUNCTION(3, "I2SIN1_LRCK"),
		MTK_FUNCTION(7, "RG_TSFDC_LDO_REFSEL0")
	),
	MTK_PIN(
		10, "GPIO10",
		MTK_EINT_FUNCTION(0, 10),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO10"),
		MTK_FUNCTION(3, "I2SOUT1_DO"),
		MTK_FUNCTION(7, "RG_TSFDC_LDO_REFSEL1")
	),
	MTK_PIN(
		11, "GPIO11",
		MTK_EINT_FUNCTION(0, 11),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO11"),
		MTK_FUNCTION(4, "FMI2S_B_BCK"),
		MTK_FUNCTION(7, "DBG_MON_A30")
	),
	MTK_PIN(
		12, "GPIO12",
		MTK_EINT_FUNCTION(0, 12),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO12"),
		MTK_FUNCTION(3, "I2SIN1_DI_B")
	),
	MTK_PIN(
		13, "GPIO13",
		MTK_EINT_FUNCTION(0, 13),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO13"),
		MTK_FUNCTION(1, "EDP_TX_HPD"),
		MTK_FUNCTION(2, "GPS_PPS1")
	),
	MTK_PIN(
		14, "GPIO14",
		MTK_EINT_FUNCTION(0, 14),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO14"),
		MTK_FUNCTION(1, "SRCLKENA2"),
		MTK_FUNCTION(2, "DSI2_TE"),
		MTK_FUNCTION(3, "SPMI_P_TRIG_FLAG"),
		MTK_FUNCTION(5, "MD_INT3"),
		MTK_FUNCTION(6, "TP_GPIO8_AO")
	),
	MTK_PIN(
		15, "GPIO15",
		MTK_EINT_FUNCTION(0, 15),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO15"),
		MTK_FUNCTION(1, "SRCLKENAI0"),
		MTK_FUNCTION(2, "SPMI_M_TRIG_FLAG"),
		MTK_FUNCTION(3, "UCTS0"),
		MTK_FUNCTION(4, "MD_INT4"),
		MTK_FUNCTION(5, "I2SOUT2_DO"),
		MTK_FUNCTION(6, "TP_GPIO9_AO")
	),
	MTK_PIN(
		16, "GPIO16",
		MTK_EINT_FUNCTION(0, 16),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO16"),
		MTK_FUNCTION(1, "SRCLKENAI1"),
		MTK_FUNCTION(2, "DP_TX_HPD"),
		MTK_FUNCTION(3, "URTS0"),
		MTK_FUNCTION(4, "GPS_L5_ELNA_EN"),
		MTK_FUNCTION(5, "KPROW2"),
		MTK_FUNCTION(6, "TP_GPIO10_AO")
	),
	MTK_PIN(
		17, "GPIO17",
		MTK_EINT_FUNCTION(0, 17),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO17"),
		MTK_FUNCTION(1, "MD_INT0"),
		MTK_FUNCTION(2, "DP_OC_EN"),
		MTK_FUNCTION(3, "UCTS1"),
		MTK_FUNCTION(4, "MD_NTN_URXD1"),
		MTK_FUNCTION(5, "KPCOL2"),
		MTK_FUNCTION(6, "TP_GPIO11_AO")
	),
	MTK_PIN(
		18, "GPIO18",
		MTK_EINT_FUNCTION(0, 18),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO18"),
		MTK_FUNCTION(1, "DMIC1_CLK"),
		MTK_FUNCTION(2, "DP_RAUX_SBU1"),
		MTK_FUNCTION(3, "URTS1"),
		MTK_FUNCTION(4, "MD_NTN_UTXD1"),
		MTK_FUNCTION(5, "I2SIN2_DI"),
		MTK_FUNCTION(6, "TP_UTXD_GNSS_VLP")
	),
	MTK_PIN(
		19, "GPIO19",
		MTK_EINT_FUNCTION(0, 19),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO19"),
		MTK_FUNCTION(1, "DMIC1_DAT"),
		MTK_FUNCTION(2, "DP_RAUX_SBU2"),
		MTK_FUNCTION(3, "CONN_TCXOENA_REQ"),
		MTK_FUNCTION(4, "CLKM3_A"),
		MTK_FUNCTION(5, "I2SIN2_BCK"),
		MTK_FUNCTION(6, "TP_URXD_GNSS_VLP")
	),
	MTK_PIN(
		20, "GPIO20",
		MTK_EINT_FUNCTION(0, 20),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO20"),
		MTK_FUNCTION(1, "IDDIG"),
		MTK_FUNCTION(2, "LCM2_RST"),
		MTK_FUNCTION(3, "GPS_PPS1"),
		MTK_FUNCTION(4, "CLKM2_A")
	),
	MTK_PIN(
		21, "GPIO21",
		MTK_EINT_FUNCTION(0, 21),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO21"),
		MTK_FUNCTION(1, "BPI_BUS11"),
		MTK_FUNCTION(2, "PCIE_PERSTN_1P"),
		MTK_FUNCTION(3, "DSI1_TE"),
		MTK_FUNCTION(4, "DMIC_CLK"),
		MTK_FUNCTION(5, "SCP_DMIC_CLK")
	),
	MTK_PIN(
		22, "GPIO22",
		MTK_EINT_FUNCTION(0, 22),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO22"),
		MTK_FUNCTION(1, "BPI_BUS12"),
		MTK_FUNCTION(2, "PCIE_CLKREQN_1P"),
		MTK_FUNCTION(3, "DSI2_TE"),
		MTK_FUNCTION(4, "DMIC_DAT"),
		MTK_FUNCTION(5, "SCP_DMIC_DAT")
	),
	MTK_PIN(
		23, "GPIO23",
		MTK_EINT_FUNCTION(0, 23),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO23"),
		MTK_FUNCTION(1, "BPI_BUS13"),
		MTK_FUNCTION(2, "PCIE_WAKEN_1P"),
		MTK_FUNCTION(3, "DSI3_TE"),
		MTK_FUNCTION(4, "DMIC1_CLK"),
		MTK_FUNCTION(5, "SCP_DMIC1_CLK")
	),
	MTK_PIN(
		24, "GPIO24",
		MTK_EINT_FUNCTION(0, 24),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO24"),
		MTK_FUNCTION(1, "BPI_BUS14"),
		MTK_FUNCTION(2, "LCM1_RST"),
		MTK_FUNCTION(3, "AGPS_SYNC"),
		MTK_FUNCTION(4, "DMIC1_DAT"),
		MTK_FUNCTION(5, "SCP_DMIC1_DAT"),
		MTK_FUNCTION(6, "DISP_PWM1")
	),
	MTK_PIN(
		25, "GPIO25",
		MTK_EINT_FUNCTION(0, 25),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO25"),
		MTK_FUNCTION(1, "BPI_BUS15"),
		MTK_FUNCTION(2, "LCM2_RST"),
		MTK_FUNCTION(3, "SRCLKENAI1"),
		MTK_FUNCTION(4, "DMIC2_CLK"),
		MTK_FUNCTION(6, "DISP_PWM2")
	),
	MTK_PIN(
		26, "GPIO26",
		MTK_EINT_FUNCTION(0, 26),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO26"),
		MTK_FUNCTION(1, "BPI_BUS16"),
		MTK_FUNCTION(2, "LCM3_RST"),
		MTK_FUNCTION(4, "DMIC2_DAT"),
		MTK_FUNCTION(6, "DISP_PWM3")
	),
	MTK_PIN(
		27, "GPIO27",
		MTK_EINT_FUNCTION(0, 27),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO27"),
		MTK_FUNCTION(1, "BPI_BUS17"),
		MTK_FUNCTION(2, "UTXD4"),
		MTK_FUNCTION(6, "DISP_PWM4"),
		MTK_FUNCTION(7, "DBG_MON_A20")
	),
	MTK_PIN(
		28, "GPIO28",
		MTK_EINT_FUNCTION(0, 28),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO28"),
		MTK_FUNCTION(1, "BPI_BUS18"),
		MTK_FUNCTION(2, "URXD4"),
		MTK_FUNCTION(3, "SPI2_A_MI"),
		MTK_FUNCTION(4, "CLKM0_A"),
		MTK_FUNCTION(7, "DBG_MON_A21")
	),
	MTK_PIN(
		29, "GPIO29",
		MTK_EINT_FUNCTION(0, 29),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO29"),
		MTK_FUNCTION(1, "BPI_BUS19"),
		MTK_FUNCTION(2, "MD_NTN_UTXD1"),
		MTK_FUNCTION(3, "SPI2_A_MO"),
		MTK_FUNCTION(4, "CLKM1_A"),
		MTK_FUNCTION(6, "UCTS4"),
		MTK_FUNCTION(7, "DBG_MON_A17")
	),
	MTK_PIN(
		30, "GPIO30",
		MTK_EINT_FUNCTION(0, 30),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO30"),
		MTK_FUNCTION(1, "BPI_BUS20"),
		MTK_FUNCTION(2, "MD_NTN_URXD1"),
		MTK_FUNCTION(3, "SPI2_A_CLK"),
		MTK_FUNCTION(4, "CLKM2_A"),
		MTK_FUNCTION(5, "DSI3_HSYNC"),
		MTK_FUNCTION(6, "URTS4"),
		MTK_FUNCTION(7, "DBG_MON_A18")
	),
	MTK_PIN(
		31, "GPIO31",
		MTK_EINT_FUNCTION(0, 31),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO31"),
		MTK_FUNCTION(1, "BPI_BUS21"),
		MTK_FUNCTION(3, "SPI2_A_CSB"),
		MTK_FUNCTION(4, "CLKM3_A"),
		MTK_FUNCTION(6, "EDP_TX_HPD"),
		MTK_FUNCTION(7, "DBG_MON_A19")
	),
	MTK_PIN(
		32, "GPIO32",
		MTK_EINT_FUNCTION(0, 32),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO32"),
		MTK_FUNCTION(1, "LCM4_RST"),
		MTK_FUNCTION(2, "DP_TX_HPD"),
		MTK_FUNCTION(3, "SSPM_JTAG_TCK_VLP"),
		MTK_FUNCTION(4, "ADSP_JTAG0_TCK"),
		MTK_FUNCTION(5, "SCP_JTAG0_TCK_VLP"),
		MTK_FUNCTION(6, "SPU0_TCK"),
		MTK_FUNCTION(7, "IO_JTAG_TCK")
	),
	MTK_PIN(
		33, "GPIO33",
		MTK_EINT_FUNCTION(0, 33),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO33"),
		MTK_FUNCTION(1, "DSI4_TE"),
		MTK_FUNCTION(2, "DP_OC_EN"),
		MTK_FUNCTION(3, "SSPM_JTAG_TRSTN_VLP"),
		MTK_FUNCTION(4, "ADSP_JTAG0_TRSTN"),
		MTK_FUNCTION(5, "SCP_JTAG0_TRSTN_VLP"),
		MTK_FUNCTION(6, "SPU0_NTRST"),
		MTK_FUNCTION(7, "IO_JTAG_TRSTN")
	),
	MTK_PIN(
		34, "GPIO34",
		MTK_EINT_FUNCTION(0, 34),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO34"),
		MTK_FUNCTION(1, "UCTS5"),
		MTK_FUNCTION(2, "DP_RAUX_SBU1"),
		MTK_FUNCTION(3, "SSPM_JTAG_TDI_VLP"),
		MTK_FUNCTION(4, "ADSP_JTAG0_TDI"),
		MTK_FUNCTION(5, "SCP_JTAG0_TDI_VLP"),
		MTK_FUNCTION(6, "SPU0_TDI"),
		MTK_FUNCTION(7, "IO_JTAG_TDI")
	),
	MTK_PIN(
		35, "GPIO35",
		MTK_EINT_FUNCTION(0, 35),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO35"),
		MTK_FUNCTION(1, "URTS5"),
		MTK_FUNCTION(2, "DP_RAUX_SBU2"),
		MTK_FUNCTION(3, "SSPM_JTAG_TDO_VLP"),
		MTK_FUNCTION(4, "ADSP_JTAG0_TDO"),
		MTK_FUNCTION(5, "SCP_JTAG0_TDO_VLP"),
		MTK_FUNCTION(6, "SPU0_TDO"),
		MTK_FUNCTION(7, "IO_JTAG_TDO")
	),
	MTK_PIN(
		36, "GPIO36",
		MTK_EINT_FUNCTION(0, 36),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO36"),
		MTK_FUNCTION(1, "UTXD5"),
		MTK_FUNCTION(3, "SSPM_JTAG_TMS_VLP"),
		MTK_FUNCTION(4, "ADSP_JTAG0_TMS"),
		MTK_FUNCTION(5, "SCP_JTAG0_TMS_VLP"),
		MTK_FUNCTION(6, "SPU0_TMS"),
		MTK_FUNCTION(7, "IO_JTAG_TMS")
	),
	MTK_PIN(
		37, "GPIO37",
		MTK_EINT_FUNCTION(0, 37),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO37"),
		MTK_FUNCTION(1, "URXD5"),
		MTK_FUNCTION(3, "MD_INT3"),
		MTK_FUNCTION(4, "CLKM0_B"),
		MTK_FUNCTION(5, "TP_GPIO5_AO"),
		MTK_FUNCTION(6, "SPU0_UTX"),
		MTK_FUNCTION(7, "DAP_MD32_SWCK")
	),
	MTK_PIN(
		38, "GPIO38",
		MTK_EINT_FUNCTION(0, 38),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO38"),
		MTK_FUNCTION(2, "SPMI_P_TRIG_FLAG"),
		MTK_FUNCTION(3, "MD_INT4"),
		MTK_FUNCTION(4, "CLKM1_B"),
		MTK_FUNCTION(5, "TP_GPIO6_AO"),
		MTK_FUNCTION(6, "SPU0_URX"),
		MTK_FUNCTION(7, "DAP_MD32_SWD")
	),
	MTK_PIN(
		39, "GPIO39",
		MTK_EINT_FUNCTION(0, 39),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO39"),
		MTK_FUNCTION(1, "I2S_MCK0"),
		MTK_FUNCTION(3, "GPS_PPS0"),
		MTK_FUNCTION(4, "CONN_TCXOENA_REQ"),
		MTK_FUNCTION(7, "DBG_MON_B12")
	),
	MTK_PIN(
		40, "GPIO40",
		MTK_EINT_FUNCTION(0, 40),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO40"),
		MTK_FUNCTION(1, "I2SIN6_0_BCK"),
		MTK_FUNCTION(3, "SPI4_B_CLK"),
		MTK_FUNCTION(4, "UCTS2"),
		MTK_FUNCTION(5, "CCU1_UTXD"),
		MTK_FUNCTION(7, "DBG_MON_B13")
	),
	MTK_PIN(
		41, "GPIO41",
		MTK_EINT_FUNCTION(0, 41),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO41"),
		MTK_FUNCTION(1, "I2SIN6_0_LRCK"),
		MTK_FUNCTION(3, "SPI4_B_CSB"),
		MTK_FUNCTION(4, "URTS2"),
		MTK_FUNCTION(5, "CCU1_URXD"),
		MTK_FUNCTION(7, "DBG_MON_B14")
	),
	MTK_PIN(
		42, "GPIO42",
		MTK_EINT_FUNCTION(0, 42),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO42"),
		MTK_FUNCTION(1, "I2SIN6_0_DI"),
		MTK_FUNCTION(3, "SPI4_B_MI"),
		MTK_FUNCTION(4, "URXD2"),
		MTK_FUNCTION(5, "CCU1_URTS"),
		MTK_FUNCTION(6, "MD32_0_RXD"),
		MTK_FUNCTION(7, "DBG_MON_B15")
	),
	MTK_PIN(
		43, "GPIO43",
		MTK_EINT_FUNCTION(0, 43),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO43"),
		MTK_FUNCTION(1, "I2SOUT6_0_DO"),
		MTK_FUNCTION(3, "SPI4_B_MO"),
		MTK_FUNCTION(4, "UTXD2"),
		MTK_FUNCTION(5, "CCU1_UCTS"),
		MTK_FUNCTION(6, "MD32_0_TXD"),
		MTK_FUNCTION(7, "DBG_MON_B16")
	),
	MTK_PIN(
		44, "GPIO44",
		MTK_EINT_FUNCTION(0, 44),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO44"),
		MTK_FUNCTION(1, "MD_INT1_C2K_UIM0_HOT_PLUG"),
		MTK_FUNCTION(3, "SPI3_A_CLK"),
		MTK_FUNCTION(6, "TP_GPIO10_AO")
	),
	MTK_PIN(
		45, "GPIO45",
		MTK_EINT_FUNCTION(0, 45),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO45"),
		MTK_FUNCTION(1, "MD_INT2_C2K_UIM1_HOT_PLUG"),
		MTK_FUNCTION(2, "DSI2_HSYNC"),
		MTK_FUNCTION(3, "SPI3_A_CSB"),
		MTK_FUNCTION(4, "PWM_VLP"),
		MTK_FUNCTION(6, "TP_GPIO11_AO")
	),
	MTK_PIN(
		46, "GPIO46",
		MTK_EINT_FUNCTION(0, 46),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO46"),
		MTK_FUNCTION(1, "SCP_SCL4"),
		MTK_FUNCTION(2, "PWM_VLP"),
		MTK_FUNCTION(4, "SCP_ILDO_DTEST1_VLP"),
		MTK_FUNCTION(5, "UFS_MPHY_SCL"),
		MTK_FUNCTION(6, "TP_GPIO0_AO")
	),
	MTK_PIN(
		47, "GPIO47",
		MTK_EINT_FUNCTION(0, 47),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO47"),
		MTK_FUNCTION(1, "SCP_SDA4"),
		MTK_FUNCTION(4, "SCP_ILDO_DTEST2_VLP"),
		MTK_FUNCTION(5, "UFS_MPHY_SDA"),
		MTK_FUNCTION(6, "TP_GPIO1_AO")
	),
	MTK_PIN(
		48, "GPIO48",
		MTK_EINT_FUNCTION(0, 48),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO48"),
		MTK_FUNCTION(1, "SCP_SCL5"),
		MTK_FUNCTION(2, "PWM_VLP"),
		MTK_FUNCTION(3, "CCU0_UTXD"),
		MTK_FUNCTION(4, "SCP_ILDO_DTEST3_VLP"),
		MTK_FUNCTION(6, "TP_GPIO2_AO")
	),
	MTK_PIN(
		49, "GPIO49",
		MTK_EINT_FUNCTION(0, 49),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO49"),
		MTK_FUNCTION(1, "SCP_SDA5"),
		MTK_FUNCTION(3, "CCU0_URXD"),
		MTK_FUNCTION(4, "SCP_ILDO_DTEST4_VLP"),
		MTK_FUNCTION(6, "TP_GPIO3_AO")
	),
	MTK_PIN(
		50, "GPIO50",
		MTK_EINT_FUNCTION(0, 50),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO50"),
		MTK_FUNCTION(1, "SCP_SCL6"),
		MTK_FUNCTION(2, "PWM_VLP"),
		MTK_FUNCTION(3, "CCU0_URTS"),
		MTK_FUNCTION(4, "DSI_HSYNC"),
		MTK_FUNCTION(6, "TP_GPIO4_AO")
	),
	MTK_PIN(
		51, "GPIO51",
		MTK_EINT_FUNCTION(0, 51),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO51"),
		MTK_FUNCTION(1, "SCP_SDA6"),
		MTK_FUNCTION(3, "CCU0_UCTS"),
		MTK_FUNCTION(4, "DSI1_HSYNC"),
		MTK_FUNCTION(6, "TP_GPIO5_AO")
	),
	MTK_PIN(
		52, "GPIO52",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO52"),
		MTK_FUNCTION(1, "SCP_SCL1"),
		MTK_FUNCTION(3, "TDM_DATA2")
	),
	MTK_PIN(
		53, "GPIO53",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO53"),
		MTK_FUNCTION(1, "SCP_SDA1"),
		MTK_FUNCTION(3, "TDM_DATA3")
	),
	MTK_PIN(
		54, "GPIO54",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO54"),
		MTK_FUNCTION(1, "AUD_CLK_MOSI"),
		MTK_FUNCTION(3, "TDM_MCK")
	),
	MTK_PIN(
		55, "GPIO55",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO55"),
		MTK_FUNCTION(1, "AUD_CLK_MISO"),
		MTK_FUNCTION(2, "I2SOUT2_BCK"),
		MTK_FUNCTION(3, "TDM_BCK")
	),
	MTK_PIN(
		56, "GPIO56",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO56"),
		MTK_FUNCTION(1, "AUD_DAT_MOSI0"),
		MTK_FUNCTION(2, "I2SOUT2_LRCK"),
		MTK_FUNCTION(3, "TDM_LRCK")
	),
	MTK_PIN(
		57, "GPIO57",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO57"),
		MTK_FUNCTION(1, "AUD_DAT_MOSI1"),
		MTK_FUNCTION(2, "I2SOUT2_DO"),
		MTK_FUNCTION(3, "TDM_DATA0")
	),
	MTK_PIN(
		58, "GPIO58",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO58"),
		MTK_FUNCTION(1, "AUD_DAT_MISO0"),
		MTK_FUNCTION(3, "TDM_DATA1")
	),
	MTK_PIN(
		59, "GPIO59",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO59"),
		MTK_FUNCTION(1, "AUD_DAT_MISO1"),
		MTK_FUNCTION(3, "I2SIN1_BCK")
	),
	MTK_PIN(
		60, "GPIO60",
		MTK_EINT_FUNCTION(0, 60),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO60"),
		MTK_FUNCTION(1, "KPCOL0"),
		MTK_FUNCTION(6, "TP_GPIO13_AO")
	),
	MTK_PIN(
		61, "GPIO61",
		MTK_EINT_FUNCTION(0, 61),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO61"),
		MTK_FUNCTION(1, "MCU_M_PMIC_POC_I")
	),
	MTK_PIN(
		62, "GPIO62",
		MTK_EINT_FUNCTION(0, 62),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO62"),
		MTK_FUNCTION(1, "MCU_B_PMIC_POC_I")
	),
	MTK_PIN(
		63, "GPIO63",
		MTK_EINT_FUNCTION(0, 63),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO63"),
		MTK_FUNCTION(1, "MFG_PMIC_POC_I")
	),
	MTK_PIN(
		64, "GPIO64",
		MTK_EINT_FUNCTION(0, 64),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO64"),
		MTK_FUNCTION(1, "PRE_UVLO")
	),
	MTK_PIN(
		65, "GPIO65",
		MTK_EINT_FUNCTION(0, 65),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO65"),
		MTK_FUNCTION(1, "DPM2PMIC"),
		MTK_FUNCTION(2, "SRCLKENA1")
	),
	MTK_PIN(
		66, "GPIO66",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO66"),
		MTK_FUNCTION(1, "WATCHDOG")
	),
	MTK_PIN(
		67, "GPIO67",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO67"),
		MTK_FUNCTION(1, "SRCLKENA0")
	),
	MTK_PIN(
		68, "GPIO68",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO68"),
		MTK_FUNCTION(1, "SCP_VREQ_VAO")
	),
	MTK_PIN(
		69, "GPIO69",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO69"),
		MTK_FUNCTION(1, "RTC32K_CK")
	),
	MTK_PIN(
		70, "GPIO70",
		MTK_EINT_FUNCTION(0, 70),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO70"),
		MTK_FUNCTION(1, "CMFLASH0")
	),
	MTK_PIN(
		71, "GPIO71",
		MTK_EINT_FUNCTION(0, 71),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO71")
	),
	MTK_PIN(
		72, "GPIO72",
		MTK_EINT_FUNCTION(0, 72),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO72")
	),
	MTK_PIN(
		73, "GPIO73",
		MTK_EINT_FUNCTION(0, 73),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO73")
	),
	MTK_PIN(
		74, "GPIO74",
		MTK_EINT_FUNCTION(0, 74),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO74"),
		MTK_FUNCTION(1, "DCXO_FPM_LPM")
	),
	MTK_PIN(
		75, "GPIO75",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO75"),
		MTK_FUNCTION(1, "SPMI_M_SCL")
	),
	MTK_PIN(
		76, "GPIO76",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO76"),
		MTK_FUNCTION(1, "SPMI_M_SDA")
	),
	MTK_PIN(
		77, "GPIO77",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO77"),
		MTK_FUNCTION(1, "SPMI_P_SCL")
	),
	MTK_PIN(
		78, "GPIO78",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO78"),
		MTK_FUNCTION(1, "SPMI_P_SDA")
	),
	MTK_PIN(
		79, "GPIO79",
		MTK_EINT_FUNCTION(0, 79),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO79"),
		MTK_FUNCTION(1, "CMMCLK0"),
		MTK_FUNCTION(2, "MD_INT4")
	),
	MTK_PIN(
		80, "GPIO80",
		MTK_EINT_FUNCTION(0, 80),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO80"),
		MTK_FUNCTION(1, "CMMCLK1")
	),
	MTK_PIN(
		81, "GPIO81",
		MTK_EINT_FUNCTION(0, 81),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO81"),
		MTK_FUNCTION(1, "SCP_SPI0_CK"),
		MTK_FUNCTION(2, "SPI6_B_CLK"),
		MTK_FUNCTION(3, "PWM_VLP"),
		MTK_FUNCTION(4, "I2SOUT5_BCK"),
		MTK_FUNCTION(6, "TP_GPIO0_AO")
	),
	MTK_PIN(
		82, "GPIO82",
		MTK_EINT_FUNCTION(0, 82),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO82"),
		MTK_FUNCTION(1, "SCP_SPI0_CS"),
		MTK_FUNCTION(2, "SPI6_B_CSB"),
		MTK_FUNCTION(4, "I2SOUT5_LRCK"),
		MTK_FUNCTION(6, "TP_GPIO1_AO")
	),
	MTK_PIN(
		83, "GPIO83",
		MTK_EINT_FUNCTION(0, 83),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO83"),
		MTK_FUNCTION(1, "SCP_SPI0_MO"),
		MTK_FUNCTION(2, "SPI6_B_MO"),
		MTK_FUNCTION(4, "I2SOUT5_DATA0"),
		MTK_FUNCTION(6, "TP_GPIO2_AO")
	),
	MTK_PIN(
		84, "GPIO84",
		MTK_EINT_FUNCTION(0, 84),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO84"),
		MTK_FUNCTION(1, "SCP_SPI0_MI"),
		MTK_FUNCTION(2, "SPI6_B_MI"),
		MTK_FUNCTION(4, "I2SOUT5_DATA1"),
		MTK_FUNCTION(6, "TP_GPIO3_AO")
	),
	MTK_PIN(
		85, "GPIO85",
		MTK_EINT_FUNCTION(0, 85),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO85"),
		MTK_FUNCTION(1, "SCP_SPI1_CK"),
		MTK_FUNCTION(2, "SPI7_B_CLK"),
		MTK_FUNCTION(4, "I2SIN5_DATA0"),
		MTK_FUNCTION(5, "PWM_VLP"),
		MTK_FUNCTION(6, "TP_GPIO4_AO")
	),
	MTK_PIN(
		86, "GPIO86",
		MTK_EINT_FUNCTION(0, 86),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO86"),
		MTK_FUNCTION(1, "SCP_SPI1_CS"),
		MTK_FUNCTION(2, "SPI7_B_CSB"),
		MTK_FUNCTION(4, "I2SIN5_DATA1"),
		MTK_FUNCTION(6, "TP_GPIO5_AO")
	),
	MTK_PIN(
		87, "GPIO87",
		MTK_EINT_FUNCTION(0, 87),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO87"),
		MTK_FUNCTION(1, "SCP_SPI1_MO"),
		MTK_FUNCTION(2, "SPI7_B_MO"),
		MTK_FUNCTION(4, "I2SIN5_BCK"),
		MTK_FUNCTION(6, "TP_GPIO6_AO")
	),
	MTK_PIN(
		88, "GPIO88",
		MTK_EINT_FUNCTION(0, 88),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO88"),
		MTK_FUNCTION(1, "SCP_SPI1_MI"),
		MTK_FUNCTION(2, "SPI7_B_MI"),
		MTK_FUNCTION(4, "I2SIN5_LRCK"),
		MTK_FUNCTION(6, "TP_GPIO7_AO")
	),
	MTK_PIN(
		89, "GPIO89",
		MTK_EINT_FUNCTION(0, 89),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO89"),
		MTK_FUNCTION(1, "DSI_TE"),
		MTK_FUNCTION(2, "DSI1_TE"),
		MTK_FUNCTION(7, "DBG_MON_B30")
	),
	MTK_PIN(
		90, "GPIO90",
		MTK_EINT_FUNCTION(0, 90),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO90"),
		MTK_FUNCTION(1, "LCM_RST"),
		MTK_FUNCTION(2, "LCM1_RST"),
		MTK_FUNCTION(7, "DBG_MON_B31")
	),
	MTK_PIN(
		91, "GPIO91",
		MTK_EINT_FUNCTION(0, 91),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO91"),
		MTK_FUNCTION(1, "CMFLASH2"),
		MTK_FUNCTION(2, "SF_D0"),
		MTK_FUNCTION(3, "SRCLKENAI1"),
		MTK_FUNCTION(5, "KPCOL2"),
		MTK_FUNCTION(6, "TP_GPIO11_AO")
	),
	MTK_PIN(
		92, "GPIO92",
		MTK_EINT_FUNCTION(0, 92),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO92"),
		MTK_FUNCTION(1, "CMFLASH3"),
		MTK_FUNCTION(2, "SF_D1"),
		MTK_FUNCTION(4, "DISP_PWM1"),
		MTK_FUNCTION(6, "TP_GPIO12_AO")
	),
	MTK_PIN(
		93, "GPIO93",
		MTK_EINT_FUNCTION(0, 93),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO93"),
		MTK_FUNCTION(1, "CMFLASH1"),
		MTK_FUNCTION(2, "SF_D2"),
		MTK_FUNCTION(3, "SRCLKENAI0"),
		MTK_FUNCTION(5, "KPROW2"),
		MTK_FUNCTION(6, "TP_GPIO13_AO")
	),
	MTK_PIN(
		94, "GPIO94",
		MTK_EINT_FUNCTION(0, 94),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO94"),
		MTK_FUNCTION(1, "I2S_MCK1"),
		MTK_FUNCTION(2, "SF_D3"),
		MTK_FUNCTION(4, "MD32_0_GPIO0"),
		MTK_FUNCTION(5, "CLKM0_A"),
		MTK_FUNCTION(6, "TP_GPIO14_AO"),
		MTK_FUNCTION(7, "DBG_MON_B18")
	),
	MTK_PIN(
		95, "GPIO95",
		MTK_EINT_FUNCTION(0, 95),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO95"),
		MTK_FUNCTION(1, "I2SIN1_BCK"),
		MTK_FUNCTION(2, "I2SIN4_BCK"),
		MTK_FUNCTION(3, "SPI6_A_CLK"),
		MTK_FUNCTION(4, "MD32_1_GPIO0"),
		MTK_FUNCTION(5, "CLKM1_A"),
		MTK_FUNCTION(6, "TP_GPIO15_AO"),
		MTK_FUNCTION(7, "DBG_MON_B19")
	),
	MTK_PIN(
		96, "GPIO96",
		MTK_EINT_FUNCTION(0, 96),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO96"),
		MTK_FUNCTION(1, "I2SIN1_LRCK"),
		MTK_FUNCTION(2, "I2SIN4_LRCK"),
		MTK_FUNCTION(3, "SPI6_A_CSB"),
		MTK_FUNCTION(4, "MD32_2_GPIO0"),
		MTK_FUNCTION(5, "CLKM2_A"),
		MTK_FUNCTION(7, "DBG_MON_B20")
	),
	MTK_PIN(
		97, "GPIO97",
		MTK_EINT_FUNCTION(0, 97),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO97"),
		MTK_FUNCTION(1, "I2SIN1_DI_A"),
		MTK_FUNCTION(2, "I2SIN4_DATA0"),
		MTK_FUNCTION(3, "SPI6_A_MO"),
		MTK_FUNCTION(4, "MD32_3_GPIO0"),
		MTK_FUNCTION(5, "CLKM3_A"),
		MTK_FUNCTION(7, "DBG_MON_B21")
	),
	MTK_PIN(
		98, "GPIO98",
		MTK_EINT_FUNCTION(0, 98),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO98"),
		MTK_FUNCTION(1, "I2SOUT1_DO"),
		MTK_FUNCTION(2, "I2SOUT4_DATA0"),
		MTK_FUNCTION(3, "SPI6_A_MI"),
		MTK_FUNCTION(7, "DBG_MON_B22")
	),
	MTK_PIN(
		99, "GPIO99",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO99"),
		MTK_FUNCTION(1, "SCL0"),
		MTK_FUNCTION(2, "LCM2_RST"),
		MTK_FUNCTION(3, "AUD_DAC_26M_CLK"),
		MTK_FUNCTION(4, "SPU0_SCL"),
		MTK_FUNCTION(7, "DBG_MON_B24")
	),
	MTK_PIN(
		100, "GPIO100",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO100"),
		MTK_FUNCTION(1, "SDA0"),
		MTK_FUNCTION(2, "DSI2_TE"),
		MTK_FUNCTION(4, "SPU0_SDA"),
		MTK_FUNCTION(7, "DBG_MON_B25")
	),
	MTK_PIN(
		101, "GPIO101",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO101"),
		MTK_FUNCTION(1, "SCL10"),
		MTK_FUNCTION(2, "SF_CS"),
		MTK_FUNCTION(3, "SCP_DMIC1_CLK"),
		MTK_FUNCTION(4, "I2SIN5_DATA2"),
		MTK_FUNCTION(5, "SCP_SCL_OIS"),
		MTK_FUNCTION(6, "TP_GPIO10_AO"),
		MTK_FUNCTION(7, "DBG_MON_B28")
	),
	MTK_PIN(
		102, "GPIO102",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO102"),
		MTK_FUNCTION(1, "SDA10"),
		MTK_FUNCTION(2, "SF_CK"),
		MTK_FUNCTION(3, "SCP_DMIC1_DAT"),
		MTK_FUNCTION(4, "I2SIN5_DATA3"),
		MTK_FUNCTION(5, "SCP_SDA_OIS"),
		MTK_FUNCTION(6, "TP_GPIO11_AO"),
		MTK_FUNCTION(7, "DBG_MON_B29")
	),
	MTK_PIN(
		103, "GPIO103",
		MTK_EINT_FUNCTION(0, 103),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO103"),
		MTK_FUNCTION(1, "DISP_PWM"),
		MTK_FUNCTION(2, "DSI1_TE"),
		MTK_FUNCTION(5, "I2S_MCK0"),
		MTK_FUNCTION(7, "DBG_MON_B23")
	),
	MTK_PIN(
		104, "GPIO104",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO104"),
		MTK_FUNCTION(1, "SCL6"),
		MTK_FUNCTION(2, "SPU1_SCL"),
		MTK_FUNCTION(3, "AUD_DAC_26M_CLK"),
		MTK_FUNCTION(4, "USB_DRVVBUS_2P"),
		MTK_FUNCTION(5, "I2S_MCK1"),
		MTK_FUNCTION(6, "IDDIG_2P"),
		MTK_FUNCTION(7, "DBG_MON_B26")
	),
	MTK_PIN(
		105, "GPIO105",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO105"),
		MTK_FUNCTION(1, "SDA6"),
		MTK_FUNCTION(2, "SPU1_SDA"),
		MTK_FUNCTION(3, "DISP_PWM2"),
		MTK_FUNCTION(4, "VBUSVALID_2P"),
		MTK_FUNCTION(5, "I2S_MCK2"),
		MTK_FUNCTION(6, "VBUSVALID_3P"),
		MTK_FUNCTION(7, "DBG_MON_B27")
	),
	MTK_PIN(
		106, "GPIO106",
		MTK_EINT_FUNCTION(0, 106),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO106"),
		MTK_FUNCTION(1, "SCP_SPI3_CK"),
		MTK_FUNCTION(2, "SPI3_B_CLK"),
		MTK_FUNCTION(3, "MD_UTXD0"),
		MTK_FUNCTION(4, "TP_UTXD1_VLP"),
		MTK_FUNCTION(5, "CONN_BG_GPS_MCU_UART0_TXD"),
		MTK_FUNCTION(6, "TP_GPIO6_AO"),
		MTK_FUNCTION(7, "DBG_MON_B0")
	),
	MTK_PIN(
		107, "GPIO107",
		MTK_EINT_FUNCTION(0, 107),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO107"),
		MTK_FUNCTION(1, "SCP_SPI3_CS"),
		MTK_FUNCTION(2, "SPI3_B_CSB"),
		MTK_FUNCTION(3, "MD_URXD0"),
		MTK_FUNCTION(4, "TP_URXD1_VLP"),
		MTK_FUNCTION(5, "CONN_BG_GPS_MCU_UART0_RXD"),
		MTK_FUNCTION(6, "TP_GPIO7_AO"),
		MTK_FUNCTION(7, "DBG_MON_B1")
	),
	MTK_PIN(
		108, "GPIO108",
		MTK_EINT_FUNCTION(0, 108),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO108"),
		MTK_FUNCTION(1, "SCP_SPI3_MO"),
		MTK_FUNCTION(2, "SPI3_B_MO"),
		MTK_FUNCTION(3, "MD_UTXD1"),
		MTK_FUNCTION(4, "MD32PCM_UTXD_AO_VLP"),
		MTK_FUNCTION(5, "CONN_BG_GPS_MCU_UART1_TXD"),
		MTK_FUNCTION(6, "TP_GPIO8_AO"),
		MTK_FUNCTION(7, "DBG_MON_B2")
	),
	MTK_PIN(
		109, "GPIO109",
		MTK_EINT_FUNCTION(0, 109),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO109"),
		MTK_FUNCTION(1, "SCP_SPI3_MI"),
		MTK_FUNCTION(2, "SPI3_B_MI"),
		MTK_FUNCTION(3, "MD_URXD1"),
		MTK_FUNCTION(4, "MD32PCM_URXD_AO_VLP"),
		MTK_FUNCTION(5, "CONN_BG_GPS_MCU_UART1_RXD"),
		MTK_FUNCTION(6, "TP_GPIO9_AO"),
		MTK_FUNCTION(7, "DBG_MON_B3")
	),
	MTK_PIN(
		110, "GPIO110",
		MTK_EINT_FUNCTION(0, 110),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO110"),
		MTK_FUNCTION(1, "SPI1_CLK"),
		MTK_FUNCTION(2, "PWM_0"),
		MTK_FUNCTION(3, "MD_UCTS0"),
		MTK_FUNCTION(4, "TP_UCTS1_VLP"),
		MTK_FUNCTION(6, "SPU0_GPIO_O"),
		MTK_FUNCTION(7, "DBG_MON_B4")
	),
	MTK_PIN(
		111, "GPIO111",
		MTK_EINT_FUNCTION(0, 111),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO111"),
		MTK_FUNCTION(1, "SPI1_CSB"),
		MTK_FUNCTION(2, "PWM_1"),
		MTK_FUNCTION(3, "MD_URTS0"),
		MTK_FUNCTION(4, "TP_URTS1_VLP"),
		MTK_FUNCTION(6, "SPU0_GPIO_I"),
		MTK_FUNCTION(7, "DBG_MON_B5")
	),
	MTK_PIN(
		112, "GPIO112",
		MTK_EINT_FUNCTION(0, 112),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO112"),
		MTK_FUNCTION(1, "SPI1_MO"),
		MTK_FUNCTION(2, "PWM_2"),
		MTK_FUNCTION(3, "MD_UCTS1"),
		MTK_FUNCTION(6, "SPU1_GPIO_O"),
		MTK_FUNCTION(7, "DBG_MON_B6")
	),
	MTK_PIN(
		113, "GPIO113",
		MTK_EINT_FUNCTION(0, 113),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO113"),
		MTK_FUNCTION(1, "SPI1_MI"),
		MTK_FUNCTION(2, "PWM_3"),
		MTK_FUNCTION(3, "MD_URTS1"),
		MTK_FUNCTION(6, "SPU1_GPIO_I"),
		MTK_FUNCTION(7, "DBG_MON_B7")
	),
	MTK_PIN(
		114, "GPIO114",
		MTK_EINT_FUNCTION(0, 114),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO114"),
		MTK_FUNCTION(1, "SPI0_SPU_CLK"),
		MTK_FUNCTION(2, "SPI4_A_CLK"),
		MTK_FUNCTION(5, "CONN_BG_GPS_MCU_DBG_UART_TX"),
		MTK_FUNCTION(7, "DBG_MON_B8")
	),
	MTK_PIN(
		115, "GPIO115",
		MTK_EINT_FUNCTION(0, 115),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO115"),
		MTK_FUNCTION(1, "SPI0_SPU_CSB"),
		MTK_FUNCTION(2, "SPI4_A_CSB"),
		MTK_FUNCTION(7, "DBG_MON_B9")
	),
	MTK_PIN(
		116, "GPIO116",
		MTK_EINT_FUNCTION(0, 116),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO116"),
		MTK_FUNCTION(1, "SPI0_SPU_MO"),
		MTK_FUNCTION(2, "SPI4_A_MO"),
		MTK_FUNCTION(3, "LCM1_RST"),
		MTK_FUNCTION(7, "DBG_MON_B10")
	),
	MTK_PIN(
		117, "GPIO117",
		MTK_EINT_FUNCTION(0, 117),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO117"),
		MTK_FUNCTION(1, "SPI0_SPU_MI"),
		MTK_FUNCTION(2, "SPI4_A_MI"),
		MTK_FUNCTION(3, "DSI1_TE"),
		MTK_FUNCTION(7, "DBG_MON_B11")
	),
	MTK_PIN(
		118, "GPIO118",
		MTK_EINT_FUNCTION(0, 118),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO118"),
		MTK_FUNCTION(1, "SPI5_CLK"),
		MTK_FUNCTION(2, "USB_DRVVBUS"),
		MTK_FUNCTION(3, "DP_TX_HPD"),
		MTK_FUNCTION(4, "AD_ILDO_DTEST0")
	),
	MTK_PIN(
		119, "GPIO119",
		MTK_EINT_FUNCTION(0, 119),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO119"),
		MTK_FUNCTION(1, "SPI5_CSB"),
		MTK_FUNCTION(2, "VBUSVALID"),
		MTK_FUNCTION(3, "DP_OC_EN"),
		MTK_FUNCTION(4, "AD_ILDO_DTEST1")
	),
	MTK_PIN(
		120, "GPIO120",
		MTK_EINT_FUNCTION(0, 120),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO120"),
		MTK_FUNCTION(1, "SPI5_MO"),
		MTK_FUNCTION(2, "LCM2_RST"),
		MTK_FUNCTION(3, "DP_RAUX_SBU1"),
		MTK_FUNCTION(4, "AD_ILDO_DTEST2"),
		MTK_FUNCTION(6, "IDDIG_3P")
	),
	MTK_PIN(
		121, "GPIO121",
		MTK_EINT_FUNCTION(0, 121),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO121"),
		MTK_FUNCTION(1, "SPI5_MI"),
		MTK_FUNCTION(2, "DSI2_TE"),
		MTK_FUNCTION(3, "DP_RAUX_SBU2"),
		MTK_FUNCTION(4, "AD_ILDO_DTEST3"),
		MTK_FUNCTION(6, "USB_DRVVBUS_3P"),
		MTK_FUNCTION(7, "DBG_MON_B17")
	),
	MTK_PIN(
		122, "GPIO122",
		MTK_EINT_FUNCTION(0, 122),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO122"),
		MTK_FUNCTION(1, "AP_GOOD"),
		MTK_FUNCTION(2, "CONN_TCXOENA_REQ")
	),
	MTK_PIN(
		123, "GPIO123",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO123"),
		MTK_FUNCTION(1, "SCL3"),
		MTK_FUNCTION(5, "I2SIN2_LRCK"),
		MTK_FUNCTION(6, "TP_UTXD_MD_VCORE")
	),
	MTK_PIN(
		124, "GPIO124",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO124"),
		MTK_FUNCTION(1, "SDA3"),
		MTK_FUNCTION(6, "TP_URXD_MD_VCORE")
	),
	MTK_PIN(
		125, "GPIO125",
		MTK_EINT_FUNCTION(0, 125),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO125"),
		MTK_FUNCTION(1, "MSDC1_CLK"),
		MTK_FUNCTION(2, "MD1_SIM2_SCLK"),
		MTK_FUNCTION(3, "HFRP_JTAG0_TCK"),
		MTK_FUNCTION(4, "UDI_TCK"),
		MTK_FUNCTION(5, "CONN_BGF_DSP_L1_JCK"),
		MTK_FUNCTION(6, "SCP_JTAG_LITTLE_TCK_VLP"),
		MTK_FUNCTION(7, "JTCK2_SEL1")
	),
	MTK_PIN(
		126, "GPIO126",
		MTK_EINT_FUNCTION(0, 126),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO126"),
		MTK_FUNCTION(1, "MSDC1_CMD"),
		MTK_FUNCTION(3, "HFRP_JTAG0_TMS"),
		MTK_FUNCTION(4, "UDI_TMS"),
		MTK_FUNCTION(5, "CONN_BGF_DSP_L1_JMS"),
		MTK_FUNCTION(6, "SCP_JTAG_LITTLE_TMS_VLP"),
		MTK_FUNCTION(7, "JTMS2_SEL1")
	),
	MTK_PIN(
		127, "GPIO127",
		MTK_EINT_FUNCTION(0, 127),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO127"),
		MTK_FUNCTION(1, "MSDC1_DAT0"),
		MTK_FUNCTION(2, "MD1_SIM2_SRST"),
		MTK_FUNCTION(3, "HFRP_JTAG0_TDI"),
		MTK_FUNCTION(4, "UDI_TDI_0"),
		MTK_FUNCTION(5, "CONN_BGF_DSP_L1_JDI"),
		MTK_FUNCTION(6, "SCP_JTAG_LITTLE_TDI_VLP"),
		MTK_FUNCTION(7, "JTDI2_SEL1")
	),
	MTK_PIN(
		128, "GPIO128",
		MTK_EINT_FUNCTION(0, 128),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO128"),
		MTK_FUNCTION(1, "MSDC1_DAT1"),
		MTK_FUNCTION(2, "MD1_SIM2_SIO"),
		MTK_FUNCTION(3, "HFRP_JTAG0_TDO"),
		MTK_FUNCTION(4, "UDI_TDO_0"),
		MTK_FUNCTION(5, "CONN_BGF_DSP_L1_JDO"),
		MTK_FUNCTION(6, "SCP_JTAG_LITTLE_TDO_VLP"),
		MTK_FUNCTION(7, "JTDO2_SEL1")
	),
	MTK_PIN(
		129, "GPIO129",
		MTK_EINT_FUNCTION(0, 129),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO129"),
		MTK_FUNCTION(1, "MSDC1_DAT2"),
		MTK_FUNCTION(2, "DSI2_HSYNC"),
		MTK_FUNCTION(3, "HFRP_JTAG0_TRSTN"),
		MTK_FUNCTION(4, "UDI_NTRST"),
		MTK_FUNCTION(6, "SCP_JTAG_LITTLE_TRSTN_VLP"),
		MTK_FUNCTION(7, "JTRSTN2_SEL1")
	),
	MTK_PIN(
		130, "GPIO130",
		MTK_EINT_FUNCTION(0, 130),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO130"),
		MTK_FUNCTION(1, "MSDC1_DAT3"),
		MTK_FUNCTION(2, "DSI3_HSYNC"),
		MTK_FUNCTION(5, "CONN_BGF_DSP_L1_JINTP")
	),
	MTK_PIN(
		131, "GPIO131",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO131"),
		MTK_FUNCTION(1, "MD1_SIM2_SCLK"),
		MTK_FUNCTION(2, "MD1_SIM1_SCLK"),
		MTK_FUNCTION(3, "MCUPM_JTAG_TDI"),
		MTK_FUNCTION(4, "CLKM0_A"),
		MTK_FUNCTION(5, "CONN_BGF_DSP_L5_JDI"),
		MTK_FUNCTION(6, "TSFDC_SCK"),
		MTK_FUNCTION(7, "SCP_JTAG0_TDI_VCORE")
	),
	MTK_PIN(
		132, "GPIO132",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO132"),
		MTK_FUNCTION(1, "MD1_SIM2_SRST"),
		MTK_FUNCTION(2, "MD1_SIM1_SRST"),
		MTK_FUNCTION(3, "MCUPM_JTAG_TMS"),
		MTK_FUNCTION(4, "CLKM1_B"),
		MTK_FUNCTION(5, "CONN_BGF_DSP_L5_JMS"),
		MTK_FUNCTION(6, "TSFDC_SDI"),
		MTK_FUNCTION(7, "SCP_JTAG0_TMS_VCORE")
	),
	MTK_PIN(
		133, "GPIO133",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO133"),
		MTK_FUNCTION(1, "MD1_SIM2_SIO"),
		MTK_FUNCTION(2, "MD1_SIM1_SIO"),
		MTK_FUNCTION(3, "MCUPM_JTAG_TDO"),
		MTK_FUNCTION(5, "CONN_BGF_DSP_L5_JDO"),
		MTK_FUNCTION(6, "TSFDC_SCF"),
		MTK_FUNCTION(7, "SCP_JTAG0_TDO_VCORE")
	),
	MTK_PIN(
		134, "GPIO134",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO134"),
		MTK_FUNCTION(1, "MD1_SIM1_SCLK"),
		MTK_FUNCTION(2, "MD1_SIM2_SCLK"),
		MTK_FUNCTION(6, "TSFDC_26M")
	),
	MTK_PIN(
		135, "GPIO135",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO135"),
		MTK_FUNCTION(1, "MD1_SIM1_SRST"),
		MTK_FUNCTION(2, "MD1_SIM2_SRST"),
		MTK_FUNCTION(3, "MCUPM_JTAG_TCK"),
		MTK_FUNCTION(5, "CONN_BGF_DSP_L5_JCK"),
		MTK_FUNCTION(6, "TSFDC_SDO"),
		MTK_FUNCTION(7, "SCP_JTAG0_TCK_VCORE")
	),
	MTK_PIN(
		136, "GPIO136",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO136"),
		MTK_FUNCTION(1, "MD1_SIM1_SIO"),
		MTK_FUNCTION(2, "MD1_SIM2_SIO"),
		MTK_FUNCTION(3, "MCUPM_JTAG_TRSTN"),
		MTK_FUNCTION(5, "CONN_BGF_DSP_L5_JINTP"),
		MTK_FUNCTION(6, "TSFDC_FOUT"),
		MTK_FUNCTION(7, "SCP_JTAG0_TRSTN_VCORE")
	),
	MTK_PIN(
		137, "GPIO137",
		MTK_EINT_FUNCTION(0, 137),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO137"),
		MTK_FUNCTION(1, "MIPI0_D_SCLK"),
		MTK_FUNCTION(2, "BPI_BUS16"),
		MTK_FUNCTION(4, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(6, "SPM_JTAG_TRSTN_VCORE"),
		MTK_FUNCTION(7, "DBG_MON_A0")
	),
	MTK_PIN(
		138, "GPIO138",
		MTK_EINT_FUNCTION(0, 138),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO138"),
		MTK_FUNCTION(1, "MIPI0_D_SDATA"),
		MTK_FUNCTION(2, "BPI_BUS17"),
		MTK_FUNCTION(4, "PCM0_LRCK"),
		MTK_FUNCTION(6, "SPM_JTAG_TCK_VCORE"),
		MTK_FUNCTION(7, "DBG_MON_A1")
	),
	MTK_PIN(
		139, "GPIO139",
		MTK_EINT_FUNCTION(0, 139),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO139"),
		MTK_FUNCTION(1, "MIPI1_D_SCLK"),
		MTK_FUNCTION(2, "BPI_BUS18"),
		MTK_FUNCTION(4, "MD_GPS_BLANK"),
		MTK_FUNCTION(6, "SPM_JTAG_TMS_VCORE"),
		MTK_FUNCTION(7, "DBG_MON_A2")
	),
	MTK_PIN(
		140, "GPIO140",
		MTK_EINT_FUNCTION(0, 140),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO140"),
		MTK_FUNCTION(1, "MIPI1_D_SDATA"),
		MTK_FUNCTION(2, "BPI_BUS19"),
		MTK_FUNCTION(4, "MD_URXD1_CONN"),
		MTK_FUNCTION(6, "SPM_JTAG_TDO_VCORE"),
		MTK_FUNCTION(7, "DBG_MON_A3")
	),
	MTK_PIN(
		141, "GPIO141",
		MTK_EINT_FUNCTION(0, 141),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO141"),
		MTK_FUNCTION(1, "MIPI2_D_SCLK"),
		MTK_FUNCTION(2, "BPI_BUS20"),
		MTK_FUNCTION(4, "MD_UTXD1_CONN"),
		MTK_FUNCTION(6, "SPM_JTAG_TDI_VCORE"),
		MTK_FUNCTION(7, "DBG_MON_A4")
	),
	MTK_PIN(
		142, "GPIO142",
		MTK_EINT_FUNCTION(0, 142),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO142"),
		MTK_FUNCTION(1, "MIPI2_D_SDATA"),
		MTK_FUNCTION(2, "BPI_BUS21"),
		MTK_FUNCTION(6, "SSPM_JTAG_TRSTN_VCORE"),
		MTK_FUNCTION(7, "DBG_MON_A5")
	),
	MTK_PIN(
		143, "GPIO143",
		MTK_EINT_FUNCTION(0, 143),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO143"),
		MTK_FUNCTION(1, "MIPI3_D_SCLK"),
		MTK_FUNCTION(2, "BPI_BUS22"),
		MTK_FUNCTION(4, "TP_UTXD_GNSS_VLP"),
		MTK_FUNCTION(5, "MD_UTXD1_CONN"),
		MTK_FUNCTION(6, "SSPM_JTAG_TCK_VCORE")
	),
	MTK_PIN(
		144, "GPIO144",
		MTK_EINT_FUNCTION(0, 144),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO144"),
		MTK_FUNCTION(1, "MIPI3_D_SDATA"),
		MTK_FUNCTION(2, "BPI_BUS23"),
		MTK_FUNCTION(4, "TP_URXD_GNSS_VLP"),
		MTK_FUNCTION(5, "MD_URXD1_CONN"),
		MTK_FUNCTION(6, "SSPM_JTAG_TMS_VCORE")
	),
	MTK_PIN(
		145, "GPIO145",
		MTK_EINT_FUNCTION(0, 145),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO145"),
		MTK_FUNCTION(1, "BPI_BUS0"),
		MTK_FUNCTION(4, "PCIE_WAKEN_1P"),
		MTK_FUNCTION(6, "SSPM_JTAG_TDO_VCORE"),
		MTK_FUNCTION(7, "DBG_MON_A10")
	),
	MTK_PIN(
		146, "GPIO146",
		MTK_EINT_FUNCTION(0, 146),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO146"),
		MTK_FUNCTION(1, "BPI_BUS1"),
		MTK_FUNCTION(4, "PCIE_PERSTN_1P"),
		MTK_FUNCTION(6, "SSPM_JTAG_TDI_VCORE"),
		MTK_FUNCTION(7, "DBG_MON_A11")
	),
	MTK_PIN(
		147, "GPIO147",
		MTK_EINT_FUNCTION(0, 147),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO147"),
		MTK_FUNCTION(1, "BPI_BUS2"),
		MTK_FUNCTION(2, "AUD_DAC_26M_CLK"),
		MTK_FUNCTION(4, "PCIE_CLKREQN_1P"),
		MTK_FUNCTION(6, "SCP_JTAG_LITTLE_TRSTN_VCORE"),
		MTK_FUNCTION(7, "DBG_MON_A12")
	),
	MTK_PIN(
		148, "GPIO148",
		MTK_EINT_FUNCTION(0, 148),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO148"),
		MTK_FUNCTION(1, "BPI_BUS3"),
		MTK_FUNCTION(2, "AUD_DAC_26M_CLK"),
		MTK_FUNCTION(4, "TP_UTXD_MD_VLP"),
		MTK_FUNCTION(5, "TP_GPIO0_AO"),
		MTK_FUNCTION(6, "SCP_JTAG_LITTLE_TCK_VCORE"),
		MTK_FUNCTION(7, "DBG_MON_A13")
	),
	MTK_PIN(
		149, "GPIO149",
		MTK_EINT_FUNCTION(0, 149),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO149"),
		MTK_FUNCTION(1, "BPI_BUS4"),
		MTK_FUNCTION(2, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(4, "TP_URXD_MD_VLP"),
		MTK_FUNCTION(5, "TP_GPIO1_AO"),
		MTK_FUNCTION(6, "SCP_JTAG_LITTLE_TMS_VCORE"),
		MTK_FUNCTION(7, "DBG_MON_A14")
	),
	MTK_PIN(
		150, "GPIO150",
		MTK_EINT_FUNCTION(0, 150),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO150"),
		MTK_FUNCTION(1, "BPI_BUS5"),
		MTK_FUNCTION(2, "GPS_PPS0"),
		MTK_FUNCTION(5, "TP_GPIO2_AO"),
		MTK_FUNCTION(6, "SCP_JTAG_LITTLE_TDO_VCORE"),
		MTK_FUNCTION(7, "DBG_MON_A15")
	),
	MTK_PIN(
		151, "GPIO151",
		MTK_EINT_FUNCTION(0, 151),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO151"),
		MTK_FUNCTION(1, "BPI_BUS6"),
		MTK_FUNCTION(2, "GPS_PPS1"),
		MTK_FUNCTION(5, "TP_GPIO3_AO"),
		MTK_FUNCTION(6, "SCP_JTAG_LITTLE_TDI_VCORE")
	),
	MTK_PIN(
		152, "GPIO152",
		MTK_EINT_FUNCTION(0, 152),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO152"),
		MTK_FUNCTION(1, "BPI_BUS7"),
		MTK_FUNCTION(2, "EDP_TX_HPD"),
		MTK_FUNCTION(5, "AGPS_SYNC"),
		MTK_FUNCTION(6, "SSPM_UTXD_AO_VCORE")
	),
	MTK_PIN(
		153, "GPIO153",
		MTK_EINT_FUNCTION(0, 153),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO153"),
		MTK_FUNCTION(1, "MD_UCNT_A_TGL"),
		MTK_FUNCTION(6, "TP_URTS1_VCORE"),
		MTK_FUNCTION(7, "DBG_MON_A8")
	),
	MTK_PIN(
		154, "GPIO154",
		MTK_EINT_FUNCTION(0, 154),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO154"),
		MTK_FUNCTION(1, "DIGRF_IRQ"),
		MTK_FUNCTION(6, "TP_UCTS1_VCORE"),
		MTK_FUNCTION(7, "DBG_MON_A9")
	),
	MTK_PIN(
		155, "GPIO155",
		MTK_EINT_FUNCTION(0, 155),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO155"),
		MTK_FUNCTION(1, "MIPI_M_SCLK"),
		MTK_FUNCTION(4, "UCTS2"),
		MTK_FUNCTION(6, "TP_UTXD_CONSYS_VCORE"),
		MTK_FUNCTION(7, "DBG_MON_A6")
	),
	MTK_PIN(
		156, "GPIO156",
		MTK_EINT_FUNCTION(0, 156),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO156"),
		MTK_FUNCTION(1, "MIPI_M_SDATA"),
		MTK_FUNCTION(4, "URTS2"),
		MTK_FUNCTION(6, "TP_URXD_CONSYS_VCORE"),
		MTK_FUNCTION(7, "DBG_MON_A7")
	),
	MTK_PIN(
		157, "GPIO157",
		MTK_EINT_FUNCTION(0, 157),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO157"),
		MTK_FUNCTION(1, "BPI_BUS8"),
		MTK_FUNCTION(4, "UTXD2"),
		MTK_FUNCTION(5, "CLKM0_A"),
		MTK_FUNCTION(6, "SSPM_URXD_AO_VCORE"),
		MTK_FUNCTION(7, "DBG_MON_A16")
	),
	MTK_PIN(
		158, "GPIO158",
		MTK_EINT_FUNCTION(0, 158),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO158"),
		MTK_FUNCTION(1, "BPI_BUS9"),
		MTK_FUNCTION(4, "URXD2"),
		MTK_FUNCTION(5, "CLKM1_A"),
		MTK_FUNCTION(6, "TP_UTXD1_VCORE")
	),
	MTK_PIN(
		159, "GPIO159",
		MTK_EINT_FUNCTION(0, 159),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO159"),
		MTK_FUNCTION(1, "BPI_BUS10"),
		MTK_FUNCTION(2, "MD_INT0"),
		MTK_FUNCTION(3, "SRCLKENAI1"),
		MTK_FUNCTION(5, "CLKM2_A"),
		MTK_FUNCTION(6, "TP_URXD1_VCORE")
	),
	MTK_PIN(
		160, "GPIO160",
		MTK_EINT_FUNCTION(0, 160),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO160"),
		MTK_FUNCTION(1, "UTXD0"),
		MTK_FUNCTION(2, "MD_UTXD1"),
		MTK_FUNCTION(5, "MBISTREADEN_TRIGGER"),
		MTK_FUNCTION(6, "CONN_BG_GPS_MCU_DBG_UART_TX")
	),
	MTK_PIN(
		161, "GPIO161",
		MTK_EINT_FUNCTION(0, 161),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO161"),
		MTK_FUNCTION(1, "URXD0"),
		MTK_FUNCTION(2, "MD_URXD1"),
		MTK_FUNCTION(5, "MBISTWRITEEN_TRIGGER")
	),
	MTK_PIN(
		162, "GPIO162",
		MTK_EINT_FUNCTION(0, 162),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO162"),
		MTK_FUNCTION(1, "UTXD1"),
		MTK_FUNCTION(2, "MD_UTXD0"),
		MTK_FUNCTION(3, "TP_UTXD1_VLP"),
		MTK_FUNCTION(4, "ADSP_UTXD0"),
		MTK_FUNCTION(5, "SSPM_UTXD_AO_VLP"),
		MTK_FUNCTION(6, "HFRP_UTXD1")
	),
	MTK_PIN(
		163, "GPIO163",
		MTK_EINT_FUNCTION(0, 163),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO163"),
		MTK_FUNCTION(1, "URXD1"),
		MTK_FUNCTION(2, "MD_URXD0"),
		MTK_FUNCTION(3, "TP_URXD1_VLP"),
		MTK_FUNCTION(4, "ADSP_URXD0"),
		MTK_FUNCTION(5, "SSPM_URXD_AO_VLP"),
		MTK_FUNCTION(6, "HFRP_URXD1")
	),
	MTK_PIN(
		164, "GPIO164",
		MTK_EINT_FUNCTION(0, 164),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO164"),
		MTK_FUNCTION(1, "SCP_SCL0"),
		MTK_FUNCTION(6, "TP_GPIO0_AO"),
		MTK_FUNCTION(7, "DBG_MON_A22")
	),
	MTK_PIN(
		165, "GPIO165",
		MTK_EINT_FUNCTION(0, 165),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO165"),
		MTK_FUNCTION(1, "SCP_SDA0"),
		MTK_FUNCTION(6, "TP_GPIO1_AO"),
		MTK_FUNCTION(7, "DBG_MON_A23")
	),
	MTK_PIN(
		166, "GPIO166",
		MTK_EINT_FUNCTION(0, 166),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO166"),
		MTK_FUNCTION(1, "SCP_SCL2"),
		MTK_FUNCTION(6, "TP_GPIO2_AO"),
		MTK_FUNCTION(7, "DBG_MON_A24")
	),
	MTK_PIN(
		167, "GPIO167",
		MTK_EINT_FUNCTION(0, 167),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO167"),
		MTK_FUNCTION(1, "SCP_SDA2"),
		MTK_FUNCTION(6, "TP_GPIO3_AO"),
		MTK_FUNCTION(7, "DBG_MON_A25")
	),
	MTK_PIN(
		168, "GPIO168",
		MTK_EINT_FUNCTION(0, 168),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO168"),
		MTK_FUNCTION(1, "SCP_SPI2_CK"),
		MTK_FUNCTION(2, "SPI2_B_CLK"),
		MTK_FUNCTION(3, "PWM_VLP"),
		MTK_FUNCTION(4, "SCP_SCL2"),
		MTK_FUNCTION(7, "DBG_MON_A26")
	),
	MTK_PIN(
		169, "GPIO169",
		MTK_EINT_FUNCTION(0, 169),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO169"),
		MTK_FUNCTION(1, "SCP_SPI2_CS"),
		MTK_FUNCTION(2, "SPI2_B_CSB"),
		MTK_FUNCTION(7, "DBG_MON_A27")
	),
	MTK_PIN(
		170, "GPIO170",
		MTK_EINT_FUNCTION(0, 170),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO170"),
		MTK_FUNCTION(1, "SCP_SPI2_MO"),
		MTK_FUNCTION(2, "SPI2_B_MO"),
		MTK_FUNCTION(4, "SCP_SDA2"),
		MTK_FUNCTION(7, "DBG_MON_A28")
	),
	MTK_PIN(
		171, "GPIO171",
		MTK_EINT_FUNCTION(0, 171),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO171"),
		MTK_FUNCTION(1, "SCP_SPI2_MI"),
		MTK_FUNCTION(2, "SPI2_B_MI"),
		MTK_FUNCTION(7, "DBG_MON_A29")
	),
	MTK_PIN(
		172, "GPIO172",
		MTK_EINT_FUNCTION(0, 172),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO172"),
		MTK_FUNCTION(1, "CONN_TCXOENA_REQ")
	),
	MTK_PIN(
		173, "GPIO173",
		MTK_EINT_FUNCTION(0, 173),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO173"),
		MTK_FUNCTION(1, "CMFLASH3"),
		MTK_FUNCTION(2, "PWM_3"),
		MTK_FUNCTION(3, "MD_GPS_L5_BLANK"),
		MTK_FUNCTION(4, "CLKM1_A"),
		MTK_FUNCTION(7, "DBG_MON_A31")
	),
	MTK_PIN(
		174, "GPIO174",
		MTK_EINT_FUNCTION(0, 174),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO174"),
		MTK_FUNCTION(1, "CMFLASH0"),
		MTK_FUNCTION(2, "PWM_0"),
		MTK_FUNCTION(3, "VBUSVALID_1P"),
		MTK_FUNCTION(4, "MD32_2_RXD"),
		MTK_FUNCTION(5, "DISP_PWM3")
	),
	MTK_PIN(
		175, "GPIO175",
		MTK_EINT_FUNCTION(0, 175),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO175"),
		MTK_FUNCTION(1, "CMFLASH1"),
		MTK_FUNCTION(2, "PWM_1"),
		MTK_FUNCTION(3, "EDP_TX_HPD"),
		MTK_FUNCTION(4, "MD32_2_TXD"),
		MTK_FUNCTION(5, "DISP_PWM4")
	),
	MTK_PIN(
		176, "GPIO176",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO176"),
		MTK_FUNCTION(1, "SCL5"),
		MTK_FUNCTION(2, "LCM3_RST"),
		MTK_FUNCTION(4, "MD_URXD1_CONN"),
		MTK_FUNCTION(6, "TP_UTXD_GNSS_VCORE")
	),
	MTK_PIN(
		177, "GPIO177",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO177"),
		MTK_FUNCTION(1, "SDA5"),
		MTK_FUNCTION(2, "DSI3_TE"),
		MTK_FUNCTION(4, "MD_UTXD1_CONN"),
		MTK_FUNCTION(6, "TP_URXD_GNSS_VCORE")
	),
	MTK_PIN(
		178, "GPIO178",
		MTK_EINT_FUNCTION(0, 178),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO178"),
		MTK_FUNCTION(1, "DMIC_CLK"),
		MTK_FUNCTION(2, "SCP_DMIC_CLK"),
		MTK_FUNCTION(3, "SRCLKENAI0"),
		MTK_FUNCTION(4, "CLKM2_B"),
		MTK_FUNCTION(5, "TP_GPIO7_AO"),
		MTK_FUNCTION(6, "SPU1_UTX"),
		MTK_FUNCTION(7, "DAP_SONIC_SWCK")
	),
	MTK_PIN(
		179, "GPIO179",
		MTK_EINT_FUNCTION(0, 179),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO179"),
		MTK_FUNCTION(1, "DMIC_DAT"),
		MTK_FUNCTION(2, "SCP_DMIC_DAT"),
		MTK_FUNCTION(3, "SRCLKENAI1"),
		MTK_FUNCTION(4, "CLKM3_B"),
		MTK_FUNCTION(5, "TP_GPIO8_AO"),
		MTK_FUNCTION(6, "SPU1_URX"),
		MTK_FUNCTION(7, "DAP_SONIC_SWD")
	),
	MTK_PIN(
		180, "GPIO180",
		MTK_EINT_FUNCTION(0, 180),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO180"),
		MTK_FUNCTION(1, "IDDIG_1P"),
		MTK_FUNCTION(2, "CMVREF0"),
		MTK_FUNCTION(3, "GPS_PPS1"),
		MTK_FUNCTION(4, "GPS_L5_ELNA_EN"),
		MTK_FUNCTION(5, "DISP_PWM1")
	),
	MTK_PIN(
		181, "GPIO181",
		MTK_EINT_FUNCTION(0, 181),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO181"),
		MTK_FUNCTION(1, "USB_DRVVBUS_1P"),
		MTK_FUNCTION(2, "CMVREF1"),
		MTK_FUNCTION(3, "MFG_EB_JTAG_TRSTN"),
		MTK_FUNCTION(4, "ADSP_JTAG1_TRSTN"),
		MTK_FUNCTION(5, "HFRP_JTAG1_TRSTN"),
		MTK_FUNCTION(6, "SPU1_NTRST"),
		MTK_FUNCTION(7, "CONN_BG_GPS_MCU_TRST_B")
	),
	MTK_PIN(
		182, "GPIO182",
		MTK_EINT_FUNCTION(0, 182),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO182"),
		MTK_FUNCTION(1, "SCL11"),
		MTK_FUNCTION(2, "CMVREF2"),
		MTK_FUNCTION(3, "MFG_EB_JTAG_TCK"),
		MTK_FUNCTION(4, "ADSP_JTAG1_TCK"),
		MTK_FUNCTION(5, "HFRP_JTAG1_TCK"),
		MTK_FUNCTION(6, "SPU1_TCK"),
		MTK_FUNCTION(7, "CONN_BG_GPS_MCU_TCK")
	),
	MTK_PIN(
		183, "GPIO183",
		MTK_EINT_FUNCTION(0, 183),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO183"),
		MTK_FUNCTION(1, "SDA11"),
		MTK_FUNCTION(2, "CMVREF3"),
		MTK_FUNCTION(3, "MFG_EB_JTAG_TMS"),
		MTK_FUNCTION(4, "ADSP_JTAG1_TMS"),
		MTK_FUNCTION(5, "HFRP_JTAG1_TMS"),
		MTK_FUNCTION(6, "SPU1_TMS"),
		MTK_FUNCTION(7, "CONN_BG_GPS_MCU_TMS")
	),
	MTK_PIN(
		184, "GPIO184",
		MTK_EINT_FUNCTION(0, 184),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO184"),
		MTK_FUNCTION(1, "SCL12"),
		MTK_FUNCTION(2, "CMVREF4"),
		MTK_FUNCTION(3, "MFG_EB_JTAG_TDO"),
		MTK_FUNCTION(4, "ADSP_JTAG1_TDO"),
		MTK_FUNCTION(5, "HFRP_JTAG1_TDO"),
		MTK_FUNCTION(6, "SPU1_TDO"),
		MTK_FUNCTION(7, "CONN_BG_GPS_MCU_TDO")
	),
	MTK_PIN(
		185, "GPIO185",
		MTK_EINT_FUNCTION(0, 185),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO185"),
		MTK_FUNCTION(1, "SDA12"),
		MTK_FUNCTION(2, "CMVREF5"),
		MTK_FUNCTION(3, "MFG_EB_JTAG_TDI"),
		MTK_FUNCTION(4, "ADSP_JTAG1_TDI"),
		MTK_FUNCTION(5, "HFRP_JTAG1_TDI"),
		MTK_FUNCTION(6, "SPU1_TDI"),
		MTK_FUNCTION(7, "CONN_BG_GPS_MCU_TDI")
	),
	MTK_PIN(
		186, "GPIO186",
		MTK_EINT_FUNCTION(0, 186),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO186"),
		MTK_FUNCTION(1, "MD_GPS_L1_BLANK"),
		MTK_FUNCTION(2, "PMSR_SMAP"),
		MTK_FUNCTION(3, "TP_GPIO2_AO")
	),
	MTK_PIN(
		187, "GPIO187",
		MTK_EINT_FUNCTION(0, 187),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO187"),
		MTK_FUNCTION(1, "MD_GPS_L5_BLANK"),
		MTK_FUNCTION(3, "TP_GPIO4_AO")
	),
	MTK_PIN(
		188, "GPIO188",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO188"),
		MTK_FUNCTION(1, "SCL2"),
		MTK_FUNCTION(2, "SCP_SCL8")
	),
	MTK_PIN(
		189, "GPIO189",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO189"),
		MTK_FUNCTION(1, "SDA2"),
		MTK_FUNCTION(2, "SCP_SDA8")
	),
	MTK_PIN(
		190, "GPIO190",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO190"),
		MTK_FUNCTION(1, "SCL4"),
		MTK_FUNCTION(2, "SCP_SCL9"),
		MTK_FUNCTION(6, "UDI_TDI_6")
	),
	MTK_PIN(
		191, "GPIO191",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO191"),
		MTK_FUNCTION(1, "SDA4"),
		MTK_FUNCTION(2, "SCP_SDA9"),
		MTK_FUNCTION(6, "UDI_TDI_7")
	),
	MTK_PIN(
		192, "GPIO192",
		MTK_EINT_FUNCTION(0, 192),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO192"),
		MTK_FUNCTION(1, "CMMCLK2"),
		MTK_FUNCTION(4, "MD32_3_RXD")
	),
	MTK_PIN(
		193, "GPIO193",
		MTK_EINT_FUNCTION(0, 193),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO193"),
		MTK_FUNCTION(3, "CLKM0_B"),
		MTK_FUNCTION(4, "MD32_3_TXD"),
		MTK_FUNCTION(6, "UDI_TDO_7")
	),
	MTK_PIN(
		194, "GPIO194",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO194"),
		MTK_FUNCTION(1, "SCL7"),
		MTK_FUNCTION(2, "MD32_3_GPIO0"),
		MTK_FUNCTION(3, "CLKM2_B"),
		MTK_FUNCTION(6, "UDI_TDI_2")
	),
	MTK_PIN(
		195, "GPIO195",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO195"),
		MTK_FUNCTION(1, "SDA7"),
		MTK_FUNCTION(3, "CLKM3_B"),
		MTK_FUNCTION(6, "UDI_TDI_3")
	),
	MTK_PIN(
		196, "GPIO196",
		MTK_EINT_FUNCTION(0, 196),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO196"),
		MTK_FUNCTION(1, "CMMCLK3")
	),
	MTK_PIN(
		197, "GPIO197",
		MTK_EINT_FUNCTION(0, 197),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO197"),
		MTK_FUNCTION(3, "CLKM1_B"),
		MTK_FUNCTION(6, "UDI_TDI_1")
	),
	MTK_PIN(
		198, "GPIO198",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO198"),
		MTK_FUNCTION(1, "SCL8"),
		MTK_FUNCTION(6, "UDI_TDI_4")
	),
	MTK_PIN(
		199, "GPIO199",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO199"),
		MTK_FUNCTION(1, "SDA8"),
		MTK_FUNCTION(6, "UDI_TDI_5")
	),
	MTK_PIN(
		200, "GPIO200",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO200"),
		MTK_FUNCTION(1, "SCL1")
	),
	MTK_PIN(
		201, "GPIO201",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO201"),
		MTK_FUNCTION(1, "SDA1"),
		MTK_FUNCTION(7, "TSFDC_BG_COMP")
	),
	MTK_PIN(
		202, "GPIO202",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO202"),
		MTK_FUNCTION(1, "SCL9"),
		MTK_FUNCTION(2, "SCP_SCL7"),
		MTK_FUNCTION(6, "TP_GPIO15_AO")
	),
	MTK_PIN(
		203, "GPIO203",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO203"),
		MTK_FUNCTION(1, "SDA9"),
		MTK_FUNCTION(2, "SCP_SDA7"),
		MTK_FUNCTION(6, "TP_GPIO9_AO")
	),
	MTK_PIN(
		204, "GPIO204",
		MTK_EINT_FUNCTION(0, 204),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO204"),
		MTK_FUNCTION(1, "SCL13"),
		MTK_FUNCTION(2, "CMVREF6"),
		MTK_FUNCTION(3, "GPS_L1_ELNA_EN"),
		MTK_FUNCTION(5, "CLKM2_B"),
		MTK_FUNCTION(6, "TP_GPIO12_AO")
	),
	MTK_PIN(
		205, "GPIO205",
		MTK_EINT_FUNCTION(0, 205),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO205"),
		MTK_FUNCTION(1, "SDA13"),
		MTK_FUNCTION(2, "CMVREF7"),
		MTK_FUNCTION(3, "GPS_L5_ELNA_EN"),
		MTK_FUNCTION(5, "CLKM3_B"),
		MTK_FUNCTION(6, "TP_GPIO13_AO")
	),
	MTK_PIN(
		206, "GPIO206",
		MTK_EINT_FUNCTION(0, 206),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO206"),
		MTK_FUNCTION(2, "MD32_2_GPIO0"),
		MTK_FUNCTION(5, "VBUSVALID"),
		MTK_FUNCTION(6, "UDI_TDO_3")
	),
	MTK_PIN(
		207, "GPIO207",
		MTK_EINT_FUNCTION(0, 207),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO207"),
		MTK_FUNCTION(1, "PCIE_WAKEN_2P"),
		MTK_FUNCTION(2, "PMSR_SMAP_MAX"),
		MTK_FUNCTION(4, "FMI2S_A_BCK"),
		MTK_FUNCTION(6, "UDI_TDO_4")
	),
	MTK_PIN(
		208, "GPIO208",
		MTK_EINT_FUNCTION(0, 208),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO208"),
		MTK_FUNCTION(1, "PCIE_CLKREQN_2P"),
		MTK_FUNCTION(2, "PMSR_SMAP_MAX_W"),
		MTK_FUNCTION(4, "FMI2S_A_LRCK"),
		MTK_FUNCTION(5, "CLKM0_B"),
		MTK_FUNCTION(6, "UDI_TDO_5")
	),
	MTK_PIN(
		209, "GPIO209",
		MTK_EINT_FUNCTION(0, 209),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO209"),
		MTK_FUNCTION(1, "PCIE_PERSTN_2P"),
		MTK_FUNCTION(2, "PMSR_SMAP"),
		MTK_FUNCTION(4, "FMI2S_A_DI"),
		MTK_FUNCTION(5, "CLKM1_B"),
		MTK_FUNCTION(6, "UDI_TDO_6")
	),
	MTK_PIN(
		210, "GPIO210",
		MTK_EINT_FUNCTION(0, 210),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO210"),
		MTK_FUNCTION(1, "CMMCLK4")
	),
	MTK_PIN(
		211, "GPIO211",
		MTK_EINT_FUNCTION(0, 211),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO211"),
		MTK_FUNCTION(1, "CMMCLK5"),
		MTK_FUNCTION(2, "CONN_TCXOENA_REQ")
	),
	MTK_PIN(
		212, "GPIO212",
		MTK_EINT_FUNCTION(0, 212),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO212"),
		MTK_FUNCTION(1, "CMMCLK6"),
		MTK_FUNCTION(2, "TP_GPIO10_AO"),
		MTK_FUNCTION(5, "IDDIG"),
		MTK_FUNCTION(6, "UDI_TDO_1")
	),
	MTK_PIN(
		213, "GPIO213",
		MTK_EINT_FUNCTION(0, 213),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO213"),
		MTK_FUNCTION(1, "CMMCLK7"),
		MTK_FUNCTION(2, "TP_GPIO11_AO"),
		MTK_FUNCTION(5, "USB_DRVVBUS"),
		MTK_FUNCTION(6, "UDI_TDO_2")
	),
	MTK_PIN(
		214, "GPIO214",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO214"),
		MTK_FUNCTION(1, "SCP_SCL3"),
		MTK_FUNCTION(2, "SDA14_E1_SCL14_E2"),
		MTK_FUNCTION(6, "GBE1_MDC"),
		MTK_FUNCTION(7, "GBE0_MDC")
	),
	MTK_PIN(
		215, "GPIO215",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO215"),
		MTK_FUNCTION(1, "SCP_SDA3"),
		MTK_FUNCTION(2, "SCL14_E1_SDA14_E2"),
		MTK_FUNCTION(6, "GBE1_MDIO"),
		MTK_FUNCTION(7, "GBE0_MDIO")
	),
	MTK_PIN(
		216, "GPIO216",
		MTK_EINT_FUNCTION(0, 216),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO216"),
		MTK_FUNCTION(1, "GPS_PPS0")
	),
	MTK_PIN(
		217, "GPIO217",
		MTK_EINT_FUNCTION(0, 217),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO217"),
		MTK_FUNCTION(1, "KPROW0"),
		MTK_FUNCTION(6, "TP_GPIO12_AO")
	),
	MTK_PIN(
		218, "GPIO218",
		MTK_EINT_FUNCTION(0, 218),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO218"),
		MTK_FUNCTION(1, "KPROW1"),
		MTK_FUNCTION(2, "SPI0_WP"),
		MTK_FUNCTION(3, "MBISTREADEN_TRIGGER"),
		MTK_FUNCTION(5, "GPS_L5_ELNA_EN"),
		MTK_FUNCTION(6, "TP_GPIO14_AO")
	),
	MTK_PIN(
		219, "GPIO219",
		MTK_EINT_FUNCTION(0, 219),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO219"),
		MTK_FUNCTION(1, "KPCOL1"),
		MTK_FUNCTION(2, "SPI0_HOLD"),
		MTK_FUNCTION(3, "MBISTWRITEEN_TRIGGER"),
		MTK_FUNCTION(4, "SPMI_M_TRIG_FLAG"),
		MTK_FUNCTION(5, "GPS_L1_ELNA_EN"),
		MTK_FUNCTION(6, "SPM_JTAG_TRSTN_VLP"),
		MTK_FUNCTION(7, "JTRSTN_SEL1")
	),
	MTK_PIN(
		220, "GPIO220",
		MTK_EINT_FUNCTION(0, 220),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO220"),
		MTK_FUNCTION(1, "SPI0_CLK"),
		MTK_FUNCTION(6, "SPM_JTAG_TCK_VLP"),
		MTK_FUNCTION(7, "JTCK_SEL1")
	),
	MTK_PIN(
		221, "GPIO221",
		MTK_EINT_FUNCTION(0, 221),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO221"),
		MTK_FUNCTION(1, "SPI0_CSB"),
		MTK_FUNCTION(6, "SPM_JTAG_TMS_VLP"),
		MTK_FUNCTION(7, "JTMS_SEL1")
	),
	MTK_PIN(
		222, "GPIO222",
		MTK_EINT_FUNCTION(0, 222),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO222"),
		MTK_FUNCTION(1, "SPI0_MO"),
		MTK_FUNCTION(2, "SCP_SCL7"),
		MTK_FUNCTION(6, "SPM_JTAG_TDO_VLP"),
		MTK_FUNCTION(7, "JTDO_SEL1")
	),
	MTK_PIN(
		223, "GPIO223",
		MTK_EINT_FUNCTION(0, 223),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO223"),
		MTK_FUNCTION(1, "SPI0_MI"),
		MTK_FUNCTION(2, "SCP_SDA7"),
		MTK_FUNCTION(6, "SPM_JTAG_TDI_VLP"),
		MTK_FUNCTION(7, "JTDI_SEL1")
	),
	MTK_PIN(
		224, "GPIO224",
		MTK_EINT_FUNCTION(0, 224),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO224"),
		MTK_FUNCTION(1, "MSDC2_CLK"),
		MTK_FUNCTION(2, "DMIC2_CLK"),
		MTK_FUNCTION(3, "GBE0_AUX_PPS0"),
		MTK_FUNCTION(4, "GBE0_TXER"),
		MTK_FUNCTION(5, "GBE1_TXER"),
		MTK_FUNCTION(6, "GBE1_AUX_PPS0"),
		MTK_FUNCTION(7, "MD32_1_TXD")
	),
	MTK_PIN(
		225, "GPIO225",
		MTK_EINT_FUNCTION(0, 225),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO225"),
		MTK_FUNCTION(1, "MSDC2_CMD"),
		MTK_FUNCTION(2, "DMIC2_DAT"),
		MTK_FUNCTION(3, "GBE0_AUX_PPS1"),
		MTK_FUNCTION(4, "GBE0_RXER"),
		MTK_FUNCTION(5, "GBE1_RXER"),
		MTK_FUNCTION(6, "GBE1_AUX_PPS1"),
		MTK_FUNCTION(7, "MD32_1_RXD")
	),
	MTK_PIN(
		226, "GPIO226",
		MTK_EINT_FUNCTION(0, 226),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO226"),
		MTK_FUNCTION(1, "MSDC2_DAT0"),
		MTK_FUNCTION(2, "I2SIN3_BCK"),
		MTK_FUNCTION(3, "GBE0_AUX_PPS2"),
		MTK_FUNCTION(4, "GBE0_COL"),
		MTK_FUNCTION(5, "GBE1_COL"),
		MTK_FUNCTION(6, "GBE1_AUX_PPS2"),
		MTK_FUNCTION(7, "GBE1_MDC")
	),
	MTK_PIN(
		227, "GPIO227",
		MTK_EINT_FUNCTION(0, 227),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO227"),
		MTK_FUNCTION(1, "MSDC2_DAT1"),
		MTK_FUNCTION(2, "I2SIN3_LRCK"),
		MTK_FUNCTION(3, "GBE0_AUX_PPS3"),
		MTK_FUNCTION(4, "GBE0_INTR"),
		MTK_FUNCTION(5, "GBE1_INTR"),
		MTK_FUNCTION(6, "GBE1_AUX_PPS3"),
		MTK_FUNCTION(7, "GBE1_MDIO")
	),
	MTK_PIN(
		228, "GPIO228",
		MTK_EINT_FUNCTION(0, 228),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO228"),
		MTK_FUNCTION(1, "MSDC2_DAT2"),
		MTK_FUNCTION(2, "I2SIN3_DI"),
		MTK_FUNCTION(3, "GBE0_MDC"),
		MTK_FUNCTION(4, "GBE1_MDC"),
		MTK_FUNCTION(5, "CONN_BG_GPS_MCU_AICE_TCKC")
	),
	MTK_PIN(
		229, "GPIO229",
		MTK_EINT_FUNCTION(0, 229),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO229"),
		MTK_FUNCTION(1, "MSDC2_DAT3"),
		MTK_FUNCTION(2, "I2SOUT3_DO"),
		MTK_FUNCTION(3, "GBE0_MDIO"),
		MTK_FUNCTION(4, "GBE1_MDIO"),
		MTK_FUNCTION(5, "CONN_BG_GPS_MCU_AICE_TMSC"),
		MTK_FUNCTION(7, "AVB_CLK2")
	),
	MTK_PIN(
		230, "GPIO230",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO230"),
		MTK_FUNCTION(1, "CONN_TOP_CLK")
	),
	MTK_PIN(
		231, "GPIO231",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO231"),
		MTK_FUNCTION(1, "CONN_TOP_DATA")
	),
	MTK_PIN(
		232, "GPIO232",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO232"),
		MTK_FUNCTION(1, "CONN_HRST_B")
	),
	MTK_PIN(
		233, "GPIO233",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO233"),
		MTK_FUNCTION(1, "I2SIN0_BCK")
	),
	MTK_PIN(
		234, "GPIO234",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO234"),
		MTK_FUNCTION(1, "I2SIN0_LRCK")
	),
	MTK_PIN(
		235, "GPIO235",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO235"),
		MTK_FUNCTION(1, "I2SIN0_DI")
	),
	MTK_PIN(
		236, "GPIO236",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO236"),
		MTK_FUNCTION(1, "I2SOUT0_DO")
	),
	MTK_PIN(
		237, "GPIO237",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO237"),
		MTK_FUNCTION(1, "CONN_UARTHUB_UART_TX"),
		MTK_FUNCTION(3, "UTXD3")
	),
	MTK_PIN(
		238, "GPIO238",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO238"),
		MTK_FUNCTION(1, "CONN_UARTHUB_UART_RX"),
		MTK_FUNCTION(3, "URXD3")
	),
	MTK_PIN(
		239, "GPIO239",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO239"),
		MTK_FUNCTION(1, "TP_UTXD_CONSYS_VLP"),
		MTK_FUNCTION(2, "TP_URXD_CONSYS_VLP")
	),
	MTK_PIN(
		240, "GPIO240",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO240"),
		MTK_FUNCTION(1, "TP_URXD_CONSYS_VLP"),
		MTK_FUNCTION(2, "TP_UTXD_CONSYS_VLP")
	),
	MTK_PIN(
		241, "GPIO241",
		MTK_EINT_FUNCTION(0, 241),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO241"),
		MTK_FUNCTION(1, "PCIE_PERSTN")
	),
	MTK_PIN(
		242, "GPIO242",
		MTK_EINT_FUNCTION(0, 242),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO242"),
		MTK_FUNCTION(1, "PCIE_WAKEN")
	),
	MTK_PIN(
		243, "GPIO243",
		MTK_EINT_FUNCTION(0, 243),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO243"),
		MTK_FUNCTION(1, "PCIE_CLKREQN")
	),
	MTK_PIN(
		244, "GPIO244",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO244"),
		MTK_FUNCTION(1, "CONN_RST")
	),
	MTK_PIN(
		245, "GPIO245",
		MTK_EINT_FUNCTION(0, 245),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO245")
	),
	MTK_PIN(
		246, "GPIO246",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO246"),
		MTK_FUNCTION(1, "CONN_PTA_TXD0")
	),
	MTK_PIN(
		247, "GPIO247",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO247"),
		MTK_FUNCTION(1, "CONN_PTA_RXD0")
	),
	MTK_PIN(
		248, "GPIO248",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO248"),
		MTK_FUNCTION(3, "UCTS3")
	),
	MTK_PIN(
		249, "GPIO249",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO249"),
		MTK_FUNCTION(3, "URTS3")
	),
	MTK_PIN(
		250, "GPIO250",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO250")
	),
	MTK_PIN(
		251, "GPIO251",
		MTK_EINT_FUNCTION(0, 251),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO251"),
		MTK_FUNCTION(1, "IDDIG_1P")
	),
	MTK_PIN(
		252, "GPIO252",
		MTK_EINT_FUNCTION(0, 252),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO252"),
		MTK_FUNCTION(1, "USB_DRVVBUS_1P")
	),
	MTK_PIN(
		253, "GPIO253",
		MTK_EINT_FUNCTION(0, 253),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO253"),
		MTK_FUNCTION(1, "VBUSVALID_1P")
	),
	MTK_PIN(
		254, "GPIO254",
		MTK_EINT_FUNCTION(0, 254),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO254"),
		MTK_FUNCTION(1, "IDDIG_2P")
	),
	MTK_PIN(
		255, "GPIO255",
		MTK_EINT_FUNCTION(0, 255),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO255"),
		MTK_FUNCTION(1, "USB_DRVVBUS_2P")
	),
	MTK_PIN(
		256, "GPIO256",
		MTK_EINT_FUNCTION(0, 256),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO256"),
		MTK_FUNCTION(1, "VBUSVALID_2P")
	),
	MTK_PIN(
		257, "GPIO257",
		MTK_EINT_FUNCTION(0, 257),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO257"),
		MTK_FUNCTION(1, "VBUSVALID_3P")
	),
	MTK_PIN(
		258, "GPIO258",
		MTK_EINT_FUNCTION(0, 258),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO258"),
		MTK_FUNCTION(7, "AVB_CLK1")
	),
	MTK_PIN(
		259, "GPIO259",
		MTK_EINT_FUNCTION(0, 259),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO259"),
		MTK_FUNCTION(1, "GBE0_TXD0"),
		MTK_FUNCTION(2, "GBE1_TXD0")
	),
	MTK_PIN(
		260, "GPIO260",
		MTK_EINT_FUNCTION(0, 260),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO260"),
		MTK_FUNCTION(1, "GBE0_TXD1"),
		MTK_FUNCTION(2, "GBE1_TXD1")
	),
	MTK_PIN(
		261, "GPIO261",
		MTK_EINT_FUNCTION(0, 261),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO261"),
		MTK_FUNCTION(1, "GBE0_TXC"),
		MTK_FUNCTION(2, "GBE1_TXC")
	),
	MTK_PIN(
		262, "GPIO262",
		MTK_EINT_FUNCTION(0, 262),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO262"),
		MTK_FUNCTION(1, "GBE0_TXEN"),
		MTK_FUNCTION(2, "GBE1_TXEN")
	),
	MTK_PIN(
		263, "GPIO263",
		MTK_EINT_FUNCTION(0, 263),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO263"),
		MTK_FUNCTION(1, "GBE0_RXD0"),
		MTK_FUNCTION(2, "GBE1_RXD0"),
		MTK_FUNCTION(3, "GBE0_AUX_PPS0")
	),
	MTK_PIN(
		264, "GPIO264",
		MTK_EINT_FUNCTION(0, 264),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO264"),
		MTK_FUNCTION(1, "GBE0_RXD1"),
		MTK_FUNCTION(2, "GBE1_RXD1"),
		MTK_FUNCTION(3, "GBE0_AUX_PPS1")
	),
	MTK_PIN(
		265, "GPIO265",
		MTK_EINT_FUNCTION(0, 265),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO265"),
		MTK_FUNCTION(1, "GBE0_RXC"),
		MTK_FUNCTION(2, "GBE1_RXC"),
		MTK_FUNCTION(3, "GBE0_AUX_PPS2")
	),
	MTK_PIN(
		266, "GPIO266",
		MTK_EINT_FUNCTION(0, 266),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO266"),
		MTK_FUNCTION(1, "GBE0_RXDV"),
		MTK_FUNCTION(2, "GBE1_RXDV"),
		MTK_FUNCTION(3, "GBE0_AUX_PPS3")
	),
	MTK_PIN(
		267, "GPIO267",
		MTK_EINT_FUNCTION(0, 267),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO267"),
		MTK_FUNCTION(1, "GBE0_TXD2"),
		MTK_FUNCTION(2, "GBE1_TXD2"),
		MTK_FUNCTION(3, "GBE0_RXER"),
		MTK_FUNCTION(4, "GBE1_RXER")
	),
	MTK_PIN(
		268, "GPIO268",
		MTK_EINT_FUNCTION(0, 268),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO268"),
		MTK_FUNCTION(1, "GBE0_TXD3"),
		MTK_FUNCTION(2, "GBE1_TXD3")
	),
	MTK_PIN(
		269, "GPIO269",
		MTK_EINT_FUNCTION(0, 269),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO269"),
		MTK_FUNCTION(1, "GBE0_RXD2"),
		MTK_FUNCTION(2, "GBE1_RXD2"),
		MTK_FUNCTION(3, "GBE0_MDC")
	),
	MTK_PIN(
		270, "GPIO270",
		MTK_EINT_FUNCTION(0, 270),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO270"),
		MTK_FUNCTION(1, "GBE0_RXD3"),
		MTK_FUNCTION(2, "GBE1_RXD3"),
		MTK_FUNCTION(3, "GBE0_MDIO")
	),
	MTK_PIN(
		271, "veint271",
		MTK_EINT_FUNCTION(0, 271),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		272, "veint272",
		MTK_EINT_FUNCTION(0, 272),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		273, "veint273",
		MTK_EINT_FUNCTION(0, 273),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		274, "veint274",
		MTK_EINT_FUNCTION(0, 274),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		275, "veint275",
		MTK_EINT_FUNCTION(0, 275),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		276, "veint276",
		MTK_EINT_FUNCTION(0, 276),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		277, "veint277",
		MTK_EINT_FUNCTION(0, 277),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		278, "veint278",
		MTK_EINT_FUNCTION(0, 278),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		279, "veint279",
		MTK_EINT_FUNCTION(0, 279),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		280, "veint280",
		MTK_EINT_FUNCTION(0, 280),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		281, "veint281",
		MTK_EINT_FUNCTION(0, 281),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		282, "veint282",
		MTK_EINT_FUNCTION(0, 282),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		283, "veint283",
		MTK_EINT_FUNCTION(0, 283),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		284, "veint284",
		MTK_EINT_FUNCTION(0, 284),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		285, "veint285",
		MTK_EINT_FUNCTION(0, 285),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		286, "veint286",
		MTK_EINT_FUNCTION(0, 286),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		287, "veint287",
		MTK_EINT_FUNCTION(0, 287),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		288, "veint288",
		MTK_EINT_FUNCTION(0, 288),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		289, "veint289",
		MTK_EINT_FUNCTION(0, 289),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		290, "veint290",
		MTK_EINT_FUNCTION(0, 290),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		291, "veint291",
		MTK_EINT_FUNCTION(0, 291),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN(
		292, "veint292",
		MTK_EINT_FUNCTION(0, 292),
		DRV_GRP4,
		MTK_FUNCTION(0, NULL)
	)
};

static struct mtk_eint_pin eint_pins_mt8196[] = {
	MTK_EINT_PIN(0, 2, 0, 1),
	MTK_EINT_PIN(1, 2, 1, 1),
	MTK_EINT_PIN(2, 2, 16, 0),
	MTK_EINT_PIN(3, 2, 17, 0),
	MTK_EINT_PIN(4, 2, 2, 1),
	MTK_EINT_PIN(5, 2, 3, 1),
	MTK_EINT_PIN(6, 2, 4, 1),
	MTK_EINT_PIN(7, 2, 5, 1),
	MTK_EINT_PIN(8, 2, 6, 1),
	MTK_EINT_PIN(9, 2, 18, 0),
	MTK_EINT_PIN(10, 2, 7, 1),
	MTK_EINT_PIN(11, 2, 8, 1),
	MTK_EINT_PIN(12, 2, 9, 1),
	MTK_EINT_PIN(13, 1, 4, 0),
	MTK_EINT_PIN(14, 0, 0, 1),
	MTK_EINT_PIN(15, 1, 5, 0),
	MTK_EINT_PIN(16, 1, 6, 0),
	MTK_EINT_PIN(17, 1, 7, 0),
	MTK_EINT_PIN(18, 1, 8, 0),
	MTK_EINT_PIN(19, 1, 9, 0),
	MTK_EINT_PIN(20, 0, 1, 1),
	MTK_EINT_PIN(21, 0, 10, 0),
	MTK_EINT_PIN(22, 0, 11, 0),
	MTK_EINT_PIN(23, 0, 12, 0),
	MTK_EINT_PIN(24, 0, 13, 0),
	MTK_EINT_PIN(25, 0, 14, 0),
	MTK_EINT_PIN(26, 0, 15, 0),
	MTK_EINT_PIN(27, 0, 2, 1),
	MTK_EINT_PIN(28, 0, 16, 0),
	MTK_EINT_PIN(29, 0, 17, 0),
	MTK_EINT_PIN(30, 0, 18, 0),
	MTK_EINT_PIN(31, 0, 3, 1),
	MTK_EINT_PIN(32, 0, 19, 0),
	MTK_EINT_PIN(33, 0, 20, 0),
	MTK_EINT_PIN(34, 0, 21, 0),
	MTK_EINT_PIN(35, 0, 22, 0),
	MTK_EINT_PIN(36, 0, 23, 0),
	MTK_EINT_PIN(37, 0, 24, 0),
	MTK_EINT_PIN(38, 0, 25, 0),
	MTK_EINT_PIN(39, 2, 10, 1),
	MTK_EINT_PIN(40, 2, 11, 1),
	MTK_EINT_PIN(41, 2, 12, 1),
	MTK_EINT_PIN(42, 2, 13, 1),
	MTK_EINT_PIN(43, 2, 14, 1),
	MTK_EINT_PIN(44, 2, 19, 0),
	MTK_EINT_PIN(45, 2, 20, 0),
	MTK_EINT_PIN(46, 2, 21, 0),
	MTK_EINT_PIN(47, 2, 22, 0),
	MTK_EINT_PIN(48, 2, 23, 0),
	MTK_EINT_PIN(49, 2, 24, 0),
	MTK_EINT_PIN(50, 2, 25, 0),
	MTK_EINT_PIN(51, 2, 26, 0),
	MTK_EINT_PIN(52, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(53, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(54, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(55, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(56, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(57, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(58, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(59, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(60, 2, 27, 0),
	MTK_EINT_PIN(61, 2, 28, 0),
	MTK_EINT_PIN(62, 2, 29, 0),
	MTK_EINT_PIN(63, 2, 30, 0),
	MTK_EINT_PIN(64, 2, 31, 0),
	MTK_EINT_PIN(65, 2, 32, 0),
	MTK_EINT_PIN(66, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(67, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(68, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(69, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(70, 2, 33, 0),
	MTK_EINT_PIN(71, 2, 34, 0),
	MTK_EINT_PIN(72, 2, 35, 0),
	MTK_EINT_PIN(73, 2, 36, 0),
	MTK_EINT_PIN(74, 2, 37, 0),
	MTK_EINT_PIN(75, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(76, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(77, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(78, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(79, 2, 38, 0),
	MTK_EINT_PIN(80, 2, 39, 0),
	MTK_EINT_PIN(81, 2, 40, 0),
	MTK_EINT_PIN(82, 2, 41, 0),
	MTK_EINT_PIN(83, 2, 42, 0),
	MTK_EINT_PIN(84, 2, 43, 0),
	MTK_EINT_PIN(85, 2, 44, 0),
	MTK_EINT_PIN(86, 2, 45, 0),
	MTK_EINT_PIN(87, 2, 46, 0),
	MTK_EINT_PIN(88, 2, 47, 0),
	MTK_EINT_PIN(89, 2, 48, 0),
	MTK_EINT_PIN(90, 2, 49, 0),
	MTK_EINT_PIN(91, 2, 50, 0),
	MTK_EINT_PIN(92, 2, 15, 1),
	MTK_EINT_PIN(93, 2, 51, 0),
	MTK_EINT_PIN(94, 2, 52, 0),
	MTK_EINT_PIN(95, 2, 53, 0),
	MTK_EINT_PIN(96, 2, 54, 0),
	MTK_EINT_PIN(97, 2, 55, 0),
	MTK_EINT_PIN(98, 2, 56, 0),
	MTK_EINT_PIN(99, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(100, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(101, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(102, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(103, 2, 57, 0),
	MTK_EINT_PIN(104, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(105, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(106, 1, 10, 0),
	MTK_EINT_PIN(107, 1, 11, 0),
	MTK_EINT_PIN(108, 1, 12, 0),
	MTK_EINT_PIN(109, 1, 13, 0),
	MTK_EINT_PIN(110, 1, 0, 1),
	MTK_EINT_PIN(111, 1, 1, 1),
	MTK_EINT_PIN(112, 1, 2, 1),
	MTK_EINT_PIN(113, 1, 3, 1),
	MTK_EINT_PIN(114, 1, 14, 0),
	MTK_EINT_PIN(115, 1, 15, 0),
	MTK_EINT_PIN(116, 1, 16, 0),
	MTK_EINT_PIN(117, 1, 17, 0),
	MTK_EINT_PIN(118, 1, 18, 0),
	MTK_EINT_PIN(119, 1, 19, 0),
	MTK_EINT_PIN(120, 1, 20, 0),
	MTK_EINT_PIN(121, 1, 21, 0),
	MTK_EINT_PIN(122, 1, 22, 0),
	MTK_EINT_PIN(123, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(124, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(125, 1, 23, 0),
	MTK_EINT_PIN(126, 1, 24, 0),
	MTK_EINT_PIN(127, 1, 25, 0),
	MTK_EINT_PIN(128, 1, 26, 0),
	MTK_EINT_PIN(129, 1, 27, 0),
	MTK_EINT_PIN(130, 1, 28, 0),
	MTK_EINT_PIN(131, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(132, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(133, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(134, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(135, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(136, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(137, 0, 26, 0),
	MTK_EINT_PIN(138, 0, 27, 0),
	MTK_EINT_PIN(139, 0, 28, 0),
	MTK_EINT_PIN(140, 0, 29, 0),
	MTK_EINT_PIN(141, 0, 30, 0),
	MTK_EINT_PIN(142, 0, 31, 0),
	MTK_EINT_PIN(143, 0, 32, 0),
	MTK_EINT_PIN(144, 0, 33, 0),
	MTK_EINT_PIN(145, 0, 34, 0),
	MTK_EINT_PIN(146, 0, 35, 0),
	MTK_EINT_PIN(147, 0, 36, 0),
	MTK_EINT_PIN(148, 0, 4, 1),
	MTK_EINT_PIN(149, 0, 37, 0),
	MTK_EINT_PIN(150, 0, 5, 1),
	MTK_EINT_PIN(151, 0, 38, 0),
	MTK_EINT_PIN(152, 0, 39, 0),
	MTK_EINT_PIN(153, 0, 40, 0),
	MTK_EINT_PIN(154, 0, 41, 0),
	MTK_EINT_PIN(155, 0, 42, 0),
	MTK_EINT_PIN(156, 0, 43, 0),
	MTK_EINT_PIN(157, 0, 44, 0),
	MTK_EINT_PIN(158, 0, 45, 0),
	MTK_EINT_PIN(159, 0, 46, 0),
	MTK_EINT_PIN(160, 0, 47, 0),
	MTK_EINT_PIN(161, 0, 48, 0),
	MTK_EINT_PIN(162, 0, 49, 0),
	MTK_EINT_PIN(163, 0, 50, 0),
	MTK_EINT_PIN(164, 0, 51, 0),
	MTK_EINT_PIN(165, 0, 52, 0),
	MTK_EINT_PIN(166, 0, 53, 0),
	MTK_EINT_PIN(167, 0, 54, 0),
	MTK_EINT_PIN(168, 0, 55, 0),
	MTK_EINT_PIN(169, 0, 56, 0),
	MTK_EINT_PIN(170, 0, 57, 0),
	MTK_EINT_PIN(171, 0, 58, 0),
	MTK_EINT_PIN(172, 0, 6, 1),
	MTK_EINT_PIN(173, 0, 7, 1),
	MTK_EINT_PIN(174, 0, 8, 1),
	MTK_EINT_PIN(175, 0, 9, 1),
	MTK_EINT_PIN(176, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(177, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(178, 0, 59, 0),
	MTK_EINT_PIN(179, 0, 60, 0),
	MTK_EINT_PIN(180, 0, 61, 0),
	MTK_EINT_PIN(181, 0, 62, 0),
	MTK_EINT_PIN(182, 0, 63, 0),
	MTK_EINT_PIN(183, 0, 64, 0),
	MTK_EINT_PIN(184, 0, 65, 0),
	MTK_EINT_PIN(185, 0, 66, 0),
	MTK_EINT_PIN(186, 3, 6, 0),
	MTK_EINT_PIN(187, 3, 7, 0),
	MTK_EINT_PIN(188, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(189, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(190, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(191, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(192, 3, 8, 0),
	MTK_EINT_PIN(193, 3, 9, 0),
	MTK_EINT_PIN(194, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(195, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(196, 3, 10, 0),
	MTK_EINT_PIN(197, 3, 11, 0),
	MTK_EINT_PIN(198, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(199, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(200, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(201, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(202, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(203, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(204, 3, 12, 0),
	MTK_EINT_PIN(205, 3, 13, 0),
	MTK_EINT_PIN(206, 3, 14, 0),
	MTK_EINT_PIN(207, 3, 0, 1),
	MTK_EINT_PIN(208, 3, 1, 1),
	MTK_EINT_PIN(209, 3, 2, 1),
	MTK_EINT_PIN(210, 3, 15, 0),
	MTK_EINT_PIN(211, 3, 3, 1),
	MTK_EINT_PIN(212, 3, 4, 1),
	MTK_EINT_PIN(213, 3, 5, 1),
	MTK_EINT_PIN(214, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(215, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(216, 3, 16, 0),
	MTK_EINT_PIN(217, 3, 17, 0),
	MTK_EINT_PIN(218, 3, 18, 0),
	MTK_EINT_PIN(219, 3, 19, 0),
	MTK_EINT_PIN(220, 3, 20, 0),
	MTK_EINT_PIN(221, 3, 21, 0),
	MTK_EINT_PIN(222, 3, 22, 0),
	MTK_EINT_PIN(223, 3, 23, 0),
	MTK_EINT_PIN(224, 3, 24, 0),
	MTK_EINT_PIN(225, 3, 25, 0),
	MTK_EINT_PIN(226, 3, 26, 0),
	MTK_EINT_PIN(227, 3, 27, 0),
	MTK_EINT_PIN(228, 3, 28, 0),
	MTK_EINT_PIN(229, 3, 29, 0),
	MTK_EINT_PIN(230, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(231, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(232, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(233, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(234, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(235, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(236, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(237, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(238, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(239, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(240, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(241, 3, 30, 0),
	MTK_EINT_PIN(242, 3, 31, 0),
	MTK_EINT_PIN(243, 3, 32, 0),
	MTK_EINT_PIN(244, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(245, 3, 45, 0),
	MTK_EINT_PIN(246, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(247, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(248, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(249, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(250, EINT_INVALID_BASE, 0, 0),
	MTK_EINT_PIN(251, 0, 67, 0),
	MTK_EINT_PIN(252, 0, 68, 0),
	MTK_EINT_PIN(253, 0, 69, 0),
	MTK_EINT_PIN(254, 0, 70, 0),
	MTK_EINT_PIN(255, 0, 71, 0),
	MTK_EINT_PIN(256, 0, 72, 0),
	MTK_EINT_PIN(257, 0, 73, 0),
	MTK_EINT_PIN(258, 0, 74, 0),
	MTK_EINT_PIN(259, 3, 33, 0),
	MTK_EINT_PIN(260, 3, 34, 0),
	MTK_EINT_PIN(261, 3, 35, 0),
	MTK_EINT_PIN(262, 3, 36, 0),
	MTK_EINT_PIN(263, 3, 37, 0),
	MTK_EINT_PIN(264, 3, 38, 0),
	MTK_EINT_PIN(265, 3, 39, 0),
	MTK_EINT_PIN(266, 3, 40, 0),
	MTK_EINT_PIN(267, 3, 41, 0),
	MTK_EINT_PIN(268, 3, 42, 0),
	MTK_EINT_PIN(269, 3, 43, 0),
	MTK_EINT_PIN(270, 3, 44, 0),
	MTK_EINT_PIN(271, 4, 0, 0),
	MTK_EINT_PIN(272, 4, 1, 0),
	MTK_EINT_PIN(273, 4, 2, 0),
	MTK_EINT_PIN(274, 4, 3, 0),
	MTK_EINT_PIN(275, 4, 4, 0),
	MTK_EINT_PIN(276, 4, 5, 0),
	MTK_EINT_PIN(277, 4, 6, 0),
	MTK_EINT_PIN(278, 4, 7, 0),
	MTK_EINT_PIN(279, 4, 8, 0),
	MTK_EINT_PIN(280, 4, 9, 0),
	MTK_EINT_PIN(281, 4, 10, 0),
	MTK_EINT_PIN(282, 4, 11, 0),
	MTK_EINT_PIN(283, 4, 12, 0),
	MTK_EINT_PIN(284, 4, 13, 0),
	MTK_EINT_PIN(285, 4, 14, 0),
	MTK_EINT_PIN(286, 4, 15, 0),
	MTK_EINT_PIN(287, 4, 16, 0),
	MTK_EINT_PIN(288, 4, 17, 0),
	MTK_EINT_PIN(289, 4, 18, 0),
	MTK_EINT_PIN(290, 4, 19, 0),
	MTK_EINT_PIN(291, 4, 20, 0),
	MTK_EINT_PIN(292, 4, 21, 0),
};
#endif /* __PINCTRL_MTK_MT8196_H */
