/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import org.cojen.classfile.Location;
import org.cojen.classfile.LocationRange;

public class LocationRangeImpl
implements LocationRange {
    private final Location mStart;
    private final Location mEnd;

    public LocationRangeImpl(Location a, Location b) {
        if (a.compareTo(b) <= 0) {
            this.mStart = a;
            this.mEnd = b;
        } else {
            this.mStart = b;
            this.mEnd = a;
        }
    }

    public LocationRangeImpl(LocationRange a, LocationRange b) {
        this.mStart = a.getStartLocation().compareTo(b.getStartLocation()) <= 0 ? a.getStartLocation() : b.getStartLocation();
        this.mEnd = b.getEndLocation().compareTo(a.getEndLocation()) >= 0 ? b.getEndLocation() : a.getEndLocation();
    }

    public Location getStartLocation() {
        return this.mStart;
    }

    public Location getEndLocation() {
        return this.mEnd;
    }

    public int hashCode() {
        return this.getStartLocation().hashCode() * 31 + this.getEndLocation().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LocationRangeImpl) {
            LocationRangeImpl other = (LocationRangeImpl)obj;
            return this.getStartLocation() == other.getStartLocation() && this.getEndLocation() == other.getEndLocation();
        }
        return false;
    }

    public String toString() {
        int end;
        int start = this.getStartLocation().getLocation();
        if (start == (end = this.getEndLocation().getLocation() - 1)) {
            return String.valueOf(start);
        }
        return start + ".." + end;
    }
}

