/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.instrumentor;

import alt.jiapi.Runtime;
import alt.jiapi.instrumentor.AbstractInstrumentor;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.reflect.instruction.FieldAccess;
import alt.jiapi.reflect.instruction.Invocation;
import alt.jiapi.reflect.instruction.OpcodeGroups;
import alt.jiapi.reflect.instruction.ReferencingInstruction;
import org.apache.log4j.Category;

public class ChangeReferenceInstrumentor
extends AbstractInstrumentor {
    private static Category log = Runtime.getLogCategory(ChangeReferenceInstrumentor.class);
    private String replacement;
    private int mode;
    private byte[] bytesToScan;
    private String patternString;
    public static final int CHANGE_FIELD_REFERENCES = 1;
    public static final int CHANGE_METHODCALL_REFERENCES = 2;
    public static final int CHANGE_ALL = 3;

    public ChangeReferenceInstrumentor(String pattern, String replacement) {
        this(3, pattern, replacement);
    }

    public ChangeReferenceInstrumentor(int mode, String pattern, String replacement) {
        this.mode = mode;
        this.patternString = pattern;
        this.replacement = replacement;
        int length = 0;
        if ((mode & 1) == 1) {
            length = OpcodeGroups.FIELD_ACCESS_INSTRUCTIONS.length;
        }
        if ((mode & 2) == 2) {
            length += OpcodeGroups.INVOKE_INSTRUCTIONS.length;
        }
        this.bytesToScan = new byte[length];
        int targetPosition = 0;
        if ((mode & 1) == 1) {
            System.arraycopy(OpcodeGroups.FIELD_ACCESS_INSTRUCTIONS, 0, this.bytesToScan, targetPosition, OpcodeGroups.FIELD_ACCESS_INSTRUCTIONS.length);
            targetPosition = OpcodeGroups.FIELD_ACCESS_INSTRUCTIONS.length;
        }
        if ((mode & 2) == 2) {
            System.arraycopy(OpcodeGroups.INVOKE_INSTRUCTIONS, 0, this.bytesToScan, targetPosition, OpcodeGroups.INVOKE_INSTRUCTIONS.length);
        }
        log.info((Object)("Pattern is " + pattern + ", replacement is " + replacement));
    }

    public void instrument(InstructionList il) {
        int index = 0;
        String __replacement = null;
        __replacement = this.replacement == null ? this.getCurrentClass().getName() : this.replacement;
        while ((index = il.indexOf(this.bytesToScan, index)) != -1) {
            ReferencingInstruction i = (ReferencingInstruction)il.get(index);
            if ((this.mode & 1) == 1 && i instanceof FieldAccess) {
                this.changeReference(i, __replacement);
            } else if ((this.mode & 2) == 2 && i instanceof Invocation) {
                this.changeReference(i, __replacement);
            }
            ++index;
        }
        this.forward(il);
    }

    private void changeReference(ReferencingInstruction i, String __replacement) {
        String referencedType = i.getReferencedTypeName();
        throw new RuntimeException("NOT IMPLEMENTED");
    }
}

