/* ssl/ssl_enc.c */
/* Copyright (C) 1995-1997 Eric Young (eay@mincom.oz.au)
 * All rights reserved.
 *
 * This package is an SSL implementation written
 * by Eric Young (eay@mincom.oz.au).
 * The implementation was written so as to conform with Netscapes SSL.
 * 
 * This library is free for commercial and non-commercial use as long as
 * the following conditions are aheared to.  The following conditions
 * apply to all code found in this distribution, be it the RC4, RSA,
 * lhash, DES, etc., code; not just the SSL code.  The SSL documentation
 * included with this distribution is covered by the same copyright terms
 * except that the holder is Tim Hudson (tjh@mincom.oz.au).
 * 
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * If this package is used in a product, Eric Young should be given attribution
 * as the author of the parts of the library used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    "This product includes cryptographic software written by
 *     Eric Young (eay@mincom.oz.au)"
 *    The word 'cryptographic' can be left out if the rouines from the library
 *    being used are not cryptographic related :-).
 * 4. If you include any Windows specific code (or a derivative thereof) from 
 *    the apps directory (application code) you must include an acknowledgement:
 *    "This product includes software written by Tim Hudson (tjh@mincom.oz.au)"
 * 
 * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.  i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 */

#include <stdio.h>
#include "ssl_locl.h"

#define RS	0
#define WS	1

int ssl_enc_init(s, client)
SSL *s;
int client;
	{
	/* Max number of bytes needed */
	EVP_CIPHER_CTX *rs,*ws,*dd;
	EVP_CIPHER *cm;
	int num;

	cm=s->session->cipher->crypt();
	if (s->crypt_state == NULL)
		{
		s->crypt_state=(char *)Malloc(sizeof(EVP_CIPHER_CTX)*2);
		if (s->crypt_state == NULL) goto err;
		}

	dd=(EVP_CIPHER_CTX *)s->crypt_state;
	rs= &(dd[RS]);
	ws= &(dd[WS]);

	if (s->key_material != NULL)
		{
		memset(s->key_material,0,s->key_material_length);
		Free(s->key_material);
		}

	num=cm->key_len;
	s->key_material=(unsigned char *)Malloc(num*2);
	if (s->key_material == NULL) goto err;
	s->key_material_length=num*2;

	ssl_generate_key_material(s);

	if (client)
		{
		EVP_DecryptInit(rs,cm,&(s->key_material[  0]),
			s->session->key_arg);
		EVP_EncryptInit(ws,cm,&(s->key_material[num]),
			s->session->key_arg);
		s->read_key=  &(s->key_material[0]);
		s->write_key= &(s->key_material[num]);
		}
	else
		{
		EVP_EncryptInit(ws,cm,&(s->key_material[  0]),
			s->session->key_arg);
		EVP_DecryptInit(rs,cm,&(s->key_material[num]),
			s->session->key_arg);
		s->write_key= &(s->key_material[0]);
		s->read_key=  &(s->key_material[num]);
		}
	return(1);
err:
	SSLerr(SSL_F_SSL_ENC_INIT,ERR_R_MALLOC_FAILURE);
	return(0);
	}

/* read/writes from s->mac_data using length for encrypt and 
 * decrypt.  It sets the s->padding, s->[rw]length and s->pad_data ptr if we
 * are encrypting */
void ssl_enc(s)
SSL *s;
	{
	EVP_CIPHER_CTX *ds;
	unsigned long l;
	int bs;

	ds=(EVP_CIPHER_CTX *)s->crypt_state;

	/* check for NULL cipher */
	if (ds == NULL) return;

	if (s->s2.send)
		{
		ds= &(ds[WS]);
		l=s->wlength;
		}
	else
		{
		ds= &(ds[RS]);
		l=s->rlength;
		}

	bs=ds->cipher->block_size;
	/* This should be using (bs-1) and bs instead of 7 and 8, but
	 * what the hell. */
	if (bs == 8)
		l=(l+7)/8*8;

	EVP_Cipher(ds,s->mac_data,s->mac_data,l);
	}
