/* driver.c - driver program for point-repulsion simulation
 *
 * $Id: driver.c,v 1.2 96/02/11 21:37:18 leech Exp $
 *
 * Copyright (C) 1996, Jonathan P. Leech
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is". Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Log:	driver.c,v $
 * Revision 1.2  96/02/11  21:37:18  leech
 * Remove old g++ workarounds.
 * 
 * Revision 1.1  92/04/27  04:25:12  leech
 * Initial revision
 *
 */

#include "Interface.h"
#include "dvector.h"

#include <stdlib.h>
#include <string.h>
#include <stream.h>
#include <math.h>

// Error handler for Vector library
void bad_dvec(int code, const char *msg) {
    cerr << "dvector: error " << code << ": "
	 << msg << endl;
}

// Breakpoint for debugger
void stophere() {
}

// Error handler for math library; atan2(0,0) is not considered an error.
extern "C" int matherr(struct exception *exc) {
    switch (exc->type) {
	case DOMAIN:
	    if (!strcmp(exc->name, "atan2"))
		return 1;
	    else {
		stophere();
		return 0;
	    }
	    break;
	case TLOSS:
	    stophere();
	    return 0;
	default:
	    return 0;
    }
}

int main(int ac, char** av)
{
    // Allow breaking on normalization problems, etc.
    dvector::setErrorHandler(&bad_dvec);

    Interface *interface = Interface::MakeInterface(ac, av);

    // Run simulation until stopping criteria satisfied
    interface->Run();

    // Write save file and termination condition
    long iterations;
    TerminationCause why;
    interface->Cleanup(iterations, why);

    cerr << iterations;
    switch (why) {
	case kConverged:
	    cerr << "\t# (converged)\n";
	    break;
	case kStopped:
	    cerr << "\t# (stopped)\n";
	    break;
	case kQuit:
	    cerr << "\t# (quit)\n";
	    break;
    }

    return 0;
}
