* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* **          MATHEMATICAL ANALYSIS BY JOHN SNYDER                    **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
*                        *  EQUIDISTANT CONIC  *
* **********************************************************************
*
      SUBROUTINE PJ08Z0
*
      IMPLICIT REAL*8 (A-Z)
      INTEGER*4 SWITCH,IND,I,ZONE,IPFILE,IFLG
      CHARACTER*16 ANGS(4)
      COMMON /ELLPZ0/ AZ,EZ,ESZ,E0Z,E1Z,E2Z,E3Z,E4Z
* PARAMETERS ** A,E,ES,LAT1,LAT2,LON0,LAT0,X0,Y0,E0,E1,E2,E3,NS,GL,RH0 *
      DIMENSION DATA(1),GEOG(1),PROJ(1)
      DATA ZERO,ONE /0.0D0,1.0D0/
      DATA EPSLN /1.0D-10/
      DATA SWITCH /0/
*
* ......................................................................
*      .  INITIALIZATION OF PROJECTION PARAMETERS (ENTRY INPUT)  .
* ......................................................................
*
      ENTRY IS08Z0 (ZONE,DATA,IPFILE,IFLG)
*
      IFLG = 0
      IF (SWITCH.NE.0 .AND. SWITCH.EQ.ZONE) RETURN
      IF (DATA(1) .LE. ZERO) GO TO 100
      A = DATA(1)
      B = DATA(2)
      IF (B .GT. ZERO) GO TO 040
      E = ZERO
      ES = ZERO
      E0 = ONE
      E1 = ZERO
      E2 = ZERO
      E3 = ZERO
      GO TO 120
  040 IF (B .GT. ONE) GO TO 060
      E = DSQRT (B)
      ES = B
      GO TO 080
  060 ES = ONE - (B / A) ** 2
      E = DSQRT (ES)
  080 E0 = E0FNZ0 (ES)
      E1 = E1FNZ0 (ES)
      E2 = E2FNZ0 (ES)
      E3 = E3FNZ0 (ES)
      GO TO 120
  100 A = AZ
      E = EZ
      ES = ESZ
      E0 = E0Z
      E1 = E1Z
      E2 = E2Z
      E3 = E3Z
  120 CALL UNITZ0 (DATA(3),5,LAT1,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      CALL UNITZ0 (DATA(4),5,LAT2,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      IF (DABS(LAT1+LAT2) .GE. EPSLN) GO TO 130
      IF (IPFILE .NE. 0) WRITE (IPFILE,2000)
 2000 FORMAT (' EQUAL LATITUDES FOR ST. PARALLELS ON OPPOSITE',
     .        ' SIDES OF EQUATOR')
      IFLG = 801
      RETURN
  130 CALL UNITZ0 (DATA(5),5,LON0,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      CALL UNITZ0 (DATA(6),5,LAT0,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      X0 = DATA(7)
      Y0 = DATA(8)
      SINPHI = DSIN (LAT1)
      COSPHI = DCOS (LAT1)
      MS1 = MSFNZ0 (E,SINPHI,COSPHI)
      ML1 = MLFNZ0 (E0,E1,E2,E3,LAT1)
      IND = 0
      IF (DATA(9) .NE. ZERO) GO TO 140
      NS = SINPHI
      GO TO 160
  140 IND = 1
      SINPHI = DSIN (LAT2)
      COSPHI = DCOS (LAT2)
      MS2 = MSFNZ0 (E,SINPHI,COSPHI)
      ML2 = MLFNZ0 (E0,E1,E2,E3,LAT2)
      IF (DABS(LAT1-LAT2) .GE. EPSLN) GO TO 150
      NS = SINPHI
      GO TO 160
  150 NS = (MS1 - MS2) / (ML2 - ML1)
  160 GL = ML1 + MS1 / NS
      ML0 = MLFNZ0 (E0,E1,E2,E3,LAT0)
      RH0 = A * (GL - ML0)
*
* LIST RESULTS OF PARAMETER INITIALIZATION.
*
      CALL DMSLZ0 (LAT1,0,ANGS(1),IPFILE,IFLG)
      CALL DMSLZ0 (LAT2,0,ANGS(2),IPFILE,IFLG)
      CALL DMSLZ0 (LON0,0,ANGS(3),IPFILE,IFLG)
      CALL DMSLZ0 (LAT0,0,ANGS(4),IPFILE,IFLG)
      IF (IND .EQ. 0) GO TO 200
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010) A,ES,ANGS,X0,Y0
 2010 FORMAT (' INITIALIZATION PARAMETERS (EQUIDISTANT CONIC',
     .        ' PROJECTION)'/
     .        ' SEMI-MAJOR AXIS OF ELLIPSOID =',F16.4,' METERS'/
     .        ' ECCENTRICITY SQUARED         =',F16.13/
     .        ' LATITUDE OF 1ST ST. PARALLEL =',A16/
     .        ' LATITUDE OF 2ND ST. PARALLEL =',A16/
     .        ' LONGITUDE OF ORIGIN          =',A16/
     .        ' LATITUDE OF ORIGIN           =',A16/
     .        ' FALSE EASTING                =',F16.4,' METERS'/
     .        ' FALSE NORTHING               =',F16.4,' METERS')
      GO TO 220
  200 IF (IPFILE .NE. 0) WRITE (IPFILE,2020) A,ES,ANGS(1),ANGS(3),
     .                                       ANGS(4),X0,Y0
 2020 FORMAT (' INITIALIZATION PARAMETERS (EQUIDISTANT CONIC',
     .        ' PROJECTION)'/
     .        ' SEMI-MAJOR AXIS OF ELLIPSOID =',F16.4,' METERS'/
     .        ' ECCENTRICITY SQUARED         =',F16.13/
     .        ' LATITUDE OF ST. PARALLEL     =',A16/
     .        ' LONGITUDE OF ORIGIN          =',A16/
     .        ' LATITUDE OF ORIGIN           =',A16/
     .        ' FALSE EASTING                =',F16.4,' METERS'/
     .        ' FALSE NORTHING               =',F16.4,' METERS')
  220 SWITCH = ZONE
      RETURN
*
* ......................................................................
*                      .  FORWARD TRANSFORMATION  .
* ......................................................................
*
      ENTRY PF08Z0 (GEOG,PROJ,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 300
      IF (IPFILE .NE. 0) WRITE (IPFILE,2030)
 2030 FORMAT (' UNINITIALIZED TRANSFORMATION')
      IFLG = 800
      RETURN
  300 ML = MLFNZ0 (E0,E1,E2,E3,GEOG(2))
      RH = A * (GL - ML)
      THETA = NS * ADJLZ0 (GEOG(1) - LON0)
      PROJ(1) = X0 + RH * DSIN (THETA)
      PROJ(2) = Y0 + RH0 - RH * DCOS (THETA)
      RETURN
*
* ......................................................................
*                      .  INVERSE TRANSFORMATION  .
* ......................................................................
*
      ENTRY PI08Z0 (PROJ,GEOG,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 320
      IF (IPFILE .NE. 0) WRITE (IPFILE,2030)
      IFLG = 800
      RETURN
  320 X = PROJ(1) - X0
      Y = RH0 - PROJ(2) + Y0
      RH = DSIGN (DSQRT (X * X + Y * Y) , NS)
      THETA = ZERO
      CON = DSIGN (ONE , NS)
      IF (RH .NE. ZERO) THETA = DATAN2 (CON * X , CON * Y)
      ML = GL - RH / A
      GEOG(2) = PHI3Z0 (ML,E0,E1,E2,E3,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      GEOG(1) = ADJLZ0 (LON0 + THETA / NS)
      RETURN
*
      END
