* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
*                              *  U T M  *
* **********************************************************************
*
      SUBROUTINE PJ01Z0
*
      IMPLICIT REAL*8 (A-Z)
      INTEGER*4 SWITCH,IND,ZONE,IPFILE,IFLG
      DIMENSION DATA(1),GEOG(1),PROJ(1)
      DIMENSION BUFFL(8)
      DATA ZERO /0.0D0/
      DATA SWITCH /0/
*
* ......................................................................
*      .  INITIALIZATION OF PROJECTION PARAMETERS (ENTRY INPUT)  .
* ......................................................................
*
      ENTRY IS01Z0 (ZONE,DATA,IPFILE,IFLG)
*
      IFLG = 0
      IF (SWITCH.NE.0 .AND. SWITCH.EQ.ZONE) RETURN
      IF (ZONE .EQ. ZERO) GO TO 040
      IF (ZONE.GE.1 .AND. ZONE.LE.60) GO TO 100
      IF (IPFILE .NE. 0) WRITE (IPFILE,2000) ZONE
 2000 FORMAT (' ILLEGAL ZONE NO = ',I6)
      IFLG = 101
      RETURN
  040 CALL UNITZ0 (DATA(3),5,CON,4,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      ZONE = CON / 6.0D0
      IND = 1
      IF (ZONE .LT. 0) IND = 0
      ZONE = MOD ((ZONE + 30) , 60) + IND
      IF (ZONE) 060,080,100
  060 ZONE = ZONE + 60
      GO TO 100
  080 ZONE = 1
  100 BUFFL(1) = DATA(1)
      BUFFL(2) = DATA(2)
      BUFFL(3) = 0.9996D0
      BUFFL(4) = ZERO
      LON0 = 6 * ZONE - 183
      CALL UNITZ0 (LON0,4,BUFFL(5),5,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      BUFFL(6) = ZERO
      BUFFL(7) = 500000.0D0
      BUFFL(8) = ZERO
      IF (DATA(4) .LT. ZERO) BUFFL(8) = 10000000.0D0
      SWITCH = 0
      CALL IS09Z0 (ZONE,BUFFL,IPFILE,IFLG)
      IF (IFLG .NE. 0) GO TO 110
*
* LIST RESULTS OF PARAMETER INITIALIZATION.
*
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010) ZONE
 2010 FORMAT (' INITIALIZATION PARAMETERS (U T M PROJECTION)'/
     .        ' ZONE = ',I2)
      SWITCH = ZONE
  110 RETURN
*
* ......................................................................
*                      .  FORWARD TRANSFORMATION  .
* ......................................................................
*
      ENTRY PF01Z0 (GEOG,PROJ,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 140
      IF (IPFILE .NE. 0) WRITE (IPFILE,2020)
 2020 FORMAT (' UNINITIALIZED TRANSFORMATION')
      IFLG = 100
      RETURN
  140 CALL PF09Z0 (GEOG,PROJ,IFLG)
      RETURN
*
* ......................................................................
*                      .  INVERSE TRANSFORMATION  .
* ......................................................................
*
      ENTRY PI01Z0 (PROJ,GEOG,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 160
      IF (IPFILE .NE. 0) WRITE (IPFILE,2020)
      IFLG = 100
      RETURN
  160 CALL PI09Z0 (PROJ,GEOG,IFLG)
      RETURN
*
      END
