/* SCCS @(#)selectplaneO.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       selectplaneO.layout.c                          */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   selectplaneO.layout.c                               */
/*                                                                      */
/* DESCRIPTION  :   1 Output plane                                      */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "selectplaneO.layout.h"
#include "widgetstructure.h"

#define MAX_ARGS 100

extern XmFontList gFontlist;
extern Pixel      gorchid, gthistle;

/********************************************************
/   Creation Function for SelectionPlaneout 
/*******************************************************/

Widget
build_SelectionPlaneout(selectplaneoutput, IO_load_image_planeout_OK, message, vector)
	Widget selectplaneoutput;
	Widget IO_load_image_planeout_OK;
        char   *message;
	int    vector;
{
	Widget SelectionPlaneout;
	Widget SelectPlaneout0;
	Widget SelectPlaneout1;
	Arg args[MAX_ARGS];
	int n;

	/* Creating SelectionPlaneout Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx,1); n++;

	SelectionPlaneout = 
		XmCreateRowColumn(selectplaneoutput,"SelectionPlaneout",args,n);

	XtManageChild(SelectionPlaneout);

	/* Creating SelectPlaneout0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	if (vector != 1)
	     XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[100],
			XmSTRING_DEFAULT_CHARSET)); 
	else XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[101],
			XmSTRING_DEFAULT_CHARSET)); 
	n++;

	SelectPlaneout0 = XmCreateLabel(SelectionPlaneout,"SelectPlaneout0",args,n);
	XtManageChild(SelectPlaneout0);

	/* Creating SelectPlaneout1 Widget */ 

	SelectPlaneout1 = 
	  build_SelectPlaneout1(SelectionPlaneout, 
		IO_load_image_planeout_OK, message, 1, vector);

	return(SelectionPlaneout);
}


/********************************************************
/   Creation Function for SelectPlaneout1 
/*******************************************************/

Widget
build_SelectPlaneout1(SelectionPlaneout, 
			IO_load_image_planeout_OK, message, numplan, vector)
	Widget SelectionPlaneout;
	Widget IO_load_image_planeout_OK;
        char *message;
	int numplan;
	int vector;
{
	Widget SelectPlaneout1;
	Widget SelectPlaneLabelout1;
	Widget SelectPlanesout;
	Widget SelectPlaneLabel2out;
	Widget Planeoutnumbers;
	Widget Planeout[MAX_IMAGE];
	plan_image_select *Tableau_plans;
	char num[4];
	Arg args[MAX_ARGS];
	int i, n;

	/* Creating SelectPlaneout1 Widget */ 


	SelectPlaneout1 = 
		XmCreateRowColumn(SelectionPlaneout,"SelectPlaneout1",NULL,0);

	XtManageChild(SelectPlaneout1);

	/* Creating SelectPlaneLabelout1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	if (vector != 1) 
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[103],
			XmSTRING_DEFAULT_CHARSET)); 
	else
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[104],
			XmSTRING_DEFAULT_CHARSET)); 
	n++;

	SelectPlaneLabelout1 = 
		XmCreateLabel(SelectPlaneout1,"SelectPlaneLabelout1",args,n);
	XtManageChild(SelectPlaneLabelout1);

	/* Creating SelectPlanesout Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	SelectPlanesout = 
	    XmCreateRowColumn(SelectPlaneout1,"SelectPlanesout",args,n);

	XtManageChild(SelectPlanesout);

	/* Creating SelectPlaneLabel2out Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	if (vector != 1) 
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(message,
				   XmSTRING_DEFAULT_CHARSET)); 
	else
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(message,
				   XmSTRING_DEFAULT_CHARSET)); 
	n++;

	SelectPlaneLabel2out = 
		XmCreateLabel(SelectPlanesout,"SelectPlaneLabel2out",args,n);
	XtManageChild(SelectPlaneLabel2out);

	/* Creating Planeoutnumbers Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	Planeoutnumbers = 
		XmCreateForm(SelectPlanesout,"Planeoutnumbers",args,n);


	XtManageChild(Planeoutnumbers);

	/* Creating Planeout[MAX_IMAGE] Widgets */ 

	Tableau_plans = 
	    (plan_image_select *) malloc (sizeof (plan_image_select));

	if (vector != 1) {
	  for (i=0;i < MAX_IMAGE; i++){
	    itoa (i, num);	 
	    n = 0;
	    XtSetArg(args[n],XmNfontList, gFontlist); n++;
	    if (i == 0) XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
	    else
	    {
	      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);n++;
	      XtSetArg(args[n],XmNleftWidget,Planeout[i-1]);
	    }
	    n++;
	    XtSetArg(args[n],XmNwidth, 20); n++;
	    XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(num,
			XmSTRING_DEFAULT_CHARSET)); n++;
	    XtSetArg(args[n],XmNpushButtonEnabled,true); n++;
	    XtSetArg(args[n],XmNrecomputeSize,false); n++;
	    XtSetArg(args[n],XmNhighlightThickness, 0); n++;

	    /* Definition de l'occupation du plan represente par ce bouton!*/
	    if (Occupation_Plan(i) == 1){
	      XtSetArg (args[n],XmNforeground, gorchid); n++;
	    }
	    XtSetArg (args[n],XmNbackground, gthistle);n++;

	    Planeout[i] = XmCreateDrawnButton(Planeoutnumbers,"Planeout",args,n);

	    XtManageChild(Planeout[i]);
	  
	    Tableau_plans->plan_image[i] = Planeout[i];
	  }

	  Tableau_plans->num_index = numplan;

	    /* Adding Callbacks for Planeout[i] */ 

 	  for (i=0;i < MAX_IMAGE; i++)
	    XtAddCallback(Planeout[i],
		XmNactivateCallback, planeout_selected,Tableau_plans);

	}
	else {
	  for (i=0;i < MAX_VECTEUR; i++){
	    itoa (i, num);	 
	    n = 0;
	    XtSetArg(args[n],XmNfontList, gFontlist); n++;
	    if (i == 0) XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
	    else
	    {
	      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);n++;
	      XtSetArg(args[n],XmNleftWidget,Planeout[i-1]);
	    }
	    n++;
	    XtSetArg(args[n],XmNwidth, 20); n++;
	    XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(num,
			XmSTRING_DEFAULT_CHARSET)); n++;
	    XtSetArg(args[n],XmNpushButtonEnabled,true); n++;
	    XtSetArg(args[n],XmNrecomputeSize,false); n++;
	    XtSetArg(args[n],XmNhighlightThickness, 0); n++;

	    /* Definition de l'occupation du plan represente par ce bouton!*/
	    if (Occupation_Vector(i) == 1){
	      XtSetArg (args[n],XmNforeground, gorchid); n++;
	    }
	    XtSetArg (args[n],XmNbackground, gthistle);n++;

	    Planeout[i] = XmCreateDrawnButton(Planeoutnumbers,"Planeout",args,n);

	    XtManageChild(Planeout[i]);
	  
	    Tableau_plans->plan_image[i] = Planeout[i];
	  }

	  Tableau_plans->num_index = numplan;

	    /* Adding Callbacks for Planeout[i] */ 

 	  for (i=0;i < MAX_VECTEUR; i++)
	    XtAddCallback(Planeout[i],
		XmNactivateCallback, vectorout_selected,Tableau_plans);
	}

	XtAddCallback(IO_load_image_planeout_OK,XmNactivateCallback,
		      libere_memoire,Tableau_plans);

	return(SelectPlaneout1);
}
