/* SCCS @(#)LaboGel1D.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      LaboGel1D.layout.c                              */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   LaboGel1D.layout.c                                  */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Gel1D Tool)                              */
/*                                                                      */
/* AUTHORS      :   Thierry PUN, Krassimir TODOROV, Marianne Logean     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "LaboGel1D.layout.h"
#include "global.h"

#define MAX_ARGS 100

extern XmFontList gFontlist;
extern Pixel      glavender;

extern char *menutabs[];
extern char *geltooltabs[];
extern char *gel1tabs[];
extern char *gel3tabs[];
extern char *gel4tabs[];
extern char *gelcortabs[];


/********************************************************
/   Creation Function for Quit_gel1D
/*******************************************************/

Widget
build_Quit_Gel1D(labof22)
	Widget labof22;
{
	Widget Quit_gel1D;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Quit_gel1D Widget */ 

	n = 0;
	XtSetArg(args[n],XmNdialogTitle, 
		XmStringLtoRCreate(paneltabs[177],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNlabelFontList, gFontlist); n++;
	XtSetArg(args[n],XmNbuttonFontList, gFontlist); n++;
	XtSetArg(args[n],XmNmessageString,
		XmStringLtoRCreate(panel_titres[1],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNshadowThickness,2); n++;
	XtSetArg(args[n],XmNx,12); n++;
	XtSetArg(args[n],XmNy,14); n++;

	Quit_gel1D = XmCreateInformationDialog(labof22,"Quit_gel1D",args,n);

	/* Adding Callbacks for Quit_gel1D */ 

	XtAddCallback(Quit_gel1D,XmNcancelCallback,Cancel_Gel1D,NULL);
	XtAddCallback(Quit_gel1D,XmNokCallback,OKquitgel1d, NULL);

	return(Quit_gel1D);
}

/********************************************************
/   Creation Function for Frame_5 
/*******************************************************/

void
build_Menugel1D(MenuGel1D)
	Widget MenuGel1D;
{
        Widget IO_cascade;
        Widget IO_pulldown;
	Widget init_data;
	Widget read_prepro;
	Widget read_pulldown;
	Widget read_prepro_standard;
	Widget read_prepro_melanie;
	Widget save;
	Widget save_pulldown;
	Widget save_standard;
	Widget save_melanie;
	Widget show_gel;
	Widget preestimated_cascade;
	Widget preestimated_pulldown;
	Widget preestimated_calc;
	Widget preestimated_show;
	Widget preestimated_man_corr_cascade;
	Widget preestimated_man_corr_pulldown;
	Widget preestimated_man_corr1;
	Widget preestimated_man_corr2;
	Widget preestimated_man_corr3;
	Widget precise_cascade;
	Widget precise_pulldown;
	Widget precise1;
	Widget precise2;
	Widget precise3;
	Widget band_prof_cascade;
	Widget band_prof_pulldown;
	Widget band_prof1;
	Widget band_prof2;
	Widget band_prof3;
	Widget smoothing;
	Widget peaks_cascade;
	Widget peaks_pulldown;
	Widget peaks1;
	Widget peaks2;
	Widget peaks3;
	Widget peaks4;
	Widget peaks5;
	Widget peaks6;
	Widget peaks7;
	Arg args[MAX_ARGS];
	int n;


	/* Creating IO_cascade Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground, glavender); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	IO_cascade = XmCreateCascadeButton(MenuGel1D,"IO_cascade",args,n);
	XtManageChild(IO_cascade);

	/* Creating IO_pulldown Widget */ 

	IO_pulldown = CreatePulldownMenu(IO_cascade,"IO_pulldown",NULL,0);


	/* Creating init_data Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(geltooltabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	init_data = XmCreatePushButton(IO_pulldown,"init_data",args,n);
	XtManageChild(init_data);

	/* Adding Callbacks for init_data */ 

	XtAddCallback(init_data,XmNactivateCallback, initial_data_actcall, 40);


	/* Creating read_prepro Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(geltooltabs[7],
			XmSTRING_DEFAULT_CHARSET)); n++;

	read_prepro = XmCreateCascadeButton(IO_pulldown,"read_prepro",args,n);
	XtManageChild(read_prepro);

	/* Creating read_pulldown Widget */ 

	read_pulldown = CreatePulldownMenu(read_prepro,"read_pulldown",NULL,0);

	/* Creating read_prepro_standard Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(geltooltabs[8],
			XmSTRING_DEFAULT_CHARSET)); n++;

	read_prepro_standard = XmCreatePushButton(read_pulldown,"read_prepro_standard",args,n);
	XtManageChild(read_prepro_standard);

	/* Adding Callbacks for read_prepro_standard */ 

	XtAddCallback(read_prepro_standard,XmNactivateCallback, read_prepro_standard_actcall, NULL);

	/* Creating read_prepro_melanie Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(geltooltabs[11],
			XmSTRING_DEFAULT_CHARSET)); n++;

	read_prepro_melanie = XmCreatePushButton(read_pulldown,"read_prepro_melanie",args,n);
	XtManageChild(read_prepro_melanie);

	/* Adding Callbacks for read_prepro_melanie */ 

	XtAddCallback(read_prepro_melanie,XmNactivateCallback, read_prepro_melanie_actcall, NULL);

	/* Creating save Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(geltooltabs[10],
			XmSTRING_DEFAULT_CHARSET)); n++;

	save = XmCreateCascadeButton(IO_pulldown,"save",args,n);
	XtManageChild(save);

	/* Creating save_pulldown Widget */ 

	save_pulldown = CreatePulldownMenu(save,"save_pulldown",NULL,0);

	/* Creating save_standard Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(geltooltabs[8],
			XmSTRING_DEFAULT_CHARSET)); n++;

	save_standard = XmCreatePushButton(save_pulldown,"save_standard",args,n);
	XtManageChild(save_standard);

	/* Adding Callbacks for save_standard */ 

	XtAddCallback(save_standard,XmNactivateCallback, save_standard_actcall, NULL);

	/* Creating save_melanie Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(geltooltabs[11],
			XmSTRING_DEFAULT_CHARSET)); n++;

	save_melanie = XmCreatePushButton(save_pulldown,"save_melanie",args,n);
	XtManageChild(save_melanie);

	/* Adding Callbacks for save_melanie */ 

	XtAddCallback(save_melanie,XmNactivateCallback, save_melanie_actcall, NULL);

	/* Creating show_gel Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground, glavender); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(geltooltabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	show_gel = XmCreateCascadeButton(MenuGel1D,"show_gel",args,n);
	XtManageChild(show_gel);

	/* Adding Callbacks for show_gel */  


	XtAddCallback(show_gel,XmNactivateCallback, show_gel_actcall, 41);


	/* Creating preestimated_cascade Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(geltooltabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	preestimated_cascade = XmCreateCascadeButton(MenuGel1D,"preestimated_cascade",args,n);
	XtManageChild(preestimated_cascade);

	/* Creating preestimated_pulldown Widget */ 


	preestimated_pulldown = CreatePulldownMenu(preestimated_cascade,"preestimated_pulldown",NULL,0);

	/* Creating preestimated_calc Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gel1tabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	preestimated_calc = XmCreatePushButton(preestimated_pulldown,"preestimated_calc",args,n);
	XtManageChild(preestimated_calc);

	/* Adding Callbacks for preestimated_calc */ 

	XtAddCallback(preestimated_calc,XmNactivateCallback, 
		      preestimated_calc_actcall, 10);

	/* Creating preestimated_show Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gel1tabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	preestimated_show = XmCreatePushButton(preestimated_pulldown,"preestimated_show",args,n);
	XtManageChild(preestimated_show);

	/* Adding Callbacks for preestimated_show */ 

	XtAddCallback(preestimated_show,XmNactivateCallback, 
		      preestimated_show_actcall, 10);


	/* Creating preestimated_man_corr_cascade Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(geltooltabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	preestimated_man_corr_cascade = XmCreateCascadeButton(preestimated_pulldown,"preestimated_man_corr_cascade",args,n);
	XtManageChild(preestimated_man_corr_cascade);

	/* Creating preestimated_man_corr_pulldown Widget */ 


	preestimated_man_corr_pulldown = CreatePulldownMenu(preestimated_man_corr_cascade,"preestimated_man_corr_pulldown",NULL,0);

	/* Creating preestimated_man_corr1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gelcortabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	preestimated_man_corr1 = XmCreatePushButton(preestimated_man_corr_pulldown,"preestimated_man_corr1",args,n);
	XtManageChild(preestimated_man_corr1);

	/* Adding Callbacks for preestimated_man_corr1 */ 

	XtAddCallback(preestimated_man_corr1,XmNactivateCallback, 
		      preestimated_man_corr1_actcall, 12);


	/* Creating preestimated_man_corr2 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gelcortabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	preestimated_man_corr2 = XmCreatePushButton(preestimated_man_corr_pulldown,"preestimated_man_corr2",args,n);
	XtManageChild(preestimated_man_corr2);

	/* Adding Callbacks for preestimated_man_corr2 */ 

	XtAddCallback(preestimated_man_corr2,XmNactivateCallback, 
		      preestimated_man_corr2_actcall, 13);

	/* Creating preestimated_man_corr3 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gelcortabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	preestimated_man_corr3 = XmCreatePushButton(preestimated_man_corr_pulldown,"preestimated_man_corr3",args,n);
	XtManageChild(preestimated_man_corr3);

	/* Adding Callbacks for preestimated_man_corr3 */ 

	XtAddCallback(preestimated_man_corr3,XmNactivateCallback, 
		      preestimated_man_corr3_actcall, 14);


	/* Creating precise_cascade Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground, glavender); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(geltooltabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	precise_cascade = XmCreateCascadeButton(MenuGel1D,"precise_cascade",args,n);
	XtManageChild(precise_cascade);

	/* Creating precise_pulldown Widget */ 


	precise_pulldown = CreatePulldownMenu(precise_cascade,"precise_pulldown",NULL,0);

	/* Creating precise1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gel1tabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	precise1 = XmCreatePushButton(precise_pulldown,"precise1",args,n);
	XtManageChild(precise1);

	/* Adding Callbacks for precise1 */ 

	XtAddCallback(precise1,XmNactivateCallback, precise1_actcall, 20);

	/* Creating precise2 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gel1tabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	precise2 = XmCreatePushButton(precise_pulldown,"precise2",args,n);
	XtManageChild(precise2);

	/* Adding Callbacks for precise2 */ 

	XtAddCallback(precise2,XmNactivateCallback, precise2_actcall, 21);

	/* Creating precise3 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gel1tabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	precise3 = XmCreatePushButton(precise_pulldown,"precise3",args,n);
	XtManageChild(precise3);

	/* Adding Callbacks for precise3 */ 

	XtAddCallback(precise3,XmNactivateCallback, precise3_actcall, 22);


	/* Creating band_prof_cascade Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground, glavender); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(geltooltabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;

	band_prof_cascade = XmCreateCascadeButton(MenuGel1D,"band_prof_cascade",args,n);
	XtManageChild(band_prof_cascade);

	/* Creating band_prof_pulldown Widget */ 


	band_prof_pulldown = CreatePulldownMenu(band_prof_cascade,"band_prof_pulldown",NULL,0);

	/* Creating band_prof1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gel1tabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	band_prof1 = XmCreatePushButton(band_prof_pulldown,"band_prof1",args,n);
	XtManageChild(band_prof1);

	/* Adding Callbacks for band_prof1 */ 

	XtAddCallback(band_prof1,XmNactivateCallback, band_prof1_actcall, 30);

	/* Creating band_prof2 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gel3tabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	band_prof2 = XmCreatePushButton(band_prof_pulldown,"band_prof2",args,n);
	XtManageChild(band_prof2);

	/* Adding Callbacks for band_prof2 */ 

	XtAddCallback(band_prof2,XmNactivateCallback, band_prof2_actcall, 31);

	/* Creating band_prof3 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gel3tabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	band_prof3 = XmCreatePushButton(band_prof_pulldown,"band_prof3",args,n);
	XtManageChild(band_prof3);

	/* Adding Callbacks for band_prof3 */ 

	XtAddCallback(band_prof3,XmNactivateCallback, band_prof3_actcall, 32);


	/* Creating smoothing Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground,glavender); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(geltooltabs[5],
			XmSTRING_DEFAULT_CHARSET)); n++;

	smoothing = XmCreateCascadeButton(MenuGel1D,"smoothing",args,n);
	XtManageChild(smoothing);

	/* Adding Callbacks for smoothing */ 

	XtAddCallback(smoothing,XmNactivateCallback, smoothing_actcall, 42);


	/* Creating peaks_cascade Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground, glavender); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(geltooltabs[6],
			XmSTRING_DEFAULT_CHARSET)); n++;

	peaks_cascade = XmCreateCascadeButton(MenuGel1D,"peaks_cascade",args,n);
	XtManageChild(peaks_cascade);

	/* Creating peaks_pulldown Widget */ 


	peaks_pulldown = CreatePulldownMenu(peaks_cascade,"peaks_pulldown",NULL,0);

	/* Creating peaks1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gel4tabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	peaks1 = XmCreatePushButton(peaks_pulldown,"peaks1",args,n);
	XtManageChild(peaks1);

	/* Adding Callbacks for peaks1 */ 

	XtAddCallback(peaks1,XmNactivateCallback, peaks1_actcall, 1);


	/* Creating peaks2 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gel4tabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	peaks2 = XmCreatePushButton(peaks_pulldown,"peaks2",args,n);
	XtManageChild(peaks2);

	/* Adding Callbacks for peaks2 */ 

	XtAddCallback(peaks2,XmNactivateCallback, peaks2_actcall, 2);


	/* Creating peaks3 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gel4tabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	peaks3 = XmCreatePushButton(peaks_pulldown,"peaks3",args,n);
	XtManageChild(peaks3);

	/* Adding Callbacks for peaks3 */ 

	XtAddCallback(peaks3,XmNactivateCallback, peaks3_actcall, 3);

	/* Creating peaks4 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gel4tabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	peaks4 = XmCreatePushButton(peaks_pulldown,"peaks4",args,n);
	XtManageChild(peaks4);

	/* Adding Callbacks for peaks4 */ 

	XtAddCallback(peaks4,XmNactivateCallback, peaks4_actcall, 4);

	/* Creating peaks5 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gel4tabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;

	peaks5 = XmCreatePushButton(peaks_pulldown,"peaks5",args,n);
	XtManageChild(peaks5);

	/* Adding Callbacks for peaks5 */ 

	XtAddCallback(peaks5,XmNactivateCallback, peaks5_actcall, 5);

	/* Creating peaks6 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gel4tabs[5],
			XmSTRING_DEFAULT_CHARSET)); n++;

	peaks6 = XmCreatePushButton(peaks_pulldown,"peaks6",args,n);
	XtManageChild(peaks6);

	/* Adding Callbacks for peaks6 */ 

	XtAddCallback(peaks6,XmNactivateCallback, peaks6_actcall, 6);

	/* Creating peaks7 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(gel4tabs[6],
			XmSTRING_DEFAULT_CHARSET)); n++;

	peaks7 = XmCreatePushButton(peaks_pulldown,"peaks7",args,n);
	XtManageChild(peaks7);

	/* Adding Callbacks for peaks7 */ 

	XtAddCallback(peaks7,XmNactivateCallback, peaks7_actcall, 7);



}


