/*****************************************************************************/
/* module smorpho.c							     */
/*									     */
/* Author: Markus Buchi							     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1988							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/

/*
pow_ii()
{
    
}
*/
  
#define NON 0
#define OUI 1
#define TRUE 1
#define FALSE 0
#define TYPE_BIN -1
#define MAX_POINT 512

#include <stdio.h>
#include "defwin.h"
#include "def.h"

extern int statis();
extern affiche_image();
extern write_erreur();

extern struct description_memoire dir_desc[MAX_IMA];
extern struct description_memoire buffer_desc[2];

extern struct directoire_image    dir_image[MAX_IMA];
extern struct directoire_image    buffer_image[2];
extern int index_image[8], taille, angle;

extern char *buf;

struct desc_ima  tab_ima[MAX_IMA];

struct param
      {
          int nl;
          int nc;
	  unsigned short **ima_dep;
          unsigned short **ima_res;
          unsigned short **ima_condi;
          short angle;
          int   taille;
          short stop;
          int no_dep, no_arr, no_cond;
      } ;

struct param *ask_para(), para;
unsigned char *allouer();
unsigned short **c_allouer();

unsigned short **liste_point;
int	flag_autoconvert;

long entree_morpho(proc_num)
int proc_num;
{
     struct param *p;
     int i, nl, nc, ima_courante;
     unsigned short **ima1, **ima2;
     unsigned char  *imas, *imah;
     long n;
    
     switch(proc_num)
       {
           case 0   :  /* entree dans morphmat binaire */
                      init();
                      break;

           case 1   :  /* afficher */
                       ima_courante = m_affiche();
                       break;

           case 20  :  /* complement */
                      p = ask_para(1);
                      if( p->stop == TRUE) break;
                      not_ima( p->nl,  p->nc,  p->ima_dep,  p->ima_res);
                      break; 

           case 21  :  /* intersection */
                      p = ask_para(3);
                      if( p->stop == TRUE) break;
                      and_ima( p->nl, p->nc, p->ima_dep, p->ima_condi, p->ima_res);
                      break;

           case 22  :  /* union */
                      p = ask_para(3);
                      if( p->stop == TRUE) break;
                      or_ima( p->nl, p->nc, p->ima_dep, p->ima_condi, p->ima_res);
                      break;
 
           case 23  :  /* difference symetrique */
                      p = ask_para(3);
                      if( p->stop == TRUE) break;
                      xor_ima( p->nl, p->nc, p->ima_dep, p->ima_condi, p->ima_res);
                      break;
 
           case 24  :  /* difference */
                      p = ask_para(3);
                      diff_ima( p->nl, p->nc, p->ima_dep, p->ima_condi, p->ima_res);
                      break;

/****************************************************************************************/
 
           case 30  :  /* erosion */
                      p = ask_para(5);
                      if( p->stop == TRUE) break;
                      erosion( p->nl,  p->nc,  p->ima_res,  p->taille);
                      break;
      
           case 31  :  /* erosion conditionnelle */
                      p = ask_para(4);
                      if( p->stop == TRUE) break;
                      conderos( p->nl , p->nc , p->ima_res, p->ima_condi, p->taille); 
                      break;

           case 32  :  /* erosion lineaire */
                      p = ask_para(6);
                      if( p->stop == TRUE) break;
                      R_amincir( p->nl,  p->nc,  p->ima_res,  p->taille,  p->angle);
                      break;

           case 33  :  /* dilatation */
                      p = ask_para(5);
                      if( p->stop == TRUE) break;
                      dilatation( p->nl,  p->nc,  p->ima_res,  p->taille);
                      break;

           case 34  :  /* dilatation conditionnelle */
                      p = ask_para(4);
                      if( p->stop == TRUE) break;
                      condilat( p->nl , p->nc , p->ima_res, p->ima_condi, p->taille); 
                      break;


           case 35  :  /* dilatation lineaire */
                      p = ask_para(6);
                      if( p->stop == TRUE) break;
                      R_epaissir( p->nl,  p->nc,  p->ima_res,  p->taille,  p->angle);
                      break;

           case 36  :  /* ouverture */
                      p = ask_para(5);
                      if( p->stop == TRUE) break;
                      ouverture( p->nl,  p->nc,  p->ima_res,  p->taille);
                      break;

           case 37  :  /* fermeture */
                      p = ask_para(5);
                      if( p->stop == TRUE) break;
                      fermeture( p->nl,  p->nc,  p->ima_res,  p->taille);
                      break;

/******************************************************************************************/

           case 40  :  /* amincissement homotopique : L */
                      p = ask_para(5);
                      if( p->stop == TRUE) break;
                      L_amincir( p->nl, p->nc, p->ima_res, p->taille);
                      break;

           case 41  :  /* amincissement homotopique : D */
                      p = ask_para(5);
                      if( p->stop == TRUE) break;
                      D_amincir( p->nl, p->nc, p->ima_res, p->taille);
                      break;

           case 42  :  /* ebarbulage : E */
                      p = ask_para(5);
                      if( p->stop == TRUE) break;
                      E_amincir( p->nl, p->nc, p->ima_res, p->taille);
                      break;

           case 43  :  /* contour */
                      p = ask_para(2);
                      if( p->stop == TRUE) break;
                      p->taille = 1;
                      H_amincir( p->nl, p->nc, p->ima_res, p->taille);
                      break;

/*************************************************************************************/

           case 50  :  /* epaississement points isoles : ~M */
                      p = ask_para(5);
                      if( p->stop == TRUE) break;
                      M_epaissir( p->nl, p->nc, p->ima_res, p->taille);
                      break;

           case 51  :  /* epaississement homotopique : ~L */
                      p = ask_para(5);
                      if( p->stop == TRUE) break;
                      L_epaissir( p->nl, p->nc, p->ima_res, p->taille);
                      break;

           case 52  :  /* epaississement homotopique : ~D  */
                      p = ask_para(5);
                      if( p->stop == TRUE) break;
                      D_epaissir( p->nl, p->nc, p->ima_res, p->taille);
                      break;

           case 53  :  /* epaississement : ~E */
                      p = ask_para(5);
                      if( p->stop == TRUE) break;
                      E_epaissir( p->nl,  p->nc,  p->ima_res,  p->taille);
                      break;

           case 54  :  /* epaississment : ~C */
                      p = ask_para(5);
                      if( p->stop == TRUE) break;
                      C_epaissir( p->nl, p->nc, p->ima_res, p->taille);
                      break; 

/*************************************************************************************/

           case 61  :  /* points extremes du squelette */
                      p = ask_para(2);
                      if( p->stop == TRUE) break;
                      n = E_tout_ou_rien( p->nl, p->nc, p->ima_res);
                      break;

           case 62  :  /* points isoles */
                      p = ask_para(2);
                      if( p->stop == TRUE) break;
                      n = I_tout_ou_rien( p->nl, p->nc, p->ima_res);
                      break;

           case 63  :  /* points triples */
                      p = ask_para(2);
                      if( p->stop == TRUE) break;
                      F_tout_ou_rien( p->nl, p->nc, p->ima_res);
                      break;

/******************************************************************************/

           case 70  :  /* contour */
                      p = ask_para(2);
                      if( p->stop == TRUE) break;
                      contour( p->nl, p->nc, p->ima_res);
                      break;

           case 71  :  /* elimine bords */
                      p = ask_para(2);
                      if( p->stop == TRUE) break;
                      elim_bord( p->nl, p->nc, p->ima_res);
		      break;

           case 72  :  /* boucher trous */
                      p = ask_para(2);
                      if( p->stop == TRUE) break;
                      elim_trous( p->nl, p->nc, p->ima_res);
                      break;

           case 73  :  /* squelette homotopique */
                      p = ask_para(2);
                      if( p->stop == TRUE) break;
                      p->taille = -1;
                      L_amincir( p->nl, p->nc, p->ima_res, p->taille);
                      break;

           case 74  :  /* marqueur homotopique */
                      p = ask_para(2);
                      if( p->stop == TRUE) break;
                      p->taille = -1;
                      D_amincir( p->nl, p->nc, p->ima_res, p->taille);
                      break;

           case 75  :  /* enveloppe quasi-convexe */
                      p = ask_para(2);
                      if( p->stop == TRUE) break;
                      p->taille = -1;
                      D_epaissir( p->nl, p->nc, p->ima_res, p->taille);
                      break;

           case 76  :  /* enveloppe fortement convexe */
                      p = ask_para(2);
                      if( p->stop == TRUE) break;
                      p->taille = -1;
                      C_epaissir( p->nl, p->nc, p->ima_res, p->taille);
                      break; 

           case 77  : /* squelette par zone d'influence */
                      p = ask_para(2);
                      if( p->stop == TRUE) break;
                      squelz(p->nl, p->nc, p->ima_res);
                      break;       
          
/*********************************************************************************/

           case 80  :  /* amincissement homotopique conditionnelle : L */
                      p = ask_para(4);
                      if( p->stop == TRUE) break;
                      L_camincir( p->nl, p->nc, p->ima_res, p->ima_condi, p->taille);
                      break;

           case 81  :  /* amincissement homotopique conditionnelle : D */
                      p = ask_para(4);
                      if( p->stop == TRUE) break;
                      D_camincir( p->nl, p->nc, p->ima_res, p->ima_condi, p->taille);
                      break;

           case 82  :  /* ebarbulage conditionnel*/
                      p = ask_para(4);
                      if( p->stop == TRUE) break;
                      E_camincir( p->nl, p->nc, p->ima_res, p->ima_condi, p->taille);
                      break;

/*************************************************************************************/

           case 90  :  /* epaississement points isoles condi : ~M */
                      p = ask_para(4);
                      if( p->stop == TRUE) break;
                      M_cepaissir( p->nl, p->nc, p->ima_res, p->ima_condi, p->taille);
                      break;

           case 91  :  /* epaississement homotopique condi : ~L */
                      p = ask_para(4);
                      if( p->stop == TRUE) break;
                      L_cepaissir( p->nl, p->nc, p->ima_res, p->ima_condi, p->taille);
                      break;

           case 92  :  /* epaississement homotopique condi : ~D  */
                      p = ask_para(4);
                      if( p->stop == TRUE) break;
                      D_cepaissir( p->nl, p->nc, p->ima_res, p->ima_condi, p->taille);
                      break;

           case 93  :  /* epaississement condi: ~E */
                      p = ask_para(4);
                      if( p->stop == TRUE) break;
                      E_cepaissir( p->nl,  p->nc,  p->ima_res, p->ima_condi, p->taille);
                      break;

           case 94  :  /* epaississment condi : ~C */
                      p = ask_para(4);
                      if( p->stop == TRUE) break;
                      C_cepaissir( p->nl, p->nc, p->ima_res, p->ima_condi, p->taille);
                      break; 
       }
       

/*    if (flag_autoconvert){
	free(buffer_image[0].image);
	buffer_image[0].image = NULL;
	 free(buffer_image[1].image);
	flag_autoconvert = FALSE;
    }
*/
    return ((proc_num==61||proc_num==62 ? n : (long)0));
} /* end entree_morpho */

/*****************************************************************/
/* retourne les parametres dans para */
struct param *ask_para(npara)
int npara;       
{ 
     int nls, ncs, ncolh, nl, nc,  i, ima_courante, n, m;
     unsigned char  *imas, *imah;
 
  
     para.stop = FALSE;

     para.ima_dep = tab_ima[index_image[0]].image;
     para.ima_res = tab_ima[index_image[1]].image;
     para.no_dep = index_image[0];
     para.no_arr = index_image[1];
     imas = dir_image[index_image[0]].image;

     if( (imas == NULL) && (para.ima_dep == NULL))
        {
	    /* erreur image de depart vide */
	    write_erreur (1);
            para.stop = TRUE;
            return (&para);
	}
     if( dir_desc[index_image[0]].type != TYPE_BIN)
        {
	    /* erreur image non binaire */
	    flag_autoconvert = TRUE;
	    autoconvcreer_plan_bin(index_image[0], 0);
	    imas = (unsigned char *) buffer_image[0].image;
/*            write_erreur (17);
            para.stop = TRUE;
            return (&para);  */
	}

     nls = dir_desc[index_image[0]].nligne;
     ncs = dir_desc[index_image[0]].ncolonne;           
     ima_courante = index_image[0];                   
     if(  para.ima_dep == NULL)
        { 
            imah = allouer(nls, ncs);
            ncolh = carhex(nls, ncs, imas, imah, ima_courante);
            para.ima_dep = c_allouer(nls/2, ncolh/2);
            compacter(nls, ncolh, imah, para.ima_dep);
            desallouer(imah);  
            tab_ima[ima_courante].image = para.ima_dep;
            tab_ima[ima_courante].sauve = OUI;
            tab_ima[ima_courante].nl = nls/2;
            tab_ima[ima_courante].nc = ncolh/2;
            tab_ima[ima_courante].ncs = ncs;
	}
    nl = tab_ima[index_image[0]].nl;
    nc = tab_ima[index_image[0]].nc;
 /*   if (flag_autoconvert) free(imas);  */  
    if( index_image[0] == index_image[1])
       {
          para.ima_res = para.ima_dep;
          tab_ima[ima_courante].sauve = NON;
       } 
    else
       { /* ELSE */
          ima_courante = index_image[1];
          imas = dir_image[ima_courante].image; 
          if( imas == NULL)
             {
                imas = allouer(nls,ncs);
                dir_image[ima_courante].image = imas;
/*
                dir_desc[ima_courante].type = TYPE_BIN;
                dir_desc[ima_courante].nligne = nls;
                dir_desc[ima_courante].ncolonne = ncs;
*/
                if (flag_autoconvert) dir_desc[ima_courante] = buffer_desc[0];
		else dir_desc[ima_courante] = dir_desc[index_image[0]];
             }

         if( (para.ima_res != NULL) && (tab_ima[ima_courante].ncs != ncs))
            {
	        c_desallouer(tab_ima[ima_courante].nl, para.ima_res);
            }
         if( para.ima_res == NULL)
            {   
                para.ima_res = c_allouer(nl, nc);
		tab_ima[ima_courante].image = para.ima_res;
                tab_ima[ima_courante].trame = tab_ima[index_image[0]].trame;
                tab_ima[ima_courante].nl = nl;
                tab_ima[ima_courante].nc = nc;
                tab_ima[ima_courante].ncs = ncs;
/*
                dir_desc[ima_courante].nligne = nls;
                dir_desc[ima_courante].ncolonne = ncs;
                dir_desc[ima_courante].type = TYPE_BIN;
*/
                if (flag_autoconvert) dir_desc[ima_courante] = buffer_desc[0];
		else dir_desc[ima_courante] = dir_desc[index_image[0]];

	    }
         tab_ima[ima_courante].sauve = NON;
         if(( npara != 1) && ( npara != 3))
             {
                copier(nl, nc, para.ima_dep, para.ima_res);
	     }
       }

para.angle = 0;

switch ( npara) {

 case 1  :  break;

 case 2  :  break;

 case 3  : /* image operation */


 case 4 : /* image conditionnelle */
          ima_courante = index_image[2];                   
          para.ima_condi = tab_ima[ima_courante].image;
          para.no_cond = ima_courante;
          imas = dir_image[ima_courante].image;

          if( (imas == NULL) && (para.ima_condi == NULL))
             {
	       /* erreur image de depart (condi) vide */
	       write_erreur (1);
               para.stop = TRUE;
               return (&para);	    
             }
          if( dir_desc[ima_courante].type != TYPE_BIN)
             {
	       /* erreur image non binaire */
		flag_autoconvert = TRUE;
		autoconvcreer_plan_bin(ima_courante, 1);
		imas = (unsigned char *) buffer_image[1].image;
             /*  write_erreur (17); 
		para.stop = TRUE;
		return (&para); */
             }

          nls = dir_desc[ima_courante].nligne;
          ncs = dir_desc[ima_courante].ncolonne;
          if(  para.ima_condi == NULL)
             { 
               imah = allouer(nls, ncs);
               ncolh = carhex(nls, ncs, imas, imah, ima_courante);
               para.ima_condi = c_allouer(nls/2, ncolh/2);
               compacter(nls, ncolh, imah, para.ima_condi);
               desallouer(imah);   
               tab_ima[ima_courante].image = para.ima_res;
               tab_ima[ima_courante].trame = tab_ima[index_image[0]].trame;
               tab_ima[ima_courante].nl = nl;
               tab_ima[ima_courante].nc = nc;
               tab_ima[ima_courante].ncs = ncs;
             }
          if( npara == 3) /* image operation */
             {
                break;
	     }

 case 5 : /* taille */
          para.taille = taille;
          break;

 case 6 : /* angle + taille */
          para.taille = taille;
          para.angle = angle;
          break;
  }

para.nl = nl;
para.nc = nc;


return ( &para);                                

} /* end ask_param */

/*****************************************************************/

init()
{
     int i;

     liste_point = c_allouer(MAX_POINT - 2, MAX_POINT - 2);
     for( i = 0; i < MAX_IMA; i++)
         {
            tab_ima[i].image = NULL;
            tab_ima[i].sauve = NON;
            if((dir_image[i].image != NULL)&&(dir_desc[i].type == TYPE_BIN))
               {
		   tab_ima[i].sauve = OUI;
	       }
	 }
}

/******************************************************************/

sortie_morpho()
{
     int nl, nc, nls, ncs , i, ima_courante;
     unsigned char  *imas, *imah;
     float mmin, mmax, mu, ecart;

     c_desallouer(MAX_POINT - 2, liste_point);

     for( i = 0; i < MAX_IMA; i++)
         { 
            ima_courante = i;

            if( (tab_ima[i].image != NULL) && (tab_ima[i].sauve == NON))
               {
                   imas = dir_image[i].image;
                   nl = tab_ima[i].nl;    
                   nc = tab_ima[i].nc;
                   imah = allouer(nl*2, nc*2);
                   decompacter(nl, nc, tab_ima[i].image, imah);
                   if( dir_desc[i].ncolonne != tab_ima[i].ncs)
                      {
		         desallouer(imas);
	              }
                   if( dir_image[i].image == NULL)
                      {
                         imas = allouer(nl*2, tab_ima[i].ncs);
                      }
                   hexcar(nl*2, nc*2, imah, imas, ima_courante);
                   desallouer(imah);
               }
            if(tab_ima[i].image != NULL) 
               c_desallouer(tab_ima[i].nl, tab_ima[i].image);       
	}

     for( i=1; i<MAX_IMA; i++)
         {
            imas = dir_image[i].image;
            if( (imas != NULL) && (dir_desc[i].type == TYPE_BIN) &&
	    (tab_ima[i].sauve == NON))
               { 
                  nls = dir_desc[i].nligne;
                  ncs = dir_desc[i].ncolonne;

                  statis(imas, TYPE_BIN, nls, ncs, &mmin, &mmax, &mu, &ecart);
                  dir_desc[i].mmin = mmin;
                  dir_desc[i].mmax = mmax;
                  dir_desc[i].mu = mu;
                  dir_desc[i].ecart = ecart;
	       }
	 }
} /* end sortie morpho */

/******************************************************************/

int m_affiche()
{
     int nls, ncs, ncolh, nl, nc,  i, ima_courante;
     unsigned char  *imas, *imah;
     float mmin, mmax, mu, ecart;
 
     ima_courante = index_image[0];
     para.no_dep = ima_courante;

     if( tab_ima[ima_courante].image != NULL) 
        {
          if( dir_desc[ima_courante].type != TYPE_BIN)
             {
	       /* erreur image non binaire */
               write_erreur (17);
               para.stop = TRUE;
               return (-1);
             }


           if( tab_ima[ima_courante].sauve == NON)
              {   tab_ima[ima_courante].sauve = OUI;
                  nc = tab_ima[ima_courante].nc;
                  nl = tab_ima[ima_courante].nl;
                  imah = allouer(nl*2, nc*2);
                  decompacter(nl, nc, tab_ima[ima_courante].image, imah);
                  imas = dir_image[ima_courante].image; 
                  if( dir_desc[ima_courante].ncolonne != tab_ima[ima_courante].ncs)
                      {
	                 desallouer(imas);
	              }
                  if( dir_image[ima_courante].image == NULL)
                      {
                         imas = allouer(nl*2, tab_ima[ima_courante].ncs);
                      }
                  hexcar(nl*2, nc*2, imah, imas, ima_courante);
                  desallouer(imah);
                  dir_image[ima_courante].image = imas;
                  nls = dir_desc[ima_courante].nligne;
                  ncs = dir_desc[ima_courante].ncolonne;

                  statis(imas, TYPE_BIN, nls, ncs, &mmin, &mmax, &mu, &ecart);
                  dir_desc[ima_courante].mmin = mmin;
                  dir_desc[ima_courante].mmax = mmax;
                  dir_desc[ima_courante].mu = mu;
                  dir_desc[ima_courante].ecart = ecart;             
             } 
          affiche_image(1, ima_courante, 100);
	}

     else
      if( dir_image[ima_courante].image != NULL)
         {
            affiche_image(1, ima_courante, 100);
         }
      else
         {
	     /* erreur image de depart vide */
             write_erreur (1);          
             return -1;
         }
    return (ima_courante);
} /* end m_afficher */

/**************************************************************************/

