/*****************************************************************************/
/* module oparithm.c							     */
/*									     */
/* Author: Alain Jacot-Descombes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <math.h>

#include "define.h"
#include "structure.h"
#include "global.h"
#include "type.h"

Frame	    frame_cte;
Panel	    panel_cte;
Panel_item  cte_reel, cte_im;

union ens_pointeur {
    float   *pf;
    int	    *pi;
    short   *ps;
    unsigned char   *pb;
};

/*****************************************************************************/

static Panel_setting lire_cte (item, event)
    Panel_item	item;
    Event	*event;
{
    static  struct  cte_cmplx	cte;
    float   f;

    if (event_id(event) == CTRLC) {
        /* demande d'interruption de l'interaction par l'utilisateur */
	flag_break = TRUE;
        window_return (NULL);
        window_destroy (frame_cte);
        return;
    }
    else { 
        f = atof((char *) panel_get (item, PANEL_VALUE));
        if (item == cte_reel) 
	    cte.reel = f;
	else if (item == cte_im) 
	    cte.im = f;
        if (event_id(event) == '\t')
	    return (PANEL_NEXT);
        else {
	    window_return(&cte);
	    window_destroy (frame_cte);
	    return;
	}
    }
}

/*****************************************************************************/

struct	cte_cmplx   *cte_panel (mode)
    int mode;
{
    Panel_item titre;
    char stitre[30], val[8];
    struct cte_cmplx	*cte;
    
    frame_cte = window_create (frame, FRAME, WIN_X, 500, WIN_Y, 500,
                         FRAME_NO_CONFIRM, TRUE, 0);
    panel_cte = window_create (frame_cte, PANEL, PANEL_LABEL_BOLD,
			 TRUE, 0);
    
    switch (mode) {
	case 10 : strcpy (stitre,paneltabs[340] 
		    ); break;
	case 11 : strcpy (stitre, paneltabs[341]
		    ); break;
    	case 12 : strcpy (stitre, paneltabs[342]
		    ); break;
	case 13 : strcpy (stitre, paneltabs[343]
		    ); break;
    	case 41 : strcpy (stitre, paneltabs[344]
		    );
    }
    titre = panel_create_item (panel_cte, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(0),
		       PANEL_LABEL_Y, ATTR_ROW(0),
                       PANEL_LABEL_STRING, stitre,
                       0);
    switch (mode) {
	case 10 :
	case 11 :
	case 12 :
        case 13 : strcpy (stitre,paneltabs[345]   
			); break;
	case 41 : strcpy (stitre,paneltabs[346] 
		    ); break;
    }
    cte_reel = panel_create_item (panel_cte, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(2),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, stitre,
                       PANEL_VALUE, "\0",
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_cte,
                       0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	panel_set_value (cte_reel, sprintf (val,"%f\0",
			 ((struct cte_cmplx *)macro_cour->param)->reel)); 
    if (mode == 41) {
	strcpy (stitre,paneltabs[347]); 
        cte_im = panel_create_item (panel_cte, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(3),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, stitre,
                       PANEL_VALUE, "\0",
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_cte,
                       0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	panel_set_value (cte_reel, sprintf (val,"%f\0",
			 ((struct cte_cmplx *)macro_cour->param)->im)); 
    }
    window_fit (panel_cte);
    window_fit (frame_cte);
    window_set (panel_cte, PANEL_CARET_ITEM, cte_reel, 0);
    cte = (struct cte_cmplx *)window_loop(frame_cte);
    return (cte);
}

/*****************************************************************************/

int ouvrir (pim, no, ordre)
    union ens_pointeur *pim;
    int	no, ordre;
{
    static  int	code[2][5] = {0, 0,  3,  7,  12,
			      0, 0, 30, 70, 120};

    switch (dir_desc[no].type) {
	case -1:
	case 0:	pim->pb = (unsigned char *) dir_image[no].image; break;
	case 1:	pim->ps = (short *)	    dir_image[no].image; break;
	case 2:	pim->pi = (int *)	    dir_image[no].image; break;
	case 3:	pim->pf = (float *)	    dir_image[no].image; break;
    }
    return (code[ordre][dir_desc[no].type + 1]);
}

/*****************************************************************************/

op_arithm (mode, nodep1, nodep2, noarr)
    int	    mode, nodep1, nodep2, noarr;
{
    union ens_pointeur pim[2];
    int	*pires, *deb_i;
    float *pfres, *deb_f;
    int	code, taille;
    register int i;

    code = ouvrir (&pim[0], nodep1, 0) + ouvrir (&pim[1], nodep2, 1);
    taille = dir_desc[nodep1].nligne * dir_desc[nodep1].ncolonne;
    dir_desc[noarr] = dir_desc[nodep1];
    if (code==120 || code==12 || code==123 || code==42 || code==127 || code==82
     || code==132 || mode==24) {
        deb_f = pfres = (float *) malloc (taille * sizeof(*pfres));
        dir_desc[noarr].type = 3;
    }
    else {
	deb_i = pires = (int *) malloc (taille * sizeof(*pires));
	dir_desc[noarr].type = 2;
    }
    switch (code){
	case 0	:   /* b,b */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) + *(pim[1].pb);
			pires++;  (pim[0].pb)++;  (pim[1].pb)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) - *(pim[1].pb);
			pires++;  (pim[0].pb)++;  (pim[1].pb)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) * *(pim[1].pb);
			pires++;  (pim[0].pb)++;  (pim[1].pb)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) / *(pim[1].pb);
			pires++;  (pim[0].pb)++;  (pim[1].pb)++;
		    }
		    break;
	    }
	    break;
	case 30	:   /* b,s */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) + *(pim[1].ps);
			pires++;  (pim[0].pb)++;  (pim[1].ps)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) - *(pim[1].ps);
			pires++;  (pim[0].pb)++;  (pim[1].ps)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) * *(pim[1].ps);
			pires++;  (pim[0].pb)++;  (pim[1].ps)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) / *(pim[1].ps);
			pires++;  (pim[0].pb)++;  (pim[1].ps)++;
		    }
		    break;
	    }
	    break;
	case 3	:   /* s,b */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) + *(pim[1].pb);
			pires++;  (pim[0].ps)++;  (pim[1].pb)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) - *(pim[1].pb);
			pires++;  (pim[0].ps)++;  (pim[1].pb)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) * *(pim[1].pb);
			pires++;  (pim[0].ps)++;  (pim[1].pb)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) / *(pim[1].pb);
			pires++;  (pim[0].ps)++;  (pim[1].pb)++;
		    }
		    break;
	    }
	    break;
	case 70	:   /* b,i */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) + *(pim[1].pi);
			pires++;  (pim[0].pb)++;  (pim[1].pi)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) - *(pim[1].pi);
			pires++;  (pim[0].pb)++;  (pim[1].pi)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) * *(pim[1].pi);
			pires++;  (pim[0].pb)++;  (pim[1].pi)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) / *(pim[1].pi);
			pires++;  (pim[0].pb)++;  (pim[1].pi)++;
		    }
		    break;
	    }
	    break;
	case 7	:   /* i,b */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) + *(pim[1].pb);
			pires++;  (pim[0].pi)++;  (pim[1].pb)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) - *(pim[1].pb);
			pires++;  (pim[0].pi)++;  (pim[1].pb)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) * *(pim[1].pb);
			pires++;  (pim[0].pi)++;  (pim[1].pb)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) / *(pim[1].pb);
			pires++;  (pim[0].pi)++;  (pim[1].pb)++;
		    }
		    break;
	    }
	    break;
	case 120:   /* b,f */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pb) + *(pim[1].pf);
			pfres++;  (pim[0].pb)++;  (pim[1].pf)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pb) - *(pim[1].pf);
			pfres++;  (pim[0].pb)++;  (pim[1].pf)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pb) * *(pim[1].pf);
			pfres++;  (pim[0].pb)++;  (pim[1].pf)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pb) / *(pim[1].pf);
			pfres++;  (pim[0].pb)++;  (pim[1].pf)++;
		    }
		    break;
	    }
	    break;
	case 12	:   /* f,b */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) + *(pim[1].pb);
			pfres++;  (pim[0].pf)++;  (pim[1].pb)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) - *(pim[1].pb);
			pfres++;  (pim[0].pf)++;  (pim[1].pb)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) * *(pim[1].pb);
			pfres++;  (pim[0].pf)++;  (pim[1].pb)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) / *(pim[1].pb);
			pfres++;  (pim[0].pf)++;  (pim[1].pb)++;
		    }
		    break;
	    }
	    break;
	case 33	:   /* s,s */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) + *(pim[1].ps);
			pires++;  (pim[0].ps)++;  (pim[1].ps)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) - *(pim[1].ps);
			pires++;  (pim[0].ps)++;  (pim[1].ps)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) * *(pim[1].ps);
			pires++;  (pim[0].ps)++;  (pim[1].ps)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) / *(pim[1].ps);
			pires++;  (pim[0].ps)++;  (pim[1].ps)++;
		    }
		    break;
	    }
	    break;
	case 73	:   /* s,i */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) + *(pim[1].pi);
			pires++;  (pim[0].ps)++;  (pim[1].pi)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) - *(pim[1].pi);
			pires++;  (pim[0].ps)++;  (pim[1].pi)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) * *(pim[1].pi);
			pires++;  (pim[0].ps)++;  (pim[1].pi)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) / *(pim[1].pi);
		        pires++;  (pim[0].ps)++;  (pim[1].pi)++;
		    }
		    break;
	    }
	    break;
	case 37	:   /* i,s */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) + *(pim[1].ps);
			pires++;  (pim[0].pi)++;  (pim[1].ps)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) - *(pim[1].ps);
			pires++;  (pim[0].pi)++;  (pim[1].ps)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) * *(pim[1].ps);
			pires++;  (pim[0].pi)++;  (pim[1].ps)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) / *(pim[1].ps);
			pires++;  (pim[0].pi)++;  (pim[1].ps)++;
		    }
		    break;
	    }
	    break;
	case 123:   /* s,f */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].ps) + *(pim[1].pf);
			pfres++;  (pim[0].ps)++;  (pim[1].pf)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].ps) - *(pim[1].pf);
			pfres++;  (pim[0].ps)++;  (pim[1].pf)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].ps) * *(pim[1].pf);
			pfres++;  (pim[0].ps)++;  (pim[1].pf)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].ps) / *(pim[1].pf);
			pfres++;  (pim[0].ps)++;  (pim[1].pf)++;
		    }
		    break;
	    }
	    break;
	case 42	:   /* f,s */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) + *(pim[1].ps);
			pfres++;  (pim[0].pf)++;  (pim[1].ps)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) - *(pim[1].ps);
			pfres++;  (pim[0].pf)++;  (pim[1].ps)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) * *(pim[1].ps);
			pfres++;  (pim[0].pf)++;  (pim[1].ps)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) / *(pim[1].ps);
			pfres++;  (pim[0].pf)++;  (pim[1].ps)++;
		    }
		    break;
	    }
	    break;
	case 77	:   /* i,i */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) + *(pim[1].pi);
			pires++;  (pim[0].pi)++;  (pim[1].pi)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) - *(pim[1].pi);
			pires++;  (pim[0].pi)++;  (pim[1].pi)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) * *(pim[1].pi);
			pires++;  (pim[0].pi)++;  (pim[1].pi)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) / *(pim[1].pi);
			pires++;  (pim[0].pi)++;  (pim[1].pi)++;
		    }
		    break;
	    }
	    break;
	case 127:   /* i,f */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pi) + *(pim[1].pf);
			pfres++;  (pim[0].pi)++;  (pim[1].pf)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pi) - *(pim[1].pf);
			pfres++;  (pim[0].pi)++;  (pim[1].pf)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pi) * *(pim[1].pf);
			pfres++;  (pim[0].pi)++;  (pim[1].pf)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pi) / *(pim[1].pf);
			pfres++;  (pim[0].pi)++;  (pim[1].pf)++;
		    }
		    break;
	    }
	    break;
	case 82	:   /* f,i */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) + *(pim[1].pi);
			pfres++;  (pim[0].pf)++;  (pim[1].pi)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) - *(pim[1].pi);
			pfres++;  (pim[0].pf)++;  (pim[1].pi)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) * *(pim[1].pi);
			pfres++;  (pim[0].pf)++;  (pim[1].pi)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) / *(pim[1].pi);
			pfres++;  (pim[0].pf)++;  (pim[1].pi)++;
		    }
		    break;
	    }
	    break;
	case 132:   /* f,f */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) + *(pim[1].pf);
			pfres++;  (pim[0].pf)++;  (pim[1].pf)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) - *(pim[1].pf);
			pfres++;  (pim[0].pf)++;  (pim[1].pf)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) * *(pim[1].pf);
			pfres++;  (pim[0].pf)++;  (pim[1].pf)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) / *(pim[1].pf);
			pfres++;  (pim[0].pf)++;  (pim[1].pf)++;
		    }
		    break;
	    }
	    break;
    }
    if (code==120 || code==12 || code==123 || code==42 || code==127 || code==82
     || code==132 || mode==24) {
	if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
        dir_image[noarr].image = (unsigned char *) deb_f;
    }
    else {
	if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
	dir_image[noarr].image = (unsigned char *) deb_i;
    }
    statis (dir_image[noarr].image, dir_desc[noarr].type,
	    dir_desc[noarr].nligne, dir_desc[noarr].ncolonne,
	    &(dir_desc[noarr].mmin), &(dir_desc[noarr].mmax),
	    &(dir_desc[noarr].mu), &(dir_desc[noarr].ecart));
}

/*****************************************************************************/

op_arithm_cmplx (nodep1_r, nodep1_im, nodep2_r, nodep2_im, noarr_r, noarr_im)
    int	nodep1_r, nodep1_im, nodep2_r, nodep2_im, noarr_r, noarr_im;
{
    union ens_pointeur pim[4];
    float *pfres_r, *pfres_im, *debf_r, *debf_im;
    int *pires_r, *pires_im, *debi_r, *debi_im;
    int	code, taille;
    register int i;

    /* le plan reel et imaginaire d'une image doit etre de meme type */
    code = (ouvrir (&pim[0], nodep1_r,0) + ouvrir (&pim[1], nodep1_im,0)) / 2 +
	   (ouvrir (&pim[2], nodep2_r,1) + ouvrir (&pim[3], nodep2_im,1)) / 2 ;
    taille = dir_desc[nodep1_r].nligne * dir_desc[nodep1_r].ncolonne;
    dir_desc[noarr_r] = dir_desc[nodep1_r];
    if (code==120 || code==12 || code==123 || code==42 || code==127 || code==82
     || code==132) {
        debf_r = pfres_r = (float *) malloc (taille * sizeof(*pfres_r));
        debf_im = pfres_im = (float *) malloc (taille * sizeof(*pfres_im));
        dir_desc[noarr_r].type = 3;
    }
    else {
	debi_r = pires_r = (int *) malloc (taille * sizeof(*pires_r));
	debi_im = pires_im = (int *) malloc (taille * sizeof(*pires_im));
	dir_desc[noarr_r].type = 2;
    }
    dir_desc[noarr_im] = dir_desc[noarr_r];
    switch (code){
	case 0	:   /* b,b */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].pb) * *(pim[2].pb) - 
			   *(pim[1].pb) * *(pim[3].pb);
		*pires_im = *(pim[0].pb) * *(pim[3].pb) +
			    *(pim[1].pb) * *(pim[2].pb);
		pires_r++;  pires_im++;
		(pim[0].pb)++;  (pim[1].pb)++;  (pim[2].pb)++;  (pim[3].pb)++;
	    }
	    break;
	case 30	:   /* b,s */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].pb) * *(pim[2].ps) - 
			   *(pim[1].pb) * *(pim[3].ps);
		*pires_im = *(pim[0].pb) * *(pim[3].ps) +
			    *(pim[1].pb) * *(pim[2].ps);
		pires_r++;  pires_im++;
		(pim[0].pb)++;  (pim[1].pb)++;  (pim[2].ps)++;  (pim[3].ps)++;
	    }
	    break;
	case 3	:   /* s,b */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].ps) * *(pim[2].pb) - 
			   *(pim[1].ps) * *(pim[3].pb);
		*pires_im = *(pim[0].ps) * *(pim[3].pb) +
			    *(pim[1].ps) * *(pim[2].pb);
		pires_r++;  pires_im++;
		(pim[0].ps)++;  (pim[1].ps)++;  (pim[2].pb)++;  (pim[3].pb)++;
	    }
	    break;
	case 70	:   /* b,i */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].pb) * *(pim[2].pi) - 
			   *(pim[1].pb) * *(pim[3].pi);
		*pires_im = *(pim[0].pb) * *(pim[3].pi) +
			    *(pim[1].pb) * *(pim[2].pi);
		pires_r++;  pires_im++;
		(pim[0].pb)++;  (pim[1].pb)++;  (pim[2].pi)++;  (pim[3].pi)++;
	    }
	    break;
	case 7	:   /* i,b */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].pi) * *(pim[2].pb) - 
			   *(pim[1].pi) * *(pim[3].pb);
		*pires_im = *(pim[0].pi) * *(pim[3].pb) +
			    *(pim[1].pi) * *(pim[2].pb);
		pires_r++;  pires_im++;
		(pim[0].pi)++;  (pim[1].pi)++;  (pim[2].pb)++;  (pim[3].pb)++;
	    }
	    break;
	case 120:   /* b,f */
	    for (i=0; i<taille; i++){
		*pfres_r = *(pim[0].pb) * *(pim[2].pf) - 
			   *(pim[1].pb) * *(pim[3].pf);
		*pfres_im = *(pim[0].pb) * *(pim[3].pf) +
			    *(pim[1].pb) * *(pim[2].pf);
		pfres_r++;  pfres_im++;
		(pim[0].pb)++;  (pim[1].pb)++;  (pim[2].pf)++;  (pim[3].pf)++;
	    }
	    break;
	case 12	:   /* f,b */
	    for (i=0; i<taille; i++){
		*pfres_r = *(pim[0].pf) * *(pim[2].pb) - 
			   *(pim[1].pf) * *(pim[3].pb);
		*pfres_im = *(pim[0].pf) * *(pim[3].pb) +
			    *(pim[1].pf) * *(pim[2].pb);
		pfres_r++;  pfres_im++;
		(pim[0].pf)++;  (pim[1].pf)++;  (pim[2].pb)++;  (pim[3].pb)++;
	    }
	    break;
	case 33	:   /* s,s */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].ps) * *(pim[2].ps) - 
			   *(pim[1].ps) * *(pim[3].ps);
		*pires_im = *(pim[0].ps) * *(pim[3].ps) +
			    *(pim[1].ps) * *(pim[2].ps);
		pires_r++;  pires_im++;
		(pim[0].ps)++;  (pim[1].ps)++;  (pim[2].ps)++;  (pim[3].ps)++;
	    }
	    break;
	case 73	:   /* s,i */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].ps) * *(pim[2].pi) - 
			   *(pim[1].ps) * *(pim[3].pi);
		*pires_im = *(pim[0].ps) * *(pim[3].pi) +
			    *(pim[1].ps) * *(pim[2].pi);
		pires_r++;  pires_im++;
		(pim[0].ps)++;  (pim[1].ps)++;  (pim[2].pi)++;  (pim[3].pi)++;
	    }
	    break;
	case 37	:   /* i,s */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].pi) * *(pim[2].ps) - 
			   *(pim[1].pi) * *(pim[3].ps);
		*pires_im = *(pim[0].pi) * *(pim[3].ps) +
			    *(pim[1].pi) * *(pim[2].ps);
		pires_r++;  pires_im++;
		(pim[0].pi)++;  (pim[1].pi)++;  (pim[2].ps)++;  (pim[3].ps)++;
	    }
	    break;
	case 123:   /* s,f */
	    for (i=0; i<taille; i++){
		*pfres_r = *(pim[0].ps) * *(pim[2].pf) - 
			   *(pim[1].ps) * *(pim[3].pf);
		*pfres_im = *(pim[0].ps) * *(pim[3].pf) +
			    *(pim[1].ps) * *(pim[2].pf);
		pfres_r++;  pfres_im++;
		(pim[0].ps)++;  (pim[1].ps)++;  (pim[2].pf)++;  (pim[3].pf)++;
	    }
	    break;
	case 42	:   /* f,s */
	    for (i=0; i<taille; i++){
		*pfres_r = *(pim[0].pf) * *(pim[2].ps) - 
			   *(pim[1].pf) * *(pim[3].ps);
		*pfres_im = *(pim[0].pf) * *(pim[3].ps) +
			    *(pim[1].pf) * *(pim[2].ps);
		pfres_r++;  pfres_im++;
		(pim[0].pf)++;  (pim[1].pf)++;  (pim[2].ps)++;  (pim[3].ps)++;
	    }
	    break;
	case 77	:   /* i,i */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].pi) * *(pim[2].pi) - 
			   *(pim[1].pi) * *(pim[3].pi);
		*pires_im = *(pim[0].pi) * *(pim[3].pi) +
			    *(pim[1].pi) * *(pim[2].pi);
		pires_r++;  pires_im++;
		(pim[0].pi)++;  (pim[1].pi)++;  (pim[2].pi)++;  (pim[3].pi)++;
	    }
	    break;
	case 127:   /* i,f */
	    for (i=0; i<taille; i++){
		*pfres_r = *(pim[0].pi) * *(pim[2].pf) - 
			   *(pim[1].pi) * *(pim[3].pf);
		*pfres_im = *(pim[0].pi) * *(pim[3].pf) +
			    *(pim[1].pi) * *(pim[2].pf);
		pfres_r++;  pfres_im++;
		(pim[0].pi)++;  (pim[1].pi)++;  (pim[2].pf)++;  (pim[3].pf)++;
	    }
	    break;
	case 82	:   /* f,i */
	    for (i=0; i<taille; i++){
		*pfres_r = *(pim[0].pf) * *(pim[2].pi) - 
			   *(pim[1].pf) * *(pim[3].pi);
		*pfres_im = *(pim[0].pf) * *(pim[3].pi) +
			    *(pim[1].pf) * *(pim[2].pi);
		pfres_r++;  pfres_im++;
		(pim[0].pf)++;  (pim[1].pf)++;  (pim[2].pi)++;  (pim[3].pi)++;
	    }
	    break;
	case 132:   /* f,f */
	    for (i=0; i<taille; i++){
		*pfres_r = *(pim[0].pf) * *(pim[2].pf) - 
			   *(pim[1].pf) * *(pim[3].pf);
		*pfres_im = *(pim[0].pf) * *(pim[3].pf) +
			    *(pim[1].pf) * *(pim[2].pf);
		pfres_r++;  pfres_im++;
		(pim[0].pf)++;  (pim[1].pf)++;  (pim[2].pf)++;  (pim[3].pf)++;
	    }
	    break;
    }
    if (code==120 || code==12 || code==123 || code==42 || code==127 || code==82
     || code==132) {
	if (dir_image[noarr_r].image != NULL) free (dir_image[noarr_r].image);
	if (dir_image[noarr_im].image != NULL) free(dir_image[noarr_im].image);
        dir_image[noarr_r].image = (unsigned char *) debf_r;
        dir_image[noarr_im].image = (unsigned char *) debf_im;
    }
    else {    
	if (dir_image[noarr_r].image != NULL) free (dir_image[noarr_r].image);
	if (dir_image[noarr_im].image != NULL) free(dir_image[noarr_im].image);
	dir_image[noarr_r].image = (unsigned char *) debi_r;
	dir_image[noarr_im].image = (unsigned char *) debi_im;
    }
    statis (dir_image[noarr_r].image, dir_desc[noarr_r].type,
	    dir_desc[noarr_r].nligne, dir_desc[noarr_r].ncolonne,
	    &(dir_desc[noarr_r].mmin), &(dir_desc[noarr_r].mmax),
	    &(dir_desc[noarr_r].mu), &(dir_desc[noarr_r].ecart));
    statis (dir_image[noarr_im].image, dir_desc[noarr_im].type,
	    dir_desc[noarr_im].nligne, dir_desc[noarr_im].ncolonne,
	    &(dir_desc[noarr_im].mmin), &(dir_desc[noarr_im].mmax),
	    &(dir_desc[noarr_im].mu), &(dir_desc[noarr_im].ecart));
}

/*****************************************************************************/

op_arithm_cte (mode, nodep, cte, noarr)
    int	mode, nodep, noarr;
    float   cte;
{
    union ens_pointeur pim;
    float *pfres, *deb_im;
    int	code, taille;
    register int i;

    code = ouvrir (&pim, nodep, 0);
    taille = dir_desc[nodep].nligne * dir_desc[nodep].ncolonne;
    dir_desc[noarr] = dir_desc[nodep];
    dir_desc[noarr].type = 3;
    deb_im =  pfres = (float *) malloc (taille * sizeof(*pfres));
    switch (code){
	case 0 :    /* b+C */
	    switch (mode){
		case 10 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pb) + cte;
			pfres++;  (pim.pb)++;
		    }
		    break;
		case 11 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pb) - cte;
			pfres++;  (pim.pb)++;
		    }
		    break;
		case 12 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pb) * cte;
			pfres++;  (pim.pb)++;
		    }
		    break;
		case 13 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pb) / cte;
			pfres++;  (pim.pb)++;
		    }
		    break;
	    }
	    break;
	case 3 :    /* s+C */
	    switch (mode){
		case 10 : for (i=0; i<taille; i++) {
			*pfres = *(pim.ps) + cte;
			pfres++;  (pim.ps)++;
		    }
		    break;
		case 11 : for (i=0; i<taille; i++) {
			*pfres = *(pim.ps) - cte;
			pfres++;  (pim.ps)++;
		    }
		    break;
		case 12 : for (i=0; i<taille; i++) {
			*pfres = *(pim.ps) * cte;
			pfres++;  (pim.ps)++;
		    }
		    break;
		case 13 : for (i=0; i<taille; i++) {
			*pfres = *(pim.ps) / cte;
			pfres++;  (pim.ps)++;
		    }
		    break;
	    }
	    break;
	case 7 :    /* i+C */
	    switch (mode){
		case 10 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pi) + cte;
			pfres++;  (pim.pi)++;
		    }
		    break;
		case 11 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pi) - cte;
			pfres++;  (pim.pi)++;
		    }
		    break;
		case 12 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pi) * cte;
			pfres++;  (pim.pi)++;
		    }
		    break;
		case 13 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pi) / cte;
			pfres++;  (pim.pi)++;
		    }
		    break;
	    }
	    break;
	case 12:    /* f+C */
	    switch (mode){
		case 10 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pf) + cte;
			pfres++;  (pim.pf)++;
		    }
		    break;
		case 11 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pf) - cte;
			pfres++;  (pim.pf)++;
		    }
		    break;
		case 12 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pf) * cte;
			pfres++;  (pim.pf)++;
		    }
		    break;
		case 13 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pf) / cte;
			pfres++;  (pim.pf)++;
		    }
		    break;
	    }
	    break;
    }
    if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
    dir_image[noarr].image = (unsigned char *) deb_im;
    statis (dir_image[noarr].image, dir_desc[noarr].type,
	    dir_desc[noarr].nligne, dir_desc[noarr].ncolonne,
	    &(dir_desc[noarr].mmin), &(dir_desc[noarr].mmax),
	    &(dir_desc[noarr].mu), &(dir_desc[noarr].ecart));
}     

/*****************************************************************************/

op_arithm_cte_cmplx (nodep_r, nodep_im, cte, noarr_r, noarr_im)
    int	nodep_r, nodep_im, noarr_r, noarr_im;
    struct  cte_cmplx	*cte;
{
    union ens_pointeur pim[2];
    float *pfres_r, *pfres_im, *deb_r, *deb_im;
    int	code, taille;
    register int i;
    
    /* le plan reel et imaginaire doit etre de meme type */
    code = (ouvrir (&pim[0], nodep_r, 0) + ouvrir (&pim[1], nodep_im, 0)) / 2;
    taille = dir_desc[nodep_r].nligne * dir_desc[nodep_r].ncolonne;
    dir_desc[noarr_r] = dir_desc[nodep_r];
    dir_desc[noarr_r].type = 3;
    deb_r = pfres_r = (float *) malloc (taille * sizeof(*pfres_r));
    deb_im = pfres_im = (float *) malloc (taille * sizeof(*pfres_im));
    dir_desc[noarr_im] = dir_desc[noarr_r];
    switch (code){
	case 0 :    /* b+C */
	    for (i=0; i<taille; i++){
	      *pfres_r = *(pim[0].pb) * (cte->reel) - *(pim[1].pb) * (cte->im);
	      *pfres_im= *(pim[0].pb) * (cte->im) + *(pim[1].pb) * (cte->reel);
	      pfres_r++;  pfres_im++;  (pim[0].pb)++;  (pim[1].pb)++;
	    }
	    break;
	case 3 :    /* s+C */
	    for (i=0; i<taille; i++){
	      *pfres_r = *(pim[0].ps) * (cte->reel) - *(pim[1].ps) * (cte->im);
	      *pfres_im= *(pim[0].ps) * (cte->im) + *(pim[1].ps) * (cte->reel);
	      pfres_r++;  pfres_im++;  (pim[0].ps)++;  (pim[1].ps)++;
	    }
	    break;
	case 7 :    /* i+C */
	    for (i=0; i<taille; i++){
	      *pfres_r = *(pim[0].pi) * (cte->reel) - *(pim[1].pi) * (cte->im);
	      *pfres_im= *(pim[0].pi) * (cte->im) + *(pim[1].pi) * (cte->reel);
	      pfres_r++;  pfres_im++;  (pim[0].pi)++;  (pim[1].pi)++;
	    }
	    break;
	case 12:    /* f+C */
	    for (i=0; i<taille; i++){
	      *pfres_r = *(pim[0].pf) * (cte->reel) - *(pim[1].pf) * (cte->im);
	      *pfres_im= *(pim[0].pf) * (cte->im) + *(pim[1].pf) * (cte->reel);
	      pfres_r++;  pfres_im++;  (pim[0].pf)++;  (pim[1].pf)++;
	    }
	    break;
    }
    if (dir_image[noarr_r].image != NULL) free (dir_image[noarr_r].image);
    dir_image[noarr_r].image = (unsigned char *) deb_r;
    if (dir_image[noarr_im].image != NULL) free (dir_image[noarr_im].image);
    dir_image[noarr_im].image = (unsigned char *) deb_im;
    statis (dir_image[noarr_r].image, dir_desc[noarr_r].type,
	    dir_desc[noarr_r].nligne, dir_desc[noarr_r].ncolonne,
	    &(dir_desc[noarr_r].mmin), &(dir_desc[noarr_r].mmax),
	    &(dir_desc[noarr_r].mu), &(dir_desc[noarr_r].ecart));
    statis (dir_image[noarr_im].image, dir_desc[noarr_im].type,
	    dir_desc[noarr_im].nligne, dir_desc[noarr_im].ncolonne,
	    &(dir_desc[noarr_im].mmin), &(dir_desc[noarr_im].mmax),
	    &(dir_desc[noarr_im].mu), &(dir_desc[noarr_im].ecart));
}     

/*****************************************************************************/

caddr_t proc_op_arithm (m, mi)
    Menu    m;
    Menu_item   mi;
{
    struct  cte_cmplx	*cte, *copycte;
    int mode = (int) menu_get (mi, MENU_VALUE);

    if (flag_bother){
	switch (mode){
	    case 10:hproc_oparithm_addcte();
		    break;
	    case 11:hproc_oparithm_subcte();
		    break;
	    case 12:hproc_oparithm_mulcte();
		    break;
	    case 13:hproc_oparithm_divcte();
		    break;
	    case 20:hproc_oparithm_adddeuxplans();
		    break;
	    case 21:hproc_oparithm_subdeuxplans();
		    break;
	    case 22:hproc_oparithm_muldeuxplans();
		    break;
	    case 23:hproc_oparithm_divdeuxplans();
		    break;
	    case 40:hproc_oparithm_mul_deuximagescomplex();
		    break;
	    case 41:hproc_oparithm_mul_imagecomplexe_ctecomplex();
		    break;
	}
	return;
    }
    if (flag_help){
	switch (mode){
	    case 10:hproc_oparithm_addcte();
		    break;
	    case 11:hproc_oparithm_subcte();
		    break;
	    case 12:hproc_oparithm_mulcte();
		    break;
	    case 13:hproc_oparithm_divcte();
		    break;
	    case 20:hproc_oparithm_adddeuxplans();
		    break;
	    case 21:hproc_oparithm_subdeuxplans();
		    break;
	    case 22:hproc_oparithm_muldeuxplans();
		    break;
	    case 23:hproc_oparithm_divdeuxplans();
		    break;
	    case 40:hproc_oparithm_mul_deuximagescomplex();
		    break;
	    case 41:hproc_oparithm_mul_imagecomplexe_ctecomplex();
		    break;
	}
    }
    if (!flag_creer){
	sprintf (buf, mastertabs[186]);
	write_master (buf);
    }

    switch (mode) {
	case 10:    /* addition cte */
	case 11:    /* soustraction cte */
	case 12:    /* multiplication cte */
	case 13:    /* division cte */
	    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
		cte = (struct cte_cmplx *)malloc(sizeof(*cte));
		cte->reel = ((struct cte_cmplx *)macro_cour->param)->reel;
	    }
	    else cte = cte_panel (mode);
	    if (!flag_break)
		if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
		    index_image[0] = macro_cour->from[0];
		    index_image[1] = macro_cour->to[0];
		}
		else fromto (FROMTO, DEFAUT);
	    if (flag_break) interruption();
	    else if (!flag_creer){
		switch (mode){
		    case 10:
			sprintf (buf,mastertabs[187], 
			index_image[0], cte->reel, index_image[1]);  break;
		    case 11:
			sprintf (buf,mastertabs[188], 
			index_image[0], cte->reel, index_image[1]);  break;
		    case 12:
			sprintf (buf, mastertabs[189],
			index_image[0], cte->reel, index_image[1]);  break;
		    case 13:
			sprintf (buf, mastertabs[190],
			index_image[0], cte->reel, index_image[1]);  break;
		}
		write_master (buf);
		if (dir_image[index_image[0]].image == NULL){
		    write_erreur(1);
		    return;
		}
		op_arithm_cte(mode, index_image[0], cte->reel, index_image[1]);
	    }
	    else{
		struct commande *com;
		com = (struct commande *)new_commande (&macro_cour);
		com->from[0] = index_image[0];
		com->to[0] = index_image[1];
		switch (mode){
		    case 10:
			sprintf (com->nom, "AUXAOP1PCADD");
			com->code = 44;
			break;
		    case 11:
			sprintf (com->nom, "AUXAOP1PCSUB");
			com->code = 45;
			break;
		    case 12:
			sprintf (com->nom, "AUXAOP1PCMUL");
			com->code = 46;
			break;
		    case 13:
			sprintf (com->nom, "AUXAOP1PCDIV");
			com->code = 47;
			break;
		}
		write_macro (com->nom);
		copycte = (struct cte_cmplx *)malloc(sizeof(*copycte));
		*copycte = *cte;
		com->param = (char *)copycte;
		sprintf (buf, " FROM %d TO %d WITH %f\n",
			index_image[0], index_image[1], cte->reel);
		write_macro (buf);
	    }
	    break;

	case 20:    /* addition 2 plans */
	case 21:    /* soustraction 2 plans */
	case 22:    /* multiplication 2 plans */
	case 23:    /* division 2 plans */
	    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
		index_image[0] = macro_cour->from[0];
		index_image[2] = macro_cour->from[1];
		index_image[1] = macro_cour->to[0];
	    }
	    else fromto (FROMTO, DEF21);
	    if (flag_break) interruption();
	    else if (!flag_creer){
		switch (mode){
		    case 20:
			sprintf (buf, mastertabs[191],
			index_image[0], index_image[2], index_image[1]); break;
		    case 21:
			sprintf (buf, mastertabs[192],
			index_image[0], index_image[2], index_image[1]); break;
		    case 22:
			sprintf (buf, mastertabs[193],
			index_image[0], index_image[2], index_image[1]); break;
		    case 23:
			sprintf (buf,mastertabs[194], 
			index_image[0], index_image[2], index_image[1]); break;
		}
		write_master (buf);
		if (dir_image[index_image[0]].image == NULL){
		    write_erreur(9);
		    return;
		}
		if (dir_image[index_image[2]].image == NULL){
		    write_erreur(10);
		    return;
		}
		op_arithm (mode,index_image[0],index_image[2],index_image[1]);
	    }
	    else{
		struct commande *com;
		com = (struct commande *)new_commande (&macro_cour);
		com->from[0] = index_image[0];
		com->from[1] = index_image[2];
		com->to[0] = index_image[1];
		switch (mode){
		    case 20:
			sprintf (com->nom, "AUXAOP2PLADD");
			com->code = 40;
			break;
		    case 21:
			sprintf (com->nom, "AUXAOP2PLSUB");
			com->code = 41;
			break;
		    case 22:
			sprintf (com->nom, "AUXAOP2PLMUL");
			com->code = 42;
			break;
		    case 23:
			sprintf (com->nom, "AUXAOP2PlDIV");
			com->code = 43;
			break;
		}
		write_macro (com->nom);
		com->param = NULL;
		sprintf (buf, " FROM %d %d TO %d\n",
			 index_image[0], index_image[2], index_image[1]);
		write_macro (buf);
	    }
	    break;

	case 40:    /* multiplication 2 images complexes */
	    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
		index_image[0] = macro_cour->from[0];
		index_image[2] = macro_cour->from[1];
		index_image[4] = macro_cour->from[2];
		index_image[6] = macro_cour->from[3];
		index_image[1] = macro_cour->to[0];
		index_image[3] = macro_cour->to[1];
	    }
	    else fromto (FROMTO, COMPL142);
	    if (flag_break) interruption();
	    else if (!flag_creer){
		sprintf(buf,mastertabs[195],
			index_image[0], index_image[2], index_image[4],
			index_image[6], index_image[1], index_image[3]);
		write_master (buf);
		if (dir_image[index_image[0]].image == NULL){
		    write_erreur(9);
		    return;
		}
		if (dir_image[index_image[2]].image == NULL){
		    write_erreur(10);
		    return;
		}
		if (dir_image[index_image[4]].image == NULL){
		    write_erreur(9);
		    return;
		}
		if (dir_image[index_image[6]].image == NULL){
		    write_erreur(10);
		    return;
		}
		op_arithm_cmplx (index_image[0],index_image[2],index_image[4],
				 index_image[6],index_image[1],index_image[3]);
	    }
	    else{
		struct commande *com;
		com = (struct commande *)new_commande (&macro_cour);
		com->from[0] = index_image[0];
		com->from[1] = index_image[2];
		com->from[2] = index_image[4];
		com->from[3] = index_image[6];
		com->to[0] = index_image[1];
		com->to[1] = index_image[3];
		sprintf (com->nom, "AUXAOP4PLMUL");
		com->code = 48;
		write_macro (com->nom);
		com->param = NULL;
		sprintf (buf, " FROM %d %d %d %d TO %d %d\n", index_image[0],
			 index_image[2], index_image[4], index_image[6],
			 index_image[1], index_image[3]);
		write_macro (buf);
	    }
	    break;

	case 41:    /* multiplication image complexe * cte cmplx */
	    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
		cte = (struct cte_cmplx *)malloc(sizeof(*cte));
		cte->reel = ((struct cte_cmplx *)macro_cour->param)->reel;
		cte->im = ((struct cte_cmplx *)macro_cour->param)->im;
	    }
	    else cte = cte_panel (mode);
	    if (!flag_break)
		if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
		    index_image[0] = macro_cour->from[0];
		    index_image[1] = macro_cour->to[0];
		}
		else fromto (FROMTO, COMPL1);
	    if (flag_break) interruption();
	    else if (!flag_creer){
		sprintf (buf, mastertabs[196],
			index_image[0], index_image[2], cte->reel, cte->im,
			index_image[1], index_image[3]);
		write_master (buf);
		if (dir_image[index_image[0]].image == NULL){
		    write_erreur(9);
		    return;
		}
		if (dir_image[index_image[2]].image == NULL){
		    write_erreur(10);
		    return;
		}
		op_arithm_cte_cmplx (index_image[0], index_image[2],
				     cte, index_image[1], index_image[3]);
	    }
	    else{
		struct commande *com;
		com = (struct commande *)new_commande (&macro_cour);
		com->from[0] = index_image[0];
		com->from[1] = index_image[2];
		com->to[0] = index_image[1];
		com->to[1] = index_image[3];
		sprintf (com->nom, "AUXAOP2PCMUL");
		com->code = 49;
		write_macro (com->nom);
		copycte = (struct cte_cmplx *)malloc(sizeof(*copycte));
		*copycte = *cte;
		com->param = (char *)copycte;
		sprintf (buf, " FROM %d TO %d WITH %f %f\n",
			index_image[0], index_image[1], cte->reel, cte->im);
		write_macro (buf);
	    }
	    break;
    }    
}
