/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: support.c,v 1.11 1993/11/05 21:59:28 gbourhis Exp $";
#endif

/* $Log: support.c,v $
 * Revision 1.11  1993/11/05  21:59:28  gbourhis
 * Add the parameter oldHigh to SqueezeImage().
 * Fix a bug in RemoveGapsFromImage().
 *
 * Revision 1.10  1993/08/27  21:40:12  davet
 * Added new routine RemoveGapsFromImage() for consolidating the palette.
 *
 * Revision 1.9  1993/07/30  15:14:20  gbourhis
 * Add SetShortMinMax() and CreateRasterFromShort().
 *
 */

#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include "collageP.h"
#include "support.h"


#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif


void SetMinMax(data,xdim,ydim,min,max)
/*scan float dataset and set min & max */
float	*data;
int	xdim,ydim;
float	*min,*max;
{
register int x,last;
register float *pf;

	pf = data;
	*min = *max = *data;
	last = xdim*ydim;

	for (x = 0; x < last ; x++,pf++) {
		*min = (*pf < *min)? *pf : *min;
		*max = (*pf > *max)? *pf : *max;
		}
} /*SetMinMax() */


void SetIntMinMax(data,xdim,ydim,min,max)
/*scan int dataset and set min & max */
int	*data;
int	xdim,ydim;
int	*min,*max;
{
register int x,last;
register int *pi;

	pi = data;
	*min = *max = *data;
	last = xdim*ydim;

	for (x = 0; x < last ; x++,pi++) {
		*min = (*pi < *min)? *pi : *min;
		*max = (*pi > *max)? *pi : *max;
		}
} /*SetIntMinMax() */


void DEFUN(SetShortMinMax,(data,xdim,ydim,min,max),
/*scan short dataset and set min & max */
short	*data AND
int	xdim AND
int	ydim AND
int	*min AND
int	*max)
{
register int x,last;
register short *pi;

	pi = data;
	*min = *max = (int)*data;
	last = xdim*ydim;

	for (x = 0; x < last ; x++,pi++) {
		*min = ((int)*pi < *min)? (int)*pi : *min;
		*max = ((int)*pi > *max)? (int)*pi : *max;
		}
} /*SetShortMinMax() */


void SetCharMinMax(data,xdim,ydim,min,max)
unsigned char *data;
int xdim,ydim;
unsigned char *min,*max;
{
register int x,last;
register unsigned char *pc;

	pc = data;
	*min = *max = *data;
	last = xdim*ydim;
	for (x = 0; x < last; x++, pc++) {
		*min = (*pc < *min)? *pc : *min;
		*max = (*pc > *max)? *pc : *max;
		}
}




int CreateRasterFromFloat(fdata,raster,xdim,ydim,min,max,shouldMalloc)
float	*fdata;
unsigned char **raster;	/* returned */
int	xdim,ydim;
float	min,max;
char	shouldMalloc;	/* Should it create new space? or use existing raster*/
/* return 0 on Failure */
{
int length;
int x;
float range;
unsigned char *pc;
float *pf;

        length = xdim * ydim;
	if (shouldMalloc){
		if (! (*raster = (unsigned char *) MALLOC(length))) {
			printf("Can't allocate memory for raster image\n");
			return(NULL);
			}
		}
        range = max - min;
	if (range)
	        for (x = 0, pc= *raster, pf=fdata; x < length; x++,pc++,pf++ ){
			*pc =(unsigned char)
			  CNV2PIX(*pf, min, max, BASE_PIX, NCOLORS);
			}
	else
	        for (x = 0, pc= *raster, pf=fdata; x < length; x++,pc++,pf++ ){
			*pc =(unsigned char) BASE_PIX;
			}

	return(1);
} /*CreateRasterFromFloat() */


int CreateRasterFromInt(data,raster,xdim,ydim,min,max,shouldMalloc)
int	*data;
unsigned char **raster;	/* returned */
int	xdim,ydim;
int	min,max;
char	shouldMalloc;	/* Should it create new space? or use existing raster*/
/* return 0 on Failure */
{
int length;
int x;
int range;
unsigned char *pc;
int *pi;

        length = xdim * ydim;
	if (shouldMalloc){
		if (! (*raster = (unsigned char *) MALLOC(length))) {
			printf("Can't allocate memory for raster image\n");
			return(NULL);
			}
		}
        range = max - min;
	if (range)
	        for (x = 0, pc= *raster, pi=data; x < length; x++,pc++,pi++ ){
			*pc =(unsigned char)
			  CNV2PIX(*pi, min, max, BASE_PIX, NCOLORS);
			}
	else
	        for (x = 0, pc= *raster, pi=data; x < length; x++,pc++,pi++ ){
			*pc =(unsigned char) 0;
			}

	return(1);
} /*CreateRasterFromInt() */


int DEFUN(CreateRasterFromShort,(data,raster,xdim,ydim,min,max,shouldMalloc),
short	*data AND
unsigned char **raster AND	/* returned */
int	xdim AND int ydim AND
int	min AND int max AND
char	shouldMalloc)	/* Should it create new space? or use existing raster*/
/* return 0 on Failure */
{
int length;
int x;
int range;
unsigned char *pc;
short *pi;

        length = xdim * ydim;
	if (shouldMalloc){
		if (! (*raster = (unsigned char *) MALLOC(length))) {
			printf("Can't allocate memory for raster image\n");
			return(0);
			}
		}
        range = max - min;
	if (range)
	        for (x = 0, pc= *raster, pi=data; x < length; x++,pc++,pi++ ){
			*pc =(unsigned char)
			  CNV2PIX((int)*pi, min, max, BASE_PIX, NCOLORS);
			}
	else
	        for (x = 0, pc= *raster; x < length; x++,pc++ ){
			*pc =(unsigned char) 0;
			}

	return(1);
} /*CreateRasterFromShort() */

void ConvertSEQtoRGB(seq,rgb) 
unsigned char seq[768];
unsigned char rgb[768];
/* 256 red, 256 green, 256 blue ---> rgb,rgb,rgb,rgb .... */
{
register int x;
	for (x=0; x< 256; x++ ) {
		rgb[x*3] = seq[x];
		rgb[x*3+1] = seq[x+256];
		rgb[x*3+2] = seq[x+512];
		}
	
}

void ConvertSEQToXColors(rgb,ccells)
unsigned char rgb[768];
XColor	 ccells[256];
/*  Convert 8 bit SEQ palette to XColor array */
/*  8 bit palette is arranged 256 entries of red followed by green & blue */
{
register int x;
        for (x=0; x < 256;x++) {
                ccells[x].pixel = x;
                ccells[x].red   = (unsigned short) rgb[x] << 8;
                ccells[x].green = (unsigned short) rgb[x+256] << 8;
                ccells[x].blue  = (unsigned short) rgb[x+512] << 8;
                ccells[x].flags = DoRed|DoGreen|DoBlue;
                }
}


void ConvertToXColors(rgb,ccells)
unsigned char rgb[768];
XColor	 ccells[256];
/*  Convert 8 bit palette to XColor array */
/*  8 bit palette is arranged rgb, rgb, rgb, rgb  ...*/
{
register int x;
        for (x=0; x < 256;x++) {
                ccells[x].pixel = x;
                ccells[x].red   = (unsigned short) rgb[x*3] << 8;
                ccells[x].green = (unsigned short) rgb[x*3+1] << 8;
                ccells[x].blue  = (unsigned short) rgb[x*3+2] << 8;
                ccells[x].flags = DoRed|DoGreen|DoBlue;
                }
}

void ConvertXColorsToRGB(ccells,pal)
/* Converts a 8 bit X ccells to rgb, rgb, rgb */
XColor ccells[];
unsigned char *pal;
{
register int x;

        for (x=0 ; x<256; x++) {
                *pal++ = (unsigned char) (ccells[x].red >> 8);
                *pal++ = (unsigned char) (ccells[x].green >> 8);
                *pal++ = (unsigned char) (ccells[x].blue >> 8);
		}
}


void SetPointer(w,cursorfont)
/* Set pointer to cursorfont if widget has been mapped */
/* (see X11/cursorfont.h for cursorfonts)( */
Widget  w;
int     cursorfont;
{
Cursor  cursor;
Window  win = XtWindow(w);
Display *dpy = XtDisplay(w);

        if(win) {
            cursor = XCreateFontCursor(dpy,cursorfont);
            XDefineCursor(dpy,win,cursor);
            }

        return;

} /* SetPointer() */

Visual *GetVisual(dpy)
Display *dpy;
{
static char haveIComplainedYet = FALSE;
XVisualInfo vinfo;

        if (!XMatchVisualInfo(dpy,XDefaultScreen(dpy),8,PseudoColor,&vinfo)) {
                if (! haveIComplainedYet) {
			ErrMesg("Couldn't get a PseudoColor 8 bit visual\n");
                        haveIComplainedYet = TRUE;
                        }
                return(XDefaultVisual(dpy,XDefaultScreen(dpy)));
                }
        return(vinfo.visual);
}

void SqueezeImage(image,newImage,width,height,oldHigh,newRangeLow,newRangeHigh,
                oldPal,newPal)
/* squeeze an image&pal to a range of values Ex: 0-255 -> 32-254 */
unsigned char *image;
unsigned char *newImage;  /* can be ptr to same location as image */
int width,height;
unsigned char oldHigh, newRangeLow, newRangeHigh;
unsigned char *oldPal;
unsigned char *newPal;  /* can be ptr to same location as oldPal*/
{
register int x;
register unsigned char *new,*old;
int length;
float oldr, range;
float low;
float xinc;
float findex;
unsigned char tmpPal[768];

	oldr = (float)oldHigh;
        range = (float) (newRangeHigh - newRangeLow);
        low = (float) newRangeLow;
        length = width * height;
        for (x = 0, new = newImage, old = image ; x < length; x++ ) {
                *new++ =  (unsigned char)
                        ((float) (*old++) / oldr * range + .5) + newRangeLow;
                }

        xinc =  oldr / range;
        findex = 0.0;
	for (x = 0; x < newRangeLow; x++) {
		tmpPal[x*3] =
			tmpPal[x*3+1] =
				tmpPal[x*3+2] =  (unsigned char) 0;
		}
        for (; x <= newRangeHigh; x++) {
                tmpPal[x*3]   = oldPal[((int) findex)*3];
                tmpPal[x*3+1] = oldPal[((int) findex)*3+1];
                tmpPal[x*3+2] = oldPal[((int) findex)*3+2];
                findex += xinc;
                }
	memcpy(newPal,tmpPal,768); /* so can use same space for newPal&oldPal*/
}

void ShiftImage(image,newImage,width,height,shift,oldPal,newPal)
unsigned char *image;
unsigned char *newImage;
int width,height;
unsigned char shift;  /* positive... shift right only */
unsigned char *oldPal;
unsigned char *newPal;
{
register int x;
int length;
register unsigned char *new, *old;
unsigned char tmpPal[768];

        length = width * height;
        new = newImage;
        old = image;
        for (x = 0 ; x < length; x++ ) {
                newImage[x] = image[x] + shift;
                }
        for (x = 0; x < shift*3; x++ ) {
                tmpPal[x] = 0;
                }
        for (x = shift; x < 256; x++ ) {
                tmpPal[x*3]   = oldPal[(x - shift)*3];
                tmpPal[x*3+1] = oldPal[(x - shift)*3+1];
                tmpPal[x*3+2] = oldPal[(x - shift)*3+2];
                }
	memcpy(newPal,tmpPal,768); /* so can use same space for newPal&oldPal*/
}

void RemoveGapsFromImage(image,newImage,width,height,oldPal,newPal)
unsigned char *image;
unsigned char *newImage;  /* can be the same location as image */
int width,height;
unsigned char *oldPal,*newPal; /* can be the same location */
/* this will routine will consolidate the palette.  Gaps will be removed
   and the image values will be ajusted accordingly. */
{
register int x,y;
register unsigned char *p;
unsigned char isUsed[256], newIndex[256];
long length;
int range;
unsigned char newPalIndex;
unsigned char tmpPal[768];

	/* clear new Index table */
	for (x=0;x < 256; x++) {
		isUsed[x] = FALSE;
		}
	length = width * height;

	/* find out which ones are used */
	for (x=0; x < length; x++) {
		isUsed[image[x]] = TRUE;
		}

	/* create new index table */
	for (x=0,newPalIndex = 0; x < 256; x++) {
		if (isUsed[x]) {
			newIndex[x] = newPalIndex++;
			}
		}
#ifdef DEBUG
	printf("RemoveGapsFromImage(): reduced pal to %d entries\n",
			newPalIndex);
#endif

	/* assign new values to image */
	for (x = 0; x < length; x++) {
		newImage[x] = newIndex[image[x]];
		}
	/* assign new values to palette */
	for (x = 0; x < 256; x++) {
		if (isUsed[x]) {
                	newPal[newIndex[x]*3]   = oldPal[x*3];
	                newPal[newIndex[x]*3+1] = oldPal[x*3+1];
       		        newPal[newIndex[x]*3+2] = oldPal[x*3+2];
			}
		}
	for (x = newPalIndex; x < 256; x++) {
		newPal[x*3]   = (unsigned char) 0;
		newPal[x*3+1] = (unsigned char) 0;
		newPal[x*3+2] = (unsigned char) 0;
		}
}

void ReduceImage(image,newImage,width,height,newMin,newMax,oldPal,newPal)
unsigned char *image;
unsigned char *newImage; /* newImage cannot be the same as image */
int width,height;
unsigned char newMin,newMax;
unsigned char *oldPal,*newPal;
/* this routine will reduce the number of palette entries an image will
   use in an intelligent fasion */
{
register int x;
register unsigned char *p;
long histogram[256];
long length;
int range;
int numEntriesUsed;

	for (x = 0; x < 256; x++)
		histogram[x] = 0L;

	length = width * height;

	for (x=0; x < length; x++) {
		histogram[image[x]]++;
		}
	for (x=0,numEntriesUsed=0; x < 256; x++) {
		numEntriesUsed=(histogram[x])?numEntriesUsed+1:numEntriesUsed;
		}
	range = newMax - newMin;
	if (range > numEntriesUsed) {
		}
	
	/* this routine not finished yet */

	

}

