/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: palSupport.c,v 1.2 1993/07/01 19:56:02 gbourhis Exp $";
#endif


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>

#include "palUI.h"
#include "netdata.h"
#include "net.h"

extern Pal *PalCreate();
extern int PalNewPalette();
extern int PalInit();

#define MALLOC	malloc
#define FREE	free

static void NewPalette(d,garbage)
Data *d;
caddr_t garbage;
{
XColor *ccells;
int i;

	if (d->dot != DOT_Palette8) {
#ifdef DEBUG
	    printf("************************* NewPalette() \n");
	    printf("Yikes, I shouldn't have been called... INTERNAL ERROR\n");
#endif
	    return;
	    }
#ifdef DEBUG
	printf("NewPalette(): I've been called with palette %s\n",d->label);
#endif

	if (!(ccells = (XColor *) MALLOC(sizeof(XColor) *256))) {
		ErrMesg("Out of Memory\n");
		return;
		}

	for(i=0; i<256; i++) {
		ccells[i].pixel = i;
		ccells[i].red = 0;
		ccells[i].green = 0;
		ccells[i].blue = 0;
		ccells[i].flags = 0;
		}

	ConvertToXColors(d->data,ccells);
	
	PalNewPalette(d->label,ccells);
}

static void ChangePalette(d,garbage)
Data *d;
caddr_t garbage;
{
	NewPalette(d,garbage);
}

int PalSetup(rootWidget)
Widget rootWidget;
{
int retc;

	NetRegisterModule(PAL_MODULE_NAME, NETPAL, NewPalette,0, 
						   ChangePalette,0, 
						   0,0);
	if (PalInit(rootWidget))
		retc = (PalCreate(rootWidget) != NULL);
	else
		retc = 0;

	return retc;
}
